/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.ui.OptionsSearchTopHitProvider;
import com.intellij.ide.ui.OptionsTopHitProvider;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TopHitCache
implements Disposable {
    protected final ConcurrentMap<Class<?>, Collection<OptionDescription>> map = new ConcurrentHashMap();

    public static TopHitCache getInstance() {
        return (TopHitCache)ApplicationManager.getApplication().getService(TopHitCache.class);
    }

    public void dispose() {
        this.clear();
    }

    public void clear() {
        this.map.values().forEach(TopHitCache::dispose);
        this.map.clear();
    }

    private static void dispose(Collection<? extends OptionDescription> options2) {
        if (options2 != null) {
            options2.forEach(TopHitCache::dispose);
        }
    }

    private static void dispose(OptionDescription option2) {
        if (option2 instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)option2));
        }
    }

    public final void invalidateCachedOptions(@NotNull Class<? extends OptionsSearchTopHitProvider> providerClass) {
        Collection removed;
        if (providerClass == null) {
            TopHitCache.$$$reportNull$$$0(0);
        }
        if ((removed = (Collection)this.map.remove(providerClass)) != null) {
            TopHitCache.dispose(removed);
        }
    }

    @NotNull
    public final Collection<OptionDescription> getCachedOptions(@NotNull OptionsSearchTopHitProvider provider, @Nullable Project project, @Nullable PluginDescriptor pluginDescriptor) {
        if (provider == null) {
            TopHitCache.$$$reportNull$$$0(1);
        }
        Collection collection = this.map.computeIfAbsent(provider.getClass(), aClass -> {
            long startTime = StartUpMeasurer.getCurrentTime();
            Collection<OptionDescription> result2 = provider instanceof OptionsSearchTopHitProvider.ProjectLevelProvider ? ((OptionsSearchTopHitProvider.ProjectLevelProvider)provider).getOptions(project) : (provider instanceof OptionsSearchTopHitProvider.ApplicationLevelProvider ? ((OptionsSearchTopHitProvider.ApplicationLevelProvider)provider).getOptions() : ((OptionsTopHitProvider)provider).getOptions(project));
            ActivityCategory category = project == null ? ActivityCategory.APP_OPTIONS_TOP_HIT_PROVIDER : ActivityCategory.PROJECT_OPTIONS_TOP_HIT_PROVIDER;
            StartUpMeasurer.addCompletedActivity((long)startTime, (Class)aClass, (ActivityCategory)category, pluginDescriptor == null ? null : pluginDescriptor.getPluginId().getIdString());
            return result2;
        });
        if (collection == null) {
            TopHitCache.$$$reportNull$$$0(2);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/TopHitCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/TopHitCache";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invalidateCachedOptions";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCachedOptions";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

