/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.ex.util.EditorUIUtil;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.util.DocumentUtil;
import org.jetbrains.annotations.Nullable;

public class DeleteInColumnModeHandler
extends EditorWriteActionHandler {
    private final EditorActionHandler myOriginalHandler;

    public DeleteInColumnModeHandler(EditorActionHandler handler2) {
        this.myOriginalHandler = handler2;
    }

    public void executeWriteAction(Editor editor, @Nullable Caret caret, DataContext dataContext) {
        if (editor.isColumnMode() && caret == null && editor.getCaretModel().getCaretCount() > 1) {
            EditorUIUtil.hideCursorInEditor(editor);
            CommandProcessor.getInstance().setCurrentCommandGroupId(EditorActionUtil.DELETE_COMMAND_GROUP);
            CopyPasteManager.getInstance().stopKillRings();
            editor.getCaretModel().runForEachCaret(c -> {
                int lineEndOffset;
                int offset = c.getOffset();
                if (offset < (lineEndOffset = DocumentUtil.getLineEndOffset(offset, editor.getDocument()))) {
                    this.myOriginalHandler.execute(editor, c, dataContext);
                }
            });
        } else {
            this.myOriginalHandler.execute(editor, caret, dataContext);
        }
    }
}

