/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.find.EditorSearchSession;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindUtil;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IncrementalFindAction
extends EditorAction {
    public static final Key<Boolean> SEARCH_DISABLED = Key.create((String)"EDITOR_SEARCH_DISABLED");

    public IncrementalFindAction() {
        super((EditorActionHandler)new Handler(false));
    }

    public static class Handler
    extends EditorActionHandler {
        private final boolean myReplace;

        public Handler(boolean isReplace) {
            this.myReplace = isReplace;
        }

        protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
            if (editor == null) {
                Handler.$$$reportNull$$$0(0);
            }
            Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)editor.getComponent()));
            if (!editor.isOneLineMode()) {
                EditorSearchSession search2 = EditorSearchSession.get(editor);
                if (search2 != null) {
                    search2.getComponent().requestFocusInTheSearchFieldAndSelectContent(project);
                    FindUtil.configureFindModel(this.myReplace, editor, search2.getFindModel(), false);
                } else {
                    FindModel model;
                    FindManager findManager = FindManager.getInstance((Project)project);
                    if (this.myReplace) {
                        model = findManager.createReplaceInFileModel();
                    } else {
                        model = new FindModel();
                        model.copyFrom(findManager.getFindInFileModel());
                    }
                    boolean consoleViewEditor = ConsoleViewUtil.isConsoleViewEditor(editor);
                    FindUtil.configureFindModel(this.myReplace, editor, model, consoleViewEditor);
                    EditorSearchSession.start(editor, model, project).getComponent().requestFocusInTheSearchFieldAndSelectContent(project);
                    if (!consoleViewEditor && editor.getSelectionModel().hasSelection()) {
                        FindUtil.updateFindInFileModel(project, model, true);
                    }
                }
            }
        }

        protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
            if (editor == null) {
                Handler.$$$reportNull$$$0(1);
            }
            if (caret == null) {
                Handler.$$$reportNull$$$0(2);
            }
            if (this.myReplace && ConsoleViewUtil.isConsoleViewEditor(editor) && !ConsoleViewUtil.isReplaceActionEnabledForConsoleViewEditor(editor)) {
                return false;
            }
            if (((Boolean)SEARCH_DISABLED.get((UserDataHolder)editor, (Object)false)).booleanValue()) {
                return false;
            }
            Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)editor.getComponent()));
            return project != null && !editor.isOneLineMode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caret";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/actions/IncrementalFindAction$Handler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doExecute";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledForCaret";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

