/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.impl.view.EditorView;
import com.intellij.openapi.editor.impl.view.FontLayoutService;
import com.intellij.openapi.editor.impl.view.LineFragment;
import com.intellij.ui.paint.LinePainter2D;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpecialCharacterFragment
implements LineFragment {
    private static final Int2ObjectMap<String> SPECIAL_CHAR_CODES = new Int2ObjectOpenHashMap(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 11, 12, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 127, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 173, 8192, 8193, 8194, 8195, 8196, 8197, 8198, 8199, 8200, 8201, 8202, 8203, 8204, 8205, 8206, 8207, 8232, 8233, 8234, 8235, 8236, 8237, 8238, 8239, 8287, 8288, 8289, 8290, 8291, 8292, 8294, 8295, 8296, 8297, 8298, 8299, 8300, 8301, 8302, 8303, 65279}, (Object[])new String[]{"NUL", "SOH", "STX", "ETX", "EOT", "ENQ", "ACK", "BEL", "BS", "VT", "FF", "SO", "SI", "DLE", "DC1", "DC2", "DC3", "DC4", "NAK", "SYN", "ETB", "CAN", "EM", "SUB", "ESC", "FS", "GS", "RS", "US", "DEL", "HOP", "BPH", "NBH", "IND", "NEL", "SSA", "ESA", "HTS", "HTJ", "VTS", "PLD", "PLU", "RI", "SS2", "SS3", "DCS", "PU1", "PU2", "STS", "CCH", "MW", "SPA", "EPA", "SOS", "SGCI", "SCI", "CSI", "ST", "OSC", "PM", "APC", "NBSP", "SHY", "NQSP", "MQSP", "ENSP", "EMSP", "3/MSP", "4/MSP", "6/MSP", "FSP", "PSP", "THSP", "HSP", "ZWSP", "ZWNJ", "ZWJ", "LRM", "RLM", "LSEP", "PSEP", "LRE", "RLE", "PDF", "LRO", "RLO", "NNBSP", "MMSP", "WJ", "f()", "x", ",", "+", "LRI", "RLI", "FSI", "PDI", "ISS", "ASS", "IAFS", "AAFS", "NADS", "NODS", "ZWNBSP"});
    private static final int BRACKETS_DISTANCE_TO_TEXT = 4;
    private static final int BRACKETS_SIZE = 2;
    private static final int BRACKETS_THICKNESS = 1;
    private final EditorView myView;
    private final String myCode;
    private final float myWidth;

    @Nullable
    static SpecialCharacterFragment create(@NotNull EditorView view, int c, char @Nullable [] text, int pos) {
        String code;
        if (view == null) {
            SpecialCharacterFragment.$$$reportNull$$$0(0);
        }
        if ((code = (String)SPECIAL_CHAR_CODES.get(c)) == null) {
            return null;
        }
        if (text != null) {
            if (c == 160 || c >= 8192 && c <= 8202 || c == 8239 || c == 8287) {
                if (pos < text.length - 1 && Character.getType(text[pos + 1]) == 6) {
                    return null;
                }
            } else if (c == 8204 || c == 8205) {
                if (pos > 0 && text[pos - 1] >= '\u0080') {
                    return null;
                }
                if (pos < text.length - 1 && text[pos + 1] >= '\u0080') {
                    return null;
                }
            }
        }
        return new SpecialCharacterFragment(view, code);
    }

    SpecialCharacterFragment(@NotNull EditorView view, @NotNull String code) {
        if (view == null) {
            SpecialCharacterFragment.$$$reportNull$$$0(1);
        }
        if (code == null) {
            SpecialCharacterFragment.$$$reportNull$$$0(2);
        }
        this.myView = view;
        this.myCode = code;
        FontMetrics fontMetrics = FontInfo.getFontMetrics(this.getFont(), view.getFontRenderContext());
        this.myWidth = FontLayoutService.getInstance().stringWidth(fontMetrics, code);
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public int getLogicalColumnCount(int startColumn) {
        return 1;
    }

    @Override
    public int getVisualColumnCount(float startX) {
        return 1;
    }

    @Override
    public int logicalToVisualColumn(float startX, int startColumn, int column) {
        return column;
    }

    @Override
    public int visualToLogicalColumn(float startX, int startColumn, int column) {
        return column;
    }

    @Override
    public int visualColumnToOffset(float startX, int column) {
        return column;
    }

    @Override
    public float visualColumnToX(float startX, int column) {
        return startX + (column <= 0 ? 0.0f : this.myWidth);
    }

    @Override
    public int[] xToVisualColumn(float startX, float x) {
        if (x <= startX) {
            return new int[]{0, 0};
        }
        if (x > startX + this.myWidth) {
            return new int[]{1, 1};
        }
        int column = x <= startX + this.myWidth / 2.0f ? 0 : 1;
        return new int[]{column, 1 - column};
    }

    @Override
    public float offsetToX(float startX, int startOffset, int offset) {
        return startX + (startOffset >= offset ? 0.0f : this.myWidth);
    }

    @Override
    public Consumer<Graphics2D> draw(float x, float y, int startOffset, int endOffset) {
        return g -> {
            g.setFont(this.getFont());
            g.drawString(this.myCode, x, y);
            float xEnd = x + this.myWidth - 1.0f;
            float yTop = y - (float)Math.min(this.myView.getAscent(), this.myView.getCapHeight() + 4);
            float yBottom = y + (float)Math.min(this.myView.getDescent(), 4) - 1.0f;
            LinePainter2D.paint((Graphics2D)g, (double)x, (double)yTop, (double)xEnd, (double)yTop, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.INSIDE, (double)1.0);
            LinePainter2D.paint((Graphics2D)g, (double)x, (double)(yTop + 2.0f), (double)x, (double)yTop, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.INSIDE, (double)1.0);
            LinePainter2D.paint((Graphics2D)g, (double)xEnd, (double)(yTop + 2.0f), (double)xEnd, (double)yTop, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.INSIDE, (double)1.0);
            LinePainter2D.paint((Graphics2D)g, (double)x, (double)yBottom, (double)xEnd, (double)yBottom, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.INSIDE, (double)1.0);
            LinePainter2D.paint((Graphics2D)g, (double)x, (double)(yBottom - 2.0f), (double)x, (double)yBottom, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.INSIDE, (double)1.0);
            LinePainter2D.paint((Graphics2D)g, (double)xEnd, (double)(yBottom - 2.0f), (double)xEnd, (double)yBottom, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.INSIDE, (double)1.0);
        };
    }

    @Override
    @NotNull
    public LineFragment subFragment(int startOffset, int endOffset) {
        SpecialCharacterFragment specialCharacterFragment = this;
        if (specialCharacterFragment == null) {
            SpecialCharacterFragment.$$$reportNull$$$0(3);
        }
        return specialCharacterFragment;
    }

    private Font getFont() {
        return this.myView.getEditor().getColorsScheme().getFont(EditorFontType.PLAIN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "code";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/view/SpecialCharacterFragment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/view/SpecialCharacterFragment";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "subFragment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

