/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.autoimport;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionPointUtil;
import com.intellij.openapi.externalSystem.ExternalSystemAutoImportAware;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectAware;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectId;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectTracker;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.project.autoimport.ProjectAware;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListenerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
class ExternalProjectsSettingsWatcher
implements ExternalSystemSettingsListenerEx {
    ExternalProjectsSettingsWatcher() {
    }

    public void onProjectsLoaded(@NotNull Project project, @NotNull ExternalSystemManager<?, ?, ?, ?, ?> manager, @NotNull Collection<? extends ExternalProjectSettings> settings) {
        if (project == null) {
            ExternalProjectsSettingsWatcher.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            ExternalProjectsSettingsWatcher.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            ExternalProjectsSettingsWatcher.$$$reportNull$$$0(2);
        }
        if (!(manager instanceof ExternalSystemAutoImportAware)) {
            return;
        }
        ExternalSystemProjectTracker projectTracker = ExternalSystemProjectTracker.getInstance((Project)project);
        ProjectSystemId systemId = manager.getSystemId();
        for (ExternalProjectSettings externalProjectSettings : settings) {
            String externalProjectPath = externalProjectSettings.getExternalProjectPath();
            projectTracker.activate(new ExternalSystemProjectId(systemId, externalProjectPath));
        }
    }

    public void onProjectsLinked(@NotNull Project project, @NotNull ExternalSystemManager<?, ?, ?, ?, ?> manager, @NotNull Collection<? extends ExternalProjectSettings> settings) {
        if (project == null) {
            ExternalProjectsSettingsWatcher.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            ExternalProjectsSettingsWatcher.$$$reportNull$$$0(4);
        }
        if (settings == null) {
            ExternalProjectsSettingsWatcher.$$$reportNull$$$0(5);
        }
        if (!(manager instanceof ExternalSystemAutoImportAware)) {
            return;
        }
        Disposable extensionDisposable = ExtensionPointUtil.createExtensionDisposable(manager, (ExtensionPointName)ExternalSystemManager.EP_NAME);
        Disposer.register((Disposable)project, (Disposable)extensionDisposable);
        ExternalSystemAutoImportAware autoImportAware = (ExternalSystemAutoImportAware)manager;
        ExternalSystemProjectTracker projectTracker = ExternalSystemProjectTracker.getInstance((Project)project);
        ProjectSystemId systemId = manager.getSystemId();
        for (ExternalProjectSettings externalProjectSettings : settings) {
            String externalProjectPath = externalProjectSettings.getExternalProjectPath();
            ExternalSystemProjectId id2 = new ExternalSystemProjectId(systemId, externalProjectPath);
            projectTracker.register((ExternalSystemProjectAware)new ProjectAware(project, id2, autoImportAware), extensionDisposable);
        }
    }

    public void onProjectsUnlinked(@NotNull Project project, @NotNull ExternalSystemManager<?, ?, ?, ?, ?> manager, @NotNull Set<String> linkedProjectPaths) {
        if (project == null) {
            ExternalProjectsSettingsWatcher.$$$reportNull$$$0(6);
        }
        if (manager == null) {
            ExternalProjectsSettingsWatcher.$$$reportNull$$$0(7);
        }
        if (linkedProjectPaths == null) {
            ExternalProjectsSettingsWatcher.$$$reportNull$$$0(8);
        }
        if (!(manager instanceof ExternalSystemAutoImportAware)) {
            return;
        }
        ExternalSystemProjectTracker projectTracker = ExternalSystemProjectTracker.getInstance((Project)project);
        ProjectSystemId systemId = manager.getSystemId();
        for (String linkedProjectPath : linkedProjectPaths) {
            projectTracker.remove(new ExternalSystemProjectId(systemId, linkedProjectPath));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkedProjectPaths";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalProjectsSettingsWatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onProjectsLoaded";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "onProjectsLinked";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "onProjectsUnlinked";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

