/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypesBundle;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.fileTypes.impl.RemovedMappingTracker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.registry.Registry;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

final class ApproveRemovedMappingsActivity
implements StartupActivity {
    ApproveRemovedMappingsActivity() {
        if (ApplicationManager.getApplication().isUnitTestMode() || !Registry.is((String)"ide.restore.removed.mappings")) {
            throw ExtensionNotApplicableException.INSTANCE;
        }
    }

    public void runActivity(@NotNull Project project) {
        RemovedMappingTracker removedMappings;
        List<RemovedMappingTracker.RemovedMapping> list2;
        if (project == null) {
            ApproveRemovedMappingsActivity.$$$reportNull$$$0(0);
        }
        if ((list2 = (removedMappings = ((FileTypeManagerImpl)FileTypeManager.getInstance()).getRemovedMappingTracker()).retrieveUnapprovedMappings()).isEmpty()) {
            return;
        }
        ApplicationManager.getApplication().invokeAndWait(() -> {
            for (RemovedMappingTracker.RemovedMapping mapping2 : list2) {
                final FileNameMatcher matcher = mapping2.getFileNameMatcher();
                final FileType fileType = FileTypeManager.getInstance().findFileTypeByName(mapping2.getFileTypeName());
                Notification notification = new Notification(NotificationGroup.createIdWithTitle((String)"File type recognized", (String)FileTypesBundle.message("notification.title.file.type.recognized", new Object[0])), FileTypesBundle.message("notification.title.file.type.recognized", new Object[0]), FileTypesBundle.message("notification.file.extension.0.was.reassigned.to.1.revert", matcher.getPresentableString(), fileType.getName()), NotificationType.WARNING, (NotificationListener)new NotificationListener.Adapter(){

                    protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                        if (notification == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (e == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        ApplicationManager.getApplication().runWriteAction(() -> {
                            FileTypeManager.getInstance().associate((FileType)PlainTextFileType.INSTANCE, matcher);
                            removedMappings.add(matcher, fileType.getName(), true);
                        });
                        notification.expire();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "notification";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "e";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/openapi/fileTypes/impl/ApproveRemovedMappingsActivity$1";
                        objectArray[2] = "hyperlinkActivated";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                Notifications.Bus.notify((Notification)notification, (Project)project);
                ApplicationManager.getApplication().runWriteAction(() -> FileTypeManager.getInstance().associate(fileType, matcher));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileTypes/impl/ApproveRemovedMappingsActivity", "runActivity"));
    }
}

