/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.diagnostic.PluginException;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.StaticGetter;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementTypeBase;
import com.intellij.reference.SoftReference;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.ImmutableCharSequence;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LazyParseableElement
extends CompositeElement {
    private static final Logger LOG = Logger.getInstance(LazyParseableElement.class);
    private static final StaticGetter<CharSequence> NO_TEXT = new StaticGetter(null);
    private final ReentrantLock myLock;
    @NotNull
    private volatile Getter<CharSequence> myText;
    private volatile boolean myParsed;
    private static boolean ourParsingAllowed = true;

    public LazyParseableElement(@NotNull IElementType type, @Nullable CharSequence text) {
        if (type == null) {
            LazyParseableElement.$$$reportNull$$$0(0);
        }
        super(type);
        this.myLock = new ReentrantLock();
        LazyParseableElement.waitForLock(this.myLock);
        try {
            if (text == null) {
                this.myParsed = true;
                this.myText = NO_TEXT;
            } else {
                this.myText = new StaticGetter((Object)ImmutableCharSequence.asImmutable((CharSequence)text));
                this.setCachedLength(text.length());
            }
        }
        finally {
            this.myLock.unlock();
        }
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        LazyParseableElement.waitForLock(this.myLock);
        try {
            if (this.myParsed) {
                this.myText = NO_TEXT;
            } else {
                this.setCachedLength(((CharSequence)this.myText.get()).length());
            }
        }
        finally {
            this.myLock.unlock();
        }
    }

    @Override
    @NotNull
    public String getText() {
        CharSequence text = this.myText();
        if (text != null) {
            String string = text.toString();
            if (string == null) {
                LazyParseableElement.$$$reportNull$$$0(1);
            }
            return string;
        }
        String s = super.getText();
        this.myText = new SoftReference((Object)s);
        String string = s;
        if (string == null) {
            LazyParseableElement.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public CharSequence getChars() {
        CharSequence text = this.myText();
        if (text == null) {
            text = super.getText();
            this.myText = new SoftReference((Object)text);
        }
        CharSequence charSequence = text;
        if (charSequence == null) {
            LazyParseableElement.$$$reportNull$$$0(3);
        }
        return charSequence;
    }

    @Override
    public int getTextLength() {
        CharSequence text = this.myText();
        if (text != null) {
            return text.length();
        }
        return super.getTextLength();
    }

    @Override
    public int hc() {
        CharSequence text = this.myText();
        return text == null ? super.hc() : LeafElement.leafHC(text);
    }

    @Override
    protected int textMatches(@NotNull CharSequence buffer, int start2) {
        CharSequence text;
        if (buffer == null) {
            LazyParseableElement.$$$reportNull$$$0(4);
        }
        if ((text = this.myText()) != null) {
            return LeafElement.leafTextMatches(text, buffer, start2);
        }
        return super.textMatches(buffer, start2);
    }

    public boolean isParsed() {
        return this.myParsed;
    }

    private CharSequence myText() {
        return (CharSequence)this.myText.get();
    }

    @Override
    final void setFirstChildNode(TreeElement child2) {
        if (!this.isParsed()) {
            LOG.error("Mutating collapsed chameleon");
        }
        super.setFirstChildNode(child2);
    }

    @Override
    final void setLastChildNode(TreeElement child2) {
        if (!this.isParsed()) {
            LOG.error("Mutating collapsed chameleon");
        }
        super.setLastChildNode(child2);
    }

    private void ensureParsed() {
        if (!ourParsingAllowed) {
            LOG.error("Parsing not allowed!!!");
        }
        if (this.myParsed) {
            return;
        }
        LazyParseableElement.waitForLock(this.myLock);
        try {
            if (this.myParsed) {
                return;
            }
            CharSequence text = (CharSequence)this.myText.get();
            assert (text != null);
            FileElement fileElement = TreeUtil.getFileElement(this);
            if (fileElement == null) {
                LOG.error("Chameleons must not be parsed till they're in file tree: " + this);
            } else {
                fileElement.assertReadAccessAllowed();
            }
            if (this.rawFirstChild() != null) {
                LOG.error("Reentrant parsing?");
            }
            DebugUtil.performPsiModification("lazy-parsing", () -> {
                TreeElement parsedNode = (TreeElement)((ILazyParseableElementTypeBase)this.getElementType()).parseContents((ASTNode)this);
                this.assertTextLengthIntact(text, parsedNode);
                if (parsedNode != null) {
                    this.setChildren(parsedNode);
                }
                this.myParsed = true;
                this.myText = new SoftReference((Object)text);
            });
        }
        finally {
            this.myLock.unlock();
        }
    }

    private void assertTextLengthIntact(CharSequence text, TreeElement child2) {
        int length = 0;
        while (child2 != null) {
            length += child2.getTextLength();
            child2 = child2.getTreeNext();
        }
        if (length != text.length()) {
            LOG.error("Text mismatch in " + LogUtil.objectAndClass((Object)this.getElementType()), (Throwable)PluginException.createByClass((String)"Text mismatch", null, this.getElementType().getClass()), new Attachment[]{new Attachment("code.txt", text.toString())});
        }
    }

    private void setChildren(@NotNull TreeElement parsedNode) {
        if (parsedNode == null) {
            LazyParseableElement.$$$reportNull$$$0(5);
        }
        ProgressManager.getInstance().executeNonCancelableSection(() -> {
            try {
                TreeElement last = LazyParseableElement.rawSetParents(parsedNode, this);
                super.setFirstChildNode(parsedNode);
                super.setLastChildNode(last);
            }
            catch (Throwable e) {
                LOG.error("Chameleon expansion may not be interrupted by exceptions", e);
            }
        });
    }

    @Override
    public void rawAddChildrenWithoutNotifications(@NotNull TreeElement first) {
        if (first == null) {
            LazyParseableElement.$$$reportNull$$$0(6);
        }
        if (!this.isParsed()) {
            LOG.error("Mutating collapsed chameleon " + this.getClass());
        }
        super.rawAddChildrenWithoutNotifications(first);
    }

    @Override
    public TreeElement getFirstChildNode() {
        this.ensureParsed();
        return super.getFirstChildNode();
    }

    @Override
    public TreeElement getLastChildNode() {
        this.ensureParsed();
        return super.getLastChildNode();
    }

    public int copyTo(char @Nullable [] buffer, int start2) {
        CharSequence text = this.myText();
        if (text == null) {
            return -1;
        }
        if (buffer != null) {
            CharArrayUtil.getChars((CharSequence)text, (char[])buffer, (int)start2);
        }
        return start2 + text.length();
    }

    public static void setParsingAllowed(boolean allowed) {
        ourParsingAllowed = allowed;
    }

    private static void waitForLock(@NotNull ReentrantLock ml) {
        if (ml == null) {
            LazyParseableElement.$$$reportNull$$$0(7);
        }
        while (true) {
            try {
                if (ml.tryLock(10L, TimeUnit.MILLISECONDS)) {
                    return;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ProgressManager.checkCanceled();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/LazyParseableElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parsedNode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ml";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/LazyParseableElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "textMatches";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setChildren";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "rawAddChildrenWithoutNotifications";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "waitForLock";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

