/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.ui;

import com.intellij.ide.HelpTooltip;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class RefactoringDialog
extends DialogWrapper {
    private Action myRefactorAction;
    private Action myPreviewAction;
    private boolean myCbPreviewResults;
    protected final Project myProject;

    protected RefactoringDialog(@NotNull Project project, boolean canBeParent) {
        if (project == null) {
            RefactoringDialog.$$$reportNull$$$0(0);
        }
        this(project, canBeParent, false);
    }

    protected RefactoringDialog(@NotNull Project project, boolean canBeParent, boolean addOpenInEditorCheckbox) {
        if (project == null) {
            RefactoringDialog.$$$reportNull$$$0(1);
        }
        super(project, canBeParent);
        this.myCbPreviewResults = true;
        this.myProject = project;
        if (addOpenInEditorCheckbox) {
            this.addOpenInEditorCheckbox();
        }
    }

    protected void addOpenInEditorCheckbox() {
        this.setDoNotAskOption((DialogWrapper.DoNotAskOption)new DialogWrapper.DoNotAskOption.Adapter(){

            public void rememberChoice(boolean selected2, int exitCode) {
                PropertiesComponent.getInstance().setValue(RefactoringDialog.this.getRefactoringId() + ".OpenInEditor", selected2, true);
                this.report(selected2, "open.in.editor.saved");
            }

            public boolean isSelectedByDefault() {
                boolean selected2 = PropertiesComponent.getInstance().getBoolean(RefactoringDialog.this.getRefactoringId() + ".OpenInEditor", true);
                return this.report(selected2, "open.in.editor.shown");
            }

            private boolean report(boolean selected2, String eventId) {
                String refactoringClassName = ((Object)((Object)RefactoringDialog.this)).getClass().getName();
                FeatureUsageData data2 = new FeatureUsageData().addData("selected", selected2).addData("class_name", refactoringClassName);
                FUCounterUsageLogger.getInstance().logEvent("refactoring.dialog", eventId, data2);
                return selected2;
            }

            @NotNull
            public String getDoNotShowMessage() {
                String string = RefactoringBundle.message((String)"open.in.editor.label");
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/ui/RefactoringDialog$1", "getDoNotShowMessage"));
            }
        });
    }

    @NonNls
    @NotNull
    protected String getRefactoringId() {
        String string = ((Object)((Object)this)).getClass().getName();
        if (string == null) {
            RefactoringDialog.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isOpenInEditor() {
        return this.myCheckBoxDoNotShowDialog != null && this.myCheckBoxDoNotShowDialog.isSelected();
    }

    public final boolean isPreviewUsages() {
        return this.myCbPreviewResults;
    }

    public void setPreviewResults(boolean previewResults) {
        this.myCbPreviewResults = previewResults;
    }

    public void show() {
        IdeEventQueue.getInstance().getPopupManager().closeAllPopups(false);
        super.show();
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.myRefactorAction = new RefactorAction();
        this.myPreviewAction = new PreviewAction();
    }

    protected final Action getRefactorAction() {
        return this.myRefactorAction;
    }

    protected final Action getPreviewAction() {
        return this.myPreviewAction;
    }

    protected abstract void doAction();

    private void doPreviewAction() {
        this.myCbPreviewResults = true;
        this.doAction();
    }

    protected void doRefactorAction() {
        this.myCbPreviewResults = false;
        this.doAction();
    }

    protected final void closeOKAction() {
        super.doOKAction();
    }

    protected final void doOKAction() {
        if (!DumbService.isDumbAware((Object)((Object)this)) && DumbService.isDumb((Project)this.myProject)) {
            Messages.showMessageDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"refactoring.not.available.indexing"), (String)RefactoringBundle.message((String)"refactoring.indexing.warning.title"), null);
            return;
        }
        this.doAction();
    }

    protected boolean areButtonsValid() {
        return true;
    }

    protected void canRun() throws ConfigurationException {
        if (!this.areButtonsValid()) {
            throw new ConfigurationException(null);
        }
    }

    protected void setHelpTooltip(@NotNull JButton helpButton) {
        if (helpButton == null) {
            RefactoringDialog.$$$reportNull$$$0(3);
        }
        if (Registry.is((String)"ide.helptooltip.enabled")) {
            new HelpTooltip().setDescription(ActionsBundle.actionDescription((String)"HelpTopics")).installOn((JComponent)helpButton);
        } else {
            super.setHelpTooltip(helpButton);
        }
    }

    protected void validateButtons() {
        boolean enabled = true;
        try {
            this.setErrorText(null);
            this.canRun();
        }
        catch (ConfigurationException e) {
            enabled = false;
            this.setErrorText(e.getMessage());
        }
        this.getPreviewAction().setEnabled(enabled);
        this.getRefactorAction().setEnabled(enabled);
    }

    protected boolean hasHelpAction() {
        return true;
    }

    protected boolean hasPreviewButton() {
        return true;
    }

    protected Action @NotNull [] createActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(this.getRefactorAction());
        if (this.hasPreviewButton()) {
            actions.add(this.getPreviewAction());
        }
        actions.add(this.getCancelAction());
        if (this.hasHelpAction()) {
            actions.add(this.getHelpAction());
        }
        if (SystemInfo.isMac) {
            Collections.reverse(actions);
        }
        Action[] actionArray = actions.toArray(new Action[0]);
        if (actionArray == null) {
            RefactoringDialog.$$$reportNull$$$0(4);
        }
        return actionArray;
    }

    protected Project getProject() {
        return this.myProject;
    }

    protected void invokeRefactoring(BaseRefactoringProcessor processor2) {
        Runnable prepareSuccessfulCallback = () -> this.close(0);
        processor2.setPrepareSuccessfulSwingThreadCallback(prepareSuccessfulCallback);
        processor2.setPreviewUsages(this.isPreviewUsages());
        processor2.run();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/ui/RefactoringDialog";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpButton";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/ui/RefactoringDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefactoringId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setHelpTooltip";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class PreviewAction
    extends AbstractAction {
        PreviewAction() {
            super(RefactoringBundle.message((String)"preview.button"));
            if (SystemInfo.isMac) {
                this.putValue("FocusedAction", Boolean.TRUE);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RefactoringDialog.this.doPreviewAction();
        }
    }

    private class RefactorAction
    extends AbstractAction {
        RefactorAction() {
            super(RefactoringBundle.message((String)"refactor.button"));
            this.putValue("DefaultAction", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RefactoringDialog.this.doRefactorAction();
        }
    }
}

