/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.layout;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.LayoutPassInfo;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.tabsLayout.TabsLayout;
import com.intellij.ui.tabs.impl.tabsLayout.TabsLayoutCallback;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TabsLayoutBase
implements TabsLayout {
    @NonNls
    private static final String LAYOUT_DONE = "Layout.done";
    protected TabsLayoutCallback myCallback;

    protected double getDragOutMultiplier() {
        return Registry.doubleValue((String)"ide.tabbedPane.dragOutMultiplier");
    }

    protected abstract LayoutPassInfo doLayout(List<TabInfo> var1, boolean var2);

    public void init(@NotNull TabsLayoutCallback callback2) {
        if (callback2 == null) {
            TabsLayoutBase.$$$reportNull$$$0(0);
        }
        this.myCallback = callback2;
    }

    public final LayoutPassInfo layoutContainer(boolean isForced) {
        ArrayList<TabInfo> tabsInfos = new ArrayList<TabInfo>(this.myCallback.getVisibleTabsInfos());
        TabInfo dropInfo = this.myCallback.getDropInfo();
        if (dropInfo != null && !tabsInfos.contains(dropInfo) && this.myCallback.isShowDropLocation()) {
            int dropInfoIndex = this.myCallback.getDropInfoIndex();
            if (dropInfoIndex >= 0 && dropInfoIndex < tabsInfos.size()) {
                tabsInfos.add(dropInfoIndex, dropInfo);
            } else {
                tabsInfos.add(dropInfo);
            }
        }
        LayoutPassInfo layoutPassInfo = this.doLayout(tabsInfos, isForced);
        this.applyResetComponents();
        return layoutPassInfo;
    }

    @Nullable
    public MouseListener getMouseListener() {
        return null;
    }

    @Nullable
    public MouseMotionListener getMouseMotionListener() {
        return null;
    }

    @Nullable
    public MouseWheelListener getMouseWheelListener() {
        return null;
    }

    public void mouseMotionEventDispatched(MouseEvent mouseMotionEvent) {
    }

    public boolean isToolbarOnTabs() {
        return false;
    }

    public boolean isDragOut(TabLabel tabLabel, int deltaX, int deltaY) {
        return (double)Math.abs(deltaY) > (double)tabLabel.getSize().height * this.getDragOutMultiplier();
    }

    public boolean ignoreTabLabelLimitedWidthWhenPaint() {
        return false;
    }

    public void dispose() {
    }

    protected Rectangle layoutComp(int componentX, int componentY, JComponent comp, int deltaWidth, int deltaHeight) {
        return this.layoutComp(new Rectangle(componentX, componentY, this.myCallback.getComponent().getWidth(), this.myCallback.getComponent().getHeight()), comp, deltaWidth, deltaHeight);
    }

    protected Rectangle layoutComp(Rectangle bounds2, JComponent comp, int deltaWidth, int deltaHeight) {
        Insets insets = this.myCallback.getLayoutInsets();
        Insets inner = this.myCallback.getInnerInsets();
        int x = insets.left + bounds2.x + inner.left;
        int y = insets.top + bounds2.y + inner.top;
        int width = bounds2.width - insets.left - insets.right - bounds2.x - inner.left - inner.right;
        int height = bounds2.height - insets.top - insets.bottom - bounds2.y - inner.top - inner.bottom;
        if (!this.myCallback.isHiddenTabs()) {
            width += deltaWidth;
            height += deltaHeight;
        }
        return this.layout(comp, x, y, width, height);
    }

    protected Rectangle layout(JComponent c, int x, int y, int width, int height) {
        return this.layout(c, new Rectangle(x, y, width, height));
    }

    protected Rectangle layout(JComponent component2, Rectangle bounds2) {
        Rectangle now = component2.getBounds();
        if (!bounds2.equals(now)) {
            component2.setBounds(bounds2);
        }
        component2.doLayout();
        component2.putClientProperty(LAYOUT_DONE, Boolean.TRUE);
        return bounds2;
    }

    protected void resetLayout(boolean resetLabels) {
        for (TabInfo each : this.myCallback.getVisibleTabsInfos()) {
            this.reset(each, resetLabels);
        }
        if (this.myCallback.getDropInfo() != null) {
            this.reset(this.myCallback.getDropInfo(), resetLabels);
        }
        for (TabInfo each : this.myCallback.getHiddenInfos().keySet()) {
            this.reset(each, resetLabels);
        }
        for (Component eachDeferred : this.myCallback.getDeferredToRemove().keySet()) {
            this.resetLayout((JComponent)eachDeferred);
        }
    }

    protected void reset(TabInfo each, boolean resetLabels) {
        JComponent c = each.getComponent();
        if (c != null) {
            this.resetLayout(c);
        }
        this.resetLayout((JComponent)this.myCallback.getToolbar(each));
        if (resetLabels) {
            this.resetLayout((JComponent)this.myCallback.getTabLabel(each));
        }
    }

    protected void resetLayout(JComponent component2) {
        if (component2 == null) {
            return;
        }
        component2.putClientProperty(LAYOUT_DONE, null);
    }

    private void applyResetComponents() {
        JComponent container2 = this.myCallback.getComponent();
        for (int i2 = 0; i2 < container2.getComponentCount(); ++i2) {
            JComponent jc;
            Component each = container2.getComponent(i2);
            if (!(each instanceof JComponent) || UIUtil.isClientPropertyTrue((Object)(jc = (JComponent)each), (Object)LAYOUT_DONE)) continue;
            this.layout(jc, new Rectangle(0, 0, 0, 0));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/ui/tabs/layout/TabsLayoutBase", "init"));
    }
}

