/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.layout.singleRowLayout;

import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.Splittable;
import com.intellij.openapi.util.Key;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.tabsLayout.TabsLayoutCallback;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

class TabsSideSplitter
implements Splittable,
PropertyChangeListener {
    @NotNull
    private final TabsLayoutCallback myCallback;
    private int mySideTabsLimit;
    private final OnePixelDivider myDivider;

    TabsSideSplitter(@NotNull TabsLayoutCallback callback2) {
        if (callback2 == null) {
            TabsSideSplitter.$$$reportNull$$$0(0);
        }
        this.mySideTabsLimit = JBTabsImpl.DEFAULT_MAX_TAB_WIDTH;
        this.myCallback = callback2;
        this.myCallback.getComponent().addPropertyChangeListener(JBTabsImpl.SIDE_TABS_SIZE_LIMIT_KEY.toString(), this);
        this.myDivider = new OnePixelDivider(false, (Splittable)this);
    }

    OnePixelDivider getDivider() {
        return this.myDivider;
    }

    public float getMinProportion(boolean first) {
        return Math.min(0.5f, (float)JBTabsImpl.MIN_TAB_WIDTH / (float)Math.max(1, this.myCallback.getComponent().getWidth()));
    }

    public void setProportion(float proportion) {
        int width = this.myCallback.getComponent().getWidth();
        if (this.myCallback.getTabsPosition() == JBTabsPosition.left) {
            this.setSideTabsLimit((int)Math.max((float)JBTabsImpl.MIN_TAB_WIDTH, proportion * (float)width));
        } else if (this.myCallback.getTabsPosition() == JBTabsPosition.right) {
            this.setSideTabsLimit(width - (int)Math.max((float)JBTabsImpl.MIN_TAB_WIDTH, proportion * (float)width));
        }
    }

    int getSideTabsLimit() {
        return this.mySideTabsLimit;
    }

    void setSideTabsLimit(int sideTabsLimit) {
        if (this.mySideTabsLimit != sideTabsLimit) {
            JComponent page;
            this.mySideTabsLimit = sideTabsLimit;
            UIUtil.putClientProperty((JComponent)this.myCallback.getComponent(), (Key)JBTabsImpl.SIDE_TABS_SIZE_LIMIT_KEY, (Object)this.mySideTabsLimit);
            this.myCallback.relayout(true, true);
            TabInfo info = this.myCallback.getSelectedInfo();
            JComponent jComponent = page = info != null ? info.getComponent() : null;
            if (page != null) {
                page.revalidate();
                page.repaint();
            }
        }
    }

    public boolean getOrientation() {
        return false;
    }

    public void setOrientation(boolean verticalSplit) {
    }

    public void setDragging(boolean dragging) {
    }

    @NotNull
    public Component asComponent() {
        JComponent jComponent = this.myCallback.getComponent();
        if (jComponent == null) {
            TabsSideSplitter.$$$reportNull$$$0(1);
        }
        return jComponent;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() != this.myCallback) {
            return;
        }
        Integer limit = (Integer)UIUtil.getClientProperty((Object)this.myCallback.getComponent(), (Key)JBTabsImpl.SIDE_TABS_SIZE_LIMIT_KEY);
        if (limit == null) {
            limit = JBTabsImpl.DEFAULT_MAX_TAB_WIDTH;
        }
        this.setSideTabsLimit(limit);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/tabs/layout/singleRowLayout/TabsSideSplitter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/tabs/layout/singleRowLayout/TabsSideSplitter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "asComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

