/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.Range;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ToggleBreakpointEnabledAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleBreakpointEnabledAction.$$$reportNull$$$0(0);
        }
        Set<XLineBreakpoint> breakpoints = ToggleBreakpointEnabledAction.findLineBreakpoints(e);
        Iterator iterator2 = breakpoints.iterator();
        while (iterator2.hasNext()) {
            XLineBreakpoint breakpoint;
            breakpoint.setEnabled(!(breakpoint = (XLineBreakpoint)iterator2.next()).isEnabled());
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleBreakpointEnabledAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabled(!ToggleBreakpointEnabledAction.findLineBreakpoints(e).isEmpty());
    }

    @NotNull
    private static Set<XLineBreakpoint> findLineBreakpoints(AnActionEvent e) {
        Project project = e.getProject();
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (project == null || editor == null) {
            Set<XLineBreakpoint> set = Collections.emptySet();
            if (set == null) {
                ToggleBreakpointEnabledAction.$$$reportNull$$$0(2);
            }
            return set;
        }
        XBreakpointManagerImpl breakpointManager = (XBreakpointManagerImpl)XDebuggerManager.getInstance((Project)project).getBreakpointManager();
        XLineBreakpointManager lineBreakpointManager = breakpointManager.getLineBreakpointManager();
        Document document = editor.getDocument();
        ArrayList<Range> lineRanges = new ArrayList<Range>();
        for (Caret caret : editor.getCaretModel().getAllCarets()) {
            lineRanges.add(new Range((Comparable)Integer.valueOf(document.getLineNumber(caret.getSelectionStart())), (Comparable)Integer.valueOf(document.getLineNumber(caret.getSelectionEnd()))));
        }
        Collection<XLineBreakpointImpl> breakpoints = lineBreakpointManager.getDocumentBreakpoints(document);
        HashSet<XLineBreakpoint> res2 = new HashSet<XLineBreakpoint>();
        for (XLineBreakpointImpl breakpoint : breakpoints) {
            int line = breakpoint.getLine();
            for (Range range2 : lineRanges) {
                if (!range2.isWithin((Comparable)Integer.valueOf(line))) continue;
                res2.add(breakpoint);
            }
        }
        HashSet<XLineBreakpoint> hashSet = res2;
        if (hashSet == null) {
            ToggleBreakpointEnabledAction.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/actions/ToggleBreakpointEnabledAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/actions/ToggleBreakpointEnabledAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findLineBreakpoints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

