/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp;

import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.openapi.project.Project;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import java.util.Map;
import org.intellij.lang.regexp.RegExpTT;
import org.jetbrains.annotations.NotNull;

public class RegExpHighlighter
extends SyntaxHighlighterBase {
    private static final Map<IElementType, TextAttributesKey> ourMap = new HashMap<IElementType, TextAttributesKey>();
    static final TextAttributesKey CHARACTER = TextAttributesKey.createTextAttributesKey((String)"REGEXP.CHARACTER", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
    static final TextAttributesKey DOT = TextAttributesKey.createTextAttributesKey((String)"REGEXP.DOT", (TextAttributesKey)DefaultLanguageHighlighterColors.DOT);
    public static final TextAttributesKey META = TextAttributesKey.createTextAttributesKey((String)"REGEXP.META", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
    static final TextAttributesKey INVALID_CHARACTER_ESCAPE = TextAttributesKey.createTextAttributesKey((String)"REGEXP.INVALID_STRING_ESCAPE", (TextAttributesKey)DefaultLanguageHighlighterColors.INVALID_STRING_ESCAPE);
    static final TextAttributesKey BAD_CHARACTER = TextAttributesKey.createTextAttributesKey((String)"REGEXP.BAD_CHARACTER", (TextAttributesKey)HighlighterColors.BAD_CHARACTER);
    static final TextAttributesKey REDUNDANT_ESCAPE = TextAttributesKey.createTextAttributesKey((String)"REGEXP.REDUNDANT_ESCAPE", (TextAttributesKey)DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE);
    static final TextAttributesKey PARENTHS = TextAttributesKey.createTextAttributesKey((String)"REGEXP.PARENTHS", (TextAttributesKey)DefaultLanguageHighlighterColors.PARENTHESES);
    static final TextAttributesKey BRACES = TextAttributesKey.createTextAttributesKey((String)"REGEXP.BRACES", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACES);
    static final TextAttributesKey BRACKETS = TextAttributesKey.createTextAttributesKey((String)"REGEXP.BRACKETS", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACKETS);
    static final TextAttributesKey COMMA = TextAttributesKey.createTextAttributesKey((String)"REGEXP.COMMA", (TextAttributesKey)DefaultLanguageHighlighterColors.COMMA);
    public static final TextAttributesKey ESC_CHARACTER = TextAttributesKey.createTextAttributesKey((String)"REGEXP.ESC_CHARACTER", (TextAttributesKey)DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE);
    static final TextAttributesKey CHAR_CLASS = TextAttributesKey.createTextAttributesKey((String)"REGEXP.CHAR_CLASS", (TextAttributesKey)DefaultLanguageHighlighterColors.MARKUP_ENTITY);
    static final TextAttributesKey QUOTE_CHARACTER = TextAttributesKey.createTextAttributesKey((String)"REGEXP.QUOTE_CHARACTER", (TextAttributesKey)DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE);
    static final TextAttributesKey COMMENT = TextAttributesKey.createTextAttributesKey((String)"REGEXP.COMMENT", (TextAttributesKey)DefaultLanguageHighlighterColors.LINE_COMMENT);
    static final TextAttributesKey QUANTIFIER = TextAttributesKey.createTextAttributesKey((String)"REGEXP.QUANTIFIER", (TextAttributesKey)DefaultLanguageHighlighterColors.NUMBER);
    static final TextAttributesKey OPTIONS = TextAttributesKey.createTextAttributesKey((String)"REGEXP.OPTIONS", (TextAttributesKey)DefaultLanguageHighlighterColors.PREDEFINED_SYMBOL);
    static final TextAttributesKey NAME = TextAttributesKey.createTextAttributesKey((String)"REGEXP.NAME", (TextAttributesKey)DefaultLanguageHighlighterColors.IDENTIFIER);
    public static final TextAttributesKey MATCHED_GROUPS = TextAttributesKey.createTextAttributesKey((String)"REGEXP_MATCHED_GROUPS");
    private final Project myProject;
    private final ParserDefinition myParserDefinition;

    public RegExpHighlighter(Project project, ParserDefinition parserDefinition) {
        this.myProject = project;
        this.myParserDefinition = parserDefinition;
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        Lexer lexer = this.myParserDefinition.createLexer(this.myProject);
        if (lexer == null) {
            RegExpHighlighter.$$$reportNull$$$0(0);
        }
        return lexer;
    }

    public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey[] textAttributesKeyArray = RegExpHighlighter.pack((TextAttributesKey)ourMap.get(tokenType));
        if (textAttributesKeyArray == null) {
            RegExpHighlighter.$$$reportNull$$$0(1);
        }
        return textAttributesKeyArray;
    }

    static {
        ourMap.put(RegExpTT.CHARACTER, CHARACTER);
        ourMap.put(RegExpTT.COLON, CHARACTER);
        ourMap.put(RegExpTT.MINUS, CHARACTER);
        ourMap.put(RegExpTT.DOT, DOT);
        ourMap.put(RegExpTT.NAME, NAME);
        ourMap.put(RegExpTT.BACKREF, NAME);
        ourMap.put(RegExpTT.UNION, META);
        ourMap.put(RegExpTT.CARET, META);
        ourMap.put(RegExpTT.DOLLAR, META);
        ourMap.put(RegExpTT.ANDAND, META);
        ourMap.put(StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN, INVALID_CHARACTER_ESCAPE);
        ourMap.put(StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN, INVALID_CHARACTER_ESCAPE);
        ourMap.put(RegExpTT.BAD_CHARACTER, BAD_CHARACTER);
        ourMap.put(RegExpTT.BAD_HEX_VALUE, INVALID_CHARACTER_ESCAPE);
        ourMap.put(RegExpTT.BAD_OCT_VALUE, INVALID_CHARACTER_ESCAPE);
        ourMap.put(RegExpTT.ESC_CHARACTER, ESC_CHARACTER);
        ourMap.put(RegExpTT.UNICODE_CHAR, ESC_CHARACTER);
        ourMap.put(RegExpTT.HEX_CHAR, ESC_CHARACTER);
        ourMap.put(RegExpTT.OCT_CHAR, ESC_CHARACTER);
        ourMap.put(RegExpTT.CTRL_CHARACTER, ESC_CHARACTER);
        ourMap.put(RegExpTT.PROPERTY, CHAR_CLASS);
        ourMap.put(RegExpTT.CHAR_CLASS, CHAR_CLASS);
        ourMap.put(RegExpTT.BOUNDARY, CHAR_CLASS);
        ourMap.put(RegExpTT.CTRL, CHAR_CLASS);
        ourMap.put(RegExpTT.ESC_CTRL_CHARACTER, CHAR_CLASS);
        ourMap.put(RegExpTT.NAMED_CHARACTER, CHAR_CLASS);
        ourMap.put(RegExpTT.CATEGORY_SHORT_HAND, CHAR_CLASS);
        ourMap.put(RegExpTT.RUBY_NAMED_GROUP_REF, CHAR_CLASS);
        ourMap.put(RegExpTT.RUBY_NAMED_GROUP_CALL, CHAR_CLASS);
        ourMap.put(RegExpTT.RUBY_QUOTED_NAMED_GROUP_REF, CHAR_CLASS);
        ourMap.put(RegExpTT.RUBY_QUOTED_NAMED_GROUP_CALL, CHAR_CLASS);
        ourMap.put(RegExpTT.REDUNDANT_ESCAPE, REDUNDANT_ESCAPE);
        ourMap.put(RegExpTT.QUOTE_BEGIN, QUOTE_CHARACTER);
        ourMap.put(RegExpTT.QUOTE_END, QUOTE_CHARACTER);
        ourMap.put(RegExpTT.NON_CAPT_GROUP, PARENTHS);
        ourMap.put(RegExpTT.ATOMIC_GROUP, PARENTHS);
        ourMap.put(RegExpTT.POS_LOOKBEHIND, PARENTHS);
        ourMap.put(RegExpTT.NEG_LOOKBEHIND, PARENTHS);
        ourMap.put(RegExpTT.POS_LOOKAHEAD, PARENTHS);
        ourMap.put(RegExpTT.PCRE_BRANCH_RESET, PARENTHS);
        ourMap.put(RegExpTT.NEG_LOOKAHEAD, PARENTHS);
        ourMap.put(RegExpTT.SET_OPTIONS, PARENTHS);
        ourMap.put(RegExpTT.PYTHON_NAMED_GROUP, PARENTHS);
        ourMap.put(RegExpTT.PYTHON_NAMED_GROUP_REF, PARENTHS);
        ourMap.put(RegExpTT.PCRE_RECURSIVE_NAMED_GROUP_REF, PARENTHS);
        ourMap.put(RegExpTT.PYTHON_COND_REF, PARENTHS);
        ourMap.put(RegExpTT.PCRE_COND_REF, PARENTHS);
        ourMap.put(RegExpTT.RUBY_NAMED_GROUP, PARENTHS);
        ourMap.put(RegExpTT.RUBY_QUOTED_NAMED_GROUP, PARENTHS);
        ourMap.put(RegExpTT.GROUP_BEGIN, PARENTHS);
        ourMap.put(RegExpTT.GROUP_END, PARENTHS);
        ourMap.put(RegExpTT.GT, PARENTHS);
        ourMap.put(RegExpTT.QUOTE, PARENTHS);
        ourMap.put(RegExpTT.LBRACE, BRACES);
        ourMap.put(RegExpTT.RBRACE, BRACES);
        ourMap.put(RegExpTT.CLASS_BEGIN, BRACKETS);
        ourMap.put(RegExpTT.CLASS_END, BRACKETS);
        ourMap.put(RegExpTT.BRACKET_EXPRESSION_BEGIN, BRACKETS);
        ourMap.put(RegExpTT.BRACKET_EXPRESSION_END, BRACKETS);
        ourMap.put(RegExpTT.COMMA, COMMA);
        ourMap.put(RegExpTT.NUMBER, QUANTIFIER);
        ourMap.put(RegExpTT.STAR, QUANTIFIER);
        ourMap.put(RegExpTT.PLUS, QUANTIFIER);
        ourMap.put(RegExpTT.QUEST, QUANTIFIER);
        ourMap.put(RegExpTT.COMMENT, COMMENT);
        ourMap.put(RegExpTT.OPTIONS_ON, OPTIONS);
        ourMap.put(RegExpTT.OPTIONS_OFF, OPTIONS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/intellij/lang/regexp/RegExpHighlighter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightingLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenHighlights";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

