/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import sun.security.ssl.CipherBox;
import sun.security.ssl.Debug;
import sun.security.ssl.EngineArgs;
import sun.security.ssl.EngineWriter;
import sun.security.ssl.InputRecord;
import sun.security.ssl.MAC;
import sun.security.ssl.OutputRecord;
import sun.security.ssl.SSLEngineImpl;

final class EngineOutputRecord
extends OutputRecord {
    private SSLEngineImpl engine;
    private EngineWriter writer;
    private boolean finishedMsg = false;

    EngineOutputRecord(byte type, SSLEngineImpl engine) {
        super(type, EngineOutputRecord.recordSize(type));
        this.engine = engine;
        this.writer = engine.writer;
    }

    private static int recordSize(byte type) {
        switch (type) {
            case 20: 
            case 21: {
                return 539;
            }
            case 22: {
                return 16921;
            }
            case 23: {
                return 0;
            }
        }
        throw new RuntimeException("Unknown record type: " + type);
    }

    void setFinishedMsg() {
        this.finishedMsg = true;
    }

    @Override
    public void flush() throws IOException {
        this.finishedMsg = false;
    }

    boolean isFinishedMsg() {
        return this.finishedMsg;
    }

    private void addMAC(MAC signer, ByteBuffer bb) throws IOException {
        if (signer.MAClen() != 0) {
            byte[] hash = signer.compute(this.contentType(), bb, false);
            bb.limit(bb.limit() + hash.length);
            bb.put(hash);
        }
    }

    void encrypt(CipherBox box, ByteBuffer bb) {
        box.encrypt(bb);
    }

    @Override
    void writeBuffer(OutputStream s, byte[] buf, int off, int len, int debugOffset) throws IOException {
        ByteBuffer netBB = (ByteBuffer)ByteBuffer.allocate(len).put(buf, 0, len).flip();
        this.writer.putOutboundData(netBB);
    }

    void write(MAC writeMAC, CipherBox writeCipher) throws IOException {
        switch (this.contentType()) {
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            default: {
                throw new RuntimeException("unexpected byte buffers");
            }
        }
        if (!this.isEmpty()) {
            this.addMAC(writeMAC);
            this.encrypt(writeCipher);
            this.write((OutputStream)null, false, (ByteArrayOutputStream)null);
        }
    }

    void write(EngineArgs ea, MAC writeMAC, CipherBox writeCipher) throws IOException {
        int length;
        assert (this.contentType() == 23);
        if (writeMAC == MAC.NULL) {
            return;
        }
        if (ea.getAppRemaining() == 0) {
            return;
        }
        if (this.engine.needToSplitPayload(writeCipher, this.protocolVersion)) {
            this.write(ea, writeMAC, writeCipher, 1);
            ea.resetLim();
            length = Math.min(ea.getAppRemaining(), 15846);
        } else {
            length = Math.min(ea.getAppRemaining(), 16384);
        }
        if (length > 0) {
            this.write(ea, writeMAC, writeCipher, length);
        }
    }

    void write(EngineArgs ea, MAC writeMAC, CipherBox writeCipher, int length) throws IOException {
        ByteBuffer dstBB = ea.netData;
        int dstPos = dstBB.position();
        int dstLim = dstBB.limit();
        int dstData = dstPos + 5;
        dstBB.position(dstData);
        ea.gather(length);
        dstBB.limit(dstBB.position());
        dstBB.position(dstData);
        this.addMAC(writeMAC, dstBB);
        dstBB.limit(dstBB.position());
        dstBB.position(dstData);
        this.encrypt(writeCipher, dstBB);
        if (debug != null && (Debug.isOn("record") || Debug.isOn("handshake")) && (debug != null && Debug.isOn("record") || this.contentType() == 20)) {
            System.out.println(Thread.currentThread().getName() + ", WRITE: " + this.protocolVersion + " " + InputRecord.contentName(this.contentType()) + ", length = " + length);
        }
        int packetLength = dstBB.limit() - dstData;
        dstBB.put(dstPos, this.contentType());
        dstBB.put(dstPos + 1, this.protocolVersion.major);
        dstBB.put(dstPos + 2, this.protocolVersion.minor);
        dstBB.put(dstPos + 3, (byte)(packetLength >> 8));
        dstBB.put(dstPos + 4, (byte)packetLength);
        dstBB.limit(dstLim);
    }
}

