"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var escape = require("escape-html");
var XMLValidatorConstructor;
try {
    XMLValidatorConstructor = require("raml-xml-validation").XMLValidator;
}
catch (exception) {
}
if (!XMLValidatorConstructor) {
    var XMLValidatorDummyImpl = /** @class */ (function () {
        function XMLValidatorDummyImpl(arg) {
        }
        XMLValidatorDummyImpl.prototype.validate = function (xml, references) {
            return [];
        };
        return XMLValidatorDummyImpl;
    }());
    XMLValidatorConstructor = XMLValidatorDummyImpl;
}
function createXmlSchemaReference(originalPath, virtualIndex, patchedContent) {
    return {
        originalPath: originalPath,
        virtualIndex: virtualIndex,
        patchedContent: patchedContent
    };
}
exports.createXmlSchemaReference = createXmlSchemaReference;
function objectToXml(object) {
    if (!object) {
        return '';
    }
    var nodeName = Object.keys(object)[0];
    var root = object[nodeName];
    if (nodeName == "#text") {
        return root;
    }
    if (!root && root !== '') {
        return '';
    }
    var result = '<' + nodeName;
    var attributes = root['$'] || {};
    Object.keys(attributes).forEach(function (key) {
        result = result + ' ' + key + '="' + attributes[key] + '"';
    });
    result = result + '>';
    if (typeof root === 'string') {
        result = result + escape(root);
    }
    else {
        Object.keys(root).forEach(function (key) {
            if (key === '$') {
                return;
            }
            if (key === "_" && (typeof root[key] === "string")) {
                result += escape(root[key]);
                return;
            }
            if (typeof root[key] === 'object' && !root[key].length) {
                var child = {};
                child[key] = root[key];
                result = result + objectToXml(child);
            }
            else if (typeof root[key] === 'string' || !root[key]) {
                var child = {};
                child[key] = root[key] || '';
                result = result + objectToXml(child);
            }
            else if (typeof root[key] === 'object' && root[key].length) {
                var children = root[key];
                for (var i = 0; i < children.length; i++) {
                    var member = children[i];
                    var child = {};
                    child[key] = member;
                    result = result + objectToXml(child);
                }
            }
        });
    }
    result = result + '</' + nodeName + '>';
    return result;
}
function getValidator(arg) {
    return new XMLValidatorConstructor(arg);
}
exports.getValidator = getValidator;
function jsonToXml(jsonObject) {
    var nodeName = jsonObject && Object.keys(jsonObject)[0];
    if (nodeName) {
        var root = jsonObject[nodeName];
        checkAttributes(root);
    }
    return objectToXml(jsonObject);
}
exports.jsonToXml = jsonToXml;
function checkAttributes(root) {
    if (!root || typeof root === 'string') {
        return;
    }
    var attributes = [];
    Object.keys(root).forEach(function (key) {
        if (key == "$") {
            return;
        }
        if (key.indexOf('@') === 0) {
            var attribute = { key: key, value: root[key] };
            attributes.push(attribute);
        }
        else {
            if (isArray(root[key])) {
                var elements = root[key];
                elements.forEach(function (element) { return checkAttributes(element); });
            }
            else if (typeof root[key] !== 'string') {
                checkAttributes(root[key]);
            }
        }
    });
    if (!root['$']) {
        root['$'] = {};
    }
    var newAttributes = root['$'];
    attributes.forEach(function (attribute) {
        delete root[attribute.key];
        var newKey = attribute.key.substring(1);
        newAttributes[newKey] = attribute.value;
    });
}
function isArray(instance) {
    if (!instance) {
        return false;
    }
    return typeof instance === 'object' && typeof instance.length === 'number';
}
//# sourceMappingURL=xmlUtil.js.map