# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.array_data_algorithm import ArrayDataAlgorithm


class BoostRandomSparseArraySource(ArrayDataAlgorithm):
    """
    BoostRandomSparseArraySource - generates a sparse N-way array
    containing random values.
    
    Superclass: ArrayDataAlgorithm
    
    @par Thanks: Developed by Timothy M. Shead (tshead@sandia.gov) at
    Sandia National Laboratories.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkBoostRandomSparseArraySource, obj, update, **traits)
    
    element_probability = traits.Float(0.5, enter_set=True, auto_set=False, desc=\
        """
        Stores the probability (in the range [0, 1]) that an element
        within the output matrix will have a non-zero value
        """
    )

    def _element_probability_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetElementProbability,
                        self.element_probability)

    element_probability_seed = traits.Int(123, enter_set=True, auto_set=False, desc=\
        """
        Stores a random-number-seed for determining which elements within
        the output matrix will have non-zero values
        """
    )

    def _element_probability_seed_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetElementProbabilitySeed,
                        self.element_probability_seed)

    element_value_seed = traits.Int(456, enter_set=True, auto_set=False, desc=\
        """
        Stores a random-number-seed for computing random element values
        """
    )

    def _element_value_seed_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetElementValueSeed,
                        self.element_value_seed)

    max_value = traits.Float(1.0, enter_set=True, auto_set=False, desc=\
        """
        Stores the maximum value of any element
        """
    )

    def _max_value_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaxValue,
                        self.max_value)

    min_value = traits.Float(0.0, enter_set=True, auto_set=False, desc=\
        """
        Stores the minimum value of any element
        """
    )

    def _min_value_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMinValue,
                        self.min_value)

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('element_probability', 'GetElementProbability'),
    ('element_probability_seed', 'GetElementProbabilitySeed'),
    ('element_value_seed', 'GetElementValueSeed'), ('max_value',
    'GetMaxValue'), ('min_value', 'GetMinValue'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'element_probability',
    'element_probability_seed', 'element_value_seed', 'max_value',
    'min_value', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(BoostRandomSparseArraySource, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit BoostRandomSparseArraySource properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['element_probability', 'element_probability_seed',
            'element_value_seed', 'max_value', 'min_value']),
            title='Edit BoostRandomSparseArraySource properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit BoostRandomSparseArraySource properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

