# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_set_algorithm import DataSetAlgorithm


class ProcessIdScalars(DataSetAlgorithm):
    """
    ProcessIdScalars - Sets cell or point scalars to the processor
    rank.
    
    Superclass: DataSetAlgorithm
    
    ProcessIdScalars is meant to display which processor owns which
    cells and points.  It is useful for visualizing the partitioning for
    streaming or distributed pipelines.
    
    @sa
    PolyDataStreamer
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkProcessIdScalars, obj, update, **traits)
    
    random_mode = tvtk_base.false_bool_trait(desc=\
        """
        
        """
    )

    def _random_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRandomMode,
                        self.random_mode_)

    def get_scalar_mode(self):
        """
        V.get_scalar_mode() -> int
        C++: int GetScalarMode()"""
        ret = self._vtk_obj.GetScalarMode()
        return ret
        

    def set_scalar_mode_to_cell_data(self):
        """
        V.set_scalar_mode_to_cell_data()
        C++: void SetScalarModeToCellData()
        Option to centerate cell scalars of points scalars.  Default is
        point scalars.
        """
        self._vtk_obj.SetScalarModeToCellData()

    def set_scalar_mode_to_point_data(self):
        """
        V.set_scalar_mode_to_point_data()
        C++: void SetScalarModeToPointData()"""
        self._vtk_obj.SetScalarModeToPointData()

    def _get_controller(self):
        return wrap_vtk(self._vtk_obj.GetController())
    def _set_controller(self, arg):
        old_val = self._get_controller()
        self._wrap_call(self._vtk_obj.SetController,
                        deref_vtk(arg))
        self.trait_property_changed('controller', old_val, arg)
    controller = traits.Property(_get_controller, _set_controller, desc=\
        """
        By default this filter uses the global controller, but this
        method can be used to set another instead.
        """
    )

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        """
        Get the input data object. This method is not recommended for
        use, but lots of old style filters use it.
        """
    )

    _updateable_traits_ = \
    (('random_mode', 'GetRandomMode'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('progress', 'GetProgress'),
    ('progress_text', 'GetProgressText'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display', 'random_mode',
    'release_data_flag', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ProcessIdScalars, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ProcessIdScalars properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['random_mode'], [], []),
            title='Edit ProcessIdScalars properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ProcessIdScalars properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

