//============================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//============================================================================
// **** DO NOT EDIT THIS FILE!!! ****
// This file is automatically generated by FunctionInterfaceDetailPre.h.in

#ifndef vtk_m_internal_FunctionInterfaceDetailPre_h
#define vtk_m_internal_FunctionInterfaceDetailPre_h

#if !defined(vtk_m_internal_FunctionInterface_h) && !defined(VTKM_TEST_HEADER_BUILD)
#error FunctionInterfaceDetailPre.h must be included from FunctionInterface.h
#endif

#include <vtkm/Types.h>
#include <vtkm/internal/IndexTag.h>

#include <type_traits>

#include <vtkm/internal/brigand.hpp>

#define VTKM_MAX_FUNCTION_PARAMETERS 20


namespace vtkm
{
namespace internal
{

/// This struct is used internally by FunctionInterface to store the return
/// value of a function. There is a special implementation for a return type of
/// void, which stores nothing.
///
template <typename T>
struct FunctionInterfaceReturnContainer
{
  T Value;
  static constexpr bool VALID = true;
};

template <>
struct FunctionInterfaceReturnContainer<void>
{
  // Nothing to store for void return.
  static constexpr bool VALID = false;
};

namespace detail
{

//============================================================================

// This templated class contains the state of parameters. If you get a compiler
// error stating that this class is not specialized, that probably means that
// you are using FunctionInterface with an unsupported number of arguments.
template <typename FunctionSignature>
struct ParameterContainer;

// clang-format off

template <typename R>
struct ParameterContainer<R()>
{
};

template <typename R,
          typename P1>
struct ParameterContainer<R(P1)>
{
  P1 Parameter1;
};

template <typename R,
          typename P1,
          typename P2>
struct ParameterContainer<R(P1, P2)>
{
  P1 Parameter1;
  P2 Parameter2;
};

template <typename R,
          typename P1,
          typename P2,
          typename P3>
struct ParameterContainer<R(P1, P2, P3)>
{
  P1 Parameter1;
  P2 Parameter2;
  P3 Parameter3;
};

template <typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4>
struct ParameterContainer<R(P1, P2, P3, P4)>
{
  P1 Parameter1;
  P2 Parameter2;
  P3 Parameter3;
  P4 Parameter4;
};

template <typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5>
struct ParameterContainer<R(P1, P2, P3, P4, P5)>
{
  P1 Parameter1;
  P2 Parameter2;
  P3 Parameter3;
  P4 Parameter4;
  P5 Parameter5;
};

template <typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6>
struct ParameterContainer<R(P1, P2, P3, P4, P5, P6)>
{
  P1 Parameter1;
  P2 Parameter2;
  P3 Parameter3;
  P4 Parameter4;
  P5 Parameter5;
  P6 Parameter6;
};

template <typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7>
struct ParameterContainer<R(P1, P2, P3, P4, P5, P6, P7)>
{
  P1 Parameter1;
  P2 Parameter2;
  P3 Parameter3;
  P4 Parameter4;
  P5 Parameter5;
  P6 Parameter6;
  P7 Parameter7;
};

template <typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8>
struct ParameterContainer<R(P1, P2, P3, P4, P5, P6, P7, P8)>
{
  P1 Parameter1;
  P2 Parameter2;
  P3 Parameter3;
  P4 Parameter4;
  P5 Parameter5;
  P6 Parameter6;
  P7 Parameter7;
  P8 Parameter8;
};

template <typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9>
struct ParameterContainer<R(P1, P2, P3, P4, P5, P6, P7, P8, P9)>
{
  P1 Parameter1;
  P2 Parameter2;
  P3 Parameter3;
  P4 Parameter4;
  P5 Parameter5;
  P6 Parameter6;
  P7 Parameter7;
  P8 Parameter8;
  P9 Parameter9;
};

template <typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9,
          typename P10>
struct ParameterContainer<R(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10)>
{
  P1 Parameter1;
  P2 Parameter2;
  P3 Parameter3;
  P4 Parameter4;
  P5 Parameter5;
  P6 Parameter6;
  P7 Parameter7;
  P8 Parameter8;
  P9 Parameter9;
  P10 Parameter10;
};

template <typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9,
          typename P10,
          typename P11>
struct ParameterContainer<R(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11)>
{
  P1 Parameter1;
  P2 Parameter2;
  P3 Parameter3;
  P4 Parameter4;
  P5 Parameter5;
  P6 Parameter6;
  P7 Parameter7;
  P8 Parameter8;
  P9 Parameter9;
  P10 Parameter10;
  P11 Parameter11;
};

template <typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9,
          typename P10,
          typename P11,
          typename P12>
struct ParameterContainer<R(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12)>
{
  P1 Parameter1;
  P2 Parameter2;
  P3 Parameter3;
  P4 Parameter4;
  P5 Parameter5;
  P6 Parameter6;
  P7 Parameter7;
  P8 Parameter8;
  P9 Parameter9;
  P10 Parameter10;
  P11 Parameter11;
  P12 Parameter12;
};

template <typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9,
          typename P10,
          typename P11,
          typename P12,
          typename P13>
struct ParameterContainer<R(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13)>
{
  P1 Parameter1;
  P2 Parameter2;
  P3 Parameter3;
  P4 Parameter4;
  P5 Parameter5;
  P6 Parameter6;
  P7 Parameter7;
  P8 Parameter8;
  P9 Parameter9;
  P10 Parameter10;
  P11 Parameter11;
  P12 Parameter12;
  P13 Parameter13;
};

template <typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9,
          typename P10,
          typename P11,
          typename P12,
          typename P13,
          typename P14>
struct ParameterContainer<R(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14)>
{
  P1 Parameter1;
  P2 Parameter2;
  P3 Parameter3;
  P4 Parameter4;
  P5 Parameter5;
  P6 Parameter6;
  P7 Parameter7;
  P8 Parameter8;
  P9 Parameter9;
  P10 Parameter10;
  P11 Parameter11;
  P12 Parameter12;
  P13 Parameter13;
  P14 Parameter14;
};

template <typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9,
          typename P10,
          typename P11,
          typename P12,
          typename P13,
          typename P14,
          typename P15>
struct ParameterContainer<R(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15)>
{
  P1 Parameter1;
  P2 Parameter2;
  P3 Parameter3;
  P4 Parameter4;
  P5 Parameter5;
  P6 Parameter6;
  P7 Parameter7;
  P8 Parameter8;
  P9 Parameter9;
  P10 Parameter10;
  P11 Parameter11;
  P12 Parameter12;
  P13 Parameter13;
  P14 Parameter14;
  P15 Parameter15;
};

template <typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9,
          typename P10,
          typename P11,
          typename P12,
          typename P13,
          typename P14,
          typename P15,
          typename P16>
struct ParameterContainer<R(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15, P16)>
{
  P1 Parameter1;
  P2 Parameter2;
  P3 Parameter3;
  P4 Parameter4;
  P5 Parameter5;
  P6 Parameter6;
  P7 Parameter7;
  P8 Parameter8;
  P9 Parameter9;
  P10 Parameter10;
  P11 Parameter11;
  P12 Parameter12;
  P13 Parameter13;
  P14 Parameter14;
  P15 Parameter15;
  P16 Parameter16;
};

template <typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9,
          typename P10,
          typename P11,
          typename P12,
          typename P13,
          typename P14,
          typename P15,
          typename P16,
          typename P17>
struct ParameterContainer<R(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15, P16, P17)>
{
  P1 Parameter1;
  P2 Parameter2;
  P3 Parameter3;
  P4 Parameter4;
  P5 Parameter5;
  P6 Parameter6;
  P7 Parameter7;
  P8 Parameter8;
  P9 Parameter9;
  P10 Parameter10;
  P11 Parameter11;
  P12 Parameter12;
  P13 Parameter13;
  P14 Parameter14;
  P15 Parameter15;
  P16 Parameter16;
  P17 Parameter17;
};

template <typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9,
          typename P10,
          typename P11,
          typename P12,
          typename P13,
          typename P14,
          typename P15,
          typename P16,
          typename P17,
          typename P18>
struct ParameterContainer<R(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15, P16, P17, P18)>
{
  P1 Parameter1;
  P2 Parameter2;
  P3 Parameter3;
  P4 Parameter4;
  P5 Parameter5;
  P6 Parameter6;
  P7 Parameter7;
  P8 Parameter8;
  P9 Parameter9;
  P10 Parameter10;
  P11 Parameter11;
  P12 Parameter12;
  P13 Parameter13;
  P14 Parameter14;
  P15 Parameter15;
  P16 Parameter16;
  P17 Parameter17;
  P18 Parameter18;
};

template <typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9,
          typename P10,
          typename P11,
          typename P12,
          typename P13,
          typename P14,
          typename P15,
          typename P16,
          typename P17,
          typename P18,
          typename P19>
struct ParameterContainer<R(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15, P16, P17, P18, P19)>
{
  P1 Parameter1;
  P2 Parameter2;
  P3 Parameter3;
  P4 Parameter4;
  P5 Parameter5;
  P6 Parameter6;
  P7 Parameter7;
  P8 Parameter8;
  P9 Parameter9;
  P10 Parameter10;
  P11 Parameter11;
  P12 Parameter12;
  P13 Parameter13;
  P14 Parameter14;
  P15 Parameter15;
  P16 Parameter16;
  P17 Parameter17;
  P18 Parameter18;
  P19 Parameter19;
};

template <typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9,
          typename P10,
          typename P11,
          typename P12,
          typename P13,
          typename P14,
          typename P15,
          typename P16,
          typename P17,
          typename P18,
          typename P19,
          typename P20>
struct ParameterContainer<R(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15, P16, P17, P18, P19, P20)>
{
  P1 Parameter1;
  P2 Parameter2;
  P3 Parameter3;
  P4 Parameter4;
  P5 Parameter5;
  P6 Parameter6;
  P7 Parameter7;
  P8 Parameter8;
  P9 Parameter9;
  P10 Parameter10;
  P11 Parameter11;
  P12 Parameter12;
  P13 Parameter13;
  P14 Parameter14;
  P15 Parameter15;
  P16 Parameter16;
  P17 Parameter17;
  P18 Parameter18;
  P19 Parameter19;
  P20 Parameter20;
};

// clang-format on

//============================================================================
template <typename>
struct FunctionSigInfo;
template <typename R, typename... ArgTypes>
struct FunctionSigInfo<R(ArgTypes...)>
{
  static constexpr std::size_t Arity = sizeof...(ArgTypes);
  using ArityType = std::integral_constant<int, static_cast<int>(Arity)>;

  using ResultType = R;
  using Components = brigand::list<R, ArgTypes...>;
  using Parameters = brigand::list<ArgTypes...>;
};

template <int, typename>
struct AtType;
template <int Index, typename R, typename... ArgTypes>
struct AtType<Index, R(ArgTypes...)>
{
  using type = brigand::at_c<brigand::list<R, ArgTypes...>, Index>;
};

//============================================================================

// clang-format off

VTKM_SUPPRESS_EXEC_WARNINGS
template <typename FunctionSignature>
VTKM_EXEC_CONT auto ParameterGet(const ParameterContainer<FunctionSignature>& parameters,
                                 vtkm::internal::IndexTag<1>)
  -> decltype(parameters.Parameter1) const&
{
  return parameters.Parameter1;
}
VTKM_SUPPRESS_EXEC_WARNINGS
template <typename FunctionSignature>
VTKM_EXEC_CONT auto ParameterGet(const ParameterContainer<FunctionSignature>& parameters,
                                 vtkm::internal::IndexTag<2>)
  -> decltype(parameters.Parameter2) const&
{
  return parameters.Parameter2;
}
VTKM_SUPPRESS_EXEC_WARNINGS
template <typename FunctionSignature>
VTKM_EXEC_CONT auto ParameterGet(const ParameterContainer<FunctionSignature>& parameters,
                                 vtkm::internal::IndexTag<3>)
  -> decltype(parameters.Parameter3) const&
{
  return parameters.Parameter3;
}
VTKM_SUPPRESS_EXEC_WARNINGS
template <typename FunctionSignature>
VTKM_EXEC_CONT auto ParameterGet(const ParameterContainer<FunctionSignature>& parameters,
                                 vtkm::internal::IndexTag<4>)
  -> decltype(parameters.Parameter4) const&
{
  return parameters.Parameter4;
}
VTKM_SUPPRESS_EXEC_WARNINGS
template <typename FunctionSignature>
VTKM_EXEC_CONT auto ParameterGet(const ParameterContainer<FunctionSignature>& parameters,
                                 vtkm::internal::IndexTag<5>)
  -> decltype(parameters.Parameter5) const&
{
  return parameters.Parameter5;
}
VTKM_SUPPRESS_EXEC_WARNINGS
template <typename FunctionSignature>
VTKM_EXEC_CONT auto ParameterGet(const ParameterContainer<FunctionSignature>& parameters,
                                 vtkm::internal::IndexTag<6>)
  -> decltype(parameters.Parameter6) const&
{
  return parameters.Parameter6;
}
VTKM_SUPPRESS_EXEC_WARNINGS
template <typename FunctionSignature>
VTKM_EXEC_CONT auto ParameterGet(const ParameterContainer<FunctionSignature>& parameters,
                                 vtkm::internal::IndexTag<7>)
  -> decltype(parameters.Parameter7) const&
{
  return parameters.Parameter7;
}
VTKM_SUPPRESS_EXEC_WARNINGS
template <typename FunctionSignature>
VTKM_EXEC_CONT auto ParameterGet(const ParameterContainer<FunctionSignature>& parameters,
                                 vtkm::internal::IndexTag<8>)
  -> decltype(parameters.Parameter8) const&
{
  return parameters.Parameter8;
}
VTKM_SUPPRESS_EXEC_WARNINGS
template <typename FunctionSignature>
VTKM_EXEC_CONT auto ParameterGet(const ParameterContainer<FunctionSignature>& parameters,
                                 vtkm::internal::IndexTag<9>)
  -> decltype(parameters.Parameter9) const&
{
  return parameters.Parameter9;
}
VTKM_SUPPRESS_EXEC_WARNINGS
template <typename FunctionSignature>
VTKM_EXEC_CONT auto ParameterGet(const ParameterContainer<FunctionSignature>& parameters,
                                 vtkm::internal::IndexTag<10>)
  -> decltype(parameters.Parameter10) const&
{
  return parameters.Parameter10;
}
VTKM_SUPPRESS_EXEC_WARNINGS
template <typename FunctionSignature>
VTKM_EXEC_CONT auto ParameterGet(const ParameterContainer<FunctionSignature>& parameters,
                                 vtkm::internal::IndexTag<11>)
  -> decltype(parameters.Parameter11) const&
{
  return parameters.Parameter11;
}
VTKM_SUPPRESS_EXEC_WARNINGS
template <typename FunctionSignature>
VTKM_EXEC_CONT auto ParameterGet(const ParameterContainer<FunctionSignature>& parameters,
                                 vtkm::internal::IndexTag<12>)
  -> decltype(parameters.Parameter12) const&
{
  return parameters.Parameter12;
}
VTKM_SUPPRESS_EXEC_WARNINGS
template <typename FunctionSignature>
VTKM_EXEC_CONT auto ParameterGet(const ParameterContainer<FunctionSignature>& parameters,
                                 vtkm::internal::IndexTag<13>)
  -> decltype(parameters.Parameter13) const&
{
  return parameters.Parameter13;
}
VTKM_SUPPRESS_EXEC_WARNINGS
template <typename FunctionSignature>
VTKM_EXEC_CONT auto ParameterGet(const ParameterContainer<FunctionSignature>& parameters,
                                 vtkm::internal::IndexTag<14>)
  -> decltype(parameters.Parameter14) const&
{
  return parameters.Parameter14;
}
VTKM_SUPPRESS_EXEC_WARNINGS
template <typename FunctionSignature>
VTKM_EXEC_CONT auto ParameterGet(const ParameterContainer<FunctionSignature>& parameters,
                                 vtkm::internal::IndexTag<15>)
  -> decltype(parameters.Parameter15) const&
{
  return parameters.Parameter15;
}
VTKM_SUPPRESS_EXEC_WARNINGS
template <typename FunctionSignature>
VTKM_EXEC_CONT auto ParameterGet(const ParameterContainer<FunctionSignature>& parameters,
                                 vtkm::internal::IndexTag<16>)
  -> decltype(parameters.Parameter16) const&
{
  return parameters.Parameter16;
}
VTKM_SUPPRESS_EXEC_WARNINGS
template <typename FunctionSignature>
VTKM_EXEC_CONT auto ParameterGet(const ParameterContainer<FunctionSignature>& parameters,
                                 vtkm::internal::IndexTag<17>)
  -> decltype(parameters.Parameter17) const&
{
  return parameters.Parameter17;
}
VTKM_SUPPRESS_EXEC_WARNINGS
template <typename FunctionSignature>
VTKM_EXEC_CONT auto ParameterGet(const ParameterContainer<FunctionSignature>& parameters,
                                 vtkm::internal::IndexTag<18>)
  -> decltype(parameters.Parameter18) const&
{
  return parameters.Parameter18;
}
VTKM_SUPPRESS_EXEC_WARNINGS
template <typename FunctionSignature>
VTKM_EXEC_CONT auto ParameterGet(const ParameterContainer<FunctionSignature>& parameters,
                                 vtkm::internal::IndexTag<19>)
  -> decltype(parameters.Parameter19) const&
{
  return parameters.Parameter19;
}
VTKM_SUPPRESS_EXEC_WARNINGS
template <typename FunctionSignature>
VTKM_EXEC_CONT auto ParameterGet(const ParameterContainer<FunctionSignature>& parameters,
                                 vtkm::internal::IndexTag<20>)
  -> decltype(parameters.Parameter20) const&
{
  return parameters.Parameter20;
}

// clang-format on

//============================================================================

template <typename OriginalSignature, typename Transform>
struct FunctionInterfaceStaticTransformType;

// clang-format off

VTKM_SUPPRESS_EXEC_WARNINGS
template <typename Result,
          typename Transform,
          typename OriginalR>
VTKM_CONT Result DoStaticTransformCont(
  const Transform& transform,
  ParameterContainer<OriginalR()>& originalParameters)
{
  (void)transform;
  (void)originalParameters;
}

VTKM_SUPPRESS_EXEC_WARNINGS
template <typename Result,
          typename Transform,
          typename OriginalR,
          typename OriginalP1>
VTKM_CONT Result DoStaticTransformCont(
  const Transform& transform,
  ParameterContainer<OriginalR(OriginalP1)>& originalParameters)
{
  return Result{
    transform(originalParameters.Parameter1, vtkm::internal::IndexTag<1>())
  };
}

VTKM_SUPPRESS_EXEC_WARNINGS
template <typename Result,
          typename Transform,
          typename OriginalR,
          typename OriginalP1,
          typename OriginalP2>
VTKM_CONT Result DoStaticTransformCont(
  const Transform& transform,
  ParameterContainer<OriginalR(OriginalP1, OriginalP2)>& originalParameters)
{
  return Result{
    transform(originalParameters.Parameter1, vtkm::internal::IndexTag<1>()),
    transform(originalParameters.Parameter2, vtkm::internal::IndexTag<2>())
  };
}

VTKM_SUPPRESS_EXEC_WARNINGS
template <typename Result,
          typename Transform,
          typename OriginalR,
          typename OriginalP1,
          typename OriginalP2,
          typename OriginalP3>
VTKM_CONT Result DoStaticTransformCont(
  const Transform& transform,
  ParameterContainer<OriginalR(OriginalP1, OriginalP2, OriginalP3)>& originalParameters)
{
  return Result{
    transform(originalParameters.Parameter1, vtkm::internal::IndexTag<1>()),
    transform(originalParameters.Parameter2, vtkm::internal::IndexTag<2>()),
    transform(originalParameters.Parameter3, vtkm::internal::IndexTag<3>())
  };
}

VTKM_SUPPRESS_EXEC_WARNINGS
template <typename Result,
          typename Transform,
          typename OriginalR,
          typename OriginalP1,
          typename OriginalP2,
          typename OriginalP3,
          typename OriginalP4>
VTKM_CONT Result DoStaticTransformCont(
  const Transform& transform,
  ParameterContainer<OriginalR(OriginalP1, OriginalP2, OriginalP3, OriginalP4)>& originalParameters)
{
  return Result{
    transform(originalParameters.Parameter1, vtkm::internal::IndexTag<1>()),
    transform(originalParameters.Parameter2, vtkm::internal::IndexTag<2>()),
    transform(originalParameters.Parameter3, vtkm::internal::IndexTag<3>()),
    transform(originalParameters.Parameter4, vtkm::internal::IndexTag<4>())
  };
}

VTKM_SUPPRESS_EXEC_WARNINGS
template <typename Result,
          typename Transform,
          typename OriginalR,
          typename OriginalP1,
          typename OriginalP2,
          typename OriginalP3,
          typename OriginalP4,
          typename OriginalP5>
VTKM_CONT Result DoStaticTransformCont(
  const Transform& transform,
  ParameterContainer<OriginalR(OriginalP1, OriginalP2, OriginalP3, OriginalP4, OriginalP5)>& originalParameters)
{
  return Result{
    transform(originalParameters.Parameter1, vtkm::internal::IndexTag<1>()),
    transform(originalParameters.Parameter2, vtkm::internal::IndexTag<2>()),
    transform(originalParameters.Parameter3, vtkm::internal::IndexTag<3>()),
    transform(originalParameters.Parameter4, vtkm::internal::IndexTag<4>()),
    transform(originalParameters.Parameter5, vtkm::internal::IndexTag<5>())
  };
}

VTKM_SUPPRESS_EXEC_WARNINGS
template <typename Result,
          typename Transform,
          typename OriginalR,
          typename OriginalP1,
          typename OriginalP2,
          typename OriginalP3,
          typename OriginalP4,
          typename OriginalP5,
          typename OriginalP6>
VTKM_CONT Result DoStaticTransformCont(
  const Transform& transform,
  ParameterContainer<OriginalR(OriginalP1, OriginalP2, OriginalP3, OriginalP4, OriginalP5, OriginalP6)>& originalParameters)
{
  return Result{
    transform(originalParameters.Parameter1, vtkm::internal::IndexTag<1>()),
    transform(originalParameters.Parameter2, vtkm::internal::IndexTag<2>()),
    transform(originalParameters.Parameter3, vtkm::internal::IndexTag<3>()),
    transform(originalParameters.Parameter4, vtkm::internal::IndexTag<4>()),
    transform(originalParameters.Parameter5, vtkm::internal::IndexTag<5>()),
    transform(originalParameters.Parameter6, vtkm::internal::IndexTag<6>())
  };
}

VTKM_SUPPRESS_EXEC_WARNINGS
template <typename Result,
          typename Transform,
          typename OriginalR,
          typename OriginalP1,
          typename OriginalP2,
          typename OriginalP3,
          typename OriginalP4,
          typename OriginalP5,
          typename OriginalP6,
          typename OriginalP7>
VTKM_CONT Result DoStaticTransformCont(
  const Transform& transform,
  ParameterContainer<OriginalR(OriginalP1, OriginalP2, OriginalP3, OriginalP4, OriginalP5, OriginalP6, OriginalP7)>& originalParameters)
{
  return Result{
    transform(originalParameters.Parameter1, vtkm::internal::IndexTag<1>()),
    transform(originalParameters.Parameter2, vtkm::internal::IndexTag<2>()),
    transform(originalParameters.Parameter3, vtkm::internal::IndexTag<3>()),
    transform(originalParameters.Parameter4, vtkm::internal::IndexTag<4>()),
    transform(originalParameters.Parameter5, vtkm::internal::IndexTag<5>()),
    transform(originalParameters.Parameter6, vtkm::internal::IndexTag<6>()),
    transform(originalParameters.Parameter7, vtkm::internal::IndexTag<7>())
  };
}

VTKM_SUPPRESS_EXEC_WARNINGS
template <typename Result,
          typename Transform,
          typename OriginalR,
          typename OriginalP1,
          typename OriginalP2,
          typename OriginalP3,
          typename OriginalP4,
          typename OriginalP5,
          typename OriginalP6,
          typename OriginalP7,
          typename OriginalP8>
VTKM_CONT Result DoStaticTransformCont(
  const Transform& transform,
  ParameterContainer<OriginalR(OriginalP1, OriginalP2, OriginalP3, OriginalP4, OriginalP5, OriginalP6, OriginalP7, OriginalP8)>& originalParameters)
{
  return Result{
    transform(originalParameters.Parameter1, vtkm::internal::IndexTag<1>()),
    transform(originalParameters.Parameter2, vtkm::internal::IndexTag<2>()),
    transform(originalParameters.Parameter3, vtkm::internal::IndexTag<3>()),
    transform(originalParameters.Parameter4, vtkm::internal::IndexTag<4>()),
    transform(originalParameters.Parameter5, vtkm::internal::IndexTag<5>()),
    transform(originalParameters.Parameter6, vtkm::internal::IndexTag<6>()),
    transform(originalParameters.Parameter7, vtkm::internal::IndexTag<7>()),
    transform(originalParameters.Parameter8, vtkm::internal::IndexTag<8>())
  };
}

VTKM_SUPPRESS_EXEC_WARNINGS
template <typename Result,
          typename Transform,
          typename OriginalR,
          typename OriginalP1,
          typename OriginalP2,
          typename OriginalP3,
          typename OriginalP4,
          typename OriginalP5,
          typename OriginalP6,
          typename OriginalP7,
          typename OriginalP8,
          typename OriginalP9>
VTKM_CONT Result DoStaticTransformCont(
  const Transform& transform,
  ParameterContainer<OriginalR(OriginalP1, OriginalP2, OriginalP3, OriginalP4, OriginalP5, OriginalP6, OriginalP7, OriginalP8, OriginalP9)>& originalParameters)
{
  return Result{
    transform(originalParameters.Parameter1, vtkm::internal::IndexTag<1>()),
    transform(originalParameters.Parameter2, vtkm::internal::IndexTag<2>()),
    transform(originalParameters.Parameter3, vtkm::internal::IndexTag<3>()),
    transform(originalParameters.Parameter4, vtkm::internal::IndexTag<4>()),
    transform(originalParameters.Parameter5, vtkm::internal::IndexTag<5>()),
    transform(originalParameters.Parameter6, vtkm::internal::IndexTag<6>()),
    transform(originalParameters.Parameter7, vtkm::internal::IndexTag<7>()),
    transform(originalParameters.Parameter8, vtkm::internal::IndexTag<8>()),
    transform(originalParameters.Parameter9, vtkm::internal::IndexTag<9>())
  };
}

VTKM_SUPPRESS_EXEC_WARNINGS
template <typename Result,
          typename Transform,
          typename OriginalR,
          typename OriginalP1,
          typename OriginalP2,
          typename OriginalP3,
          typename OriginalP4,
          typename OriginalP5,
          typename OriginalP6,
          typename OriginalP7,
          typename OriginalP8,
          typename OriginalP9,
          typename OriginalP10>
VTKM_CONT Result DoStaticTransformCont(
  const Transform& transform,
  ParameterContainer<OriginalR(OriginalP1, OriginalP2, OriginalP3, OriginalP4, OriginalP5, OriginalP6, OriginalP7, OriginalP8, OriginalP9, OriginalP10)>& originalParameters)
{
  return Result{
    transform(originalParameters.Parameter1, vtkm::internal::IndexTag<1>()),
    transform(originalParameters.Parameter2, vtkm::internal::IndexTag<2>()),
    transform(originalParameters.Parameter3, vtkm::internal::IndexTag<3>()),
    transform(originalParameters.Parameter4, vtkm::internal::IndexTag<4>()),
    transform(originalParameters.Parameter5, vtkm::internal::IndexTag<5>()),
    transform(originalParameters.Parameter6, vtkm::internal::IndexTag<6>()),
    transform(originalParameters.Parameter7, vtkm::internal::IndexTag<7>()),
    transform(originalParameters.Parameter8, vtkm::internal::IndexTag<8>()),
    transform(originalParameters.Parameter9, vtkm::internal::IndexTag<9>()),
    transform(originalParameters.Parameter10, vtkm::internal::IndexTag<10>())
  };
}

VTKM_SUPPRESS_EXEC_WARNINGS
template <typename Result,
          typename Transform,
          typename OriginalR,
          typename OriginalP1,
          typename OriginalP2,
          typename OriginalP3,
          typename OriginalP4,
          typename OriginalP5,
          typename OriginalP6,
          typename OriginalP7,
          typename OriginalP8,
          typename OriginalP9,
          typename OriginalP10,
          typename OriginalP11>
VTKM_CONT Result DoStaticTransformCont(
  const Transform& transform,
  ParameterContainer<OriginalR(OriginalP1, OriginalP2, OriginalP3, OriginalP4, OriginalP5, OriginalP6, OriginalP7, OriginalP8, OriginalP9, OriginalP10, OriginalP11)>& originalParameters)
{
  return Result{
    transform(originalParameters.Parameter1, vtkm::internal::IndexTag<1>()),
    transform(originalParameters.Parameter2, vtkm::internal::IndexTag<2>()),
    transform(originalParameters.Parameter3, vtkm::internal::IndexTag<3>()),
    transform(originalParameters.Parameter4, vtkm::internal::IndexTag<4>()),
    transform(originalParameters.Parameter5, vtkm::internal::IndexTag<5>()),
    transform(originalParameters.Parameter6, vtkm::internal::IndexTag<6>()),
    transform(originalParameters.Parameter7, vtkm::internal::IndexTag<7>()),
    transform(originalParameters.Parameter8, vtkm::internal::IndexTag<8>()),
    transform(originalParameters.Parameter9, vtkm::internal::IndexTag<9>()),
    transform(originalParameters.Parameter10, vtkm::internal::IndexTag<10>()),
    transform(originalParameters.Parameter11, vtkm::internal::IndexTag<11>())
  };
}

VTKM_SUPPRESS_EXEC_WARNINGS
template <typename Result,
          typename Transform,
          typename OriginalR,
          typename OriginalP1,
          typename OriginalP2,
          typename OriginalP3,
          typename OriginalP4,
          typename OriginalP5,
          typename OriginalP6,
          typename OriginalP7,
          typename OriginalP8,
          typename OriginalP9,
          typename OriginalP10,
          typename OriginalP11,
          typename OriginalP12>
VTKM_CONT Result DoStaticTransformCont(
  const Transform& transform,
  ParameterContainer<OriginalR(OriginalP1, OriginalP2, OriginalP3, OriginalP4, OriginalP5, OriginalP6, OriginalP7, OriginalP8, OriginalP9, OriginalP10, OriginalP11, OriginalP12)>& originalParameters)
{
  return Result{
    transform(originalParameters.Parameter1, vtkm::internal::IndexTag<1>()),
    transform(originalParameters.Parameter2, vtkm::internal::IndexTag<2>()),
    transform(originalParameters.Parameter3, vtkm::internal::IndexTag<3>()),
    transform(originalParameters.Parameter4, vtkm::internal::IndexTag<4>()),
    transform(originalParameters.Parameter5, vtkm::internal::IndexTag<5>()),
    transform(originalParameters.Parameter6, vtkm::internal::IndexTag<6>()),
    transform(originalParameters.Parameter7, vtkm::internal::IndexTag<7>()),
    transform(originalParameters.Parameter8, vtkm::internal::IndexTag<8>()),
    transform(originalParameters.Parameter9, vtkm::internal::IndexTag<9>()),
    transform(originalParameters.Parameter10, vtkm::internal::IndexTag<10>()),
    transform(originalParameters.Parameter11, vtkm::internal::IndexTag<11>()),
    transform(originalParameters.Parameter12, vtkm::internal::IndexTag<12>())
  };
}

VTKM_SUPPRESS_EXEC_WARNINGS
template <typename Result,
          typename Transform,
          typename OriginalR,
          typename OriginalP1,
          typename OriginalP2,
          typename OriginalP3,
          typename OriginalP4,
          typename OriginalP5,
          typename OriginalP6,
          typename OriginalP7,
          typename OriginalP8,
          typename OriginalP9,
          typename OriginalP10,
          typename OriginalP11,
          typename OriginalP12,
          typename OriginalP13>
VTKM_CONT Result DoStaticTransformCont(
  const Transform& transform,
  ParameterContainer<OriginalR(OriginalP1, OriginalP2, OriginalP3, OriginalP4, OriginalP5, OriginalP6, OriginalP7, OriginalP8, OriginalP9, OriginalP10, OriginalP11, OriginalP12, OriginalP13)>& originalParameters)
{
  return Result{
    transform(originalParameters.Parameter1, vtkm::internal::IndexTag<1>()),
    transform(originalParameters.Parameter2, vtkm::internal::IndexTag<2>()),
    transform(originalParameters.Parameter3, vtkm::internal::IndexTag<3>()),
    transform(originalParameters.Parameter4, vtkm::internal::IndexTag<4>()),
    transform(originalParameters.Parameter5, vtkm::internal::IndexTag<5>()),
    transform(originalParameters.Parameter6, vtkm::internal::IndexTag<6>()),
    transform(originalParameters.Parameter7, vtkm::internal::IndexTag<7>()),
    transform(originalParameters.Parameter8, vtkm::internal::IndexTag<8>()),
    transform(originalParameters.Parameter9, vtkm::internal::IndexTag<9>()),
    transform(originalParameters.Parameter10, vtkm::internal::IndexTag<10>()),
    transform(originalParameters.Parameter11, vtkm::internal::IndexTag<11>()),
    transform(originalParameters.Parameter12, vtkm::internal::IndexTag<12>()),
    transform(originalParameters.Parameter13, vtkm::internal::IndexTag<13>())
  };
}

VTKM_SUPPRESS_EXEC_WARNINGS
template <typename Result,
          typename Transform,
          typename OriginalR,
          typename OriginalP1,
          typename OriginalP2,
          typename OriginalP3,
          typename OriginalP4,
          typename OriginalP5,
          typename OriginalP6,
          typename OriginalP7,
          typename OriginalP8,
          typename OriginalP9,
          typename OriginalP10,
          typename OriginalP11,
          typename OriginalP12,
          typename OriginalP13,
          typename OriginalP14>
VTKM_CONT Result DoStaticTransformCont(
  const Transform& transform,
  ParameterContainer<OriginalR(OriginalP1, OriginalP2, OriginalP3, OriginalP4, OriginalP5, OriginalP6, OriginalP7, OriginalP8, OriginalP9, OriginalP10, OriginalP11, OriginalP12, OriginalP13, OriginalP14)>& originalParameters)
{
  return Result{
    transform(originalParameters.Parameter1, vtkm::internal::IndexTag<1>()),
    transform(originalParameters.Parameter2, vtkm::internal::IndexTag<2>()),
    transform(originalParameters.Parameter3, vtkm::internal::IndexTag<3>()),
    transform(originalParameters.Parameter4, vtkm::internal::IndexTag<4>()),
    transform(originalParameters.Parameter5, vtkm::internal::IndexTag<5>()),
    transform(originalParameters.Parameter6, vtkm::internal::IndexTag<6>()),
    transform(originalParameters.Parameter7, vtkm::internal::IndexTag<7>()),
    transform(originalParameters.Parameter8, vtkm::internal::IndexTag<8>()),
    transform(originalParameters.Parameter9, vtkm::internal::IndexTag<9>()),
    transform(originalParameters.Parameter10, vtkm::internal::IndexTag<10>()),
    transform(originalParameters.Parameter11, vtkm::internal::IndexTag<11>()),
    transform(originalParameters.Parameter12, vtkm::internal::IndexTag<12>()),
    transform(originalParameters.Parameter13, vtkm::internal::IndexTag<13>()),
    transform(originalParameters.Parameter14, vtkm::internal::IndexTag<14>())
  };
}

VTKM_SUPPRESS_EXEC_WARNINGS
template <typename Result,
          typename Transform,
          typename OriginalR,
          typename OriginalP1,
          typename OriginalP2,
          typename OriginalP3,
          typename OriginalP4,
          typename OriginalP5,
          typename OriginalP6,
          typename OriginalP7,
          typename OriginalP8,
          typename OriginalP9,
          typename OriginalP10,
          typename OriginalP11,
          typename OriginalP12,
          typename OriginalP13,
          typename OriginalP14,
          typename OriginalP15>
VTKM_CONT Result DoStaticTransformCont(
  const Transform& transform,
  ParameterContainer<OriginalR(OriginalP1, OriginalP2, OriginalP3, OriginalP4, OriginalP5, OriginalP6, OriginalP7, OriginalP8, OriginalP9, OriginalP10, OriginalP11, OriginalP12, OriginalP13, OriginalP14, OriginalP15)>& originalParameters)
{
  return Result{
    transform(originalParameters.Parameter1, vtkm::internal::IndexTag<1>()),
    transform(originalParameters.Parameter2, vtkm::internal::IndexTag<2>()),
    transform(originalParameters.Parameter3, vtkm::internal::IndexTag<3>()),
    transform(originalParameters.Parameter4, vtkm::internal::IndexTag<4>()),
    transform(originalParameters.Parameter5, vtkm::internal::IndexTag<5>()),
    transform(originalParameters.Parameter6, vtkm::internal::IndexTag<6>()),
    transform(originalParameters.Parameter7, vtkm::internal::IndexTag<7>()),
    transform(originalParameters.Parameter8, vtkm::internal::IndexTag<8>()),
    transform(originalParameters.Parameter9, vtkm::internal::IndexTag<9>()),
    transform(originalParameters.Parameter10, vtkm::internal::IndexTag<10>()),
    transform(originalParameters.Parameter11, vtkm::internal::IndexTag<11>()),
    transform(originalParameters.Parameter12, vtkm::internal::IndexTag<12>()),
    transform(originalParameters.Parameter13, vtkm::internal::IndexTag<13>()),
    transform(originalParameters.Parameter14, vtkm::internal::IndexTag<14>()),
    transform(originalParameters.Parameter15, vtkm::internal::IndexTag<15>())
  };
}

VTKM_SUPPRESS_EXEC_WARNINGS
template <typename Result,
          typename Transform,
          typename OriginalR,
          typename OriginalP1,
          typename OriginalP2,
          typename OriginalP3,
          typename OriginalP4,
          typename OriginalP5,
          typename OriginalP6,
          typename OriginalP7,
          typename OriginalP8,
          typename OriginalP9,
          typename OriginalP10,
          typename OriginalP11,
          typename OriginalP12,
          typename OriginalP13,
          typename OriginalP14,
          typename OriginalP15,
          typename OriginalP16>
VTKM_CONT Result DoStaticTransformCont(
  const Transform& transform,
  ParameterContainer<OriginalR(OriginalP1, OriginalP2, OriginalP3, OriginalP4, OriginalP5, OriginalP6, OriginalP7, OriginalP8, OriginalP9, OriginalP10, OriginalP11, OriginalP12, OriginalP13, OriginalP14, OriginalP15, OriginalP16)>& originalParameters)
{
  return Result{
    transform(originalParameters.Parameter1, vtkm::internal::IndexTag<1>()),
    transform(originalParameters.Parameter2, vtkm::internal::IndexTag<2>()),
    transform(originalParameters.Parameter3, vtkm::internal::IndexTag<3>()),
    transform(originalParameters.Parameter4, vtkm::internal::IndexTag<4>()),
    transform(originalParameters.Parameter5, vtkm::internal::IndexTag<5>()),
    transform(originalParameters.Parameter6, vtkm::internal::IndexTag<6>()),
    transform(originalParameters.Parameter7, vtkm::internal::IndexTag<7>()),
    transform(originalParameters.Parameter8, vtkm::internal::IndexTag<8>()),
    transform(originalParameters.Parameter9, vtkm::internal::IndexTag<9>()),
    transform(originalParameters.Parameter10, vtkm::internal::IndexTag<10>()),
    transform(originalParameters.Parameter11, vtkm::internal::IndexTag<11>()),
    transform(originalParameters.Parameter12, vtkm::internal::IndexTag<12>()),
    transform(originalParameters.Parameter13, vtkm::internal::IndexTag<13>()),
    transform(originalParameters.Parameter14, vtkm::internal::IndexTag<14>()),
    transform(originalParameters.Parameter15, vtkm::internal::IndexTag<15>()),
    transform(originalParameters.Parameter16, vtkm::internal::IndexTag<16>())
  };
}

VTKM_SUPPRESS_EXEC_WARNINGS
template <typename Result,
          typename Transform,
          typename OriginalR,
          typename OriginalP1,
          typename OriginalP2,
          typename OriginalP3,
          typename OriginalP4,
          typename OriginalP5,
          typename OriginalP6,
          typename OriginalP7,
          typename OriginalP8,
          typename OriginalP9,
          typename OriginalP10,
          typename OriginalP11,
          typename OriginalP12,
          typename OriginalP13,
          typename OriginalP14,
          typename OriginalP15,
          typename OriginalP16,
          typename OriginalP17>
VTKM_CONT Result DoStaticTransformCont(
  const Transform& transform,
  ParameterContainer<OriginalR(OriginalP1, OriginalP2, OriginalP3, OriginalP4, OriginalP5, OriginalP6, OriginalP7, OriginalP8, OriginalP9, OriginalP10, OriginalP11, OriginalP12, OriginalP13, OriginalP14, OriginalP15, OriginalP16, OriginalP17)>& originalParameters)
{
  return Result{
    transform(originalParameters.Parameter1, vtkm::internal::IndexTag<1>()),
    transform(originalParameters.Parameter2, vtkm::internal::IndexTag<2>()),
    transform(originalParameters.Parameter3, vtkm::internal::IndexTag<3>()),
    transform(originalParameters.Parameter4, vtkm::internal::IndexTag<4>()),
    transform(originalParameters.Parameter5, vtkm::internal::IndexTag<5>()),
    transform(originalParameters.Parameter6, vtkm::internal::IndexTag<6>()),
    transform(originalParameters.Parameter7, vtkm::internal::IndexTag<7>()),
    transform(originalParameters.Parameter8, vtkm::internal::IndexTag<8>()),
    transform(originalParameters.Parameter9, vtkm::internal::IndexTag<9>()),
    transform(originalParameters.Parameter10, vtkm::internal::IndexTag<10>()),
    transform(originalParameters.Parameter11, vtkm::internal::IndexTag<11>()),
    transform(originalParameters.Parameter12, vtkm::internal::IndexTag<12>()),
    transform(originalParameters.Parameter13, vtkm::internal::IndexTag<13>()),
    transform(originalParameters.Parameter14, vtkm::internal::IndexTag<14>()),
    transform(originalParameters.Parameter15, vtkm::internal::IndexTag<15>()),
    transform(originalParameters.Parameter16, vtkm::internal::IndexTag<16>()),
    transform(originalParameters.Parameter17, vtkm::internal::IndexTag<17>())
  };
}

VTKM_SUPPRESS_EXEC_WARNINGS
template <typename Result,
          typename Transform,
          typename OriginalR,
          typename OriginalP1,
          typename OriginalP2,
          typename OriginalP3,
          typename OriginalP4,
          typename OriginalP5,
          typename OriginalP6,
          typename OriginalP7,
          typename OriginalP8,
          typename OriginalP9,
          typename OriginalP10,
          typename OriginalP11,
          typename OriginalP12,
          typename OriginalP13,
          typename OriginalP14,
          typename OriginalP15,
          typename OriginalP16,
          typename OriginalP17,
          typename OriginalP18>
VTKM_CONT Result DoStaticTransformCont(
  const Transform& transform,
  ParameterContainer<OriginalR(OriginalP1, OriginalP2, OriginalP3, OriginalP4, OriginalP5, OriginalP6, OriginalP7, OriginalP8, OriginalP9, OriginalP10, OriginalP11, OriginalP12, OriginalP13, OriginalP14, OriginalP15, OriginalP16, OriginalP17, OriginalP18)>& originalParameters)
{
  return Result{
    transform(originalParameters.Parameter1, vtkm::internal::IndexTag<1>()),
    transform(originalParameters.Parameter2, vtkm::internal::IndexTag<2>()),
    transform(originalParameters.Parameter3, vtkm::internal::IndexTag<3>()),
    transform(originalParameters.Parameter4, vtkm::internal::IndexTag<4>()),
    transform(originalParameters.Parameter5, vtkm::internal::IndexTag<5>()),
    transform(originalParameters.Parameter6, vtkm::internal::IndexTag<6>()),
    transform(originalParameters.Parameter7, vtkm::internal::IndexTag<7>()),
    transform(originalParameters.Parameter8, vtkm::internal::IndexTag<8>()),
    transform(originalParameters.Parameter9, vtkm::internal::IndexTag<9>()),
    transform(originalParameters.Parameter10, vtkm::internal::IndexTag<10>()),
    transform(originalParameters.Parameter11, vtkm::internal::IndexTag<11>()),
    transform(originalParameters.Parameter12, vtkm::internal::IndexTag<12>()),
    transform(originalParameters.Parameter13, vtkm::internal::IndexTag<13>()),
    transform(originalParameters.Parameter14, vtkm::internal::IndexTag<14>()),
    transform(originalParameters.Parameter15, vtkm::internal::IndexTag<15>()),
    transform(originalParameters.Parameter16, vtkm::internal::IndexTag<16>()),
    transform(originalParameters.Parameter17, vtkm::internal::IndexTag<17>()),
    transform(originalParameters.Parameter18, vtkm::internal::IndexTag<18>())
  };
}

VTKM_SUPPRESS_EXEC_WARNINGS
template <typename Result,
          typename Transform,
          typename OriginalR,
          typename OriginalP1,
          typename OriginalP2,
          typename OriginalP3,
          typename OriginalP4,
          typename OriginalP5,
          typename OriginalP6,
          typename OriginalP7,
          typename OriginalP8,
          typename OriginalP9,
          typename OriginalP10,
          typename OriginalP11,
          typename OriginalP12,
          typename OriginalP13,
          typename OriginalP14,
          typename OriginalP15,
          typename OriginalP16,
          typename OriginalP17,
          typename OriginalP18,
          typename OriginalP19>
VTKM_CONT Result DoStaticTransformCont(
  const Transform& transform,
  ParameterContainer<OriginalR(OriginalP1, OriginalP2, OriginalP3, OriginalP4, OriginalP5, OriginalP6, OriginalP7, OriginalP8, OriginalP9, OriginalP10, OriginalP11, OriginalP12, OriginalP13, OriginalP14, OriginalP15, OriginalP16, OriginalP17, OriginalP18, OriginalP19)>& originalParameters)
{
  return Result{
    transform(originalParameters.Parameter1, vtkm::internal::IndexTag<1>()),
    transform(originalParameters.Parameter2, vtkm::internal::IndexTag<2>()),
    transform(originalParameters.Parameter3, vtkm::internal::IndexTag<3>()),
    transform(originalParameters.Parameter4, vtkm::internal::IndexTag<4>()),
    transform(originalParameters.Parameter5, vtkm::internal::IndexTag<5>()),
    transform(originalParameters.Parameter6, vtkm::internal::IndexTag<6>()),
    transform(originalParameters.Parameter7, vtkm::internal::IndexTag<7>()),
    transform(originalParameters.Parameter8, vtkm::internal::IndexTag<8>()),
    transform(originalParameters.Parameter9, vtkm::internal::IndexTag<9>()),
    transform(originalParameters.Parameter10, vtkm::internal::IndexTag<10>()),
    transform(originalParameters.Parameter11, vtkm::internal::IndexTag<11>()),
    transform(originalParameters.Parameter12, vtkm::internal::IndexTag<12>()),
    transform(originalParameters.Parameter13, vtkm::internal::IndexTag<13>()),
    transform(originalParameters.Parameter14, vtkm::internal::IndexTag<14>()),
    transform(originalParameters.Parameter15, vtkm::internal::IndexTag<15>()),
    transform(originalParameters.Parameter16, vtkm::internal::IndexTag<16>()),
    transform(originalParameters.Parameter17, vtkm::internal::IndexTag<17>()),
    transform(originalParameters.Parameter18, vtkm::internal::IndexTag<18>()),
    transform(originalParameters.Parameter19, vtkm::internal::IndexTag<19>())
  };
}

// clang-format on

} // namespace detail
}
} // namespace vtkm::internal

#endif //vtk_m_internal_FunctionInterfaceDetailPre_h
