/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.codearea;

import jadx.api.CodePosition;
import jadx.api.JadxDecompiler;
import jadx.api.JavaNode;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.ContentPanel;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.codearea.AbstractCodeArea;
import jadx.gui.ui.codearea.CodeLinkGenerator;
import jadx.gui.ui.codearea.FindUsageAction;
import jadx.gui.ui.codearea.GoToDeclarationAction;
import jadx.gui.ui.codearea.JadxTokenMaker;
import jadx.gui.ui.codearea.MouseHoverHighlighter;
import jadx.gui.ui.codearea.RenameAction;
import jadx.gui.utils.JNodeCache;
import jadx.gui.utils.JumpPosition;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenMaker;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CodeArea
extends AbstractCodeArea {
    private static final Logger LOG = LoggerFactory.getLogger(CodeArea.class);
    private static final long serialVersionUID = 6312736869579635796L;

    CodeArea(final ContentPanel contentPanel) {
        super(contentPanel);
        this.setSyntaxEditingStyle(this.node.getSyntaxName());
        boolean isJavaCode = this.node instanceof JClass;
        if (isJavaCode) {
            ((RSyntaxDocument)this.getDocument()).setSyntaxStyle((TokenMaker)new JadxTokenMaker(this));
            this.addMenuItems();
        }
        this.setHyperlinksEnabled(true);
        this.setLinkScanningMask(128);
        final CodeLinkGenerator codeLinkGenerator = new CodeLinkGenerator(this);
        this.setLinkGenerator(codeLinkGenerator);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int offs;
                JumpPosition jump;
                if (e.isControlDown() && (jump = codeLinkGenerator.getJumpLinkAtOffset(CodeArea.this, offs = CodeArea.this.viewToModel(e.getPoint()))) != null) {
                    contentPanel.getTabbedPane().codeJump(jump);
                }
            }
        });
        if (isJavaCode) {
            this.addMouseMotionListener(new MouseHoverHighlighter(this, codeLinkGenerator));
        }
    }

    @Override
    public void load() {
        if (this.getText().isEmpty()) {
            this.setText(this.node.getContent());
            this.setCaretPosition(0);
        }
    }

    @Override
    public void refresh() {
        this.setText(this.node.getContent());
    }

    private void addMenuItems() {
        FindUsageAction findUsage = new FindUsageAction(this);
        GoToDeclarationAction goToDeclaration = new GoToDeclarationAction(this);
        RenameAction rename = new RenameAction(this);
        JPopupMenu popup = this.getPopupMenu();
        popup.addSeparator();
        popup.add(findUsage);
        popup.add(goToDeclaration);
        popup.add(rename);
        popup.addPopupMenuListener(findUsage);
        popup.addPopupMenuListener(goToDeclaration);
        popup.addPopupMenuListener(rename);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int adjustOffsetForToken(@Nullable Token token) {
        char ch;
        int sourceOffset;
        if (token == null) {
            return -1;
        }
        int type = token.getType();
        if (this.node instanceof JClass) {
            if (type == 20) {
                sourceOffset = token.getOffset();
            } else {
                if (type != 19 || token.length() <= 1) return -1;
                sourceOffset = token.getOffset() + 1;
            }
        } else {
            if (type != 28) return -1;
            sourceOffset = token.getOffset() + 1;
        }
        if (token.length() != 1 || (ch = token.getTextArray()[token.getTextOffset()]) != '.' && ch != ',' && ch != ';') return sourceOffset;
        return -1;
    }

    @Nullable
    public JumpPosition getDefPosForNodeAtOffset(int offset) {
        if (offset == -1) {
            return null;
        }
        JavaNode foundNode = this.getJavaNodeAtOffset(offset);
        if (foundNode == null) {
            return null;
        }
        CodePosition pos = this.getDecompiler().getDefinitionPosition(foundNode);
        if (pos == null) {
            return null;
        }
        JNode jNode = this.convertJavaNode(foundNode);
        return new JumpPosition(jNode.getRootClass(), pos.getLine());
    }

    private JNode convertJavaNode(JavaNode javaNode) {
        JNodeCache nodeCache = this.getMainWindow().getCacheObject().getNodeCache();
        return nodeCache.makeFrom(javaNode);
    }

    @Nullable
    public JNode getJNodeAtOffset(int offset) {
        JavaNode javaNode = this.getJavaNodeAtOffset(offset);
        if (javaNode != null) {
            return this.convertJavaNode(javaNode);
        }
        return null;
    }

    public JavaNode getJavaNodeAtOffset(int offset) {
        if (offset == -1) {
            return null;
        }
        try {
            int line = this.getLineOfOffset(offset);
            int lineOffset = offset - this.getLineStartOffset(line);
            return this.node.getJavaNodeAtPosition(this.getDecompiler(), line + 1, lineOffset + 1);
        }
        catch (Exception e) {
            LOG.error("Can't get java node by offset: {}", (Object)offset, (Object)e);
            return null;
        }
    }

    public MainWindow getMainWindow() {
        return this.contentPanel.getTabbedPane().getMainWindow();
    }

    private JadxDecompiler getDecompiler() {
        return this.getMainWindow().getWrapper().getDecompiler();
    }
}

