/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils.search;

import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import jadx.api.JavaClass;
import jadx.gui.treemodel.JNode;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class SimpleIndex {
    private final Map<JNode, String> data = new ConcurrentHashMap<JNode, String>();

    public void put(String str, JNode value) {
        this.data.put(value, str);
    }

    public void removeForCls(JavaClass cls) {
        this.data.entrySet().removeIf(e -> ((JNode)e.getKey()).getJavaNode().getTopParentClass().equals(cls));
    }

    private boolean isMatched(String str, String searchStr, boolean caseInsensitive) {
        if (caseInsensitive) {
            return StringUtils.containsIgnoreCase((CharSequence)str, (CharSequence)searchStr);
        }
        return str.contains(searchStr);
    }

    public Flowable<JNode> search(String searchStr, boolean caseInsensitive) {
        return Flowable.create(emitter -> {
            for (Map.Entry<JNode, String> entry : this.data.entrySet()) {
                if (this.isMatched(entry.getValue(), searchStr, caseInsensitive)) {
                    emitter.onNext((Object)entry.getKey());
                }
                if (!emitter.isCancelled()) continue;
                return;
            }
            emitter.onComplete();
        }, (BackpressureStrategy)BackpressureStrategy.LATEST);
    }

    public int size() {
        return this.data.size();
    }
}

