/*
 * Decompiled with CFR 0.152.
 */
package jadx.core;

import jadx.api.ICodeInfo;
import jadx.core.codegen.CodeGen;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.LoadStage;
import jadx.core.dex.nodes.ProcessState;
import jadx.core.dex.visitors.DepthTraversal;
import jadx.core.dex.visitors.IDexTreeVisitor;
import jadx.core.utils.exceptions.JadxRuntimeException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProcessClass {
    private ProcessClass() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static ICodeInfo process(ClassNode cls, boolean codegen) {
        if (!codegen && cls.getState() == ProcessState.PROCESS_COMPLETE) {
            return null;
        }
        ClassInfo classInfo = cls.getClassInfo();
        synchronized (classInfo) {
            try {
                if (cls.contains(AFlag.CLASS_DEEP_RELOAD)) {
                    cls.remove(AFlag.CLASS_DEEP_RELOAD);
                    cls.unload();
                    cls.deepUnload();
                    cls.root().runPreDecompileStageForClass(cls);
                }
                if (codegen) {
                    if (cls.getState() == ProcessState.GENERATED_AND_UNLOADED) {
                        cls.setState(ProcessState.NOT_LOADED);
                    }
                    cls.setLoadStage(LoadStage.CODEGEN_STAGE);
                    if (cls.contains(AFlag.RELOAD_AT_CODEGEN_STAGE)) {
                        cls.remove(AFlag.RELOAD_AT_CODEGEN_STAGE);
                        cls.unload();
                    }
                } else {
                    cls.setLoadStage(LoadStage.PROCESS_STAGE);
                }
                if (cls.getState() == ProcessState.NOT_LOADED) {
                    cls.load();
                }
                if (cls.getState() == ProcessState.LOADED) {
                    cls.setState(ProcessState.PROCESS_STARTED);
                    for (IDexTreeVisitor visitor : cls.root().getPasses()) {
                        DepthTraversal.visit(visitor, cls);
                    }
                    cls.setState(ProcessState.PROCESS_COMPLETE);
                }
                if (codegen) {
                    ICodeInfo code = CodeGen.generate(cls);
                    if (!cls.contains(AFlag.DONT_UNLOAD_CLASS)) {
                        cls.unload();
                        cls.setState(ProcessState.GENERATED_AND_UNLOADED);
                    }
                    return code;
                }
            }
            catch (Throwable e) {
                cls.addError("Class process error: " + e.getClass().getSimpleName(), e);
            }
            return null;
        }
    }

    @NotNull
    public static ICodeInfo generateCode(ClassNode cls) {
        ClassNode topParentClass = cls.getTopParentClass();
        if (topParentClass != cls) {
            return ProcessClass.generateCode(topParentClass);
        }
        try {
            for (ClassNode depCls : cls.getDependencies()) {
                ProcessClass.process(depCls, false);
            }
            ICodeInfo code = ProcessClass.process(cls, true);
            if (code == null) {
                throw new JadxRuntimeException("Codegen failed");
            }
            return code;
        }
        catch (Throwable e) {
            throw new JadxRuntimeException("Failed to generate code for class: " + cls.getFullName(), e);
        }
    }
}

