/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.JumpInfo;
import jadx.core.dex.instructions.BaseInvokeNode;
import jadx.core.dex.instructions.FillArrayData;
import jadx.core.dex.instructions.FillArrayInsn;
import jadx.core.dex.instructions.FilledNewArrayNode;
import jadx.core.dex.instructions.GotoNode;
import jadx.core.dex.instructions.IfNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.SwitchData;
import jadx.core.dex.instructions.SwitchInsn;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.blocksmaker.BlockSplitter;
import jadx.core.utils.InsnUtils;
import jadx.core.utils.exceptions.JadxException;
import jadx.core.utils.exceptions.JadxRuntimeException;
import org.jetbrains.annotations.Nullable;

@JadxVisitor(name="Process Instructions Visitor", desc="Init instructions info", runBefore={BlockSplitter.class})
public class ProcessInstructionsVisitor
extends AbstractVisitor {
    @Override
    public void visit(MethodNode mth) throws JadxException {
        if (mth.isNoCode()) {
            return;
        }
        ProcessInstructionsVisitor.initJumps(mth, mth.getInstructions());
    }

    private static void initJumps(MethodNode mth, InsnNode[] insnByOffset) {
        block8: for (int offset = 0; offset < insnByOffset.length; ++offset) {
            InsnNode insn = insnByOffset[offset];
            if (insn == null) continue;
            switch (insn.getType()) {
                case SWITCH: {
                    int dataTarget;
                    InsnNode switchDataInsn;
                    SwitchInsn sw = (SwitchInsn)insn;
                    int nextInsnOffset = ProcessInstructionsVisitor.getNextInsnOffset(insnByOffset, offset);
                    if (nextInsnOffset != -1) {
                        ProcessInstructionsVisitor.addJump(mth, insnByOffset, offset, nextInsnOffset);
                    }
                    if ((switchDataInsn = ProcessInstructionsVisitor.getInsnAtOffset(insnByOffset, dataTarget = sw.getDataTarget())) == null || switchDataInsn.getType() != InsnType.SWITCH_DATA) {
                        throw new JadxRuntimeException("Payload for fill-array not found at " + InsnUtils.formatOffset(dataTarget));
                    }
                    sw.attachSwitchData((SwitchData)switchDataInsn, nextInsnOffset);
                    for (int target : sw.getTargets()) {
                        ProcessInstructionsVisitor.addJump(mth, insnByOffset, offset, target);
                    }
                    continue block8;
                }
                case IF: {
                    int next = ProcessInstructionsVisitor.getNextInsnOffset(insnByOffset, offset);
                    if (next != -1) {
                        ProcessInstructionsVisitor.addJump(mth, insnByOffset, offset, next);
                    }
                    ProcessInstructionsVisitor.addJump(mth, insnByOffset, offset, ((IfNode)insn).getTarget());
                    continue block8;
                }
                case GOTO: {
                    ProcessInstructionsVisitor.addJump(mth, insnByOffset, offset, ((GotoNode)insn).getTarget());
                    continue block8;
                }
                case INVOKE: {
                    ArgType retType = ((BaseInvokeNode)insn).getCallMth().getReturnType();
                    ProcessInstructionsVisitor.mergeMoveResult(insnByOffset, offset, insn, retType);
                    continue block8;
                }
                case FILLED_NEW_ARRAY: {
                    ArgType arrType = ((FilledNewArrayNode)insn).getArrayType();
                    ProcessInstructionsVisitor.mergeMoveResult(insnByOffset, offset, insn, arrType);
                    continue block8;
                }
                case FILL_ARRAY: {
                    FillArrayInsn fillArrayInsn = (FillArrayInsn)insn;
                    int target = fillArrayInsn.getTarget();
                    InsnNode arrDataInsn = ProcessInstructionsVisitor.getInsnAtOffset(insnByOffset, target);
                    if (arrDataInsn != null && arrDataInsn.getType() == InsnType.FILL_ARRAY_DATA) {
                        fillArrayInsn.setArrayData((FillArrayData)arrDataInsn);
                        continue block8;
                    }
                    throw new JadxRuntimeException("Payload for fill-array not found at " + InsnUtils.formatOffset(target));
                }
            }
        }
    }

    private static void mergeMoveResult(InsnNode[] insnByOffset, int offset, InsnNode insn, ArgType resType) {
        int nextInsnOffset = ProcessInstructionsVisitor.getNextInsnOffset(insnByOffset, offset);
        if (nextInsnOffset == -1) {
            return;
        }
        InsnNode nextInsn = insnByOffset[nextInsnOffset];
        if (nextInsn.getType() != InsnType.MOVE_RESULT) {
            return;
        }
        RegisterArg moveRes = nextInsn.getResult();
        insn.setResult(moveRes.duplicate(resType));
        insn.copyAttributesFrom(nextInsn);
        insnByOffset[nextInsnOffset] = null;
    }

    private static void addJump(MethodNode mth, InsnNode[] insnByOffset, int offset, int target) {
        try {
            insnByOffset[target].addAttr(AType.JUMP, new JumpInfo(offset, target));
        }
        catch (Exception e) {
            mth.addError("Failed to set jump: " + InsnUtils.formatOffset(offset) + " -> " + InsnUtils.formatOffset(target), e);
        }
    }

    public static int getNextInsnOffset(InsnNode[] insnByOffset, int offset) {
        int len = insnByOffset.length;
        for (int i = offset + 1; i < len; ++i) {
            InsnNode insnNode = insnByOffset[i];
            if (insnNode == null || insnNode.getType() == InsnType.NOP) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    private static InsnNode getInsnAtOffset(InsnNode[] insnByOffset, int offset) {
        int len = insnByOffset.length;
        for (int i = offset; i < len; ++i) {
            InsnNode insnNode = insnByOffset[i];
            if (insnNode == null || insnNode.getType() == InsnType.NOP) continue;
            return insnNode;
        }
        return null;
    }
}

