/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.methods;

import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.IMethodDetails;
import java.util.Collections;
import java.util.List;

public class MutableMethodDetails
implements IMethodDetails {
    private final MethodInfo mthInfo;
    private ArgType retType;
    private List<ArgType> argTypes;
    private List<ArgType> typeParams;
    private List<ArgType> throwTypes;
    private boolean varArg;

    public MutableMethodDetails(IMethodDetails base) {
        this.mthInfo = base.getMethodInfo();
        this.retType = base.getReturnType();
        this.argTypes = Collections.unmodifiableList(base.getArgTypes());
        this.typeParams = Collections.unmodifiableList(base.getTypeParameters());
        this.throwTypes = Collections.unmodifiableList(base.getThrows());
        this.varArg = base.isVarArg();
    }

    @Override
    public MethodInfo getMethodInfo() {
        return this.mthInfo;
    }

    @Override
    public ArgType getReturnType() {
        return this.retType;
    }

    @Override
    public List<ArgType> getArgTypes() {
        return this.argTypes;
    }

    @Override
    public List<ArgType> getTypeParameters() {
        return this.typeParams;
    }

    @Override
    public List<ArgType> getThrows() {
        return this.throwTypes;
    }

    @Override
    public boolean isVarArg() {
        return this.varArg;
    }

    public void setRetType(ArgType retType) {
        this.retType = retType;
    }

    public void setArgTypes(List<ArgType> argTypes) {
        this.argTypes = argTypes;
    }

    public void setTypeParams(List<ArgType> typeParams) {
        this.typeParams = typeParams;
    }

    public void setThrowTypes(List<ArgType> throwTypes) {
        this.throwTypes = throwTypes;
    }

    public void setVarArg(boolean varArg) {
        this.varArg = varArg;
    }

    public String toString() {
        return "Mutable" + this.toAttrString();
    }
}

