/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils;

import jadx.api.JadxArgs;
import jadx.core.deobf.NameMapper;
import org.jetbrains.annotations.Nullable;

public class StringUtils {
    private static final StringUtils DEFAULT_INSTANCE = new StringUtils(new JadxArgs());
    private final boolean escapeUnicode;

    public static StringUtils getInstance() {
        return DEFAULT_INSTANCE;
    }

    public StringUtils(JadxArgs args) {
        this.escapeUnicode = args.isEscapeUnicode();
    }

    public String unescapeString(String str) {
        int len = str.length();
        if (len == 0) {
            return "\"\"";
        }
        StringBuilder res = new StringBuilder();
        res.append('\"');
        for (int i = 0; i < len; ++i) {
            int c = str.charAt(i) & 0xFFFF;
            this.processCharInsideString(c, res);
        }
        res.append('\"');
        return res.toString();
    }

    private void processCharInsideString(int c, StringBuilder res) {
        String str = this.getSpecialStringForChar(c);
        if (str != null) {
            res.append(str);
            return;
        }
        if (c < 32 || c >= 127 && this.escapeUnicode) {
            res.append("\\u").append(String.format("%04x", c));
        } else {
            res.append((char)c);
        }
    }

    public String unescapeChar(int c, boolean explicitCast) {
        if (c == 39) {
            return "'\\''";
        }
        String str = this.getSpecialStringForChar(c);
        if (str != null) {
            return '\'' + str + '\'';
        }
        if (c >= 127 && this.escapeUnicode) {
            return String.format("'\\u%04x'", c);
        }
        if (NameMapper.isPrintableChar(c)) {
            return "'" + (char)c + '\'';
        }
        if (explicitCast) {
            return "(char) " + c;
        }
        return String.valueOf(c);
    }

    public String unescapeChar(char ch) {
        return this.unescapeChar(ch, false);
    }

    @Nullable
    private String getSpecialStringForChar(int c) {
        switch (c) {
            case 10: {
                return "\\n";
            }
            case 13: {
                return "\\r";
            }
            case 9: {
                return "\\t";
            }
            case 8: {
                return "\\b";
            }
            case 12: {
                return "\\f";
            }
            case 39: {
                return "'";
            }
            case 34: {
                return "\\\"";
            }
            case 92: {
                return "\\\\";
            }
        }
        return null;
    }

    public static String escape(String str) {
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        block5: for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case ' ': 
                case '$': 
                case ',': 
                case '.': 
                case '/': 
                case ';': 
                case '<': {
                    sb.append('_');
                    continue block5;
                }
                case '[': {
                    sb.append('A');
                    continue block5;
                }
                case '*': 
                case '>': 
                case '?': 
                case ']': {
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String escapeXML(String str) {
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            String replace = StringUtils.escapeXmlChar(c);
            if (replace != null) {
                sb.append(replace);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String escapeResValue(String str) {
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            StringUtils.commonEscapeAndAppend(sb, c);
        }
        return sb.toString();
    }

    public static String escapeResStrValue(String str) {
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        block4: for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    continue block4;
                }
                case '\'': {
                    sb.append("\\'");
                    continue block4;
                }
                default: {
                    StringUtils.commonEscapeAndAppend(sb, c);
                }
            }
        }
        return sb.toString();
    }

    private static String escapeXmlChar(char c) {
        if (c >= '\u0000' && c <= '\u001f') {
            return "\\" + c;
        }
        switch (c) {
            case '&': {
                return "&amp;";
            }
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return "&apos;";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return null;
    }

    private static String escapeWhiteSpaceChar(char c) {
        switch (c) {
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\t': {
                return "\\t";
            }
            case '\b': {
                return "\\b";
            }
            case '\f': {
                return "\\f";
            }
        }
        return null;
    }

    private static void commonEscapeAndAppend(StringBuilder sb, char c) {
        String replace = StringUtils.escapeXmlChar(c);
        if (replace == null) {
            replace = StringUtils.escapeWhiteSpaceChar(c);
        }
        if (replace != null) {
            sb.append(replace);
        } else {
            sb.append(c);
        }
    }

    public static boolean notEmpty(String str) {
        return str != null && !str.isEmpty();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean notBlank(String str) {
        return StringUtils.notEmpty(str) && !str.trim().isEmpty();
    }

    public static int countMatches(String str, String subStr) {
        if (str == null || str.isEmpty() || subStr == null || subStr.isEmpty()) {
            return 0;
        }
        int subStrLen = subStr.length();
        int count = 0;
        int idx = 0;
        while ((idx = str.indexOf(subStr, idx)) != -1) {
            ++count;
            idx += subStrLen;
        }
        return count;
    }
}

