/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.bsh;

import java.io.Serializable;
import java.util.Hashtable;
import org.gjt.sp.jedit.bsh.InterpreterError;
import org.gjt.sp.jedit.bsh.ParserConstants;
import org.gjt.sp.jedit.bsh.Reflect;
import org.gjt.sp.jedit.bsh.Types;
import org.gjt.sp.jedit.bsh.UtilEvalError;
import org.gjt.sp.jedit.bsh.UtilTargetError;

public final class Primitive
implements ParserConstants,
Serializable {
    static Hashtable wrapperMap = new Hashtable();
    private Object value;
    public static final Primitive NULL;
    public static final Primitive VOID;

    public Primitive(Object object) {
        if (object == null) {
            throw new InterpreterError("Use Primitve.NULL instead of Primitive(null)");
        }
        if (object != Special.NULL_VALUE && object != Special.VOID_TYPE && !Primitive.isWrapperType(object.getClass())) {
            throw new InterpreterError("Not a wrapper type: " + object);
        }
        this.value = object;
    }

    public Primitive(boolean bl) {
        this((Object)bl);
    }

    public Primitive(byte by) {
        this((Object)by);
    }

    public Primitive(short s) {
        this((Object)s);
    }

    public Primitive(char c) {
        this(Character.valueOf(c));
    }

    public Primitive(int n) {
        this((Object)n);
    }

    public Primitive(long l) {
        this((Object)l);
    }

    public Primitive(float f) {
        this(Float.valueOf(f));
    }

    public Primitive(double d) {
        this((Object)d);
    }

    public Object getValue() {
        if (this.value == Special.NULL_VALUE) {
            return null;
        }
        if (this.value == Special.VOID_TYPE) {
            throw new InterpreterError("attempt to unwrap void type");
        }
        return this.value;
    }

    public String toString() {
        if (this.value == Special.NULL_VALUE) {
            return "null";
        }
        if (this.value == Special.VOID_TYPE) {
            return "void";
        }
        return this.value.toString();
    }

    public Class getType() {
        if (this == VOID) {
            return Void.TYPE;
        }
        if (this == NULL) {
            return null;
        }
        return Primitive.unboxType(this.value.getClass());
    }

    public static Object binaryOperation(Object object, Object object2, int n) throws UtilEvalError {
        Object object3;
        if (object == NULL || object2 == NULL) {
            throw new UtilEvalError("Null value or 'null' literal in binary operation");
        }
        if (object == VOID || object2 == VOID) {
            throw new UtilEvalError("Undefined variable, class, or 'void' literal in binary operation");
        }
        Class<?> clazz = object.getClass();
        Class<?> clazz2 = object2.getClass();
        if (object instanceof Primitive) {
            object = ((Primitive)object).getValue();
        }
        if (object2 instanceof Primitive) {
            object2 = ((Primitive)object2).getValue();
        }
        Object[] objectArray = Primitive.promotePrimitives(object, object2);
        Object object4 = objectArray[0];
        Object object5 = objectArray[1];
        if (object4.getClass() != object5.getClass()) {
            throw new UtilEvalError("Type mismatch in operator.  " + object4.getClass() + " cannot be used with " + object5.getClass());
        }
        try {
            object3 = Primitive.binaryOperationImpl(object4, object5, n);
        }
        catch (ArithmeticException arithmeticException) {
            throw new UtilTargetError("Arithemetic Exception in binary op", arithmeticException);
        }
        if (clazz == Primitive.class && clazz2 == Primitive.class || object3 instanceof Boolean) {
            return new Primitive(object3);
        }
        return object3;
    }

    static Object binaryOperationImpl(Object object, Object object2, int n) throws UtilEvalError {
        if (object instanceof Boolean) {
            return Primitive.booleanBinaryOperation((Boolean)object, (Boolean)object2, n);
        }
        if (object instanceof Integer) {
            return Primitive.intBinaryOperation((Integer)object, (Integer)object2, n);
        }
        if (object instanceof Long) {
            return Primitive.longBinaryOperation((Long)object, (Long)object2, n);
        }
        if (object instanceof Float) {
            return Primitive.floatBinaryOperation((Float)object, (Float)object2, n);
        }
        if (object instanceof Double) {
            return Primitive.doubleBinaryOperation((Double)object, (Double)object2, n);
        }
        throw new UtilEvalError("Invalid types in binary operator");
    }

    static Boolean booleanBinaryOperation(Boolean bl, Boolean bl2, int n) {
        boolean bl3 = bl;
        boolean bl4 = bl2;
        switch (n) {
            case 90: {
                return bl3 == bl4;
            }
            case 95: {
                return bl3 != bl4;
            }
            case 96: 
            case 97: {
                return bl3 || bl4;
            }
            case 98: 
            case 99: {
                return bl3 && bl4;
            }
        }
        throw new InterpreterError("unimplemented binary operator");
    }

    static Object longBinaryOperation(Long l, Long l2, int n) {
        long l3 = l;
        long l4 = l2;
        switch (n) {
            case 84: 
            case 85: {
                return l3 < l4;
            }
            case 82: 
            case 83: {
                return l3 > l4;
            }
            case 90: {
                return l3 == l4;
            }
            case 91: 
            case 92: {
                return l3 <= l4;
            }
            case 93: 
            case 94: {
                return l3 >= l4;
            }
            case 95: {
                return l3 != l4;
            }
            case 102: {
                return l3 + l4;
            }
            case 103: {
                return l3 - l4;
            }
            case 104: {
                return l3 * l4;
            }
            case 105: {
                return l3 / l4;
            }
            case 111: {
                return l3 % l4;
            }
            case 112: 
            case 113: {
                return l3 << (int)l4;
            }
            case 114: 
            case 115: {
                return l3 >> (int)l4;
            }
            case 116: 
            case 117: {
                return l3 >>> (int)l4;
            }
            case 106: 
            case 107: {
                return l3 & l4;
            }
            case 108: 
            case 109: {
                return l3 | l4;
            }
            case 110: {
                return l3 ^ l4;
            }
        }
        throw new InterpreterError("Unimplemented binary long operator");
    }

    static Object intBinaryOperation(Integer n, Integer n2, int n3) {
        int n4 = n;
        int n5 = n2;
        switch (n3) {
            case 84: 
            case 85: {
                return n4 < n5;
            }
            case 82: 
            case 83: {
                return n4 > n5;
            }
            case 90: {
                return n4 == n5;
            }
            case 91: 
            case 92: {
                return n4 <= n5;
            }
            case 93: 
            case 94: {
                return n4 >= n5;
            }
            case 95: {
                return n4 != n5;
            }
            case 102: {
                return n4 + n5;
            }
            case 103: {
                return n4 - n5;
            }
            case 104: {
                return n4 * n5;
            }
            case 105: {
                return n4 / n5;
            }
            case 111: {
                return n4 % n5;
            }
            case 112: 
            case 113: {
                return n4 << n5;
            }
            case 114: 
            case 115: {
                return n4 >> n5;
            }
            case 116: 
            case 117: {
                return n4 >>> n5;
            }
            case 106: 
            case 107: {
                return n4 & n5;
            }
            case 108: 
            case 109: {
                return n4 | n5;
            }
            case 110: {
                return n4 ^ n5;
            }
        }
        throw new InterpreterError("Unimplemented binary integer operator");
    }

    static Object doubleBinaryOperation(Double d, Double d2, int n) throws UtilEvalError {
        double d3 = d;
        double d4 = d2;
        switch (n) {
            case 84: 
            case 85: {
                return d3 < d4;
            }
            case 82: 
            case 83: {
                return d3 > d4;
            }
            case 90: {
                return d3 == d4;
            }
            case 91: 
            case 92: {
                return d3 <= d4;
            }
            case 93: 
            case 94: {
                return d3 >= d4;
            }
            case 95: {
                return d3 != d4;
            }
            case 102: {
                return d3 + d4;
            }
            case 103: {
                return d3 - d4;
            }
            case 104: {
                return d3 * d4;
            }
            case 105: {
                return d3 / d4;
            }
            case 111: {
                return d3 % d4;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: {
                throw new UtilEvalError("Can't shift doubles");
            }
        }
        throw new InterpreterError("Unimplemented binary double operator");
    }

    static Object floatBinaryOperation(Float f, Float f2, int n) throws UtilEvalError {
        float f3 = f.floatValue();
        float f4 = f2.floatValue();
        switch (n) {
            case 84: 
            case 85: {
                return f3 < f4;
            }
            case 82: 
            case 83: {
                return f3 > f4;
            }
            case 90: {
                return f3 == f4;
            }
            case 91: 
            case 92: {
                return f3 <= f4;
            }
            case 93: 
            case 94: {
                return f3 >= f4;
            }
            case 95: {
                return f3 != f4;
            }
            case 102: {
                return Float.valueOf(f3 + f4);
            }
            case 103: {
                return Float.valueOf(f3 - f4);
            }
            case 104: {
                return Float.valueOf(f3 * f4);
            }
            case 105: {
                return Float.valueOf(f3 / f4);
            }
            case 111: {
                return Float.valueOf(f3 % f4);
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: {
                throw new UtilEvalError("Can't shift floats ");
            }
        }
        throw new InterpreterError("Unimplemented binary float operator");
    }

    static Object promoteToInteger(Object object) {
        if (object instanceof Character) {
            return (int)((Character)object).charValue();
        }
        if (object instanceof Byte || object instanceof Short) {
            return ((Number)object).intValue();
        }
        return object;
    }

    static Object[] promotePrimitives(Object object, Object object2) {
        object = Primitive.promoteToInteger(object);
        object2 = Primitive.promoteToInteger(object2);
        if (object instanceof Number && object2 instanceof Number) {
            Number number = (Number)object;
            Number number2 = (Number)object2;
            boolean bl = number instanceof Double;
            if (bl || number2 instanceof Double) {
                if (bl) {
                    object2 = number2.doubleValue();
                } else {
                    object = number.doubleValue();
                }
            } else {
                bl = number instanceof Float;
                if (bl || number2 instanceof Float) {
                    if (bl) {
                        object2 = Float.valueOf(number2.floatValue());
                    } else {
                        object = Float.valueOf(number.floatValue());
                    }
                } else {
                    bl = number instanceof Long;
                    if (bl || number2 instanceof Long) {
                        if (bl) {
                            object2 = number2.longValue();
                        } else {
                            object = number.longValue();
                        }
                    }
                }
            }
        }
        return new Object[]{object, object2};
    }

    public static Primitive unaryOperation(Primitive primitive, int n) throws UtilEvalError {
        if (primitive == NULL) {
            throw new UtilEvalError("illegal use of null object or 'null' literal");
        }
        if (primitive == VOID) {
            throw new UtilEvalError("illegal use of undefined object or 'void' literal");
        }
        Class clazz = primitive.getType();
        Object object = Primitive.promoteToInteger(primitive.getValue());
        if (object instanceof Boolean) {
            return new Primitive(Primitive.booleanUnaryOperation((Boolean)object, n));
        }
        if (object instanceof Integer) {
            int n2 = Primitive.intUnaryOperation((Integer)object, n);
            if (n == 100 || n == 101) {
                if (clazz == Byte.TYPE) {
                    return new Primitive((byte)n2);
                }
                if (clazz == Short.TYPE) {
                    return new Primitive((short)n2);
                }
                if (clazz == Character.TYPE) {
                    return new Primitive((char)n2);
                }
            }
            return new Primitive(n2);
        }
        if (object instanceof Long) {
            return new Primitive(Primitive.longUnaryOperation((Long)object, n));
        }
        if (object instanceof Float) {
            return new Primitive(Primitive.floatUnaryOperation((Float)object, n));
        }
        if (object instanceof Double) {
            return new Primitive(Primitive.doubleUnaryOperation((Double)object, n));
        }
        throw new InterpreterError("An error occurred.  Please call technical support.");
    }

    static boolean booleanUnaryOperation(Boolean bl, int n) throws UtilEvalError {
        boolean bl2 = bl;
        switch (n) {
            case 86: {
                return !bl2;
            }
        }
        throw new UtilEvalError("Operator inappropriate for boolean");
    }

    static int intUnaryOperation(Integer n, int n2) {
        int n3 = n;
        switch (n2) {
            case 102: {
                return n3;
            }
            case 103: {
                return -n3;
            }
            case 87: {
                return ~n3;
            }
            case 100: {
                return n3 + 1;
            }
            case 101: {
                return n3 - 1;
            }
        }
        throw new InterpreterError("bad integer unaryOperation");
    }

    static long longUnaryOperation(Long l, int n) {
        long l2 = l;
        switch (n) {
            case 102: {
                return l2;
            }
            case 103: {
                return -l2;
            }
            case 87: {
                return l2 ^ 0xFFFFFFFFFFFFFFFFL;
            }
            case 100: {
                return l2 + 1L;
            }
            case 101: {
                return l2 - 1L;
            }
        }
        throw new InterpreterError("bad long unaryOperation");
    }

    static float floatUnaryOperation(Float f, int n) {
        float f2 = f.floatValue();
        switch (n) {
            case 102: {
                return f2;
            }
            case 103: {
                return -f2;
            }
        }
        throw new InterpreterError("bad float unaryOperation");
    }

    static double doubleUnaryOperation(Double d, int n) {
        double d2 = d;
        switch (n) {
            case 102: {
                return d2;
            }
            case 103: {
                return -d2;
            }
        }
        throw new InterpreterError("bad double unaryOperation");
    }

    public int intValue() throws UtilEvalError {
        if (this.value instanceof Number) {
            return ((Number)this.value).intValue();
        }
        throw new UtilEvalError("Primitive not a number");
    }

    public boolean booleanValue() throws UtilEvalError {
        if (this.value instanceof Boolean) {
            return (Boolean)this.value;
        }
        throw new UtilEvalError("Primitive not a boolean");
    }

    public boolean isNumber() {
        return !(this.value instanceof Boolean) && this != NULL && this != VOID;
    }

    public Number numberValue() throws UtilEvalError {
        Object object = this.value;
        if (object instanceof Character) {
            object = (int)((Character)object).charValue();
        }
        if (object instanceof Number) {
            return (Number)object;
        }
        throw new UtilEvalError("Primitive not a number");
    }

    public boolean equals(Object object) {
        if (object instanceof Primitive) {
            return ((Primitive)object).value.equals(this.value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode() * 21;
    }

    public static Object unwrap(Object object) {
        if (object == VOID) {
            return null;
        }
        if (object instanceof Primitive) {
            return ((Primitive)object).getValue();
        }
        return object;
    }

    public static Object[] unwrap(Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = Primitive.unwrap(objectArray[i]);
        }
        return objectArray2;
    }

    public static Object[] wrap(Object[] objectArray, Class[] classArray) {
        if (objectArray == null) {
            return null;
        }
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = Primitive.wrap(objectArray[i], classArray[i]);
        }
        return objectArray2;
    }

    public static Object wrap(Object object, Class clazz) {
        if (clazz == Void.TYPE) {
            return VOID;
        }
        if (object == null) {
            return NULL;
        }
        if (clazz.isPrimitive()) {
            return new Primitive(object);
        }
        return object;
    }

    public static Primitive getDefaultValue(Class clazz) {
        if (clazz == null || !clazz.isPrimitive()) {
            return NULL;
        }
        if (clazz == Boolean.TYPE) {
            return new Primitive(false);
        }
        try {
            return new Primitive(0).castToType(clazz, 0);
        }
        catch (UtilEvalError utilEvalError) {
            throw new InterpreterError("bad cast");
        }
    }

    public static Class boxType(Class clazz) {
        Class clazz2 = (Class)wrapperMap.get(clazz);
        if (clazz2 != null) {
            return clazz2;
        }
        throw new InterpreterError("Not a primitive type: " + clazz);
    }

    public static Class unboxType(Class clazz) {
        Class clazz2 = (Class)wrapperMap.get(clazz);
        if (clazz2 != null) {
            return clazz2;
        }
        throw new InterpreterError("Not a primitive wrapper type: " + clazz);
    }

    public Primitive castToType(Class clazz, int n) throws UtilEvalError {
        return Primitive.castPrimitive(clazz, this.getType(), this, false, n);
    }

    static Primitive castPrimitive(Class clazz, Class clazz2, Primitive primitive, boolean bl, int n) throws UtilEvalError {
        if (bl && primitive != null) {
            throw new InterpreterError("bad cast param 1");
        }
        if (!bl && primitive == null) {
            throw new InterpreterError("bad cast param 2");
        }
        if (clazz2 != null && !clazz2.isPrimitive()) {
            throw new InterpreterError("bad fromType:" + clazz2);
        }
        if (primitive == NULL && clazz2 != null) {
            throw new InterpreterError("inconsistent args 1");
        }
        if (primitive == VOID && clazz2 != Void.TYPE) {
            throw new InterpreterError("inconsistent args 2");
        }
        if (clazz2 == Void.TYPE) {
            if (bl) {
                return Types.INVALID_CAST;
            }
            throw Types.castError(Reflect.normalizeClassName(clazz), "void value", n);
        }
        Object object = null;
        if (primitive != null) {
            object = primitive.getValue();
        }
        if (clazz.isPrimitive()) {
            if (clazz2 == null) {
                if (bl) {
                    return Types.INVALID_CAST;
                }
                throw Types.castError("primitive type:" + clazz, "Null value", n);
            }
        } else {
            if (clazz2 == null) {
                return bl ? Types.VALID_CAST : NULL;
            }
            if (bl) {
                return Types.INVALID_CAST;
            }
            throw Types.castError("object type:" + clazz, "primitive value", n);
        }
        if (clazz2 == Boolean.TYPE) {
            if (clazz != Boolean.TYPE) {
                if (bl) {
                    return Types.INVALID_CAST;
                }
                throw Types.castError(clazz, clazz2, n);
            }
            return bl ? Types.VALID_CAST : primitive;
        }
        if (n == 1 && !Types.isJavaAssignable(clazz, clazz2)) {
            if (bl) {
                return Types.INVALID_CAST;
            }
            throw Types.castError(clazz, clazz2, n);
        }
        return bl ? Types.VALID_CAST : new Primitive(Primitive.castWrapper(clazz, object));
    }

    public static boolean isWrapperType(Class clazz) {
        return wrapperMap.get(clazz) != null && !clazz.isPrimitive();
    }

    static Object castWrapper(Class clazz, Object object) {
        if (!clazz.isPrimitive()) {
            throw new InterpreterError("invalid type in castWrapper: " + clazz);
        }
        if (object == null) {
            throw new InterpreterError("null value in castWrapper, guard");
        }
        if (object instanceof Boolean) {
            if (clazz != Boolean.TYPE) {
                throw new InterpreterError("bad wrapper cast of boolean");
            }
            return object;
        }
        if (object instanceof Character) {
            object = (int)((Character)object).charValue();
        }
        if (!(object instanceof Number)) {
            throw new InterpreterError("bad type in cast");
        }
        Number number = (Number)object;
        if (clazz == Byte.TYPE) {
            return number.byteValue();
        }
        if (clazz == Short.TYPE) {
            return number.shortValue();
        }
        if (clazz == Character.TYPE) {
            return Character.valueOf((char)number.intValue());
        }
        if (clazz == Integer.TYPE) {
            return number.intValue();
        }
        if (clazz == Long.TYPE) {
            return number.longValue();
        }
        if (clazz == Float.TYPE) {
            return Float.valueOf(number.floatValue());
        }
        if (clazz == Double.TYPE) {
            return number.doubleValue();
        }
        throw new InterpreterError("error in wrapper cast");
    }

    static {
        wrapperMap.put(Boolean.TYPE, Boolean.class);
        wrapperMap.put(Byte.TYPE, Byte.class);
        wrapperMap.put(Short.TYPE, Short.class);
        wrapperMap.put(Character.TYPE, Character.class);
        wrapperMap.put(Integer.TYPE, Integer.class);
        wrapperMap.put(Long.TYPE, Long.class);
        wrapperMap.put(Float.TYPE, Float.class);
        wrapperMap.put(Double.TYPE, Double.class);
        wrapperMap.put(Boolean.class, Boolean.TYPE);
        wrapperMap.put(Byte.class, Byte.TYPE);
        wrapperMap.put(Short.class, Short.TYPE);
        wrapperMap.put(Character.class, Character.TYPE);
        wrapperMap.put(Integer.class, Integer.TYPE);
        wrapperMap.put(Long.class, Long.TYPE);
        wrapperMap.put(Float.class, Float.TYPE);
        wrapperMap.put(Double.class, Double.TYPE);
        NULL = new Primitive(Special.NULL_VALUE);
        VOID = new Primitive(Special.VOID_TYPE);
    }

    private static class Special
    implements Serializable {
        public static final Special NULL_VALUE = new Special();
        public static final Special VOID_TYPE = new Special();

        private Special() {
        }
    }
}

