/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.pluginmgr.MirrorList;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.Task;
import org.gjt.sp.util.ThreadUtilities;

public class PluginManagerOptionPane
extends AbstractOptionPane {
    private JLabel mirrorLabel;
    private JCheckBox disableObsolete;
    private JRadioButton settingsDir;
    private JCheckBox downloadSource;
    private JCheckBox deleteDownloads;
    private SpinnerNumberModel spinnerModel;
    private MirrorModel miraModel;
    private JList<String> miraList;
    private JButton updateMirrors;
    private final JLabel updateStatus = new JLabel();

    public PluginManagerOptionPane() {
        super("plugin-manager");
    }

    @Override
    protected void _init() {
        JComponent jComponent;
        this.setLayout(new BorderLayout());
        this.mirrorLabel = new JLabel();
        this.updateMirrorLabel();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = null;
        if (jEdit.getSettingsDirectory() != null) {
            this.settingsDir = new JRadioButton(jEdit.getProperty("options.plugin-manager.settings-dir"));
            this.settingsDir.setToolTipText(MiscUtilities.constructPath(jEdit.getSettingsDirectory(), "jars"));
            int n = jEdit.getIntegerProperty("plugin-manager.list-cache.minutes", 10);
            this.spinnerModel = new SpinnerNumberModel(n, 0, 240, 5);
            jComponent = new JSpinner(this.spinnerModel);
            jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel2.add(new JLabel(jEdit.getProperty("options.plugin-manager.list-cache.minutes")));
            jPanel2.add(jComponent);
            jPanel2.add(Box.createGlue());
        }
        JRadioButton jRadioButton = new JRadioButton(jEdit.getProperty("options.plugin-manager.app-dir"));
        jRadioButton.setToolTipText(MiscUtilities.constructPath(jEdit.getJEditHome(), "jars"));
        this.miraModel = new MirrorModel();
        this.miraList = new JList<String>(this.miraModel);
        this.miraList.setSelectionModel(new SingleSelectionModel());
        this.add("North", this.mirrorLabel);
        this.add("Center", new JScrollPane(this.miraList));
        jPanel.add(Box.createVerticalStrut(6));
        this.updateMirrors = new JButton(jEdit.getProperty("options.plugin-manager.updateMirrors"));
        this.updateMirrors.addActionListener(actionEvent -> {
            this.updateMirrors.setEnabled(false);
            this.updateStatus.setText(jEdit.getProperty("options.plugin-manager.workthread"));
            ThreadUtilities.runInBackground(new UpdateMirrorsThread(true));
        });
        this.updateMirrors.setEnabled(false);
        ThreadUtilities.runInBackground(new UpdateMirrorsThread(false));
        jComponent = new JPanel(new FlowLayout(0));
        jComponent.add(this.updateMirrors);
        if (jPanel2 != null) {
            jComponent.add(jPanel2);
        }
        jComponent.add(this.updateStatus);
        jComponent.setAlignmentX(0.0f);
        jPanel.add(jComponent);
        jPanel.add(Box.createVerticalStrut(6));
        this.downloadSource = new JCheckBox(jEdit.getProperty("options.plugin-manager.downloadSource"));
        this.downloadSource.setSelected(jEdit.getBooleanProperty("plugin-manager.downloadSource"));
        this.downloadSource.setAlignmentX(0.0f);
        jPanel.add(this.downloadSource);
        this.deleteDownloads = new JCheckBox(jEdit.getProperty("options.plugin-manager.deleteDownloads"));
        this.deleteDownloads.setSelected(jEdit.getBooleanProperty("plugin-manager.deleteDownloads"));
        this.deleteDownloads.setAlignmentX(0.0f);
        jPanel.add(this.deleteDownloads);
        this.disableObsolete = new JCheckBox(jEdit.getProperty("options.plugin-manager.disable-obsolete"));
        this.disableObsolete.setSelected(jEdit.getBooleanProperty("plugin-manager.disable-obsolete", true));
        this.disableObsolete.setAlignmentX(0.0f);
        jPanel.add(this.disableObsolete);
        jPanel.add(Box.createVerticalStrut(6));
        ButtonGroup buttonGroup = new ButtonGroup();
        if (jEdit.getSettingsDirectory() != null) {
            buttonGroup.add(this.settingsDir);
        }
        buttonGroup.add(jRadioButton);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        if (jEdit.getSettingsDirectory() != null) {
            jPanel3.add(this.settingsDir);
            jPanel3.add(Box.createVerticalStrut(3));
        }
        jPanel3.setBorder(new TitledBorder(jEdit.getProperty("options.plugin-manager.location")));
        jPanel3.add(jRadioButton);
        jPanel3.setAlignmentX(0.0f);
        jPanel.add(jPanel3);
        jPanel.add(Box.createGlue());
        this.add("South", jPanel);
        if (jEdit.getBooleanProperty("plugin-manager.installUser") && jEdit.getSettingsDirectory() != null) {
            this.settingsDir.setSelected(true);
        } else {
            jRadioButton.setSelected(true);
        }
    }

    @Override
    protected void _save() {
        jEdit.setBooleanProperty("plugin-manager.installUser", this.settingsDir != null && this.settingsDir.isSelected());
        jEdit.setBooleanProperty("plugin-manager.downloadSource", this.downloadSource.isSelected());
        jEdit.setBooleanProperty("plugin-manager.deleteDownloads", this.deleteDownloads.isSelected());
        jEdit.setIntegerProperty("plugin-manager.list-cache.minutes", this.spinnerModel.getNumber().intValue());
        jEdit.setBooleanProperty("plugin-manager.disable-obsolete", this.disableObsolete.isSelected());
        if (this.miraList.getSelectedIndex() != -1) {
            String string = this.miraModel.getID(this.miraList.getSelectedIndex());
            String string2 = jEdit.getProperty("plugin-manager.mirror.id");
            if (!string2.equals(string)) {
                jEdit.setProperty("plugin-manager.mirror.id", string);
                jEdit.setProperty("plugin-manager.mirror.name", this.miraModel.getElementAt(this.miraList.getSelectedIndex()));
                this.updateMirrorLabel();
            }
        }
    }

    private void updateMirrorLabel() {
        String string;
        String string2 = jEdit.getProperty("plugin-manager.mirror.id");
        if (string2.equals("NONE")) {
            string = "Plugin Central default";
        } else {
            string = jEdit.getProperty("plugin-manager.mirror.name");
            if (string == null) {
                string = string2;
            }
        }
        this.mirrorLabel.setText(jEdit.getProperty("options.plugin-manager.mirror") + " " + string);
    }

    class UpdateMirrorsThread
    extends Task {
        private final boolean download;

        UpdateMirrorsThread(boolean bl) {
            this.download = bl;
        }

        @Override
        public void _run() {
            try {
                ArrayList<MirrorList.Mirror> arrayList;
                block7: {
                    this.setStatus(jEdit.getProperty("options.plugin-manager.workthread"));
                    this.setMaximum(3L);
                    this.setValue(0L);
                    arrayList = new ArrayList<MirrorList.Mirror>();
                    try {
                        MirrorList mirrorList;
                        if (this.download) {
                            mirrorList = MirrorList.mirrorListFromInternet(this);
                            mirrorList.saveXml();
                        } else {
                            mirrorList = MirrorList.mirrorListFromDisk(this);
                        }
                        arrayList.addAll(mirrorList.getMirrors());
                    }
                    catch (Exception exception) {
                        if (!this.download) break block7;
                        Log.log(9, this, exception);
                        ThreadUtilities.runInDispatchThread(() -> GUIUtilities.error(PluginManagerOptionPane.this, "ioerror", new String[]{exception.toString()}));
                    }
                }
                ThreadUtilities.runInDispatchThread(() -> {
                    PluginManagerOptionPane.this.miraModel.setList(arrayList);
                    String string = jEdit.getProperty("plugin-manager.mirror.id");
                    int n = PluginManagerOptionPane.this.miraModel.getSize();
                    for (int i = 0; i < n; ++i) {
                        if (n != 1 && !PluginManagerOptionPane.this.miraModel.getID(i).equals(string)) continue;
                        PluginManagerOptionPane.this.miraList.setSelectedIndex(i);
                        break;
                    }
                    if (n == 0) {
                        PluginManagerOptionPane.this.miraList.clearSelection();
                    }
                });
                this.setValue(3L);
            }
            finally {
                ThreadUtilities.runInDispatchThread(() -> {
                    PluginManagerOptionPane.this.updateMirrors.setEnabled(true);
                    PluginManagerOptionPane.this.updateStatus.setText(null);
                });
            }
        }
    }

    static class SingleSelectionModel
    extends DefaultListSelectionModel {
        SingleSelectionModel() {
            this.setSelectionMode(0);
        }

        @Override
        public void removeSelectionInterval(int n, int n2) {
        }
    }

    static class MirrorModel
    extends AbstractListModel<String> {
        private List<MirrorList.Mirror> mirrors = new ArrayList<MirrorList.Mirror>();

        MirrorModel() {
        }

        public String getID(int n) {
            return this.mirrors.get((int)n).id;
        }

        @Override
        public int getSize() {
            return this.mirrors.size();
        }

        @Override
        public String getElementAt(int n) {
            MirrorList.Mirror mirror = this.mirrors.get(n);
            if (mirror.id.equals("NONE")) {
                return jEdit.getProperty("options.plugin-manager.none");
            }
            return mirror.continent + ": " + mirror.description + " (" + mirror.location + ")";
        }

        public void setList(List<MirrorList.Mirror> list) {
            this.mirrors = list;
            this.fireContentsChanged(this, 0, list.size() - 1);
        }
    }
}

