%%
%% This is file `bookcover.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% ./bookcover.dtx  (with options: `class')
%% This is a generated file.
%% Copyright (C) 2015-2020 Tibor Tomacs
%% This file may be distributed and/or modified under the
%% conditions of the LaTeX Project Public License, either
%% version 1.2 of this license or (at your option) any later
%% version. The latest version of this license is in:
%% 
%% http://www.latex-project.org/lppl.txt
%% 
%% and version 1.2 or later is part of all distributions of
%% LaTeX version 1999/12/01 or later.
%% 

\NeedsTeXFormat{LaTeX2e}[2020/10/01]
\ProvidesClass{bookcover}[2020/11/16 v2.5 class for book covers and dust jackets]

%% OPTIONS

\RequirePackage{kvoptions}
\SetupKeyvalOptions{family=bookcover,prefix=bookcover@}
\DeclareVoidOption{10pt}{\PassOptionsToClass{10pt}{article}}
\DeclareVoidOption{11pt}{\PassOptionsToClass{11pt}{article}}
\DeclareVoidOption{12pt}{\PassOptionsToClass{12pt}{article}}
\DeclareStringOption[170mm]{coverwidth}
\DeclareStringOption[240mm]{coverheight}
\DeclareStringOption[5mm]{spinewidth}
\DeclareStringOption[0mm]{flapwidth}
\DeclareStringOption[10mm]{marklength}
\DeclareStringOption[.4pt]{markthick}
\DeclareStringOption[5mm]{bleedwidth}
\DeclareStringOption[red]{markcolor}
\DeclareBoolOption[false]{trimmed}
\ProcessKeyvalOptions{bookcover}

%% CLASS AND PACKAGES

\LoadClass{article}
\RequirePackage{geometry,graphicx,calc,ifthen,tikz,environ}
\RequirePackage[nonefgrulers]{fgruler}

%% PAGE STYLE

\pagestyle{empty}
\def\ps@plain{}

%% NEW IF

\newif\if@inbookcoverenv

%% USER LENGTHS

\newlength{\coverwidth}
\newlength{\coverheight}
\newlength{\spinewidth}
\newlength{\flapwidth}
\newlength{\marklength}
\newlength{\markthick}
\newlength{\bleedwidth}

%% INTERNAL LENGTHS

\newlength{\bookcover@templength@}
\newlength{\bookcover@xpos@}
\newlength{\bookcover@ypos@}
\newlength{\bookcover@partwidth@}
\newlength{\bookcover@partheight@}
\newlength{\bookcover@tikz@trimmed@part@width@minus}
\newlength{\bookcover@tikz@trimmed@part@height@minus}
\newlength{\bookcover@tikz@trimmed@part@push@right}
\newlength{\bookcover@tikz@trimmed@part@push@up}
\newlength{\bookcover@rulerwidth@}
\newlength{\bookcover@rulerheight@}
\let\partheight\bookcover@partheight@
\let\partwidth\bookcover@partwidth@

%% USER LENGTHS SETTING

\setlength{\coverwidth}{\bookcover@coverwidth}
\setlength{\coverheight}{\bookcover@coverheight}
\setlength{\spinewidth}{\bookcover@spinewidth}
\setlength{\flapwidth}{\bookcover@flapwidth}
\setlength{\marklength}{\bookcover@marklength}
\setlength{\markthick}{\bookcover@markthick}
\setlength{\bleedwidth}{\bookcover@bleedwidth}

%% PAGE DIMENSIONS SETTING

\geometry{%
    margin=0pt,
    paperwidth=2\marklength+2\bleedwidth+2\coverwidth+2\flapwidth+\spinewidth,
    paperheight=2\marklength+2\bleedwidth+\coverheight}

%% INTERNAL LENGTHS SETTING

\def\bookcover@xpos#1{\setlength{\bookcover@xpos@}{#1}}
\def\bookcover@ypos#1{\setlength{\bookcover@ypos@}{#1}}
\def\bookcover@partwidth#1{\setlength{\bookcover@partwidth@}{#1}}
\def\bookcover@partheight#1{\setlength{\bookcover@partheight@}{#1}}
\def\bookcover@tikz@trimmed@part@param#1#2#3#4{%
    \setlength{\bookcover@tikz@trimmed@part@width@minus}{#1}%
    \setlength{\bookcover@tikz@trimmed@part@height@minus}{#2}%
    \setlength{\bookcover@tikz@trimmed@part@push@right}{#3}%
    \setlength{\bookcover@tikz@trimmed@part@push@up}{#4}}
\let\setpartposx\bookcover@xpos
\let\setpartposy\bookcover@ypos
\let\setpartwidth\bookcover@partwidth
\let\setpartheight\bookcover@partheight
\let\settrimmedpart\bookcover@tikz@trimmed@part@param

%% BOOKCOVERDESCGEOMETRY

\def\bookcoverdescgeometry#1{\def\bookcover@descgeometry{#1}}
\def\bookcover@descgeometry{margin=1in}

%% BOOKCOVERDESCRIPTION

\newenvironment{bookcoverdescription}{%
    \if@inbookcoverenv\@latexerr{Don't use 'bookcoverdescription' in 'bookcover' environment!}{}\fi}{}
\AddToHook{env/bookcoverdescription/before}{\expandafter\newgeometry\expandafter{\bookcover@descgeometry}}
\AddToHook{env/bookcoverdescription/after}{\restoregeometry}

%% POSBOX

\newcommand{\bookcover@posbox}[4]{%
    \setlength{\bookcover@templength@}{#3}%
    \put(#2,-\bookcover@templength@){\parbox[b][0pt][t]{#1}{#4}}}

%% MARKS

\def\bookcover@vmark{%
    \bookcover@posbox{\bookcover@partwidth@}{\bookcover@xpos@}{\bookcover@ypos@}{%
        {\color{\bookcover@markcolor}\rule[0pt]{\markthick}{\marklength}}}}

\def\bookcover@hmark{%
    \bookcover@posbox{\bookcover@partwidth@}{\bookcover@xpos@}{\bookcover@ypos@}{%
        {\color{\bookcover@markcolor}\rule[0pt]{\marklength}{\markthick}}}}

\def\bookcover@marks{
    \bookcover@ypos{0mm}
    \bookcover@partwidth{\markthick}
    \bookcover@xpos{\marklength+\bleedwidth-.5\markthick}
    \bookcover@vmark
    \ifdim\flapwidth>0mm
        \bookcover@xpos{\marklength+\bleedwidth+\flapwidth-.5\markthick}
        \bookcover@vmark\fi
    \bookcover@xpos{\marklength+\bleedwidth+\flapwidth+\coverwidth-.5\markthick}
    \bookcover@vmark
    \bookcover@xpos{\marklength+\bleedwidth+\flapwidth+\coverwidth+\spinewidth-.5\markthick}
    \bookcover@vmark
    \ifdim\flapwidth>0mm
        \bookcover@xpos{\marklength+\bleedwidth+\flapwidth+2\coverwidth+\spinewidth-.5\markthick}
        \bookcover@vmark\fi
    \bookcover@xpos{\marklength+\bleedwidth+2\flapwidth+2\coverwidth+\spinewidth-.5\markthick}
    \bookcover@vmark
    \bookcover@ypos{\paperheight-\marklength}
    \bookcover@partwidth{\markthick}
    \bookcover@xpos{\marklength+\bleedwidth-.5\markthick}
    \bookcover@vmark
    \ifdim\flapwidth>0mm
        \bookcover@xpos{\marklength+\bleedwidth+\flapwidth-.5\markthick}
        \bookcover@vmark\fi
    \bookcover@xpos{\marklength+\bleedwidth+\flapwidth+\coverwidth-.5\markthick}
    \bookcover@vmark
    \bookcover@xpos{\marklength+\bleedwidth+\flapwidth+\coverwidth+\spinewidth-.5\markthick}
    \bookcover@vmark
    \ifdim\flapwidth>0mm
        \bookcover@xpos{\marklength+\bleedwidth+\flapwidth+2\coverwidth+\spinewidth-.5\markthick}
        \bookcover@vmark\fi
    \bookcover@xpos{\marklength+\bleedwidth+2\flapwidth+2\coverwidth+\spinewidth-.5\markthick}
    \bookcover@vmark
    \bookcover@xpos{0mm}
    \bookcover@partwidth{\marklength}
    \bookcover@ypos{\marklength+\bleedwidth-.5\markthick}
    \bookcover@hmark
    \bookcover@ypos{\marklength+\bleedwidth+\coverheight-.5\markthick}
    \bookcover@hmark
    \bookcover@xpos{\paperwidth-\marklength}
    \bookcover@partwidth{\marklength}
    \bookcover@ypos{\marklength+\bleedwidth-.5\markthick}
    \bookcover@hmark
    \bookcover@ypos{\marklength+\bleedwidth+\coverheight-.5\markthick}
    \bookcover@hmark}

%% TRIMMING

\def\bookcover@trimming{%
    \bookcover@posbox{\paperwidth}{0mm}{0mm}{%
        \begin{tikzpicture}
            \begin{scope}[color=white]
                \fill(0,0)--
                     (\paperwidth,0)--
                     (\paperwidth,\marklength+\bleedwidth)--
                     (0,\marklength+\bleedwidth)--cycle;
                \fill(0,\paperheight)--
                     (\paperwidth,\paperheight)--
                     (\paperwidth,\paperheight-\marklength-\bleedwidth)--
                     (0,\paperheight-\marklength-\bleedwidth)--cycle;
                \fill(0,0)--
                     (\marklength+\bleedwidth,0)--
                     (\marklength+\bleedwidth,\paperheight)--
                     (0,\paperheight)--cycle;
                \fill(\paperwidth-\marklength-\bleedwidth,0)--
                     (\paperwidth,0)--
                     (\paperwidth,\paperheight)--
                     (\paperwidth-\marklength-\bleedwidth,\paperheight)--cycle;
            \end{scope}
            \draw[color=\bookcover@markcolor,line width=\markthick]
                 (\marklength+\bleedwidth,\marklength+\bleedwidth)--
                 (\paperwidth-\marklength-\bleedwidth,\marklength+\bleedwidth)--
                 (\paperwidth-\marklength-\bleedwidth,\paperheight-\marklength-\bleedwidth)--
                 (\marklength+\bleedwidth,\paperheight-\marklength-\bleedwidth)--cycle;
        \end{tikzpicture}}
    \bookcover@ypos{\bleedwidth}
    \bookcover@partwidth{\markthick}
    \ifdim\flapwidth>0mm
        \bookcover@xpos{\marklength+\bleedwidth+\flapwidth-.5\markthick}
        \bookcover@vmark
        \bookcover@xpos{\marklength+\bleedwidth+\flapwidth+2\coverwidth+\spinewidth-.5\markthick}
        \bookcover@vmark\fi
    \bookcover@xpos{\marklength+\bleedwidth+\flapwidth+\coverwidth-.5\markthick}
    \bookcover@vmark
    \bookcover@xpos{\marklength+\bleedwidth+\flapwidth+\coverwidth+\spinewidth-.5\markthick}
    \bookcover@vmark
    \bookcover@ypos{\paperheight-\marklength-\bleedwidth}
    \bookcover@partwidth{\markthick}
    \ifdim\flapwidth>0mm
        \bookcover@xpos{\marklength+\bleedwidth+\flapwidth-.5\markthick}
        \bookcover@vmark
        \bookcover@xpos{\marklength+\bleedwidth+\flapwidth+2\coverwidth+\spinewidth-.5\markthick}
        \bookcover@vmark\fi
    \bookcover@xpos{\marklength+\bleedwidth+\flapwidth+\coverwidth-.5\markthick}
    \bookcover@vmark
    \bookcover@xpos{\marklength+\bleedwidth+\flapwidth+\coverwidth+\spinewidth-.5\markthick}
    \bookcover@vmark}

%% BOOKCOVER ENVIRONMENT

\def\bookcover{%
    \@inbookcoverenvtrue%
    \newpage%
    \noindent%
    \begin{picture}(\paperwidth,\paperheight)(0,-\paperheight)}

\def\endbookcover{%
    \bookcover@marks%
    \ifbookcover@trimmed\bookcover@trimming\fi%
    \end{picture}%
    \@inbookcoverenvfalse}

%% BOOKCOVER COMPONENT

\long\def\bookcovercomponent#1#2#3{
    \if@inbookcoverenv\else
        \@latexerr{\string\bookcovercomponent\space is not in 'bookcover' environment.}{}\fi
    \bookcover@xpos{0pt}
    \bookcover@ypos{0pt}
    \bookcover@partwidth{0pt}
    \bookcover@partheight{0pt}
    \bookcover@tikz@trimmed@part@param{0pt}{0pt}{0pt}{0pt}
    \@ifundefined{bookcover@part@param@#2}{\@latexerr{Part '#2' undefined.}{}}{
        \@ifundefined{bookcover@componenttype@#1}{\@latexerr{Component type '#1' undefined.}{}}{
            \ifx\@empty#3\else
                \csname bookcover@part@param@#2\endcsname
                \ifdim\bookcover@partwidth@>0mm
                    \ifdim\bookcover@partheight@>0mm
                        \csname bookcover@componenttype@#1\endcsname{#3}\fi\fi\fi}}}

%% BOOKCOVERELEMENT ENVIRONMENT

\NewEnviron{bookcoverelement}[2]{\bookcovercomponent{#1}{#2}{\BODY}}

%% NEW BOOKCOVER PART

\def\newbookcoverpart#1#2{
    \@ifundefined{bookcover@part@param@#1}{
        \expandafter\def\csname bookcover@part@param@#1\endcsname{#2}}
    {\@latexerr{Part '#1' already defined.}{}}}

%% RENEW BOOKCOVER PART

\def\renewbookcoverpart#1#2{
    \@ifundefined{bookcover@part@param@#1}{\@latexerr{Part '#1' undefined.}{}}{
        \expandafter\def\csname bookcover@part@param@#1\endcsname{#2}}}

%% NEW NAME BOOKCOVER PART

\def\newnamebookcoverpart#1#2{
    \@ifundefined{bookcover@part@param@#1}{
        \@ifundefined{bookcover@part@param@#2}{\@latexerr{Part '#2' undefined.}{}}{
            \expandafter\def\csname bookcover@part@param@#1\endcsname{%
                \csname bookcover@part@param@#2\endcsname}}}
    {\@latexerr{Part '#1' already defined.}{}}}

%% NEW BOOKCOVER COMPONENT TYPE

\def\newbookcovercomponenttype#1#2{%
    \@ifundefined{bookcover@componenttype@#1}{%
        \long\expandafter\def\csname bookcover@componenttype@#1\endcsname##1{%
        \bookcover@posbox{\bookcover@partwidth@}{\bookcover@xpos@}{\bookcover@ypos@}{#2}}}
    {\@latexerr{Component type '#1' already defined.}{}}}

%% RENEW BOOKCOVER COMPONENT TYPE

\def\renewbookcovercomponenttype#1#2{%
    \@ifundefined{bookcover@componenttype@#1}{\@latex@error{Component type '#1' undefined.}{}}{%
        \long\expandafter\def\csname bookcover@componenttype@#1\endcsname##1{%
        \bookcover@posbox{\bookcover@partwidth@}{\bookcover@xpos@}{\bookcover@ypos@}{#2}}}}

%% NEW NAME BOOKCOVER COMPONENT TYPE

\def\newnamebookcovercomponenttype#1#2{
    \@ifundefined{bookcover@componenttype@#1}{
        \@ifundefined{bookcover@componenttype@#2}{\@latexerr{Component type '#2' undefined.}{}}{
            \expandafter\def\csname bookcover@componenttype@#1\endcsname{%
                \csname bookcover@componenttype@#2\endcsname}}}
    {\@latexerr{Component type '#1' already defined.}{}}}

%% COMPONENT TYPES

\newbookcovercomponenttype{color}{
    \tikz\fill\expandafter[#1] (0,0) rectangle (\bookcover@partwidth@,\bookcover@partheight@);}

\newbookcovercomponenttype{picture}{
    \includegraphics[width=\bookcover@partwidth@,height=\bookcover@partheight@]{#1}}

\newbookcovercomponenttype{tikz}{
    \begin{tikzpicture}[overlay,yshift=-\bookcover@partheight@]
    \begin{scope}[transparent,line width=0pt]
        \pgfset{minimum width=\bookcover@partwidth@,minimum height=\bookcover@partheight@}
        \pgfnode{rectangle}{south west}{}{part}{\pgfusepath{draw}}
        \pgfset{minimum width=\bookcover@partwidth@-\bookcover@tikz@trimmed@part@width@minus,
                minimum height=\bookcover@partheight@-\bookcover@tikz@trimmed@part@height@minus}
        \pgftransformshift{\pgfpoint{\bookcover@tikz@trimmed@part@push@right}
                                    {\bookcover@tikz@trimmed@part@push@up}}
        \pgfnode{rectangle}{south west}{}{trimmed part}{\pgfusepath{draw}}
    \end{scope}
    #1
    \end{tikzpicture}}

\newbookcovercomponenttype{tikz clip}{
    \begin{tikzpicture}[overlay,yshift=-\bookcover@partheight@]
    \begin{scope}[transparent,line width=0pt]
        \pgfset{minimum width=\bookcover@partwidth@,minimum height=\bookcover@partheight@}
        \pgfnode{rectangle}{south west}{}{part}{\pgfusepath{draw}}
        \pgfset{minimum width=\bookcover@partwidth@-\bookcover@tikz@trimmed@part@width@minus,
                minimum height=\bookcover@partheight@-\bookcover@tikz@trimmed@part@height@minus}
        \pgftransformshift{\pgfpoint{\bookcover@tikz@trimmed@part@push@right}
                                    {\bookcover@tikz@trimmed@part@push@up}}
        \pgfnode{rectangle}{south west}{}{trimmed part}{\pgfusepath{draw}}
    \end{scope}
    \clip (part.south west) rectangle (part.north east);
    #1
    \end{tikzpicture}}

\newbookcovercomponenttype{normal}{
    \parbox[t][\bookcover@partheight@][t]{\bookcover@partwidth@}{#1}}

\newbookcovercomponenttype{center}{
    \parbox[t][\bookcover@partheight@][c]{\bookcover@partwidth@}{\begin{center}#1\end{center}}}

\newbookcovercomponenttype{ruler}{
    \parbox[t][\bookcover@partheight@][t]{\bookcover@partwidth@}{#1}}
\newcommand{\setruler}[5][cm]{%
    \rulernorotatenum%
    \rulerparams{}{}{#5}{}{}%
    \setlength{\bookcover@rulerwidth@}{\bookcover@partwidth@-#3}%
    \setlength{\bookcover@rulerheight@}{\bookcover@partheight@-#4}%
    \ifthenelse{\equal{#2}{upper left}}{%
        \vspace{#4}%
        \hspace{#3}%
        \squareruler[#1]{upperleft}{\bookcover@rulerwidth@}{\bookcover@rulerheight@}}{}%
    \ifthenelse{\equal{#2}{upper right}}{%
        \vspace{#4}%
        \squareruler[#1]{upperright}{\bookcover@rulerwidth@}{\bookcover@rulerheight@}}{}%
    \ifthenelse{\equal{#2}{lower left}}{%
        \hspace{#3}%
        \squareruler[#1]{lowerleft}{\bookcover@rulerwidth@}{\bookcover@rulerheight@}}{}%
    \ifthenelse{\equal{#2}{lower right}}{%
        \squareruler[#1]{lowerright}{\bookcover@rulerwidth@}{\bookcover@rulerheight@}}{}}

%% BOOKCOVER PARTS

\newbookcoverpart{bg back flap}{
    \ifdim\flapwidth>0mm
        \bookcover@ypos{\marklength}
        \bookcover@partheight{\coverheight+2\bleedwidth}
        \bookcover@xpos{\marklength}
        \bookcover@partwidth{\flapwidth+\bleedwidth}
        \bookcover@tikz@trimmed@part@param{\bleedwidth}{2\bleedwidth}{\bleedwidth}{\bleedwidth}\fi}

\newbookcoverpart{bg back}{
    \bookcover@ypos{\marklength}
    \bookcover@partheight{\coverheight+2\bleedwidth}
    \ifdim\flapwidth>0mm
        \bookcover@xpos{\marklength+\bleedwidth+\flapwidth}
        \bookcover@partwidth{\coverwidth}
        \bookcover@tikz@trimmed@part@param{0pt}{2\bleedwidth}{0pt}{\bleedwidth}
    \else
        \bookcover@xpos{\marklength}
        \bookcover@partwidth{\coverwidth+\bleedwidth}
        \bookcover@tikz@trimmed@part@param{\bleedwidth}{2\bleedwidth}{\bleedwidth}{\bleedwidth}\fi}

\newbookcoverpart{bg spine}{
    \bookcover@ypos{\marklength}
    \bookcover@partheight{\coverheight+2\bleedwidth}
    \bookcover@xpos{\marklength+\bleedwidth+\flapwidth+\coverwidth}
    \bookcover@partwidth{\spinewidth}
    \bookcover@tikz@trimmed@part@param{0pt}{2\bleedwidth}{0pt}{\bleedwidth}}

\newbookcoverpart{bg front}{
    \bookcover@ypos{\marklength}
    \bookcover@partheight{\coverheight+2\bleedwidth}
    \bookcover@xpos{\marklength+\bleedwidth+\flapwidth+\coverwidth+\spinewidth}
    \ifdim\flapwidth>0mm
        \bookcover@partwidth{\coverwidth}
        \bookcover@tikz@trimmed@part@param{0pt}{2\bleedwidth}{0pt}{\bleedwidth}
    \else
        \bookcover@partwidth{\coverwidth+\bleedwidth}
        \bookcover@tikz@trimmed@part@param{\bleedwidth}{2\bleedwidth}{0pt}{\bleedwidth}\fi}

\newbookcoverpart{bg front flap}{
    \ifdim\flapwidth>0mm
        \bookcover@ypos{\marklength}
        \bookcover@partheight{\coverheight+2\bleedwidth}
        \bookcover@xpos{\marklength+\bleedwidth+\flapwidth+2\coverwidth+\spinewidth}
        \bookcover@partwidth{\flapwidth+\bleedwidth}
        \bookcover@tikz@trimmed@part@param{\bleedwidth}{2\bleedwidth}{0pt}{\bleedwidth}\fi}

\newbookcoverpart{bg back and flap}{
    \bookcover@ypos{\marklength}
    \bookcover@partheight{\coverheight+2\bleedwidth}
    \bookcover@xpos{\marklength}
    \bookcover@partwidth{\bleedwidth+\flapwidth+\coverwidth}
    \bookcover@tikz@trimmed@part@param{\bleedwidth}{2\bleedwidth}{\bleedwidth}{\bleedwidth}}

\newbookcoverpart{bg back and spine}{
    \bookcover@ypos{\marklength}
    \bookcover@partheight{\coverheight+2\bleedwidth}
    \ifdim\flapwidth>0mm
        \bookcover@xpos{\marklength+\bleedwidth+\flapwidth}
        \bookcover@partwidth{\coverwidth+\spinewidth}
        \bookcover@tikz@trimmed@part@param{0pt}{2\bleedwidth}{0pt}{\bleedwidth}
    \else
        \bookcover@xpos{\marklength}
        \bookcover@partwidth{\coverwidth+\bleedwidth+\spinewidth}
        \bookcover@tikz@trimmed@part@param{\bleedwidth}{2\bleedwidth}{\bleedwidth}{\bleedwidth}\fi}

\newbookcoverpart{bg front and spine}{
    \bookcover@ypos{\marklength}
    \bookcover@partheight{\coverheight+2\bleedwidth}
    \bookcover@xpos{\marklength+\bleedwidth+\flapwidth+\coverwidth}
    \ifdim\flapwidth>0mm
        \bookcover@partwidth{\coverwidth+\spinewidth}
        \bookcover@tikz@trimmed@part@param{0pt}{2\bleedwidth}{0pt}{\bleedwidth}
    \else
        \bookcover@partwidth{\coverwidth+\spinewidth+\bleedwidth}
        \bookcover@tikz@trimmed@part@param{\bleedwidth}{2\bleedwidth}{0pt}{\bleedwidth}\fi}

\newbookcoverpart{bg front and flap}{
    \bookcover@ypos{\marklength}
    \bookcover@partheight{\coverheight+2\bleedwidth}
    \bookcover@xpos{\marklength+\bleedwidth+\flapwidth+\coverwidth+\spinewidth}
    \bookcover@partwidth{\coverwidth+\flapwidth+\bleedwidth}
    \bookcover@tikz@trimmed@part@param{\bleedwidth}{2\bleedwidth}{0pt}{\bleedwidth}}

\newbookcoverpart{bg back and flap and spine}{
    \bookcover@ypos{\marklength}
    \bookcover@partheight{\coverheight+2\bleedwidth}
    \bookcover@xpos{\marklength}
    \bookcover@partwidth{\bleedwidth+\flapwidth+\coverwidth+\spinewidth}
    \bookcover@tikz@trimmed@part@param{\bleedwidth}{2\bleedwidth}{\bleedwidth}{\bleedwidth}}

\newbookcoverpart{bg whole without flaps}{
    \bookcover@ypos{\marklength}
    \bookcover@partheight{\coverheight+2\bleedwidth}
    \ifdim\flapwidth>0mm
        \bookcover@xpos{\marklength+\bleedwidth+\flapwidth}
        \bookcover@partwidth{2\coverwidth+\spinewidth}
        \bookcover@tikz@trimmed@part@param{0pt}{2\bleedwidth}{0pt}{\bleedwidth}
    \else
        \bookcover@xpos{\marklength}
        \bookcover@partwidth{2\coverwidth+2\bleedwidth+\spinewidth}
        \bookcover@tikz@trimmed@part@param{2\bleedwidth}{2\bleedwidth}{\bleedwidth}{\bleedwidth}\fi}

\newbookcoverpart{bg front and flap and spine}{
    \bookcover@ypos{\marklength}
    \bookcover@partheight{\coverheight+2\bleedwidth}
    \bookcover@xpos{\marklength+\bleedwidth+\flapwidth+\coverwidth}
    \bookcover@partwidth{\coverwidth+\flapwidth+\bleedwidth+\spinewidth}
    \bookcover@tikz@trimmed@part@param{\bleedwidth}{2\bleedwidth}{0pt}{\bleedwidth}}

\newbookcoverpart{bg whole without front flap}{
    \bookcover@ypos{\marklength}
    \bookcover@partheight{\coverheight+2\bleedwidth}
    \bookcover@xpos{\marklength}
    \ifdim\flapwidth>0mm
        \bookcover@partwidth{2\coverwidth+\flapwidth+\bleedwidth+\spinewidth}
        \bookcover@tikz@trimmed@part@param{\bleedwidth}{2\bleedwidth}{\bleedwidth}{\bleedwidth}
    \else
        \bookcover@partwidth{2\coverwidth+2\bleedwidth+\spinewidth}
        \bookcover@tikz@trimmed@part@param{2\bleedwidth}{2\bleedwidth}{\bleedwidth}{\bleedwidth}\fi}

\newbookcoverpart{bg whole without back flap}{
    \bookcover@ypos{\marklength}
    \bookcover@partheight{\coverheight+2\bleedwidth}
    \ifdim\flapwidth>0mm
        \bookcover@xpos{\marklength+\bleedwidth+\flapwidth}
        \bookcover@partwidth{2\coverwidth+\flapwidth+\bleedwidth+\spinewidth}
        \bookcover@tikz@trimmed@part@param{\bleedwidth}{2\bleedwidth}{0mm}{\bleedwidth}
    \else
        \bookcover@xpos{\marklength}
        \bookcover@partwidth{2\coverwidth+2\bleedwidth+\spinewidth}
        \bookcover@tikz@trimmed@part@param{2\bleedwidth}{2\bleedwidth}{\bleedwidth}{\bleedwidth}\fi}

\newbookcoverpart{bg whole}{
    \bookcover@ypos{\marklength}
    \bookcover@partheight{\coverheight+2\bleedwidth}
    \bookcover@xpos{\marklength}
    \bookcover@partwidth{2\coverwidth+2\bleedwidth+2\flapwidth+\spinewidth}
    \bookcover@tikz@trimmed@part@param{2\bleedwidth}{2\bleedwidth}{\bleedwidth}{\bleedwidth}}

\newbookcoverpart{whole page}{
    \bookcover@partheight{\paperheight}
    \bookcover@partwidth{\paperwidth}}

\newbookcoverpart{back flap}{
    \ifdim\flapwidth>0mm
        \bookcover@ypos{\marklength+\bleedwidth}
        \bookcover@partheight{\coverheight}
        \bookcover@xpos{\marklength+\bleedwidth}
        \bookcover@partwidth{\flapwidth}\fi}

\newbookcoverpart{back}{
    \bookcover@ypos{\marklength+\bleedwidth}
    \bookcover@partheight{\coverheight}
    \bookcover@xpos{\marklength+\bleedwidth+\flapwidth}
    \bookcover@partwidth{\coverwidth}}

\newbookcoverpart{spine}{
    \bookcover@ypos{\marklength+\bleedwidth}
    \bookcover@partheight{\coverheight}
    \bookcover@xpos{\marklength+\bleedwidth+\flapwidth+\coverwidth}
    \bookcover@partwidth{\spinewidth}}

\newbookcoverpart{front}{
    \bookcover@ypos{\marklength+\bleedwidth}
    \bookcover@partheight{\coverheight}
    \bookcover@xpos{\marklength+\bleedwidth+\flapwidth+\coverwidth+\spinewidth}
    \bookcover@partwidth{\coverwidth}}

\newbookcoverpart{front flap}{
    \ifdim\flapwidth>0mm
        \bookcover@ypos{\marklength+\bleedwidth}
        \bookcover@partheight{\coverheight}
        \bookcover@xpos{\marklength+\bleedwidth+\flapwidth+2\coverwidth+\spinewidth}
        \bookcover@partwidth{\flapwidth}\fi}

\newbookcoverpart{above front}{
    \ifdim\marklength>0mm
        \bookcover@xpos{\marklength+\bleedwidth+\flapwidth+\coverwidth+\spinewidth}
        \bookcover@ypos{0mm}
        \bookcover@partwidth{\coverwidth}
        \bookcover@partheight{\marklength}\fi}

\newbookcoverpart{below front}{
    \ifdim\marklength>0mm
        \bookcover@xpos{\marklength+\bleedwidth+\flapwidth+\coverwidth+\spinewidth}
        \bookcover@ypos{\marklength+2\bleedwidth+\coverheight}
        \bookcover@partwidth{\coverwidth}
        \bookcover@partheight{\marklength}\fi}

\newbookcoverpart{above back}{
    \ifdim\marklength>0mm
        \bookcover@xpos{\marklength+\bleedwidth+\flapwidth}
        \bookcover@ypos{0mm}
        \bookcover@partwidth{\coverwidth}
        \bookcover@partheight{\marklength}\fi}

\newbookcoverpart{below back}{
    \ifdim\marklength>0mm
        \bookcover@xpos{\marklength+\bleedwidth+\flapwidth}
        \bookcover@ypos{\marklength+2\bleedwidth+\coverheight}
        \bookcover@partwidth{\coverwidth}
        \bookcover@partheight{\marklength}\fi}

\newbookcoverpart{back and flap}{
    \bookcover@ypos{\marklength+\bleedwidth}
    \bookcover@xpos{\marklength+\bleedwidth}
    \bookcover@partwidth{\flapwidth+\coverwidth}
    \bookcover@partheight{\coverheight}}

\newbookcoverpart{back and spine}{
    \bookcover@ypos{\marklength+\bleedwidth}
    \bookcover@partheight{\coverheight}
    \bookcover@xpos{\marklength+\bleedwidth+\flapwidth}
    \bookcover@partwidth{\coverwidth+\spinewidth}}

\newbookcoverpart{front and spine}{
    \bookcover@ypos{\marklength+\bleedwidth}
    \bookcover@partheight{\coverheight}
    \bookcover@xpos{\marklength+\bleedwidth+\flapwidth+\coverwidth}
    \bookcover@partwidth{\coverwidth+\spinewidth}}

\newbookcoverpart{front and flap}{
    \bookcover@ypos{\marklength+\bleedwidth}
    \bookcover@partheight{\coverheight}
    \bookcover@xpos{\marklength+\bleedwidth+\flapwidth+\coverwidth+\spinewidth}
    \bookcover@partwidth{\coverwidth+\flapwidth}}

\newbookcoverpart{back and flap and spine}{
    \bookcover@ypos{\marklength+\bleedwidth}
    \bookcover@xpos{\marklength+\bleedwidth}
    \bookcover@partwidth{\flapwidth+\coverwidth+\spinewidth}
    \bookcover@partheight{\coverheight}}

\newbookcoverpart{whole without flaps}{
    \bookcover@ypos{\marklength+\bleedwidth}
    \bookcover@partheight{\coverheight}
    \bookcover@xpos{\marklength+\bleedwidth+\flapwidth}
    \bookcover@partwidth{2\coverwidth+\spinewidth}}

\newbookcoverpart{front and flap and spine}{
    \bookcover@ypos{\marklength+\bleedwidth}
    \bookcover@partheight{\coverheight}
    \bookcover@xpos{\marklength+\bleedwidth+\flapwidth+\coverwidth}
    \bookcover@partwidth{\coverwidth+\flapwidth+\spinewidth}}

\newbookcoverpart{whole without front flap}{
    \bookcover@ypos{\marklength+\bleedwidth}
    \bookcover@partheight{\coverheight}
    \bookcover@xpos{\marklength+\bleedwidth}
    \bookcover@partwidth{2\coverwidth+\flapwidth+\spinewidth}}

\newbookcoverpart{whole without back flap}{
    \bookcover@ypos{\marklength+\bleedwidth}
    \bookcover@partheight{\coverheight}
    \bookcover@xpos{\marklength+\bleedwidth+\flapwidth}
    \bookcover@partwidth{2\coverwidth+\flapwidth+\spinewidth}}

\newbookcoverpart{whole}{
    \bookcover@ypos{\marklength+\bleedwidth}
    \bookcover@partheight{\coverheight}
    \bookcover@xpos{\marklength+\bleedwidth}
    \bookcover@partwidth{2\coverwidth+2\flapwidth+\spinewidth}}

\endinput
%%
%% End of file `bookcover.cls'.
