/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el.parser;

import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.MethodInfo;
import javax.el.MethodNotFoundException;
import javax.el.PropertyNotFoundException;
import javax.el.ValueExpression;
import javax.el.ValueReference;
import javax.el.VariableMapper;
import org.apache.el.lang.EvaluationContext;
import org.apache.el.parser.SimpleNode;
import org.apache.el.util.MessageFactory;
import org.apache.el.util.Validation;

public final class AstIdentifier
extends SimpleNode {
    public AstIdentifier(int n) {
        super(n);
    }

    @Override
    public Class<?> getType(EvaluationContext evaluationContext) throws ELException {
        Object object;
        VariableMapper variableMapper = evaluationContext.getVariableMapper();
        if (variableMapper != null && (object = variableMapper.resolveVariable(this.image)) != null) {
            return object.getType(evaluationContext.getELContext());
        }
        evaluationContext.setPropertyResolved(false);
        object = evaluationContext.getELResolver().getType((ELContext)evaluationContext, null, (Object)this.image);
        if (!evaluationContext.isPropertyResolved()) {
            throw new PropertyNotFoundException(MessageFactory.get("error.resolver.unhandled.null", this.image));
        }
        return object;
    }

    @Override
    public Object getValue(EvaluationContext evaluationContext) throws ELException {
        Object object;
        VariableMapper variableMapper = evaluationContext.getVariableMapper();
        if (variableMapper != null && (object = variableMapper.resolveVariable(this.image)) != null) {
            return object.getValue(evaluationContext.getELContext());
        }
        evaluationContext.setPropertyResolved(false);
        object = evaluationContext.getELResolver().getValue((ELContext)evaluationContext, null, (Object)this.image);
        if (!evaluationContext.isPropertyResolved()) {
            throw new PropertyNotFoundException(MessageFactory.get("error.resolver.unhandled.null", this.image));
        }
        return object;
    }

    @Override
    public boolean isReadOnly(EvaluationContext evaluationContext) throws ELException {
        ValueExpression valueExpression;
        VariableMapper variableMapper = evaluationContext.getVariableMapper();
        if (variableMapper != null && (valueExpression = variableMapper.resolveVariable(this.image)) != null) {
            return valueExpression.isReadOnly(evaluationContext.getELContext());
        }
        evaluationContext.setPropertyResolved(false);
        boolean bl = evaluationContext.getELResolver().isReadOnly((ELContext)evaluationContext, null, (Object)this.image);
        if (!evaluationContext.isPropertyResolved()) {
            throw new PropertyNotFoundException(MessageFactory.get("error.resolver.unhandled.null", this.image));
        }
        return bl;
    }

    @Override
    public void setValue(EvaluationContext evaluationContext, Object object) throws ELException {
        ValueExpression valueExpression;
        VariableMapper variableMapper = evaluationContext.getVariableMapper();
        if (variableMapper != null && (valueExpression = variableMapper.resolveVariable(this.image)) != null) {
            valueExpression.setValue(evaluationContext.getELContext(), object);
            return;
        }
        evaluationContext.setPropertyResolved(false);
        evaluationContext.getELResolver().setValue((ELContext)evaluationContext, null, (Object)this.image, object);
        if (!evaluationContext.isPropertyResolved()) {
            throw new PropertyNotFoundException(MessageFactory.get("error.resolver.unhandled.null", this.image));
        }
    }

    @Override
    public Object invoke(EvaluationContext evaluationContext, Class<?>[] classArray, Object[] objectArray) throws ELException {
        return this.getMethodExpression(evaluationContext).invoke(evaluationContext.getELContext(), objectArray);
    }

    @Override
    public MethodInfo getMethodInfo(EvaluationContext evaluationContext, Class<?>[] classArray) throws ELException {
        return this.getMethodExpression(evaluationContext).getMethodInfo(evaluationContext.getELContext());
    }

    @Override
    public void setImage(String string) {
        if (!Validation.isIdentifier(string)) {
            throw new ELException(MessageFactory.get("error.identifier.notjava", string));
        }
        this.image = string;
    }

    @Override
    public ValueReference getValueReference(EvaluationContext evaluationContext) {
        VariableMapper variableMapper = evaluationContext.getVariableMapper();
        if (variableMapper == null) {
            return null;
        }
        ValueExpression valueExpression = variableMapper.resolveVariable(this.image);
        if (valueExpression == null) {
            return null;
        }
        return valueExpression.getValueReference((ELContext)evaluationContext);
    }

    private final MethodExpression getMethodExpression(EvaluationContext evaluationContext) throws ELException {
        Object object = null;
        VariableMapper variableMapper = evaluationContext.getVariableMapper();
        ValueExpression valueExpression = null;
        if (variableMapper != null && (valueExpression = variableMapper.resolveVariable(this.image)) != null) {
            object = valueExpression.getValue((ELContext)evaluationContext);
        }
        if (valueExpression == null) {
            evaluationContext.setPropertyResolved(false);
            object = evaluationContext.getELResolver().getValue((ELContext)evaluationContext, null, (Object)this.image);
        }
        if (object instanceof MethodExpression) {
            return (MethodExpression)object;
        }
        if (object == null) {
            throw new MethodNotFoundException("Identity '" + this.image + "' was null and was unable to invoke");
        }
        throw new ELException("Identity '" + this.image + "' does not reference a MethodExpression instance, returned type: " + object.getClass().getName());
    }
}

