/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.tomcat.dbcp.dbcp.AbandonedTrace;
import org.apache.tomcat.dbcp.dbcp.DelegatingCallableStatement;
import org.apache.tomcat.dbcp.dbcp.DelegatingConnection;
import org.apache.tomcat.dbcp.dbcp.DelegatingPreparedStatement;
import org.apache.tomcat.dbcp.dbcp.PStmtKey;
import org.apache.tomcat.dbcp.pool.KeyedObjectPool;

public class PoolableCallableStatement
extends DelegatingCallableStatement {
    private final KeyedObjectPool<PStmtKey, DelegatingPreparedStatement> _pool;
    private final PStmtKey _key;

    public PoolableCallableStatement(CallableStatement callableStatement, PStmtKey pStmtKey, KeyedObjectPool<PStmtKey, DelegatingPreparedStatement> keyedObjectPool, Connection connection) {
        super((DelegatingConnection)connection, callableStatement);
        this._pool = keyedObjectPool;
        this._key = pStmtKey;
        if (this._conn != null) {
            this._conn.removeTrace(this);
        }
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed()) {
            try {
                this._pool.returnObject(this._key, this);
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new SQLException("Cannot close CallableStatement (return to pool failed)", exception);
            }
        }
    }

    @Override
    public void activate() throws SQLException {
        this._closed = false;
        if (this._conn != null) {
            this._conn.addTrace(this);
        }
        super.activate();
    }

    @Override
    public void passivate() throws SQLException {
        List<AbandonedTrace> list;
        this._closed = true;
        if (this._conn != null) {
            this._conn.removeTrace(this);
        }
        if ((list = this.getTrace()) != null) {
            ResultSet[] resultSetArray = list.toArray(new ResultSet[list.size()]);
            for (int i = 0; i < resultSetArray.length; ++i) {
                resultSetArray[i].close();
            }
            this.clearTrace();
        }
        super.passivate();
    }
}

