/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.clsp;

import jadx.core.clsp.ClsSet;
import jadx.core.clsp.ClspClass;
import jadx.core.clsp.ClspMethod;
import jadx.core.clsp.SimpleMethodDetails;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.IMethodDetails;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.exceptions.DecodeException;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClspGraph {
    private static final Logger LOG = LoggerFactory.getLogger(ClspGraph.class);
    private final RootNode root;
    private final Map<String, Set<String>> superTypesCache = Collections.synchronizedMap(new WeakHashMap());
    private Map<String, ClspClass> nameMap;
    private final Set<String> missingClasses = new HashSet<String>();

    public ClspGraph(RootNode rootNode) {
        this.root = rootNode;
    }

    public void load() throws IOException, DecodeException {
        ClsSet set = new ClsSet(this.root);
        set.loadFromClstFile();
        this.addClasspath(set);
    }

    public void addClasspath(ClsSet set) {
        if (this.nameMap != null) {
            throw new JadxRuntimeException("Classpath already loaded");
        }
        this.nameMap = new HashMap<String, ClspClass>(set.getClassesCount());
        set.addToMap(this.nameMap);
    }

    public void addApp(List<ClassNode> classes) {
        if (this.nameMap == null) {
            throw new JadxRuntimeException("Classpath must be loaded first");
        }
        for (ClassNode cls : classes) {
            this.addClass(cls);
        }
    }

    public boolean isClsKnown(String fullName) {
        return this.nameMap.containsKey(fullName);
    }

    public ClspClass getClsDetails(ArgType type) {
        return this.nameMap.get(type.getObject());
    }

    @Nullable
    public IMethodDetails getMethodDetails(MethodInfo methodInfo) {
        ClspClass cls = this.nameMap.get(methodInfo.getDeclClass().getRawName());
        if (cls == null) {
            return null;
        }
        ClspMethod clspMethod = this.getMethodFromClass(cls, methodInfo);
        if (clspMethod != null) {
            return clspMethod;
        }
        for (ArgType parent : cls.getParents()) {
            ClspMethod methodFromParent;
            ClspClass clspParent = this.getClspClass(parent);
            if (clspParent == null || (methodFromParent = this.getMethodFromClass(clspParent, methodInfo)) == null) continue;
            return methodFromParent;
        }
        return new SimpleMethodDetails(methodInfo);
    }

    private ClspMethod getMethodFromClass(ClspClass cls, MethodInfo methodInfo) {
        return cls.getMethodsMap().get(methodInfo.getShortId());
    }

    private void addClass(ClassNode cls) {
        ArgType clsType = cls.getClassInfo().getType();
        String rawName = clsType.getObject();
        ClspClass clspClass = new ClspClass(clsType, -1);
        clspClass.setParents(ClsSet.makeParentsArray(cls));
        this.nameMap.put(rawName, clspClass);
    }

    public boolean isImplements(String clsName, String implClsName) {
        Set<String> anc = this.getSuperTypes(clsName);
        return anc.contains(implClsName);
    }

    public List<String> getImplementations(String clsName) {
        ArrayList<String> list = new ArrayList<String>();
        for (String cls : this.nameMap.keySet()) {
            if (!this.isImplements(cls, clsName)) continue;
            list.add(cls);
        }
        return list;
    }

    public String getCommonAncestor(String clsName, String implClsName) {
        if (clsName.equals(implClsName)) {
            return clsName;
        }
        ClspClass cls = this.nameMap.get(implClsName);
        if (cls == null) {
            this.missingClasses.add(clsName);
            return null;
        }
        if (this.isImplements(clsName, implClsName)) {
            return implClsName;
        }
        Set<String> anc = this.getSuperTypes(clsName);
        return this.searchCommonParent(anc, cls);
    }

    private String searchCommonParent(Set<String> anc, ClspClass cls) {
        for (ArgType p : cls.getParents()) {
            String r;
            String name = p.getObject();
            if (anc.contains(name)) {
                return name;
            }
            ClspClass nCls = this.getClspClass(p);
            if (nCls == null || (r = this.searchCommonParent(anc, nCls)) == null) continue;
            return r;
        }
        return null;
    }

    public Set<String> getSuperTypes(String clsName) {
        Set<String> fromCache = this.superTypesCache.get(clsName);
        if (fromCache != null) {
            return fromCache;
        }
        ClspClass cls = this.nameMap.get(clsName);
        if (cls == null) {
            this.missingClasses.add(clsName);
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        this.addSuperTypes(cls, result);
        return this.putInSuperTypesCache(clsName, result);
    }

    @NotNull
    private Set<String> putInSuperTypesCache(String clsName, Set<String> result) {
        if (result.isEmpty()) {
            Set<String> empty = Collections.emptySet();
            this.superTypesCache.put(clsName, result);
            return empty;
        }
        this.superTypesCache.put(clsName, result);
        return result;
    }

    private void addSuperTypes(ClspClass cls, Set<String> result) {
        for (ArgType parentType : cls.getParents()) {
            boolean isNew;
            ClspClass parentCls;
            if (parentType == null || (parentCls = this.getClspClass(parentType)) == null || !(isNew = result.add(parentCls.getName()))) continue;
            this.addSuperTypes(parentCls, result);
        }
    }

    @Nullable
    private ClspClass getClspClass(ArgType clsType) {
        ClspClass clspClass = this.nameMap.get(clsType.getObject());
        if (clspClass == null && LOG.isDebugEnabled()) {
            LOG.debug("External class not found: {}", (Object)clsType.getObject());
        }
        return clspClass;
    }

    public void printMissingClasses() {
        int count = this.missingClasses.size();
        if (count == 0) {
            return;
        }
        LOG.warn("Found {} references to unknown classes", (Object)count);
        if (LOG.isDebugEnabled()) {
            ArrayList<String> clsNames = new ArrayList<String>(this.missingClasses);
            Collections.sort(clsNames);
            for (String cls : clsNames) {
                LOG.debug("  {}", (Object)cls);
            }
        }
    }
}

