/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions;

import jadx.core.codegen.CodeWriter;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.SwitchData;
import jadx.core.dex.instructions.TargetInsnNode;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.InsnUtils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SwitchInsn
extends TargetInsnNode {
    private final int dataTarget;
    private final boolean packed;
    @Nullable
    private SwitchData switchData;
    private int def;
    private Object[] modifiedKeys;
    private BlockNode[] targetBlocks;
    private BlockNode defTargetBlock;

    public SwitchInsn(InsnArg arg, int dataTarget, boolean packed) {
        super(InsnType.SWITCH, 1);
        this.addArg(arg);
        this.dataTarget = dataTarget;
        this.packed = packed;
    }

    public void attachSwitchData(SwitchData data, int def) {
        this.switchData = data;
        this.def = def;
        int switchOffset = this.getOffset();
        int size = data.getSize();
        int[] targets = data.getTargets();
        int i = 0;
        while (i < size) {
            int n = i++;
            targets[n] = targets[n] + switchOffset;
        }
    }

    @Override
    public void initBlocks(BlockNode curBlock) {
        if (this.switchData == null) {
            throw new JadxRuntimeException("Switch data not yet attached");
        }
        List<BlockNode> successors = curBlock.getSuccessors();
        int[] targets = this.switchData.getTargets();
        int len = targets.length;
        this.targetBlocks = new BlockNode[len];
        for (int i = 0; i < len; ++i) {
            this.targetBlocks[i] = BlockUtils.getBlockByOffset(targets[i], successors);
        }
        this.defTargetBlock = BlockUtils.getBlockByOffset(this.def, successors);
    }

    @Override
    public boolean replaceTargetBlock(BlockNode origin, BlockNode replace) {
        if (this.targetBlocks == null) {
            return false;
        }
        int count = 0;
        int len = this.targetBlocks.length;
        for (int i = 0; i < len; ++i) {
            if (this.targetBlocks[i] != origin) continue;
            this.targetBlocks[i] = replace;
            ++count;
        }
        if (this.defTargetBlock == origin) {
            this.defTargetBlock = replace;
            ++count;
        }
        return count > 0;
    }

    @Override
    public boolean isSame(InsnNode obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SwitchInsn) || !super.isSame(obj)) {
            return false;
        }
        SwitchInsn other = (SwitchInsn)obj;
        return this.dataTarget == other.dataTarget && this.packed == other.packed;
    }

    @Override
    public InsnNode copy() {
        SwitchInsn copy = new SwitchInsn(this.getArg(0), this.dataTarget, this.packed);
        copy.switchData = this.switchData;
        copy.def = this.def;
        copy.targetBlocks = this.targetBlocks;
        copy.defTargetBlock = this.defTargetBlock;
        return this.copyCommonParams(copy);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        if (this.switchData == null) {
            sb.append("no payload");
        } else {
            int size = this.switchData.getSize();
            int[] keys = this.switchData.getKeys();
            if (this.targetBlocks != null) {
                for (int i = 0; i < size; ++i) {
                    sb.append(CodeWriter.NL);
                    sb.append(" case ").append(keys[i]).append(": goto ").append(this.targetBlocks[i]);
                }
                if (this.def != -1) {
                    sb.append(CodeWriter.NL).append(" default: goto ").append(this.defTargetBlock);
                }
            } else {
                int[] targets = this.switchData.getTargets();
                for (int i = 0; i < size; ++i) {
                    sb.append(CodeWriter.NL);
                    sb.append(" case ").append(keys[i]).append(": goto ").append(InsnUtils.formatOffset(targets[i]));
                }
                if (this.def != -1) {
                    sb.append(CodeWriter.NL);
                    sb.append(" default: goto ").append(InsnUtils.formatOffset(this.def));
                }
            }
        }
        return sb.toString();
    }

    public int getDataTarget() {
        return this.dataTarget;
    }

    public boolean isPacked() {
        return this.packed;
    }

    public int getDefaultCaseOffset() {
        return this.def;
    }

    @NotNull
    private SwitchData getSwitchData() {
        if (this.switchData == null) {
            throw new JadxRuntimeException("Switch data not yet attached");
        }
        return this.switchData;
    }

    public int[] getTargets() {
        return this.getSwitchData().getTargets();
    }

    public int[] getKeys() {
        return this.getSwitchData().getKeys();
    }

    public Object getKey(int i) {
        if (this.modifiedKeys != null) {
            return this.modifiedKeys[i];
        }
        return this.getSwitchData().getKeys()[i];
    }

    public void modifyKey(int i, Object newKey) {
        if (this.modifiedKeys == null) {
            int[] keys = this.getKeys();
            int caseCount = keys.length;
            Object[] newKeys = new Object[caseCount];
            for (int j = 0; j < caseCount; ++j) {
                newKeys[j] = keys[j];
            }
            this.modifiedKeys = newKeys;
        }
        this.modifiedKeys[i] = newKey;
    }

    public BlockNode[] getTargetBlocks() {
        return this.targetBlocks;
    }

    public BlockNode getDefTargetBlock() {
        return this.defTargetBlock;
    }
}

