/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.nodes;

import jadx.api.ICodeCache;
import jadx.api.ICodeInfo;
import jadx.api.plugins.input.data.IClassData;
import jadx.api.plugins.input.data.annotations.EncodedValue;
import jadx.api.plugins.input.data.annotations.IAnnotation;
import jadx.core.ProcessClass;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AttrNode;
import jadx.core.dex.attributes.FieldInitAttr;
import jadx.core.dex.attributes.annotations.AnnotationsList;
import jadx.core.dex.attributes.nodes.NotificationAttrNode;
import jadx.core.dex.attributes.nodes.SourceFileAttr;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.LiteralArg;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.ICodeNode;
import jadx.core.dex.nodes.ILoadable;
import jadx.core.dex.nodes.LoadStage;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.ProcessState;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.visitors.ProcessAnonymous;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassNode
extends NotificationAttrNode
implements ILoadable,
ICodeNode,
Comparable<ClassNode> {
    private static final Logger LOG = LoggerFactory.getLogger(ClassNode.class);
    private final RootNode root;
    private final IClassData clsData;
    private final ClassInfo clsInfo;
    private AccessInfo accessFlags;
    private ArgType superClass;
    private List<ArgType> interfaces;
    private List<ArgType> generics = Collections.emptyList();
    private List<MethodNode> methods;
    private List<FieldNode> fields;
    private List<ClassNode> innerClasses = Collections.emptyList();
    private List<ClassNode> inlinedClasses = Collections.emptyList();
    private String smali;
    private ClassNode parentClass;
    private volatile ProcessState state = ProcessState.NOT_LOADED;
    private LoadStage loadStage = LoadStage.NONE;
    private List<ClassNode> dependencies = Collections.emptyList();
    private List<ClassNode> useIn = Collections.emptyList();
    private List<MethodNode> useInMth = Collections.emptyList();
    private Map<MethodInfo, MethodNode> mthInfoMap = Collections.emptyMap();

    public ClassNode(RootNode root, IClassData cls) {
        this.root = root;
        this.clsInfo = ClassInfo.fromType(root, ArgType.object(cls.getType()));
        this.clsData = cls.copy();
        this.initialLoad(this.clsData);
    }

    private void initialLoad(IClassData cls) {
        try {
            String superType = cls.getSuperType();
            if (superType == null) {
                if (!this.clsInfo.getType().getObject().equals("java.lang.Object")) {
                    throw new JadxRuntimeException("No super class in " + this.clsInfo.getType());
                }
                this.superClass = null;
            } else {
                this.superClass = ArgType.object(superType);
            }
            this.interfaces = Utils.collectionMap(cls.getInterfacesTypes(), ArgType::object);
            this.methods = new ArrayList<MethodNode>();
            this.fields = new ArrayList<FieldNode>();
            cls.visitFieldsAndMethods(fld -> this.fields.add(FieldNode.build(this, fld)), mth -> this.methods.add(MethodNode.build(this, mth)));
            AnnotationsList.attach(this, cls.getAnnotations());
            this.loadStaticValues(cls, this.fields);
            this.initAccessFlags(cls);
            this.addSourceFilenameAttr(cls.getSourceFile());
            this.buildCache();
        }
        catch (Exception e) {
            throw new JadxRuntimeException("Error decode class: " + this.clsInfo, e);
        }
    }

    public void updateGenericClsData(ArgType superClass, List<ArgType> interfaces, List<ArgType> generics) {
        this.superClass = superClass;
        this.interfaces = interfaces;
        this.generics = generics;
    }

    private void initAccessFlags(IClassData cls) {
        IAnnotation a = this.getAnnotation("Ldalvik/annotation/InnerClass;");
        int accFlagsValue = a != null ? ((Integer)((EncodedValue)a.getValues().get("accessFlags")).getValue()).intValue() : cls.getAccessFlags();
        this.accessFlags = new AccessInfo(accFlagsValue, AccessInfo.AFType.CLASS);
    }

    public static ClassNode addSyntheticClass(RootNode root, String name, int accessFlags) {
        ClassNode cls = new ClassNode(root, name, accessFlags);
        cls.add(AFlag.SYNTHETIC);
        cls.setState(ProcessState.PROCESS_COMPLETE);
        root.addClassNode(cls);
        return cls;
    }

    private ClassNode(RootNode root, String name, int accessFlags) {
        this.root = root;
        this.clsData = null;
        this.clsInfo = ClassInfo.fromName(root, name);
        this.interfaces = new ArrayList<ArgType>();
        this.methods = new ArrayList<MethodNode>();
        this.fields = new ArrayList<FieldNode>();
        this.accessFlags = new AccessInfo(accessFlags, AccessInfo.AFType.CLASS);
        this.parentClass = this;
    }

    private void loadStaticValues(IClassData cls, List<FieldNode> fields) {
        if (fields.isEmpty()) {
            return;
        }
        List<FieldNode> staticFields = fields.stream().filter(FieldNode::isStatic).collect(Collectors.toList());
        for (FieldNode f : staticFields) {
            if (!f.getAccessFlags().isFinal()) continue;
            f.addAttr(FieldInitAttr.NULL_VALUE);
        }
        List values = cls.getStaticFieldInitValues();
        int count = values.size();
        if (count == 0 || count > staticFields.size()) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            ((FieldNode)staticFields.get(i)).addAttr(FieldInitAttr.constValue((EncodedValue)values.get(i)));
        }
        this.root().getConstValues().processConstFields(this, staticFields);
    }

    private void addSourceFilenameAttr(String fileName) {
        if (fileName == null) {
            return;
        }
        if (fileName.endsWith(".java")) {
            fileName = fileName.substring(0, fileName.length() - 5);
        }
        if (fileName.isEmpty() || fileName.equals("SourceFile") || fileName.equals("\"")) {
            return;
        }
        if (this.clsInfo != null) {
            String name = this.clsInfo.getShortName();
            if (fileName.equals(name)) {
                return;
            }
            if (fileName.contains("$") && fileName.endsWith('$' + name)) {
                return;
            }
            ClassInfo parentCls = this.clsInfo.getTopParentClass();
            if (parentCls != null && fileName.equals(parentCls.getShortName())) {
                return;
            }
        }
        this.addAttr(new SourceFileAttr(fileName));
    }

    public void ensureProcessed() {
        ClassNode topClass = this.getTopParentClass();
        ProcessState state = topClass.getState();
        if (state != ProcessState.PROCESS_COMPLETE) {
            throw new JadxRuntimeException("Expected class to be processed at this point, class: " + topClass + ", state: " + (Object)((Object)state));
        }
    }

    public ICodeInfo decompile() {
        return this.decompile(true);
    }

    public ICodeInfo getCode() {
        return this.decompile(true);
    }

    public ICodeInfo reloadCode() {
        this.add(AFlag.CLASS_DEEP_RELOAD);
        return this.decompile(false);
    }

    public void deepUnload() {
        if (this.clsData == null) {
            return;
        }
        this.clearAttributes();
        this.root().getConstValues().removeForClass(this);
        this.initialLoad(this.clsData);
        ProcessAnonymous.runForClass(this);
        for (ClassNode innerClass : this.innerClasses) {
            innerClass.deepUnload();
        }
    }

    private synchronized ICodeInfo decompile(boolean searchInCache) {
        ICodeInfo code;
        ICodeCache codeCache = this.root().getCodeCache();
        ClassNode topParentClass = this.getTopParentClass();
        String clsRawName = topParentClass.getRawName();
        if (searchInCache && (code = codeCache.get(clsRawName)) != null && code != ICodeInfo.EMPTY) {
            return code;
        }
        ICodeInfo codeInfo = ProcessClass.generateCode(topParentClass);
        codeCache.add(clsRawName, codeInfo);
        return codeInfo;
    }

    @Override
    public void load() {
        for (MethodNode mth : this.getMethods()) {
            try {
                mth.load();
            }
            catch (Exception e) {
                mth.addError("Method load error", e);
            }
        }
        for (ClassNode innerCls : this.getInnerClasses()) {
            innerCls.load();
        }
        this.setState(ProcessState.LOADED);
    }

    @Override
    public void unload() {
        if (this.state == ProcessState.NOT_LOADED) {
            return;
        }
        this.methods.forEach(MethodNode::unload);
        this.innerClasses.forEach(ClassNode::unload);
        this.fields.forEach(AttrNode::unloadAttributes);
        this.unloadAttributes();
        this.setState(ProcessState.NOT_LOADED);
        this.loadStage = LoadStage.NONE;
        this.smali = null;
    }

    private void buildCache() {
        this.mthInfoMap = new HashMap<MethodInfo, MethodNode>(this.methods.size());
        for (MethodNode mth : this.methods) {
            this.mthInfoMap.put(mth.getMethodInfo(), mth);
        }
    }

    @Nullable
    public ArgType getSuperClass() {
        return this.superClass;
    }

    public List<ArgType> getInterfaces() {
        return this.interfaces;
    }

    public List<ArgType> getGenericTypeParameters() {
        return this.generics;
    }

    public ArgType getType() {
        ArgType clsType = this.clsInfo.getType();
        if (Utils.notEmpty(this.generics)) {
            return ArgType.generic(clsType, this.generics);
        }
        return clsType;
    }

    public List<MethodNode> getMethods() {
        return this.methods;
    }

    public List<FieldNode> getFields() {
        return this.fields;
    }

    public FieldNode getConstField(Object obj) {
        return this.getConstField(obj, true);
    }

    @Nullable
    public FieldNode getConstField(Object obj, boolean searchGlobal) {
        return this.root().getConstValues().getConstField(this, obj, searchGlobal);
    }

    @Nullable
    public FieldNode getConstFieldByLiteralArg(LiteralArg arg) {
        return this.root().getConstValues().getConstFieldByLiteralArg(this, arg);
    }

    public FieldNode searchField(FieldInfo field) {
        for (FieldNode f : this.fields) {
            if (!f.getFieldInfo().equals(field)) continue;
            return f;
        }
        return null;
    }

    public FieldNode searchFieldByNameAndType(FieldInfo field) {
        for (FieldNode f : this.fields) {
            if (!f.getFieldInfo().equalsNameAndType(field)) continue;
            return f;
        }
        return null;
    }

    public FieldNode searchFieldByName(String name) {
        for (FieldNode f : this.fields) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    public MethodNode searchMethod(MethodInfo mth) {
        return this.mthInfoMap.get(mth);
    }

    public MethodNode searchMethodByShortId(String shortId) {
        for (MethodNode m : this.methods) {
            if (!m.getMethodInfo().getShortId().equals(shortId)) continue;
            return m;
        }
        return null;
    }

    @Nullable
    public MethodNode searchMethodByShortName(String name) {
        for (MethodNode m : this.methods) {
            if (!m.getMethodInfo().getName().equals(name)) continue;
            return m;
        }
        return null;
    }

    public ClassNode getParentClass() {
        if (this.parentClass == null) {
            ClassNode parent;
            this.parentClass = this.clsInfo.isInner() ? ((parent = this.root.resolveClass(this.clsInfo.getParentClass())) == null ? this : parent) : this;
        }
        return this.parentClass;
    }

    public ClassNode getTopParentClass() {
        ClassNode parent = this.getParentClass();
        return parent == this ? this : parent.getTopParentClass();
    }

    public void visitParentClasses(Consumer<ClassNode> consumer) {
        ClassNode currentCls = this;
        ClassNode parentCls = currentCls.getParentClass();
        while (parentCls != currentCls) {
            consumer.accept(parentCls);
            currentCls = parentCls;
            parentCls = currentCls.getParentClass();
        }
    }

    public boolean hasNotGeneratedParent() {
        if (this.contains(AFlag.DONT_GENERATE)) {
            return true;
        }
        ClassNode parent = this.getParentClass();
        if (parent == this) {
            return false;
        }
        return parent.hasNotGeneratedParent();
    }

    public List<ClassNode> getInnerClasses() {
        return this.innerClasses;
    }

    public void getInnerAndInlinedClassesRecursive(Set<ClassNode> resultClassesSet) {
        for (ClassNode innerCls : this.innerClasses) {
            if (!resultClassesSet.add(innerCls)) continue;
            innerCls.getInnerAndInlinedClassesRecursive(resultClassesSet);
        }
        for (ClassNode inlinedCls : this.inlinedClasses) {
            if (!resultClassesSet.add(inlinedCls)) continue;
            inlinedCls.getInnerAndInlinedClassesRecursive(resultClassesSet);
        }
    }

    public void addInnerClass(ClassNode cls) {
        if (this.innerClasses.isEmpty()) {
            this.innerClasses = new ArrayList<ClassNode>(5);
        }
        this.innerClasses.add(cls);
        cls.parentClass = this;
    }

    public void addInlinedClass(ClassNode cls) {
        if (this.inlinedClasses.isEmpty()) {
            this.inlinedClasses = new ArrayList<ClassNode>(5);
        }
        this.inlinedClasses.add(cls);
    }

    public boolean isEnum() {
        return this.getAccessFlags().isEnum() && this.getSuperClass() != null && this.getSuperClass().getObject().equals(ArgType.ENUM.getObject());
    }

    public boolean isAnonymous() {
        return this.contains(AFlag.ANONYMOUS_CLASS);
    }

    public boolean isInner() {
        return this.parentClass != null;
    }

    @Nullable
    public MethodNode getClassInitMth() {
        return this.searchMethodByShortId("<clinit>()V");
    }

    @Nullable
    public MethodNode getDefaultConstructor() {
        for (MethodNode mth : this.methods) {
            if (!mth.isDefaultConstructor()) continue;
            return mth;
        }
        return null;
    }

    @Override
    public AccessInfo getAccessFlags() {
        return this.accessFlags;
    }

    @Override
    public void setAccessFlags(AccessInfo accessFlags) {
        this.accessFlags = accessFlags;
    }

    @Override
    public RootNode root() {
        return this.root;
    }

    @Override
    public String typeName() {
        return "class";
    }

    public String getRawName() {
        return this.clsInfo.getRawName();
    }

    public ClassInfo getClassInfo() {
        return this.clsInfo;
    }

    public String getShortName() {
        return this.clsInfo.getAliasShortName();
    }

    public String getFullName() {
        return this.clsInfo.getAliasFullName();
    }

    public String getPackage() {
        return this.clsInfo.getAliasPkg();
    }

    public String getSmali() {
        if (this.smali == null) {
            StringBuilder sb = new StringBuilder();
            this.getSmali(sb);
            sb.append(System.lineSeparator());
            LinkedHashSet<ClassNode> allInlinedClasses = new LinkedHashSet<ClassNode>();
            this.getInnerAndInlinedClassesRecursive(allInlinedClasses);
            for (ClassNode innerClass : allInlinedClasses) {
                innerClass.getSmali(sb);
                sb.append(System.lineSeparator());
            }
            this.smali = sb.toString();
        }
        return this.smali;
    }

    protected void getSmali(StringBuilder sb) {
        if (this.clsData == null) {
            sb.append(String.format("###### Class %s is created by jadx", this.getFullName()));
            return;
        }
        sb.append(String.format("###### Class %s (%s)", this.getFullName(), this.getRawName()));
        sb.append(System.lineSeparator());
        sb.append(this.clsData.getDisassembledCode());
    }

    public ProcessState getState() {
        return this.state;
    }

    public void setState(ProcessState state) {
        this.state = state;
    }

    public LoadStage getLoadStage() {
        return this.loadStage;
    }

    public void setLoadStage(LoadStage loadStage) {
        this.loadStage = loadStage;
    }

    public void reloadAtCodegenStage() {
        ClassNode topCls = this.getTopParentClass();
        if (topCls.getLoadStage() == LoadStage.CODEGEN_STAGE) {
            throw new JadxRuntimeException("Class not yet loaded at codegen stage: " + topCls);
        }
        topCls.add(AFlag.RELOAD_AT_CODEGEN_STAGE);
    }

    public List<ClassNode> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<ClassNode> dependencies) {
        this.dependencies = dependencies;
    }

    public List<ClassNode> getUseIn() {
        return this.useIn;
    }

    public void setUseIn(List<ClassNode> useIn) {
        this.useIn = useIn;
    }

    public List<MethodNode> getUseInMth() {
        return this.useInMth;
    }

    public void setUseInMth(List<MethodNode> useInMth) {
        this.useInMth = useInMth;
    }

    @Override
    public String getInputFileName() {
        return this.clsData == null ? "synthetic" : this.clsData.getInputFileName();
    }

    public int hashCode() {
        return this.clsInfo.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ClassNode) {
            ClassNode other = (ClassNode)o;
            return this.clsInfo.equals(other.clsInfo);
        }
        return false;
    }

    @Override
    public int compareTo(@NotNull ClassNode o) {
        return this.getFullName().compareTo(o.getFullName());
    }

    public String toString() {
        return this.clsInfo.getFullName();
    }
}

