/*
 * Decompiled with CFR 0.152.
 */
package jadx.api.plugins;

import jadx.api.plugins.JadxPlugin;
import jadx.api.plugins.input.JadxInputPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JadxPluginManager {
    private static final Logger LOG = LoggerFactory.getLogger(JadxPluginManager.class);
    private final Map<Class<? extends JadxPlugin>, JadxPlugin> allPlugins = new HashMap<Class<? extends JadxPlugin>, JadxPlugin>();

    public JadxPluginManager() {
        ServiceLoader<JadxPlugin> jadxPlugins = ServiceLoader.load(JadxPlugin.class);
        for (JadxPlugin jadxPlugin : jadxPlugins) {
            this.register(jadxPlugin);
        }
    }

    public void register(JadxPlugin plugin) {
        Objects.requireNonNull(plugin);
        LOG.debug("Loaded plugin: {}", (Object)plugin.getPluginInfo().getName());
        this.allPlugins.put(plugin.getClass(), plugin);
    }

    public List<JadxPlugin> getAllPlugins() {
        return new ArrayList<JadxPlugin>(this.allPlugins.values());
    }

    public List<JadxInputPlugin> getInputPlugins() {
        return this.allPlugins.values().stream().filter(JadxInputPlugin.class::isInstance).map(JadxInputPlugin.class::cast).collect(Collectors.toList());
    }
}

