/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.dex.sections;

import jadx.api.plugins.input.data.ICodeReader;
import jadx.api.plugins.input.data.IMethodData;
import jadx.api.plugins.input.data.annotations.IAnnotation;
import jadx.plugins.input.dex.sections.DexCodeReader;
import jadx.plugins.input.dex.sections.DexMethodRef;
import jadx.plugins.input.dex.sections.annotations.AnnotationsParser;
import jadx.plugins.input.dex.smali.SmaliPrinter;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class DexMethodData
implements IMethodData {
    @Nullable
    private final AnnotationsParser annotationsParser;
    private DexMethodRef methodRef;
    private int accessFlags;
    private boolean isDirect;
    private int annotationsOffset;
    private int paramAnnotationsOffset;
    @Nullable
    private DexCodeReader codeReader;

    public DexMethodData(@Nullable AnnotationsParser annotationsParser) {
        this.annotationsParser = annotationsParser;
    }

    public DexMethodRef getMethodRef() {
        return this.methodRef;
    }

    public void setMethodRef(DexMethodRef methodRef) {
        this.methodRef = methodRef;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public void setAccessFlags(int accessFlags) {
        this.accessFlags = accessFlags;
    }

    public boolean isDirect() {
        return this.isDirect;
    }

    public void setDirect(boolean direct) {
        this.isDirect = direct;
    }

    @Nullable
    public ICodeReader getCodeReader() {
        return this.codeReader;
    }

    public void setCodeReader(@Nullable DexCodeReader codeReader) {
        this.codeReader = codeReader;
    }

    public String disassembleMethod() {
        return SmaliPrinter.printMethod(this);
    }

    public void setAnnotationsOffset(int annotationsOffset) {
        this.annotationsOffset = annotationsOffset;
    }

    public void setParamAnnotationsOffset(int paramAnnotationsOffset) {
        this.paramAnnotationsOffset = paramAnnotationsOffset;
    }

    public List<IAnnotation> getAnnotations() {
        return this.getAnnotationsParser().readAnnotationList(this.annotationsOffset);
    }

    public List<List<IAnnotation>> getParamsAnnotations() {
        return this.getAnnotationsParser().readAnnotationRefList(this.paramAnnotationsOffset);
    }

    private AnnotationsParser getAnnotationsParser() {
        if (this.annotationsParser == null) {
            throw new NullPointerException("Annotation parser not initialized");
        }
        return this.annotationsParser;
    }

    public String toString() {
        return this.getMethodRef().toString();
    }
}

