/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui;

import io.reactivex.internal.functions.Functions;
import jadx.api.JadxArgs;
import jadx.api.JavaClass;
import jadx.api.JavaNode;
import jadx.api.ResourceFile;
import jadx.core.utils.Utils;
import jadx.core.utils.files.FileUtils;
import jadx.gui.JadxWrapper;
import jadx.gui.jobs.BackgroundExecutor;
import jadx.gui.jobs.BackgroundWorker;
import jadx.gui.jobs.DecompileJob;
import jadx.gui.jobs.IndexJob;
import jadx.gui.settings.JadxProject;
import jadx.gui.settings.JadxSettings;
import jadx.gui.settings.JadxSettingsWindow;
import jadx.gui.treemodel.ApkSignature;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JField;
import jadx.gui.treemodel.JLoadableNode;
import jadx.gui.treemodel.JMethod;
import jadx.gui.treemodel.JNode;
import jadx.gui.treemodel.JPackage;
import jadx.gui.treemodel.JResource;
import jadx.gui.treemodel.JRoot;
import jadx.gui.ui.AboutDialog;
import jadx.gui.ui.ContentPanel;
import jadx.gui.ui.HeapUsageBar;
import jadx.gui.ui.JPackagePopupMenu;
import jadx.gui.ui.LogViewer;
import jadx.gui.ui.MainDropTarget;
import jadx.gui.ui.ProgressPanel;
import jadx.gui.ui.RenameDialog;
import jadx.gui.ui.SearchDialog;
import jadx.gui.ui.TabbedPane;
import jadx.gui.update.JadxUpdate;
import jadx.gui.update.data.Release;
import jadx.gui.utils.CacheObject;
import jadx.gui.utils.FontUtils;
import jadx.gui.utils.JumpPosition;
import jadx.gui.utils.Link;
import jadx.gui.utils.NLS;
import jadx.gui.utils.SystemInfo;
import jadx.gui.utils.UiUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainWindow
extends JFrame {
    private static final Logger LOG = LoggerFactory.getLogger(MainWindow.class);
    private static final String DEFAULT_TITLE = "jadx-gui";
    private static final double BORDER_RATIO = 0.15;
    private static final double WINDOW_RATIO = 0.7;
    private static final double SPLIT_PANE_RESIZE_WEIGHT = 0.15;
    private static final ImageIcon ICON_OPEN = UiUtils.openIcon("folder");
    private static final ImageIcon ICON_ADD_FILES = UiUtils.openIcon("folder_add");
    private static final ImageIcon ICON_SAVE_ALL = UiUtils.openIcon("disk_multiple");
    private static final ImageIcon ICON_EXPORT = UiUtils.openIcon("database_save");
    private static final ImageIcon ICON_CLOSE = UiUtils.openIcon("cross");
    private static final ImageIcon ICON_SYNC = UiUtils.openIcon("sync");
    private static final ImageIcon ICON_FLAT_PKG = UiUtils.openIcon("empty_logical_package_obj");
    private static final ImageIcon ICON_SEARCH = UiUtils.openIcon("wand");
    private static final ImageIcon ICON_FIND = UiUtils.openIcon("magnifier");
    private static final ImageIcon ICON_BACK = UiUtils.openIcon("icon_back");
    private static final ImageIcon ICON_FORWARD = UiUtils.openIcon("icon_forward");
    private static final ImageIcon ICON_PREF = UiUtils.openIcon("wrench");
    private static final ImageIcon ICON_DEOBF = UiUtils.openIcon("lock_edit");
    private static final ImageIcon ICON_LOG = UiUtils.openIcon("report");
    private static final ImageIcon ICON_JADX = UiUtils.openIcon("jadx-logo");
    private final transient JadxWrapper wrapper;
    private final transient JadxSettings settings;
    private final transient CacheObject cacheObject;
    private transient JadxProject project;
    private transient Action newProjectAction;
    private transient Action saveProjectAction;
    private JPanel mainPanel;
    private JSplitPane splitPane;
    private JTree tree;
    private DefaultTreeModel treeModel;
    private JRoot treeRoot;
    private TabbedPane tabbedPane;
    private HeapUsageBar heapUsageBar;
    private transient boolean treeReloading;
    private boolean isFlattenPackage;
    private JToggleButton flatPkgButton;
    private JCheckBoxMenuItem flatPkgMenuItem;
    private JToggleButton deobfToggleBtn;
    private JCheckBoxMenuItem deobfMenuItem;
    private transient Link updateLink;
    private transient ProgressPanel progressPane;
    private transient BackgroundWorker backgroundWorker;
    private transient BackgroundExecutor backgroundExecutor;
    private transient Theme editorTheme;

    public MainWindow(JadxSettings settings) {
        this.wrapper = new JadxWrapper(settings);
        this.settings = settings;
        this.cacheObject = new CacheObject();
        this.resetCache();
        FontUtils.registerBundledFonts();
        this.initUI();
        this.initMenuAndToolbar();
        this.registerMouseNavigationButtons();
        UiUtils.setWindowIcons(this);
        this.loadSettings();
        this.checkForUpdate();
        this.newProject();
        this.backgroundExecutor = new BackgroundExecutor(this);
    }

    public void init() {
        this.pack();
        this.setLocationAndPosition();
        this.splitPane.setDividerLocation(this.settings.getTreeWidth());
        this.heapUsageBar.setVisible(this.settings.isShowHeapUsageBar());
        this.setVisible(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainWindow.this.closeWindow();
            }
        });
        this.processCommandLineArgs();
    }

    private void processCommandLineArgs() {
        if (this.settings.getFiles().isEmpty()) {
            this.openFileOrProject();
        } else {
            this.open(jadx.gui.utils.FileUtils.fileNamesToPaths(this.settings.getFiles()), this::handleSelectClassOption);
        }
    }

    private void handleSelectClassOption() {
        if (this.settings.getCmdSelectClass() != null) {
            JavaClass javaNode = this.wrapper.searchJavaClassByClassName(this.settings.getCmdSelectClass());
            if (javaNode == null) {
                javaNode = this.wrapper.searchJavaClassByOrigClassName(this.settings.getCmdSelectClass());
            }
            if (javaNode == null) {
                JOptionPane.showMessageDialog(this, NLS.str("msg.cmd_select_class_error", this.settings.getCmdSelectClass()), NLS.str("error_dialog.title"), 0);
                return;
            }
            JNode node = this.cacheObject.getNodeCache().makeFrom(javaNode);
            this.tabbedPane.codeJump(new JumpPosition(node.getRootClass(), node.getLine()));
        }
    }

    private void checkForUpdate() {
        if (!this.settings.isCheckForUpdates()) {
            return;
        }
        JadxUpdate.check(new JadxUpdate.IUpdateCallback(){

            @Override
            public void onUpdate(Release r) {
                SwingUtilities.invokeLater(() -> {
                    MainWindow.this.updateLink.setText(NLS.str("menu.update_label", r.getName()));
                    MainWindow.this.updateLink.setVisible(true);
                });
            }
        });
    }

    public void openFileOrProject() {
        String title = NLS.str("file.open_title");
        JFileChooser fileChooser = this.buildFileChooser(false, title);
        int ret = fileChooser.showDialog(this, title);
        if (ret == 0) {
            this.settings.setLastOpenFilePath(fileChooser.getCurrentDirectory().toPath());
            this.open(jadx.gui.utils.FileUtils.toPaths(fileChooser.getSelectedFiles()));
        }
    }

    public void addFiles() {
        String title = NLS.str("file.add_files_action");
        JFileChooser fileChooser = this.buildFileChooser(true, title);
        int ret = fileChooser.showDialog(this, title);
        if (ret == 0) {
            ArrayList<Path> paths = new ArrayList<Path>(this.wrapper.getOpenPaths());
            paths.addAll(jadx.gui.utils.FileUtils.toPaths(fileChooser.getSelectedFiles()));
            this.open(paths);
        }
    }

    private JFileChooser buildFileChooser(boolean addFiles, String toolTipText) {
        String[] exts = addFiles ? new String[]{"apk", "dex", "jar", "class", "smali", "zip", "aar", "arsc"} : new String[]{"jadx", "apk", "dex", "jar", "class", "smali", "zip", "aar", "arsc"};
        String description = "Supported files: (" + Utils.arrayToStr(exts) + ')';
        JFileChooser fileChooser = new JFileChooser(){

            @Override
            protected JDialog createDialog(Component parent) throws HeadlessException {
                final JDialog dialog = super.createDialog(parent);
                dialog.setLocationRelativeTo(null);
                MainWindow.this.settings.loadWindowPos(dialog);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent e) {
                        MainWindow.this.settings.saveWindowPos(dialog);
                        super.windowClosed(e);
                    }
                });
                return dialog;
            }
        };
        fileChooser.setAcceptAllFileFilterUsed(true);
        fileChooser.setFileFilter(new FileNameExtensionFilter(description, exts));
        fileChooser.setMultiSelectionEnabled(true);
        fileChooser.setToolTipText(toolTipText);
        Path currentDirectory = this.settings.getLastOpenFilePath();
        if (currentDirectory != null) {
            fileChooser.setCurrentDirectory(currentDirectory.toFile());
        }
        return fileChooser;
    }

    private void newProject() {
        if (!this.ensureProjectIsSaved()) {
            return;
        }
        this.project = new JadxProject(this.settings);
        this.update();
        this.clearTree();
    }

    private void saveProject() {
        if (this.project.getProjectPath() == null) {
            this.saveProjectAs();
        } else {
            this.project.save();
            this.update();
        }
    }

    private void saveProjectAs() {
        int ret;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setAcceptAllFileFilterUsed(true);
        Object[] exts = new String[]{"jadx"};
        String description = "supported files: " + Arrays.toString(exts).replace('[', '(').replace(']', ')');
        fileChooser.setFileFilter(new FileNameExtensionFilter(description, (String[])exts));
        fileChooser.setToolTipText(NLS.str("file.save_project"));
        Path currentDirectory = this.settings.getLastSaveProjectPath();
        if (currentDirectory != null) {
            fileChooser.setCurrentDirectory(currentDirectory.toFile());
        }
        if ((ret = fileChooser.showSaveDialog(this.mainPanel)) == 0) {
            int res;
            this.settings.setLastSaveProjectPath(fileChooser.getCurrentDirectory().toPath());
            Path path = fileChooser.getSelectedFile().toPath();
            if (!path.getFileName().toString().toLowerCase(Locale.ROOT).endsWith("jadx")) {
                path = path.resolveSibling(path.getFileName() + "." + "jadx");
            }
            if (Files.exists(path, new LinkOption[0]) && (res = JOptionPane.showConfirmDialog(this, NLS.str("confirm.save_as_message", path.getFileName()), NLS.str("confirm.save_as_title"), 0)) == 1) {
                return;
            }
            this.project.saveAs(path);
            this.update();
        }
    }

    void open(List<Path> paths) {
        this.open(paths, Functions.EMPTY_RUNNABLE);
    }

    void open(List<Path> paths, Runnable onFinish) {
        if (paths.size() == 1 && paths.get(0).getFileName().toString().toLowerCase(Locale.ROOT).endsWith("jadx")) {
            this.openProject(paths.get(0));
            onFinish.run();
        } else {
            this.project.setFilePath(paths);
            this.clearTree();
            if (paths.isEmpty()) {
                return;
            }
            this.backgroundExecutor.execute(NLS.str("progress.load"), () -> this.wrapper.openFile(paths), () -> {
                this.deobfToggleBtn.setSelected(this.settings.isDeobfuscationOn());
                this.initTree();
                this.update();
                this.runBackgroundJobs();
                onFinish.run();
            });
        }
    }

    private boolean ensureProjectIsSaved() {
        if (this.project != null && !this.project.isSaved() && !this.project.isInitial()) {
            int res = JOptionPane.showConfirmDialog(this, NLS.str("confirm.not_saved_message"), NLS.str("confirm.not_saved_title"), 1);
            if (res == 2) {
                return false;
            }
            if (res == 0) {
                this.project.save();
            }
        }
        return true;
    }

    private void openProject(Path path) {
        if (!this.ensureProjectIsSaved()) {
            return;
        }
        this.project = JadxProject.from(path, this.settings);
        if (this.project == null) {
            JOptionPane.showMessageDialog(this, NLS.str("msg.project_error"), NLS.str("msg.project_error_title"), 1);
            return;
        }
        this.update();
        this.settings.addRecentProject(path);
        List<Path> filePaths = this.project.getFilePaths();
        if (filePaths == null) {
            this.clearTree();
        } else {
            this.open(filePaths);
        }
    }

    private void update() {
        this.newProjectAction.setEnabled(!this.project.isInitial());
        this.saveProjectAction.setEnabled(!this.project.isSaved());
        Path projectPath = this.project.getProjectPath();
        String pathString = projectPath == null ? "" : " [" + projectPath.getParent().toAbsolutePath() + ']';
        this.setTitle((this.project.isSaved() ? "" : Character.valueOf('*')) + this.project.getName() + pathString + " - " + DEFAULT_TITLE);
    }

    protected void resetCache() {
        this.cacheObject.reset();
        int threadsCount = this.settings.getThreadsCount();
        this.cacheObject.setDecompileJob(new DecompileJob(this.wrapper, threadsCount));
        this.cacheObject.setIndexJob(new IndexJob(this.wrapper, this.cacheObject, threadsCount));
    }

    public void resetIndex() {
        int threadsCount = this.settings.getThreadsCount();
        this.cacheObject.setIndexJob(new IndexJob(this.wrapper, this.cacheObject, threadsCount));
    }

    synchronized void runBackgroundJobs() {
        this.cancelBackgroundJobs();
        this.backgroundWorker = new BackgroundWorker(this.cacheObject, this.progressPane);
        if (this.settings.isAutoStartJobs()) {
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    MainWindow.this.backgroundWorker.exec();
                }
            }, 1000L);
        }
    }

    public synchronized void cancelBackgroundJobs() {
        this.backgroundExecutor.cancelAll();
        if (this.backgroundWorker != null) {
            this.backgroundWorker.stop();
            this.backgroundWorker = new BackgroundWorker(this.cacheObject, this.progressPane);
            this.resetCache();
        }
    }

    public void reOpenFile() {
        List<Path> openedFile = this.wrapper.getOpenPaths();
        Map<String, Integer> openTabs = this.storeOpenTabs();
        if (openedFile != null) {
            this.open(openedFile, () -> this.restoreOpenTabs(openTabs));
        }
    }

    @NotNull
    private Map<String, Integer> storeOpenTabs() {
        LinkedHashMap<String, Integer> openTabs = new LinkedHashMap<String, Integer>();
        for (Map.Entry<JNode, ContentPanel> entry : this.tabbedPane.getOpenTabs().entrySet()) {
            JavaNode javaNode = entry.getKey().getJavaNode();
            String classRealName = "";
            if (javaNode instanceof JavaClass) {
                JavaClass javaClass = (JavaClass)javaNode;
                classRealName = javaClass.getRawName();
            }
            @Nullable JumpPosition position = entry.getValue().getTabbedPane().getCurrentPosition();
            int line = 0;
            if (position != null) {
                line = position.getLine();
            }
            openTabs.put(classRealName, line);
        }
        return openTabs;
    }

    private void restoreOpenTabs(Map<String, Integer> openTabs) {
        for (Map.Entry<String, Integer> entry : openTabs.entrySet()) {
            String classRealName = entry.getKey();
            int position = entry.getValue();
            @Nullable JavaClass newClass = this.wrapper.searchJavaClassByRawName(classRealName);
            if (newClass == null) continue;
            JNode newNode = this.cacheObject.getNodeCache().makeFrom(newClass);
            this.tabbedPane.codeJump(new JumpPosition(newNode, position));
        }
    }

    private void saveAll(boolean export) {
        int ret;
        JadxArgs decompilerArgs = this.wrapper.getArgs();
        if (!decompilerArgs.isFsCaseSensitive() && !decompilerArgs.isRenameCaseSensitive() || !decompilerArgs.isRenameValid() || !decompilerArgs.isRenamePrintable()) {
            JOptionPane.showMessageDialog(this, NLS.str("msg.rename_disabled", this.settings.getLangLocale()), NLS.str("msg.rename_disabled_title", this.settings.getLangLocale()), 1);
        }
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(1);
        fileChooser.setToolTipText(NLS.str("file.save_all_msg"));
        Path currentDirectory = this.settings.getLastSaveFilePath();
        if (currentDirectory != null) {
            fileChooser.setCurrentDirectory(currentDirectory.toFile());
        }
        if ((ret = fileChooser.showSaveDialog(this.mainPanel)) == 0) {
            decompilerArgs.setExportAsGradleProject(export);
            if (export) {
                decompilerArgs.setSkipSources(false);
                decompilerArgs.setSkipResources(false);
            } else {
                decompilerArgs.setSkipSources(this.settings.isSkipSources());
                decompilerArgs.setSkipResources(this.settings.isSkipResources());
            }
            this.settings.setLastSaveFilePath(fileChooser.getCurrentDirectory().toPath());
            ProgressMonitor progressMonitor = new ProgressMonitor(this.mainPanel, NLS.str("msg.saving_sources"), "", 0, 100);
            progressMonitor.setMillisToPopup(0);
            this.wrapper.saveAll(fileChooser.getSelectedFile(), progressMonitor);
        }
    }

    public void initTree() {
        this.treeRoot = new JRoot(this.wrapper);
        this.treeRoot.setFlatPackages(this.isFlattenPackage);
        this.treeModel.setRoot(this.treeRoot);
        this.treeRoot.update();
        this.reloadTree();
    }

    private void clearTree() {
        this.tabbedPane.reset();
        this.resetCache();
        this.treeRoot = null;
        this.treeModel.setRoot(null);
        this.treeModel.reload();
    }

    public void reloadTree() {
        this.treeReloading = true;
        this.treeModel.reload();
        List<String[]> treeExpansions = this.project.getTreeExpansions();
        if (!treeExpansions.isEmpty()) {
            this.expand(this.treeRoot, treeExpansions);
        } else {
            this.tree.expandRow(1);
        }
        this.treeReloading = false;
    }

    private void expand(TreeNode node, List<String[]> treeExpansions) {
        Object[] pathNodes = this.treeModel.getPathToRoot(node);
        if (pathNodes == null) {
            return;
        }
        TreePath path = new TreePath(pathNodes);
        for (Object[] objectArray : treeExpansions) {
            if (!Arrays.equals(objectArray, MainWindow.getPathExpansion(path))) continue;
            this.tree.expandPath(path);
            break;
        }
        for (int i = node.getChildCount() - 1; i >= 0; --i) {
            this.expand(node.getChildAt(i), treeExpansions);
        }
    }

    private void toggleFlattenPackage() {
        this.setFlattenPackage(!this.isFlattenPackage);
    }

    private void setFlattenPackage(boolean value) {
        this.isFlattenPackage = value;
        this.settings.setFlattenPackage(this.isFlattenPackage);
        this.flatPkgButton.setSelected(this.isFlattenPackage);
        this.flatPkgMenuItem.setState(this.isFlattenPackage);
        Object root = this.treeModel.getRoot();
        if (root instanceof JRoot) {
            JRoot treeRoot = (JRoot)root;
            treeRoot.setFlatPackages(this.isFlattenPackage);
            this.reloadTree();
        }
    }

    private void toggleDeobfuscation() {
        boolean deobfOn = !this.settings.isDeobfuscationOn();
        this.settings.setDeobfuscationOn(deobfOn);
        this.settings.sync();
        this.deobfToggleBtn.setSelected(deobfOn);
        this.deobfMenuItem.setState(deobfOn);
        this.reOpenFile();
    }

    private void nodeClickAction(@Nullable Object obj) {
        try {
            JNode node;
            JClass cls;
            if (obj == null) {
                return;
            }
            if (obj instanceof JResource) {
                JResource res = (JResource)obj;
                ResourceFile resFile = res.getResFile();
                if (resFile != null && JResource.isSupportedForView(resFile.getType())) {
                    this.tabbedPane.showResource(res);
                }
            } else if (obj instanceof ApkSignature) {
                this.tabbedPane.showSimpleNode((JNode)obj);
            } else if (obj instanceof JNode && (cls = (node = (JNode)obj).getRootClass()) != null) {
                this.tabbedPane.codeJump(new JumpPosition(cls, node.getLine()));
            }
        }
        catch (Exception e) {
            LOG.error("Content loading error", (Throwable)e);
        }
    }

    private void rename(JNode node) {
        RenameDialog renameDialog = new RenameDialog(this, node);
        renameDialog.setVisible(true);
    }

    private void treeRightClickAction(MouseEvent e) {
        JNode obj = this.getJNodeUnderMouse(e);
        if (obj instanceof JPackage) {
            JPackagePopupMenu menu = new JPackagePopupMenu(this, (JPackage)obj);
            menu.show(e.getComponent(), e.getX(), e.getY());
        } else if (obj instanceof JClass || obj instanceof JField || obj instanceof JMethod) {
            JPopupMenu menu = new JPopupMenu();
            JMenuItem jmi = new JMenuItem(NLS.str("popup.rename"));
            jmi.addActionListener(action -> this.rename(obj));
            menu.add(jmi);
            menu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Nullable
    private JNode getJNodeUnderMouse(MouseEvent mouseEvent) {
        Object obj;
        TreePath path = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (path != null && (obj = path.getLastPathComponent()) instanceof JNode) {
            return (JNode)obj;
        }
        return null;
    }

    private void syncWithEditor() {
        ContentPanel selectedContentPanel = this.tabbedPane.getSelectedCodePanel();
        if (selectedContentPanel == null) {
            return;
        }
        JNode node = selectedContentPanel.getNode();
        if (node.getParent() == null && this.treeRoot != null && (node = this.treeRoot.searchClassInTree(node)) == null) {
            LOG.error("Class not found in tree");
            return;
        }
        Object[] pathNodes = this.treeModel.getPathToRoot(node);
        if (pathNodes == null) {
            return;
        }
        TreePath path = new TreePath(pathNodes);
        this.tree.setSelectionPath(path);
        this.tree.makeVisible(path);
        this.tree.scrollPathToVisible(path);
        this.tree.requestFocus();
    }

    private void initMenuAndToolbar() {
        AbstractAction openAction = new AbstractAction(NLS.str("file.open_action"), ICON_OPEN){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.openFileOrProject();
            }
        };
        openAction.putValue("ShortDescription", NLS.str("file.open_action"));
        openAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, UiUtils.ctrlButton()));
        AbstractAction addFilesAction = new AbstractAction(NLS.str("file.add_files_action"), ICON_ADD_FILES){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.addFiles();
            }
        };
        addFilesAction.putValue("ShortDescription", NLS.str("file.add_files_action"));
        this.newProjectAction = new AbstractAction(NLS.str("file.new_project")){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.newProject();
            }
        };
        this.newProjectAction.putValue("ShortDescription", NLS.str("file.new_project"));
        this.saveProjectAction = new AbstractAction(NLS.str("file.save_project")){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.saveProject();
            }
        };
        this.saveProjectAction.putValue("ShortDescription", NLS.str("file.save_project"));
        AbstractAction saveProjectAsAction = new AbstractAction(NLS.str("file.save_project_as")){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.saveProjectAs();
            }
        };
        saveProjectAsAction.putValue("ShortDescription", NLS.str("file.save_project_as"));
        AbstractAction saveAllAction = new AbstractAction(NLS.str("file.save_all"), ICON_SAVE_ALL){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.saveAll(false);
            }
        };
        saveAllAction.putValue("ShortDescription", NLS.str("file.save_all"));
        saveAllAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, UiUtils.ctrlButton()));
        AbstractAction exportAction = new AbstractAction(NLS.str("file.export_gradle"), ICON_EXPORT){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.saveAll(true);
            }
        };
        exportAction.putValue("ShortDescription", NLS.str("file.export_gradle"));
        exportAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(69, UiUtils.ctrlButton()));
        JMenu recentProjects = new JMenu(NLS.str("menu.recent_projects"));
        recentProjects.addMenuListener(new RecentProjectsMenuListener(recentProjects));
        AbstractAction prefsAction = new AbstractAction(NLS.str("menu.preferences"), ICON_PREF){

            @Override
            public void actionPerformed(ActionEvent e) {
                new JadxSettingsWindow(MainWindow.this, MainWindow.this.settings).setVisible(true);
            }
        };
        prefsAction.putValue("ShortDescription", NLS.str("menu.preferences"));
        prefsAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, UiUtils.ctrlButton() | 0x40));
        AbstractAction exitAction = new AbstractAction(NLS.str("file.exit"), ICON_CLOSE){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.closeWindow();
            }
        };
        this.isFlattenPackage = this.settings.isFlattenPackage();
        this.flatPkgMenuItem = new JCheckBoxMenuItem(NLS.str("menu.flatten"), ICON_FLAT_PKG);
        this.flatPkgMenuItem.setState(this.isFlattenPackage);
        JCheckBoxMenuItem heapUsageBarMenuItem = new JCheckBoxMenuItem(NLS.str("menu.heapUsageBar"));
        heapUsageBarMenuItem.setState(this.settings.isShowHeapUsageBar());
        heapUsageBarMenuItem.addActionListener(event -> {
            this.settings.setShowHeapUsageBar(!this.settings.isShowHeapUsageBar());
            this.heapUsageBar.setVisible(this.settings.isShowHeapUsageBar());
        });
        AbstractAction syncAction = new AbstractAction(NLS.str("menu.sync"), ICON_SYNC){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.syncWithEditor();
            }
        };
        syncAction.putValue("ShortDescription", NLS.str("menu.sync"));
        syncAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, UiUtils.ctrlButton()));
        AbstractAction textSearchAction = new AbstractAction(NLS.str("menu.text_search"), ICON_SEARCH){

            @Override
            public void actionPerformed(ActionEvent e) {
                new SearchDialog(MainWindow.this, true).setVisible(true);
            }
        };
        textSearchAction.putValue("ShortDescription", NLS.str("menu.text_search"));
        textSearchAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, UiUtils.ctrlButton() | 0x40));
        AbstractAction clsSearchAction = new AbstractAction(NLS.str("menu.class_search"), ICON_FIND){

            @Override
            public void actionPerformed(ActionEvent e) {
                new SearchDialog(MainWindow.this, false).setVisible(true);
            }
        };
        clsSearchAction.putValue("ShortDescription", NLS.str("menu.class_search"));
        clsSearchAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, UiUtils.ctrlButton()));
        AbstractAction deobfAction = new AbstractAction(NLS.str("menu.deobfuscation"), ICON_DEOBF){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.toggleDeobfuscation();
            }
        };
        deobfAction.putValue("ShortDescription", NLS.str("preferences.deobfuscation"));
        deobfAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(68, UiUtils.ctrlButton() | 0x200));
        this.deobfToggleBtn = new JToggleButton(deobfAction);
        this.deobfToggleBtn.setSelected(this.settings.isDeobfuscationOn());
        this.deobfToggleBtn.setText("");
        this.deobfMenuItem = new JCheckBoxMenuItem(deobfAction);
        this.deobfMenuItem.setState(this.settings.isDeobfuscationOn());
        AbstractAction logAction = new AbstractAction(NLS.str("menu.log"), ICON_LOG){

            @Override
            public void actionPerformed(ActionEvent e) {
                new LogViewer(MainWindow.this).setVisible(true);
            }
        };
        logAction.putValue("ShortDescription", NLS.str("menu.log"));
        logAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(76, UiUtils.ctrlButton() | 0x40));
        AbstractAction aboutAction = new AbstractAction(NLS.str("menu.about"), ICON_JADX){

            @Override
            public void actionPerformed(ActionEvent e) {
                new AboutDialog().setVisible(true);
            }
        };
        AbstractAction backAction = new AbstractAction(NLS.str("nav.back"), ICON_BACK){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.tabbedPane.navBack();
            }
        };
        backAction.putValue("ShortDescription", NLS.str("nav.back"));
        backAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(37, UiUtils.ctrlButton() | 0x200));
        AbstractAction forwardAction = new AbstractAction(NLS.str("nav.forward"), ICON_FORWARD){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.tabbedPane.navForward();
            }
        };
        forwardAction.putValue("ShortDescription", NLS.str("nav.forward"));
        forwardAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(39, UiUtils.ctrlButton() | 0x200));
        JMenu file = new JMenu(NLS.str("menu.file"));
        file.setMnemonic(70);
        file.add(openAction);
        file.add(addFilesAction);
        file.addSeparator();
        file.add(this.newProjectAction);
        file.add(this.saveProjectAction);
        file.add(saveProjectAsAction);
        file.addSeparator();
        file.add(saveAllAction);
        file.add(exportAction);
        file.addSeparator();
        file.add(recentProjects);
        file.addSeparator();
        file.add(prefsAction);
        file.addSeparator();
        file.add(exitAction);
        JMenu view = new JMenu(NLS.str("menu.view"));
        view.setMnemonic(86);
        view.add(this.flatPkgMenuItem);
        view.add(syncAction);
        view.add(heapUsageBarMenuItem);
        JMenu nav = new JMenu(NLS.str("menu.navigation"));
        nav.setMnemonic(78);
        nav.add(textSearchAction);
        nav.add(clsSearchAction);
        nav.addSeparator();
        nav.add(backAction);
        nav.add(forwardAction);
        JMenu tools = new JMenu(NLS.str("menu.tools"));
        tools.setMnemonic(84);
        tools.add(this.deobfMenuItem);
        tools.add(logAction);
        JMenu help = new JMenu(NLS.str("menu.help"));
        help.setMnemonic(72);
        help.add(aboutAction);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(file);
        menuBar.add(view);
        menuBar.add(nav);
        menuBar.add(tools);
        menuBar.add(help);
        this.setJMenuBar(menuBar);
        this.flatPkgButton = new JToggleButton(ICON_FLAT_PKG);
        this.flatPkgButton.setSelected(this.isFlattenPackage);
        ActionListener flatPkgAction = e -> this.toggleFlattenPackage();
        this.flatPkgMenuItem.addActionListener(flatPkgAction);
        this.flatPkgButton.addActionListener(flatPkgAction);
        this.flatPkgButton.setToolTipText(NLS.str("menu.flatten"));
        this.updateLink = new Link("", "https://github.com/skylot/jadx/releases");
        this.updateLink.setVisible(false);
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.add(openAction);
        toolbar.add(addFilesAction);
        toolbar.addSeparator();
        toolbar.add(saveAllAction);
        toolbar.add(exportAction);
        toolbar.addSeparator();
        toolbar.add(syncAction);
        toolbar.add(this.flatPkgButton);
        toolbar.addSeparator();
        toolbar.add(textSearchAction);
        toolbar.add(clsSearchAction);
        toolbar.addSeparator();
        toolbar.add(backAction);
        toolbar.add(forwardAction);
        toolbar.addSeparator();
        toolbar.add(this.deobfToggleBtn);
        toolbar.addSeparator();
        toolbar.add(logAction);
        toolbar.addSeparator();
        toolbar.add(prefsAction);
        toolbar.addSeparator();
        toolbar.add(Box.createHorizontalGlue());
        toolbar.add(this.updateLink);
        this.mainPanel.add((Component)toolbar, "North");
    }

    private void initUI() {
        this.setMinimumSize(new Dimension(200, 150));
        this.mainPanel = new JPanel(new BorderLayout());
        this.splitPane = new JSplitPane();
        this.splitPane.setResizeWeight(0.15);
        this.mainPanel.add(this.splitPane);
        DefaultMutableTreeNode treeRootNode = new DefaultMutableTreeNode(NLS.str("msg.open_file"));
        this.treeModel = new DefaultTreeModel(treeRootNode);
        this.tree = new JTree(this.treeModel);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    MainWindow.this.nodeClickAction(MainWindow.this.getJNodeUnderMouse(e));
                } else if (SwingUtilities.isRightMouseButton(e)) {
                    MainWindow.this.treeRightClickAction(e);
                }
            }
        });
        this.tree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    MainWindow.this.nodeClickAction(MainWindow.this.tree.getLastSelectedPathComponent());
                }
            }
        });
        this.tree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean isLeaf, int row, boolean focused) {
                Component c = super.getTreeCellRendererComponent(tree, value, selected, expanded, isLeaf, row, focused);
                if (value instanceof JNode) {
                    this.setIcon(((JNode)value).getIcon());
                }
                if (value instanceof JPackage) {
                    this.setEnabled(((JPackage)value).isEnabled());
                }
                return c;
            }
        });
        this.tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) {
                TreePath path = event.getPath();
                Object node = path.getLastPathComponent();
                if (node instanceof JLoadableNode) {
                    ((JLoadableNode)node).loadNode();
                }
                if (!MainWindow.this.treeReloading) {
                    MainWindow.this.project.addTreeExpansion(MainWindow.getPathExpansion(event.getPath()));
                    MainWindow.this.update();
                }
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) {
                if (!MainWindow.this.treeReloading) {
                    MainWindow.this.project.removeTreeExpansion(MainWindow.getPathExpansion(event.getPath()));
                    MainWindow.this.update();
                }
            }
        });
        this.progressPane = new ProgressPanel(this, true);
        JPanel leftPane = new JPanel(new BorderLayout());
        JScrollPane treeScrollPane = new JScrollPane(this.tree);
        treeScrollPane.setMinimumSize(new Dimension(100, 150));
        leftPane.add((Component)treeScrollPane, "Center");
        leftPane.add((Component)this.progressPane, "Last");
        this.splitPane.setLeftComponent(leftPane);
        this.tabbedPane = new TabbedPane(this);
        this.tabbedPane.setMinimumSize(new Dimension(150, 150));
        this.splitPane.setRightComponent(this.tabbedPane);
        new DropTarget(this, 1, new MainDropTarget(this));
        this.heapUsageBar = new HeapUsageBar();
        this.mainPanel.add((Component)this.heapUsageBar, "South");
        this.setContentPane(this.mainPanel);
        this.setTitle(DEFAULT_TITLE);
    }

    private void registerMouseNavigationButtons() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        toolkit.addAWTEventListener(event -> {
            MouseEvent mouseEvent;
            if (event instanceof MouseEvent && (mouseEvent = (MouseEvent)event).getID() == 501) {
                int rawButton = mouseEvent.getButton();
                if (rawButton <= 3) {
                    return;
                }
                int button = MainWindow.remapMouseButton(rawButton);
                switch (button) {
                    case 4: {
                        this.tabbedPane.navBack();
                        break;
                    }
                    case 5: {
                        this.tabbedPane.navForward();
                    }
                }
            }
        }, 16L);
    }

    private static int remapMouseButton(int rawButton) {
        if (SystemInfo.IS_LINUX) {
            if (rawButton == 6) {
                return 4;
            }
            if (rawButton == 7) {
                return 5;
            }
        }
        return rawButton;
    }

    private static String[] getPathExpansion(TreePath path) {
        ArrayList<String> pathList = new ArrayList<String>();
        while (path != null) {
            Object node = path.getLastPathComponent();
            String name = node instanceof JClass ? ((JClass)node).getCls().getClassNode().getClassInfo().getFullName() : node.toString();
            pathList.add(name);
            path = path.getParentPath();
        }
        return pathList.toArray(new String[pathList.size()]);
    }

    public static void getExpandedPaths(JTree tree, TreePath path, List<TreePath> list) {
        if (tree.isExpanded(path)) {
            list.add(path);
            TreeNode node = (TreeNode)path.getLastPathComponent();
            for (int i = node.getChildCount() - 1; i >= 0; --i) {
                TreeNode n = node.getChildAt(i);
                TreePath child = path.pathByAddingChild(n);
                MainWindow.getExpandedPaths(tree, child, list);
            }
        }
    }

    public void setLocationAndPosition() {
        if (this.settings.loadWindowPos(this)) {
            return;
        }
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        DisplayMode mode = gd.getDisplayMode();
        int w = mode.getWidth();
        int h = mode.getHeight();
        this.setBounds((int)((double)w * 0.15), (int)((double)h * 0.15), (int)((double)w * 0.7), (int)((double)h * 0.7));
        this.setLocationRelativeTo(null);
    }

    private void setEditorTheme(String editorThemePath) {
        try (InputStream is = this.getClass().getResourceAsStream(editorThemePath);){
            this.editorTheme = Theme.load((InputStream)is);
        }
        catch (Exception e) {
            LOG.error("Can't load editor theme from classpath: {}", (Object)editorThemePath);
            try (FileInputStream is2 = new FileInputStream(editorThemePath);){
                this.editorTheme = Theme.load((InputStream)is2);
            }
            catch (Exception ex) {
                LOG.error("Can't load editor theme from file: {}", (Object)editorThemePath);
            }
        }
    }

    public Theme getEditorTheme() {
        return this.editorTheme;
    }

    public void loadSettings() {
        Font font = this.settings.getFont();
        Font largerFont = font.deriveFont((float)font.getSize() + 2.0f);
        this.setFont(largerFont);
        this.setEditorTheme(this.settings.getEditorThemePath());
        this.tree.setFont(largerFont);
        this.tree.setRowHeight(-1);
        this.tabbedPane.loadSettings();
    }

    private void closeWindow() {
        if (!this.ensureProjectIsSaved()) {
            return;
        }
        this.settings.setTreeWidth(this.splitPane.getDividerLocation());
        this.settings.saveWindowPos(this);
        this.settings.setMainWindowExtendedState(this.getExtendedState());
        this.cancelBackgroundJobs();
        this.wrapper.close();
        this.heapUsageBar.reset();
        this.dispose();
        FileUtils.deleteTempRootDir();
        System.exit(0);
    }

    public JadxWrapper getWrapper() {
        return this.wrapper;
    }

    public TabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public JadxSettings getSettings() {
        return this.settings;
    }

    public CacheObject getCacheObject() {
        return this.cacheObject;
    }

    public BackgroundWorker getBackgroundWorker() {
        return this.backgroundWorker;
    }

    public BackgroundExecutor getBackgroundExecutor() {
        return this.backgroundExecutor;
    }

    public ProgressPanel getProgressPane() {
        return this.progressPane;
    }

    private class RecentProjectsMenuListener
    implements MenuListener {
        private final JMenu menu;

        public RecentProjectsMenuListener(JMenu menu) {
            this.menu = menu;
        }

        @Override
        public void menuSelected(MenuEvent menuEvent) {
            HashSet<Path> current = new HashSet<Path>(MainWindow.this.wrapper.getOpenPaths());
            List<JMenuItem> items = MainWindow.this.settings.getRecentProjects().stream().filter(path -> !current.contains(path)).map(path -> {
                JMenuItem menuItem = new JMenuItem(path.toAbsolutePath().toString());
                menuItem.addActionListener(e -> MainWindow.this.open(Collections.singletonList(path)));
                return menuItem;
            }).collect(Collectors.toList());
            this.menu.removeAll();
            if (items.isEmpty()) {
                this.menu.add(new JMenuItem(NLS.str("menu.no_recent_projects")));
            } else {
                items.forEach(this.menu::add);
            }
        }

        @Override
        public void menuDeselected(MenuEvent e) {
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }
    }
}

