/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.codearea;

import jadx.api.ICodeInfo;
import jadx.gui.ui.codearea.AbstractCodeArea;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Element;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineNumbers
extends JPanel
implements CaretListener {
    private static final Logger LOG = LoggerFactory.getLogger(LineNumbers.class);
    private static final long serialVersionUID = -4978268673635308190L;
    private static final int NUM_HEIGHT = 2146483647;
    private static final Map<?, ?> DESKTOP_HINTS = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
    private final AbstractCodeArea codeArea;
    private boolean useSourceLines = true;
    private transient int lastDigits;
    private transient int lastLine;
    private final transient Color numberColor;
    private final transient Color normalNumColor;
    private final transient Color currentColor;
    private final transient Border border;
    private transient Insets textAreaInsets;
    private transient Rectangle visibleRect = new Rectangle();
    private transient ICodeInfo codeInfo;

    public LineNumbers(AbstractCodeArea codeArea) {
        this.codeArea = codeArea;
        this.setFont(codeArea.getFont());
        SyntaxScheme syntaxScheme = codeArea.getSyntaxScheme();
        this.numberColor = syntaxScheme.getStyle((int)10).foreground;
        this.normalNumColor = syntaxScheme.getStyle((int)19).foreground;
        this.currentColor = syntaxScheme.getStyle((int)13).foreground;
        this.border = new MatteBorder(0, 0, 0, 1, syntaxScheme.getStyle((int)2).foreground);
        this.setBackground(codeArea.getBackground());
        this.setForeground(this.numberColor);
        this.setBorderGap(5);
        this.setPreferredWidth();
        codeArea.addCaretListener(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LineNumbers.this.useSourceLines = !LineNumbers.this.useSourceLines;
                LineNumbers.this.repaint();
            }
        });
    }

    public void setBorderGap(int borderGap) {
        EmptyBorder inner = new EmptyBorder(0, borderGap, 0, borderGap);
        this.setBorder(new CompoundBorder(this.border, inner));
        this.lastDigits = 0;
    }

    private void setPreferredWidth() {
        Element root = this.codeArea.getDocument().getDefaultRootElement();
        int lines = root.getElementCount();
        int digits = Math.max(String.valueOf(lines).length(), 4);
        if (this.lastDigits != digits) {
            this.lastDigits = digits;
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int width = fontMetrics.charWidth('0') * digits;
            Insets insets = this.getInsets();
            int preferredWidth = insets.left + insets.right + width;
            Dimension d = this.getPreferredSize();
            if (d != null) {
                d.setSize(preferredWidth, 2146483647);
                this.setPreferredSize(d);
                this.setSize(d);
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        this.codeInfo = this.codeArea.getNode().getCodeInfo();
        this.visibleRect = g.getClipBounds(this.visibleRect);
        if (this.visibleRect == null) {
            this.visibleRect = this.getVisibleRect();
        }
        if (this.visibleRect == null) {
            return;
        }
        this.applyRenderHints(g);
        Font font = this.codeArea.getFont();
        font = font.deriveFont(font.getSize2D() - 1.0f);
        g.setFont(font);
        Dimension size = this.getSize();
        g.setColor(this.codeArea.getBackground());
        g.fillRect(0, 0, size.width, size.height);
        FontMetrics fontMetrics = this.codeArea.getFontMetrics(font);
        Insets insets = this.getInsets();
        int availableWidth = size.width - insets.right;
        int cellHeight = this.codeArea.getLineHeight();
        int ascent = this.codeArea.getMaxAscent();
        this.textAreaInsets = this.codeArea.getInsets(this.textAreaInsets);
        if (this.visibleRect.y < this.textAreaInsets.top) {
            this.visibleRect.height -= this.textAreaInsets.top - this.visibleRect.y;
            this.visibleRect.y = this.textAreaInsets.top;
        }
        int topLine = (this.visibleRect.y - this.textAreaInsets.top) / cellHeight;
        int actualTopY = topLine * cellHeight + this.textAreaInsets.top;
        int y = actualTopY + ascent;
        int endY = this.visibleRect.y + this.visibleRect.height + ascent;
        int currentLine = 1 + this.codeArea.getCaretLineNumber();
        int linesCount = this.codeArea.getLineCount();
        boolean isCurLine = this.updateColor(g, false, true);
        for (int lineNum = topLine + 1; y < endY && lineNum <= linesCount; ++lineNum, y += cellHeight) {
            try {
                String lineStr = this.getTextLineNumber(lineNum);
                if (lineStr != null) {
                    isCurLine = this.updateColor(g, lineNum == currentLine, isCurLine);
                    int x = availableWidth - fontMetrics.stringWidth(lineStr);
                    g.drawString(lineStr, x, y);
                    continue;
                }
                if (!this.useSourceLines) break;
                continue;
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Line numbers draw error", (Throwable)e);
                break;
            }
        }
    }

    private boolean updateColor(Graphics g, boolean newCurLine, boolean oldCurLine) {
        if (oldCurLine != newCurLine) {
            if (newCurLine) {
                g.setColor(this.currentColor);
            } else {
                g.setColor(this.useSourceLines ? this.numberColor : this.normalNumColor);
            }
        }
        return newCurLine;
    }

    private void applyRenderHints(Graphics g) {
        if (g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            if (DESKTOP_HINTS != null) {
                g2d.setRenderingHints(DESKTOP_HINTS);
            } else {
                g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            }
        }
    }

    @Nullable
    protected String getTextLineNumber(int lineNumber) {
        if (!this.useSourceLines) {
            return String.valueOf(lineNumber);
        }
        Integer sourceLine = this.codeInfo.getLineMapping().get(lineNumber);
        if (sourceLine == null) {
            return null;
        }
        return String.valueOf(sourceLine);
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        int caretPosition = this.codeArea.getCaretPosition();
        Element root = this.codeArea.getDocument().getDefaultRootElement();
        int currentLine = root.getElementIndex(caretPosition);
        if (this.lastLine != currentLine) {
            this.repaint();
            this.lastLine = currentLine;
        }
    }

    public void setUseSourceLines(boolean useSourceLines) {
        this.useSourceLines = useSourceLines;
    }
}

