/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.codearea;

import jadx.gui.ui.codearea.CodeArea;
import jadx.gui.ui.codearea.CodeLinkGenerator;
import jadx.gui.utils.JumpPosition;
import java.awt.Paint;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.text.Highlighter;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rtextarea.SmartHighlightPainter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MouseHoverHighlighter
extends MouseMotionAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(MouseHoverHighlighter.class);
    private final CodeArea codeArea;
    private final CodeLinkGenerator codeLinkGenerator;
    private final Highlighter.HighlightPainter highlighter;
    private boolean added;

    public MouseHoverHighlighter(CodeArea codeArea, CodeLinkGenerator codeLinkGenerator) {
        this.codeArea = codeArea;
        this.codeLinkGenerator = codeLinkGenerator;
        this.highlighter = new SmartHighlightPainter((Paint)codeArea.getMarkOccurrencesColor());
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Highlighter highlighter = this.codeArea.getHighlighter();
        if (this.added) {
            highlighter.removeAllHighlights();
            this.added = false;
        }
        if (e.getModifiersEx() != 0) {
            return;
        }
        try {
            Token token = this.codeArea.viewToToken(e.getPoint());
            if (token == null || token.getType() != 20) {
                return;
            }
            JumpPosition jump = this.codeLinkGenerator.getJumpLinkAtOffset(this.codeArea, token.getOffset());
            if (jump == null) {
                return;
            }
            highlighter.removeAllHighlights();
            highlighter.addHighlight(token.getOffset(), token.getEndOffset(), this.highlighter);
            this.added = true;
        }
        catch (Exception exc) {
            LOG.error("Mouse hover highlight error", (Throwable)exc);
        }
    }
}

