/*
 * Decompiled with CFR 0.152.
 */
package jadx.cli;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.Parameter;
import jadx.api.JadxArgs;
import jadx.api.JadxDecompiler;
import jadx.cli.JCommanderWrapper;
import jadx.cli.LogHelper;
import jadx.core.utils.exceptions.JadxException;
import jadx.core.utils.files.FileUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JadxCLIArgs {
    @Parameter(description="<input files> (.apk, .dex, .jar, .class, .smali, .zip, .aar, .arsc)")
    protected List<String> files = new ArrayList<String>(1);
    @Parameter(names={"-d", "--output-dir"}, description="output directory")
    protected String outDir;
    @Parameter(names={"-ds", "--output-dir-src"}, description="output directory for sources")
    protected String outDirSrc;
    @Parameter(names={"-dr", "--output-dir-res"}, description="output directory for resources")
    protected String outDirRes;
    @Parameter(names={"-r", "--no-res"}, description="do not decode resources")
    protected boolean skipResources = false;
    @Parameter(names={"-s", "--no-src"}, description="do not decompile source code")
    protected boolean skipSources = false;
    @Parameter(names={"--single-class"}, description="decompile a single class")
    protected String singleClass = null;
    @Parameter(names={"--output-format"}, description="can be 'java' or 'json'")
    protected String outputFormat = "java";
    @Parameter(names={"-e", "--export-gradle"}, description="save as android gradle project")
    protected boolean exportAsGradleProject = false;
    @Parameter(names={"-j", "--threads-count"}, description="processing threads count")
    protected int threadsCount = JadxArgs.DEFAULT_THREADS_COUNT;
    @Parameter(names={"--show-bad-code"}, description="show inconsistent code (incorrectly decompiled)")
    protected boolean showInconsistentCode = false;
    @Parameter(names={"--no-imports"}, description="disable use of imports, always write entire package name")
    protected boolean useImports = true;
    @Parameter(names={"--no-debug-info"}, description="disable debug info")
    protected boolean debugInfo = true;
    @Parameter(names={"--no-inline-anonymous"}, description="disable anonymous classes inline")
    protected boolean inlineAnonymousClasses = true;
    @Parameter(names={"--no-replace-consts"}, description="don't replace constant value with matching constant field")
    protected boolean replaceConsts = true;
    @Parameter(names={"--escape-unicode"}, description="escape non latin characters in strings (with \\u)")
    protected boolean escapeUnicode = false;
    @Parameter(names={"--respect-bytecode-access-modifiers"}, description="don't change original access modifiers")
    protected boolean respectBytecodeAccessModifiers = false;
    @Parameter(names={"--deobf"}, description="activate deobfuscation")
    protected boolean deobfuscationOn = false;
    @Parameter(names={"--deobf-min"}, description="min length of name, renamed if shorter")
    protected int deobfuscationMinLength = 3;
    @Parameter(names={"--deobf-max"}, description="max length of name, renamed if longer")
    protected int deobfuscationMaxLength = 64;
    @Parameter(names={"--deobf-rewrite-cfg"}, description="force to save deobfuscation map")
    protected boolean deobfuscationForceSave = false;
    @Parameter(names={"--deobf-use-sourcename"}, description="use source file name as class name alias")
    protected boolean deobfuscationUseSourceNameAsAlias = false;
    @Parameter(names={"--deobf-parse-kotlin-metadata"}, description="parse kotlin metadata to class and package names")
    protected boolean deobfuscationParseKotlinMetadata = false;
    @Parameter(names={"--rename-flags"}, description="what to rename, comma-separated, 'case' for system case sensitivity, 'valid' for java identifiers, 'printable' characters, 'none' or 'all' (default)", converter=RenameConverter.class)
    protected Set<JadxArgs.RenameEnum> renameFlags = EnumSet.allOf(JadxArgs.RenameEnum.class);
    @Parameter(names={"--fs-case-sensitive"}, description="treat filesystem as case sensitive, false by default")
    protected boolean fsCaseSensitive = false;
    @Parameter(names={"--cfg"}, description="save methods control flow graph to dot file")
    protected boolean cfgOutput = false;
    @Parameter(names={"--raw-cfg"}, description="save methods control flow graph (use raw instructions)")
    protected boolean rawCfgOutput = false;
    @Parameter(names={"-f", "--fallback"}, description="make simple dump (using goto instead of 'if', 'for', etc)")
    protected boolean fallbackMode = false;
    @Parameter(names={"-v", "--verbose"}, description="verbose output (set --log-level to DEBUG)")
    protected boolean verbose = false;
    @Parameter(names={"-q", "--quiet"}, description="turn off output (set --log-level to QUIET)")
    protected boolean quiet = false;
    @Parameter(names={"--log-level"}, description="set log level, values: QUIET, PROGRESS, ERROR, WARN, INFO, DEBUG", converter=LogHelper.LogLevelConverter.class)
    protected LogHelper.LogLevelEnum logLevel = LogHelper.LogLevelEnum.PROGRESS;
    @Parameter(names={"--version"}, description="print jadx version")
    protected boolean printVersion = false;
    @Parameter(names={"-h", "--help"}, description="print this help", help=true)
    protected boolean printHelp = false;

    public boolean processArgs(String[] args) {
        JCommanderWrapper<JadxCLIArgs> jcw = new JCommanderWrapper<JadxCLIArgs>(this);
        return jcw.parse(args) && this.process(jcw);
    }

    public boolean overrideProvided(String[] args) {
        JCommanderWrapper<JadxCLIArgs> jcw = new JCommanderWrapper<JadxCLIArgs>(this.newInstance());
        if (!jcw.parse(args)) {
            return false;
        }
        jcw.overrideProvided(this);
        return this.process(jcw);
    }

    protected JadxCLIArgs newInstance() {
        return new JadxCLIArgs();
    }

    private boolean process(JCommanderWrapper<JadxCLIArgs> jcw) {
        if (this.printHelp) {
            jcw.printUsage();
            return false;
        }
        if (this.printVersion) {
            System.out.println(JadxDecompiler.getVersion());
            return false;
        }
        try {
            if (this.threadsCount <= 0) {
                throw new JadxException("Threads count must be positive, got: " + this.threadsCount);
            }
            LogHelper.setLogLevelFromArgs(this);
        }
        catch (JadxException e) {
            System.err.println("ERROR: " + e.getMessage());
            jcw.printUsage();
            return false;
        }
        return true;
    }

    public JadxArgs toJadxArgs() {
        JadxArgs args = new JadxArgs();
        args.setInputFiles(this.files.stream().map(FileUtils::toFile).collect(Collectors.toList()));
        args.setOutDir(FileUtils.toFile((String)this.outDir));
        args.setOutDirSrc(FileUtils.toFile((String)this.outDirSrc));
        args.setOutDirRes(FileUtils.toFile((String)this.outDirRes));
        args.setOutputFormat(JadxArgs.OutputFormatEnum.valueOf((String)this.outputFormat.toUpperCase()));
        args.setThreadsCount(this.threadsCount);
        args.setSkipSources(this.skipSources);
        if (this.singleClass != null) {
            args.setClassFilter(className -> this.singleClass.equals(className));
        }
        args.setSkipResources(this.skipResources);
        args.setFallbackMode(this.fallbackMode);
        args.setShowInconsistentCode(this.showInconsistentCode);
        args.setCfgOutput(this.cfgOutput);
        args.setRawCFGOutput(this.rawCfgOutput);
        args.setReplaceConsts(this.replaceConsts);
        args.setDeobfuscationOn(this.deobfuscationOn);
        args.setDeobfuscationForceSave(this.deobfuscationForceSave);
        args.setDeobfuscationMinLength(this.deobfuscationMinLength);
        args.setDeobfuscationMaxLength(this.deobfuscationMaxLength);
        args.setUseSourceNameAsClassAlias(this.deobfuscationUseSourceNameAsAlias);
        args.setParseKotlinMetadata(this.deobfuscationParseKotlinMetadata);
        args.setEscapeUnicode(this.escapeUnicode);
        args.setRespectBytecodeAccModifiers(this.respectBytecodeAccessModifiers);
        args.setExportAsGradleProject(this.exportAsGradleProject);
        args.setUseImports(this.useImports);
        args.setDebugInfo(this.debugInfo);
        args.setInlineAnonymousClasses(this.inlineAnonymousClasses);
        args.setRenameCaseSensitive(this.isRenameCaseSensitive());
        args.setRenameValid(this.isRenameValid());
        args.setRenamePrintable(this.isRenamePrintable());
        args.setFsCaseSensitive(this.fsCaseSensitive);
        return args;
    }

    public List<String> getFiles() {
        return this.files;
    }

    public String getOutDir() {
        return this.outDir;
    }

    public String getOutDirSrc() {
        return this.outDirSrc;
    }

    public String getOutDirRes() {
        return this.outDirRes;
    }

    public boolean isSkipResources() {
        return this.skipResources;
    }

    public boolean isSkipSources() {
        return this.skipSources;
    }

    public int getThreadsCount() {
        return this.threadsCount;
    }

    public boolean isFallbackMode() {
        return this.fallbackMode;
    }

    public boolean isShowInconsistentCode() {
        return this.showInconsistentCode;
    }

    public boolean isUseImports() {
        return this.useImports;
    }

    public boolean isDebugInfo() {
        return this.debugInfo;
    }

    public boolean isInlineAnonymousClasses() {
        return this.inlineAnonymousClasses;
    }

    public boolean isDeobfuscationOn() {
        return this.deobfuscationOn;
    }

    public int getDeobfuscationMinLength() {
        return this.deobfuscationMinLength;
    }

    public int getDeobfuscationMaxLength() {
        return this.deobfuscationMaxLength;
    }

    public boolean isDeobfuscationForceSave() {
        return this.deobfuscationForceSave;
    }

    public boolean isDeobfuscationUseSourceNameAsAlias() {
        return this.deobfuscationUseSourceNameAsAlias;
    }

    public boolean isDeobfuscationParseKotlinMetadata() {
        return this.deobfuscationParseKotlinMetadata;
    }

    public boolean isEscapeUnicode() {
        return this.escapeUnicode;
    }

    public boolean isCfgOutput() {
        return this.cfgOutput;
    }

    public boolean isRawCfgOutput() {
        return this.rawCfgOutput;
    }

    public boolean isReplaceConsts() {
        return this.replaceConsts;
    }

    public boolean isRespectBytecodeAccessModifiers() {
        return this.respectBytecodeAccessModifiers;
    }

    public boolean isExportAsGradleProject() {
        return this.exportAsGradleProject;
    }

    public boolean isRenameCaseSensitive() {
        return this.renameFlags.contains(JadxArgs.RenameEnum.CASE);
    }

    public boolean isRenameValid() {
        return this.renameFlags.contains(JadxArgs.RenameEnum.VALID);
    }

    public boolean isRenamePrintable() {
        return this.renameFlags.contains(JadxArgs.RenameEnum.PRINTABLE);
    }

    public boolean isFsCaseSensitive() {
        return this.fsCaseSensitive;
    }

    public static String enumValuesString(Enum<?>[] values) {
        return Stream.of(values).map(v -> '\'' + v.name().toLowerCase(Locale.ROOT) + '\'').collect(Collectors.joining(", "));
    }

    static class RenameConverter
    implements IStringConverter<Set<JadxArgs.RenameEnum>> {
        private final String paramName;

        RenameConverter(String paramName) {
            this.paramName = paramName;
        }

        public Set<JadxArgs.RenameEnum> convert(String value) {
            if (value.equalsIgnoreCase("NONE")) {
                return EnumSet.noneOf(JadxArgs.RenameEnum.class);
            }
            if (value.equalsIgnoreCase("ALL")) {
                return EnumSet.allOf(JadxArgs.RenameEnum.class);
            }
            EnumSet<JadxArgs.RenameEnum> set = EnumSet.noneOf(JadxArgs.RenameEnum.class);
            for (String s : value.split(",")) {
                try {
                    set.add(JadxArgs.RenameEnum.valueOf((String)s.toUpperCase(Locale.ROOT)));
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException('\'' + s + "' is unknown for parameter " + this.paramName + ", possible values are " + JadxCLIArgs.enumValuesString(JadxArgs.RenameEnum.values()));
                }
            }
            return set;
        }
    }
}

