/*
  ==============================================================================

   This file is part of the JUCE library.
   Copyright (c) 2017 - ROLI Ltd.

   JUCE is an open source library subject to commercial or open-source
   licensing.

   The code included in this file is provided under the terms of the ISC license
   http://www.isc.org/downloads/software-support-policy/isc-license. Permission
   To use, copy, modify, and/or distribute this software for any purpose with or
   without fee is hereby granted provided that the above copyright notice and
   this permission notice appear in all copies.

   JUCE IS PROVIDED "AS IS" WITHOUT ANY WARRANTY, AND ALL WARRANTIES, WHETHER
   EXPRESSED OR IMPLIED, INCLUDING MERCHANTABILITY AND FITNESS FOR PURPOSE, ARE
   DISCLAIMED.

  ==============================================================================
*/

namespace juce
{

//==============================================================================
// This byte-code is generated from native/java/com/roli/juce/JuceMidiSupport.java with min sdk version 23
// See juce_core/native/java/README.txt on how to generate this byte-code.
static const uint8 javaMidiByteCode[] =
{31,139,8,8,116,138,97,92,0,3,74,97,118,97,68,101,120,66,121,116,101,67,111,100,101,46,100,101,120,0,149,124,9,124,219,197,
149,255,155,223,33,201,178,108,203,178,19,59,142,45,203,142,29,43,36,190,226,28,78,236,28,62,146,216,137,115,96,43,161,196,252,161,
138,173,36,10,182,228,88,114,14,216,46,161,7,9,45,44,148,35,77,41,165,180,92,225,40,176,20,10,109,129,210,66,91,216,101,129,
109,217,54,244,164,45,252,75,11,165,244,96,129,150,146,253,190,153,145,252,75,98,72,155,124,190,122,243,123,243,230,205,204,155,
55,111,222,252,164,100,56,182,207,219,212,178,144,238,255,216,139,247,126,127,96,206,252,159,157,251,212,223,22,175,248,196,
61,193,55,6,163,75,42,189,255,218,116,38,209,24,17,237,219,178,32,64,250,207,135,55,17,157,45,20,127,21,240,188,77,116,22,232,
43,46,162,16,232,187,94,162,123,152,230,18,229,128,166,11,137,174,95,78,116,13,52,188,93,79,244,87,224,239,128,209,64,100,3,
115,129,6,160,21,88,9,116,3,107,129,77,192,54,224,6,224,23,192,223,128,247,0,163,145,200,13,132,129,141,64,63,240,33,224,124,224,
34,224,114,224,38,224,86,224,14,224,30,224,126,224,235,192,163,192,227,192,83,192,31,128,226,38,162,197,192,54,224,106,224,
49,224,85,192,223,76,212,6,156,11,92,12,220,13,252,0,120,29,40,152,79,180,12,216,6,92,10,124,25,248,57,80,210,66,180,4,56,23,184,
24,56,12,220,5,124,7,120,1,248,61,96,44,128,237,128,79,1,143,2,127,2,66,11,137,18,192,253,192,111,128,105,139,136,22,1,91,129,
11,128,207,3,15,3,199,128,63,0,198,98,244,5,204,5,86,0,91,128,52,112,53,112,59,240,24,96,183,18,53,1,221,192,135,128,81,224,
98,224,48,112,23,240,8,240,44,96,45,65,127,64,24,88,1,244,3,215,2,183,3,15,2,63,7,126,9,188,12,252,14,120,3,120,27,120,23,
16,75,177,14,64,62,80,4,148,2,65,160,6,152,11,204,7,22,1,75,128,101,64,7,176,10,136,3,71,128,71,129,31,0,175,0,111,2,162,141,200,
11,20,0,165,192,108,160,5,88,1,172,1,206,6,38,128,75,129,207,1,255,14,60,14,60,3,28,3,126,7,252,9,120,7,112,183,67,15,80,9,
204,6,234,129,69,64,23,176,30,216,10,12,1,187,129,125,192,133,192,65,224,10,224,179,192,77,192,125,192,55,129,103,128,31,3,47,3,
127,4,222,1,172,101,208,15,172,0,122,129,17,224,114,224,26,224,75,192,221,192,253,192,55,129,39,128,231,128,159,1,239,0,211,
177,23,234,129,78,224,28,32,5,124,4,184,18,248,28,112,39,240,32,240,24,240,42,240,39,224,29,192,88,129,185,0,27,129,253,192,53,
192,93,192,3,192,183,129,255,6,126,13,252,30,120,23,200,91,137,249,3,97,96,49,176,18,88,11,108,2,6,129,115,129,33,32,14,140,
1,23,2,135,128,107,129,27,128,219,128,251,129,71,129,39,129,31,2,63,1,126,13,252,1,120,27,120,15,240,118,16,85,0,245,192,82,96,
57,208,5,244,0,27,128,205,192,121,64,12,216,5,140,3,151,0,95,0,30,0,158,6,94,6,222,2,188,157,68,51,128,57,192,74,224,76,96,
39,176,27,184,8,248,52,112,39,240,53,224,123,192,179,192,203,192,95,1,87,23,124,25,104,0,122,128,115,128,17,96,47,112,49,112,25,
112,53,240,5,224,86,224,27,192,143,128,55,128,255,5,222,5,220,221,68,133,192,76,96,46,176,16,232,6,54,0,231,2,49,96,23,240,
81,224,147,192,97,224,38,224,81,224,187,192,179,192,143,128,159,1,191,2,222,4,188,8,146,69,64,5,80,11,204,5,214,0,103,2,219,128,
36,112,17,112,25,112,21,240,89,224,102,224,43,192,55,128,111,1,255,9,252,16,248,41,240,18,240,7,224,109,192,88,13,123,1,11,
128,13,192,102,160,0,49,183,24,168,6,102,1,53,64,45,48,27,168,3,194,192,28,224,12,96,46,48,15,64,56,38,132,86,66,72,36,132,63,66,
152,35,132,52,66,200,34,132,40,66,88,34,132,30,66,104,33,132,13,194,246,39,108,89,194,86,35,108,7,130,91,19,92,142,176,132,
132,165,32,152,146,186,245,249,128,33,209,26,160,7,232,5,214,2,235,128,62,96,61,176,1,216,8,224,88,33,28,55,212,15,12,0,17,96,11,
240,33,96,16,248,127,192,121,124,254,0,219,128,97,32,6,108,7,70,128,127,1,46,2,14,0,23,3,31,5,62,6,124,156,148,77,50,127,
252,154,142,97,226,133,186,188,15,229,50,80,67,63,115,217,212,229,74,93,30,211,50,150,230,87,233,242,1,205,247,56,228,113,4,210,101,
154,159,171,249,51,129,60,224,26,205,207,119,244,85,224,40,7,28,242,197,90,158,203,165,142,182,101,142,190,202,245,216,88,
38,168,101,42,117,121,76,151,25,215,107,153,106,45,83,161,203,55,207,83,178,92,190,75,203,215,56,218,214,234,182,220,15,251,208,
67,122,12,13,142,113,54,58,198,214,228,24,27,151,31,155,167,242,2,46,63,57,111,146,159,177,103,179,67,79,179,99,252,92,126,
206,81,206,204,113,129,163,175,86,71,95,236,147,199,52,127,169,230,179,95,44,211,229,81,93,230,182,9,93,126,17,229,164,46,191,50,
79,229,52,92,254,11,202,187,117,217,194,230,216,167,203,62,148,199,117,185,20,229,148,46,135,80,222,163,203,243,80,222,171,
203,11,28,229,149,245,147,58,251,28,229,235,29,125,69,28,252,115,28,253,14,59,248,99,142,242,62,71,191,7,28,252,67,142,182,87,162,
188,63,211,151,67,254,40,202,23,232,242,189,142,182,207,57,198,195,107,151,145,127,210,193,31,115,148,31,118,244,245,4,202,
19,25,61,40,95,168,203,199,28,182,122,17,229,180,46,191,86,175,246,237,114,189,70,31,209,101,94,163,127,213,101,182,127,166,252,
152,131,159,241,159,14,221,150,203,157,14,127,232,114,248,67,183,230,207,212,229,107,164,207,55,209,131,164,232,10,193,109,
10,232,50,217,182,153,174,144,116,49,93,37,169,135,150,9,246,225,82,250,20,175,53,122,127,69,82,65,191,151,180,150,170,100,253,
108,154,43,56,46,20,75,185,42,205,175,210,252,89,250,153,233,38,193,123,204,162,207,16,83,63,253,69,82,85,95,163,235,107,
245,120,106,17,121,15,75,218,73,119,74,90,66,127,146,116,1,189,165,235,203,133,162,65,161,246,232,237,196,116,57,253,142,116,220,
23,28,251,43,233,211,92,134,228,155,196,177,206,67,79,72,106,210,119,37,181,233,199,196,177,206,77,95,144,180,154,30,209,
244,121,94,7,156,24,159,215,244,30,73,45,250,158,164,27,104,33,244,219,224,187,137,227,96,15,245,10,166,139,104,189,224,59,128,226,
123,179,212,75,71,36,205,161,85,168,247,105,61,121,186,62,15,156,35,146,230,82,151,80,180,91,112,140,204,163,111,17,211,42,
250,9,113,28,87,227,241,35,146,62,35,105,1,149,8,166,126,154,41,56,182,171,113,115,140,255,161,166,63,37,21,95,255,75,210,126,58,
38,105,33,189,160,249,92,95,172,245,22,227,148,90,9,61,211,244,184,74,112,42,61,37,105,19,77,19,76,151,210,116,73,151,81,179,
164,237,180,69,112,156,86,237,75,97,255,27,52,101,123,205,208,122,202,48,254,135,137,227,105,128,190,70,28,135,13,186,69,250,
225,42,89,207,126,167,168,160,199,37,173,165,255,148,116,51,125,95,210,53,36,164,191,206,165,66,73,231,81,64,210,51,169,70,
210,181,180,86,210,213,180,89,250,229,74,169,47,164,199,197,244,126,73,149,125,66,136,228,63,147,116,61,189,170,235,243,100,187,
62,42,146,116,29,117,10,197,239,209,180,79,250,245,10,169,183,74,235,173,210,122,171,180,222,42,173,175,74,183,175,210,237,
171,116,251,106,221,174,90,203,87,107,249,106,45,95,173,229,171,181,252,44,236,116,238,111,22,178,18,67,62,47,32,83,83,75,210,249,
100,75,186,144,92,154,186,53,63,95,211,2,73,155,201,175,105,177,220,111,157,82,111,13,250,191,78,210,106,250,182,164,46,250,
15,82,103,225,211,146,158,65,75,229,62,83,235,83,171,231,91,11,79,121,64,210,25,244,85,73,103,211,163,146,170,245,171,133,223,
60,41,233,22,122,86,210,205,244,156,166,255,45,105,17,253,64,210,26,250,31,73,103,210,143,36,93,66,30,217,95,43,229,104,234,
21,138,159,43,105,27,249,132,138,7,165,146,78,167,25,146,150,82,153,164,27,169,90,210,70,154,37,105,23,181,72,186,154,34,50,78,
212,203,121,204,70,230,117,175,142,19,191,144,241,225,12,204,92,81,183,164,211,232,155,146,150,209,99,196,103,253,92,201,111,
212,242,208,78,3,130,105,5,125,72,240,217,174,218,53,105,251,52,193,211,191,67,124,134,171,126,154,97,231,223,18,231,150,221,
82,174,5,158,207,251,97,129,110,183,0,114,135,244,243,245,250,249,70,73,235,232,53,253,60,95,168,60,96,141,164,17,234,23,156,
163,134,233,114,226,60,85,233,89,164,219,47,130,252,23,37,173,148,253,44,66,246,251,134,164,33,106,18,138,207,250,22,235,118,
139,117,255,139,117,63,139,117,63,139,117,63,173,24,255,207,137,105,144,222,35,206,59,212,184,150,106,218,166,245,180,33,219,
93,46,56,63,86,207,237,218,191,248,108,2,91,190,27,33,25,23,112,150,33,17,63,130,68,248,218,13,42,15,19,174,201,60,138,235,175,
68,253,51,27,212,115,72,183,103,254,135,231,41,122,35,234,127,167,235,171,116,125,147,163,254,33,212,207,222,168,234,103,105,
189,182,67,255,115,168,239,215,245,53,154,223,238,168,127,17,245,151,234,250,90,173,127,26,176,83,235,127,3,245,247,234,250,217,
186,157,115,252,43,33,23,222,164,158,235,28,227,203,212,111,66,125,167,174,231,28,252,195,184,24,236,88,175,228,198,53,189,
120,253,100,221,85,142,242,13,186,254,118,7,239,62,93,126,4,244,9,71,249,217,245,42,151,103,153,31,3,47,235,182,111,104,42,54,40,
26,208,180,78,211,118,77,7,52,29,222,48,217,215,94,205,251,232,6,214,109,200,242,185,171,213,61,99,204,159,135,231,106,248,
206,152,255,75,120,30,244,91,136,250,131,126,131,6,3,6,206,45,150,103,61,201,213,234,158,16,65,205,110,255,37,196,167,98,34,52,
130,181,246,202,187,129,165,229,246,172,86,119,136,221,178,23,159,72,132,12,236,39,200,250,109,249,204,231,129,137,58,150,253,
216,106,117,230,69,66,22,69,170,44,200,220,130,26,175,152,133,11,110,34,116,43,198,231,131,47,118,75,25,91,102,1,200,27,209,
102,58,219,220,127,59,250,244,137,113,255,109,220,198,104,53,242,192,59,138,50,183,241,81,32,144,104,90,2,79,10,191,145,175,
71,134,117,88,173,236,192,247,26,151,156,25,238,217,171,213,189,49,80,56,191,216,166,64,85,75,113,33,198,81,136,254,124,216,63,
185,20,105,230,113,241,45,202,103,36,66,55,193,119,3,29,45,197,149,136,95,211,168,204,56,159,118,135,154,193,155,108,17,56,
169,197,205,178,214,210,182,104,71,36,205,151,115,225,190,191,179,90,221,107,156,182,234,128,22,68,79,173,255,43,90,127,64,20,136,
72,179,178,188,144,146,255,34,45,21,126,211,11,77,172,253,127,86,171,119,156,129,146,128,75,235,131,30,47,149,89,208,99,231,
73,61,17,244,157,144,151,75,159,88,34,50,117,62,93,23,254,83,107,206,66,170,54,188,240,4,182,89,153,101,161,191,38,182,178,149,
8,249,113,6,85,155,121,168,11,192,114,137,80,49,178,101,230,79,195,45,215,103,5,106,185,20,161,89,233,149,232,161,0,173,125,
246,122,219,114,237,246,95,167,218,251,139,208,202,103,39,86,230,82,199,39,194,143,36,66,62,220,128,195,95,163,172,127,229,172,
81,119,210,19,253,235,34,248,87,62,242,52,151,242,249,53,234,30,58,230,111,64,155,193,89,57,52,88,227,162,193,90,47,109,157,
237,129,229,207,9,185,229,218,218,210,191,4,205,94,163,98,73,192,140,116,184,168,85,184,137,105,194,63,23,117,145,142,28,112,114,
36,141,116,122,209,215,191,194,206,131,93,208,217,229,130,150,60,189,2,1,189,2,225,87,84,60,98,221,66,212,227,248,18,114,76,
109,232,131,99,103,194,207,25,127,210,127,153,246,175,140,143,119,173,81,113,52,18,66,63,85,220,207,184,244,235,66,25,71,132,244,
203,222,53,106,175,6,96,57,161,121,27,215,76,250,106,62,230,207,119,247,205,107,212,222,90,150,235,163,129,139,61,228,62,224,
190,90,220,44,30,176,190,187,199,211,161,101,45,125,251,143,57,218,27,122,44,187,215,168,152,24,241,231,40,79,245,195,42,144,
216,236,119,75,95,225,231,68,104,30,198,23,240,159,227,119,159,208,246,130,15,104,219,154,109,91,207,109,41,211,150,199,194,
99,248,152,94,219,49,63,223,58,6,133,143,6,141,92,26,132,55,229,103,215,234,106,199,90,229,234,181,202,133,85,103,201,181,242,
233,181,242,97,173,242,178,107,5,61,93,185,255,196,90,29,205,174,85,239,148,107,117,111,118,173,208,79,85,222,148,107,245,
213,204,90,193,19,221,122,134,15,131,87,196,237,154,245,200,65,19,43,107,168,35,54,57,182,14,161,199,246,150,122,39,163,199,230,
205,172,247,15,28,235,149,225,189,224,224,153,114,148,200,103,214,168,247,56,131,162,0,246,100,171,14,26,249,50,78,171,183,
65,175,58,218,100,124,225,205,41,120,162,199,25,11,45,57,167,188,30,21,143,3,161,22,187,0,62,144,128,207,154,176,6,71,13,15,239,
95,196,157,143,200,219,204,164,158,242,158,83,117,135,167,224,45,152,130,183,178,231,196,249,241,159,190,41,120,91,28,60,91,
90,14,231,90,15,71,8,182,67,17,236,240,101,105,7,156,91,102,33,13,90,60,66,75,90,209,164,221,61,234,61,80,185,81,67,21,70,64,12,
54,7,176,242,119,163,6,62,219,236,199,122,21,72,154,128,207,10,93,226,104,195,146,126,60,23,66,194,43,105,194,95,170,249,133,
20,52,112,215,19,65,163,78,228,137,240,91,60,155,25,168,171,148,227,51,101,254,225,146,62,53,231,162,250,121,115,116,217,160,
127,235,81,57,105,185,137,177,152,145,126,232,54,102,17,211,132,127,6,199,76,145,240,87,203,211,44,176,160,165,115,58,184,85,
28,237,141,50,235,106,248,98,35,34,48,159,109,38,246,155,39,123,194,4,205,66,160,12,203,23,126,55,15,165,58,67,229,15,179,209,
178,94,251,146,192,253,43,227,191,119,245,168,250,136,223,159,245,107,174,185,175,39,115,190,171,209,200,248,235,87,111,10,
213,249,174,246,233,67,61,124,143,196,28,4,230,32,34,77,1,140,38,143,34,77,133,124,7,32,126,142,204,135,134,208,30,68,238,160,96,
255,15,138,58,82,125,22,201,190,138,177,111,212,89,254,120,143,122,135,26,176,198,252,181,176,220,96,164,152,6,183,20,195,34,
197,84,102,254,25,90,74,112,35,242,25,149,70,9,13,246,151,128,95,66,75,112,62,149,25,216,81,230,78,185,219,113,115,194,153,181,
8,62,240,57,62,19,250,103,224,105,1,158,174,146,79,165,39,212,149,157,240,52,77,234,75,248,103,179,229,169,202,12,24,11,231,
123,105,53,166,153,8,165,17,235,142,25,6,214,86,202,52,205,161,126,43,252,180,71,159,85,111,244,168,220,51,50,84,138,246,135,121,
103,88,156,135,88,228,53,91,205,38,153,135,88,114,220,65,138,32,168,85,154,126,105,83,115,114,133,205,192,194,150,129,223,28,
215,43,108,150,217,106,133,7,178,43,252,194,113,189,194,102,34,244,111,56,107,89,243,179,199,11,141,128,17,126,207,165,199,49,
173,87,189,31,143,116,150,65,255,23,120,30,198,184,255,14,77,111,3,229,86,51,229,120,12,169,185,145,34,93,144,13,221,32,199,
82,137,53,76,248,135,228,8,184,151,1,41,255,210,241,66,17,16,225,247,56,206,40,239,105,234,85,239,218,203,237,90,170,176,35,105,
158,245,17,158,173,53,171,179,147,207,130,180,178,3,230,236,18,50,35,115,161,174,213,154,46,123,118,65,123,165,25,164,99,136,
119,17,92,137,42,45,101,13,206,11,214,91,134,16,34,252,155,160,93,104,228,89,65,187,206,98,191,104,144,189,54,74,63,225,191,59,
122,213,59,250,114,11,253,195,87,70,57,215,50,7,7,166,83,208,154,92,237,68,232,124,138,241,76,212,138,152,60,14,83,142,35,40,
199,161,102,60,91,70,245,105,50,119,185,26,59,42,225,255,40,175,135,181,219,127,169,206,116,152,27,254,85,158,25,180,234,76,158,
39,91,113,86,19,103,164,159,101,43,98,46,200,72,77,30,39,71,140,197,217,61,182,136,92,122,55,93,165,215,165,220,192,120,141,
72,135,178,142,152,28,147,104,21,165,153,49,97,85,130,242,182,91,41,148,93,100,126,231,175,148,249,93,203,153,175,28,15,26,28,
111,2,20,254,187,138,56,106,47,213,201,158,194,196,121,39,247,123,103,175,250,14,162,220,139,62,189,173,254,98,10,204,72,52,
165,232,250,60,31,214,116,3,69,190,53,3,51,248,60,114,113,238,221,141,85,11,122,11,41,48,39,252,122,127,243,76,26,11,237,198,29,
216,231,110,117,47,161,200,30,140,197,133,200,232,106,129,84,43,252,181,191,185,2,109,103,34,239,246,33,207,206,193,109,33,
68,238,111,89,47,237,113,241,27,210,86,204,128,181,87,91,45,208,115,37,172,152,104,186,145,154,173,160,55,252,28,70,236,173,19,
170,125,25,183,247,180,122,126,123,188,26,231,224,24,130,255,99,173,225,95,5,189,152,217,195,36,239,243,93,152,17,127,247,
162,178,160,53,210,255,120,253,231,129,201,239,23,3,174,72,10,187,49,116,6,246,131,242,133,72,106,26,108,118,61,159,82,41,181,7,
212,202,223,33,179,77,182,182,45,125,186,68,90,219,150,30,208,168,100,177,7,138,228,106,242,30,216,6,249,240,111,213,154,7,
204,65,212,7,161,123,198,201,26,29,187,188,204,177,203,103,147,148,133,198,89,82,99,11,218,125,90,182,171,52,171,33,183,137,181,
255,122,112,207,12,200,77,21,49,170,51,186,148,47,152,130,90,17,49,152,86,154,150,60,153,76,199,147,75,62,101,162,74,41,235,
254,137,210,123,13,202,156,213,112,246,197,121,204,28,216,111,129,206,111,176,139,169,64,223,21,182,173,85,239,167,39,247,78,228,
135,211,169,106,71,192,20,11,23,78,180,96,175,185,236,132,63,196,209,199,83,117,41,184,11,22,94,83,131,200,232,65,30,31,148,
209,171,229,215,211,169,218,59,59,115,66,228,6,138,90,150,195,155,138,18,254,10,174,247,141,173,60,64,95,127,156,247,210,151,232,
152,105,9,177,32,252,139,128,25,254,227,49,211,22,98,97,248,153,66,195,214,123,251,208,90,181,87,2,161,114,129,21,133,231,95,
193,86,49,150,24,33,120,83,28,62,193,62,135,155,153,63,200,39,245,252,105,210,139,59,229,141,207,141,179,37,252,191,234,132,25,
11,237,210,178,22,115,95,13,138,128,204,3,121,190,51,49,38,158,77,142,180,67,69,54,167,253,252,90,229,119,1,255,88,40,33,111,
142,133,217,186,155,50,117,161,201,186,128,30,243,237,107,213,247,123,30,240,54,123,202,169,213,179,1,247,46,181,243,60,200,143,
34,185,176,230,195,1,143,184,116,225,83,107,97,183,220,156,128,161,119,180,135,219,244,231,205,164,150,99,75,136,109,12,205,
121,85,63,15,120,22,190,210,76,171,173,60,15,91,24,243,119,181,236,97,235,86,72,15,145,109,10,42,168,229,207,229,224,149,179,167,
216,108,39,248,54,246,83,126,38,79,240,148,229,252,77,158,34,71,80,95,105,55,243,14,183,3,117,225,251,143,121,60,34,252,220,
49,79,142,16,151,134,31,12,122,203,144,28,135,255,156,231,193,222,244,112,6,217,143,214,31,206,198,177,243,178,119,227,226,117,
234,59,56,142,172,93,50,42,201,40,230,184,115,23,56,238,220,179,101,44,133,55,24,45,253,111,28,103,107,241,25,98,105,159,155,
179,78,221,221,248,252,227,220,43,208,220,226,55,225,167,17,156,241,1,145,88,25,166,166,64,248,29,126,167,109,200,28,170,5,242,
55,114,60,203,131,85,243,210,98,6,239,86,15,91,209,3,235,4,220,129,28,190,241,69,124,101,184,45,126,146,207,152,124,246,139,
215,224,123,75,124,231,202,94,32,231,11,44,111,121,173,137,35,33,44,228,33,159,175,44,95,157,179,175,73,11,225,156,181,213,237,
28,145,193,82,250,148,127,245,161,109,171,175,157,38,121,55,128,231,115,87,186,45,7,239,139,224,85,231,214,72,142,7,254,230,
49,144,139,158,21,165,220,170,83,198,134,136,248,90,110,117,126,27,246,219,157,152,117,107,78,19,21,249,158,115,95,252,152,237,
231,156,17,59,121,229,93,244,168,63,152,151,159,25,143,143,117,240,14,120,140,124,222,86,47,188,234,46,65,238,199,42,97,77,
55,226,180,71,198,5,183,140,7,110,74,227,60,41,162,96,94,248,151,121,190,96,94,157,175,200,55,76,225,239,231,249,194,111,241,89,
49,129,21,226,239,215,216,155,14,103,115,185,35,226,162,250,27,196,17,193,121,159,33,115,237,7,215,169,239,225,202,221,176,
185,155,207,34,47,78,116,182,57,206,115,35,114,88,205,199,224,117,128,141,46,193,58,180,186,16,77,15,35,246,132,174,165,91,241,
188,196,85,75,39,202,221,0,57,159,171,210,197,81,118,88,230,2,39,214,127,17,245,172,161,218,19,164,177,166,249,116,212,228,
168,113,9,5,221,249,164,71,96,241,234,113,110,81,230,81,171,119,137,140,227,88,61,81,46,173,37,100,174,42,169,139,45,22,199,234,
182,218,240,173,1,21,51,91,77,143,142,162,42,122,114,212,244,82,248,217,60,87,248,191,242,92,65,119,157,75,157,169,156,87,140,
233,120,185,87,238,7,68,169,139,234,211,123,104,143,180,17,199,6,119,159,250,158,191,28,51,173,144,182,241,146,215,230,243,243,
108,249,254,103,125,54,54,71,4,122,23,22,5,138,3,211,90,144,248,4,172,200,181,234,68,177,229,217,116,135,166,242,140,194,138,
190,126,92,159,81,242,68,233,175,155,73,90,187,167,229,224,235,199,101,91,88,179,86,122,174,58,97,108,89,86,39,12,34,100,113,
248,233,86,225,209,55,25,117,139,137,92,203,107,243,25,212,6,93,200,197,237,160,171,206,86,115,61,91,238,245,173,217,119,99,
107,251,78,188,15,242,253,185,191,47,27,31,55,93,72,243,35,62,153,109,24,178,238,156,62,117,15,229,119,113,1,99,172,255,66,234,
242,115,125,142,220,239,6,13,247,169,223,84,4,138,56,246,241,174,225,53,226,111,45,57,35,51,169,192,80,39,56,191,67,116,195,
130,173,54,162,185,21,126,19,119,24,171,206,136,140,79,35,221,202,14,184,120,247,244,187,34,227,197,224,77,151,217,109,96,90,181,
107,22,252,101,11,237,113,39,86,226,4,140,249,144,213,96,197,29,237,100,43,17,180,196,252,240,127,240,189,245,32,133,255,170,
222,121,122,49,83,254,158,117,174,180,65,105,54,70,93,222,167,222,15,100,98,82,29,98,146,186,135,42,43,29,214,246,136,248,103,
200,221,207,239,166,148,95,88,244,133,62,245,219,15,158,163,87,238,12,142,110,106,39,69,14,171,168,114,171,228,227,30,115,88,
69,148,91,229,90,195,63,13,181,106,134,92,53,67,215,127,17,245,124,170,221,46,189,57,128,186,24,123,138,204,86,236,236,46,163,
236,46,98,207,135,44,172,11,223,235,58,225,214,225,74,132,246,98,87,168,108,33,232,14,223,175,188,62,79,148,185,112,147,242,
20,201,155,212,37,56,19,212,123,154,110,88,101,131,190,127,159,169,227,197,89,58,223,53,104,224,162,250,45,3,217,119,59,127,238,
115,190,219,57,91,204,164,115,140,114,58,219,172,144,111,173,212,173,211,92,175,222,201,7,196,18,196,220,2,156,35,151,203,204,
137,41,103,242,45,243,223,58,238,222,196,39,72,127,103,5,245,163,109,203,252,215,143,111,238,44,167,205,102,57,202,175,28,239,
239,156,9,62,78,205,249,191,58,30,40,12,255,34,243,142,15,231,197,122,245,125,68,53,238,11,253,29,51,233,251,129,3,160,21,84,
100,30,160,133,205,69,178,124,111,213,88,232,32,199,88,255,33,121,62,109,238,192,153,141,157,18,248,227,125,85,5,162,72,92,68,
225,63,64,235,95,213,13,25,103,227,122,237,247,176,89,37,16,196,92,50,239,144,26,215,171,156,66,205,55,95,199,82,131,22,172,
215,239,175,196,228,219,87,147,10,133,126,223,138,179,242,111,199,203,141,58,220,7,182,137,32,45,17,200,162,69,37,214,172,5,25,
121,28,156,160,228,135,95,201,228,248,133,82,135,208,223,149,8,153,193,152,186,175,13,235,213,119,52,101,164,238,200,134,236,
205,146,223,19,151,35,23,170,16,219,80,191,132,56,83,175,69,31,59,208,150,103,18,148,252,240,235,153,59,121,158,238,163,34,219,
71,185,252,13,172,252,158,65,219,130,231,122,99,64,125,199,116,20,244,222,236,175,108,213,159,135,245,115,70,158,127,99,245,
36,120,207,157,196,95,171,249,63,61,169,253,43,39,61,255,37,160,250,204,252,134,137,223,57,90,69,234,183,69,197,69,234,187,152,
242,34,245,155,9,31,232,78,173,55,14,90,131,231,243,65,231,21,169,223,126,44,0,109,47,58,81,127,207,73,207,130,244,247,89,164,
98,25,83,254,45,143,33,105,179,140,149,5,200,150,109,93,87,238,152,147,32,149,211,24,250,201,212,116,57,77,254,78,43,243,61,
146,33,105,147,124,158,173,249,93,89,57,159,110,171,126,101,162,250,90,145,109,47,247,80,22,211,101,236,50,180,141,76,135,173,
20,207,165,121,46,201,83,101,119,86,87,142,166,126,77,3,90,38,160,245,50,175,136,38,191,63,147,239,25,100,6,173,108,207,178,
252,125,242,108,221,47,127,151,59,91,239,197,90,252,181,52,245,235,248,176,68,183,89,162,239,36,44,215,174,247,210,114,93,183,
66,143,223,202,150,229,172,195,100,134,123,113,135,153,67,53,77,45,157,173,77,171,22,118,212,175,234,94,213,90,191,160,179,165,
165,190,99,241,194,230,250,69,93,171,90,22,172,234,90,208,181,184,9,166,69,190,214,62,52,18,79,196,211,203,201,213,174,168,
177,188,141,172,229,109,115,182,240,39,202,254,206,145,137,88,58,153,76,239,92,31,77,68,119,196,198,105,233,201,156,80,108,124,
60,57,190,52,52,148,156,24,25,14,37,146,233,208,142,88,58,148,149,10,245,173,10,165,134,162,137,4,218,174,248,199,218,14,199,
182,71,39,70,156,58,162,195,209,177,52,20,148,117,79,140,142,238,207,242,215,68,211,233,174,232,200,200,182,232,208,249,36,122,
201,232,237,35,179,183,175,143,42,123,55,134,86,237,27,138,141,165,227,73,4,243,157,241,145,88,104,104,36,153,138,39,118,132,
198,146,227,105,170,237,221,248,126,245,163,241,225,56,134,176,39,62,20,35,177,150,172,181,155,187,86,81,225,218,137,161,216,
122,212,244,38,198,38,210,155,88,69,32,195,218,56,145,206,240,124,25,158,124,42,206,60,13,76,140,113,175,13,187,162,123,162,
36,250,200,232,235,37,179,175,87,126,160,7,124,32,179,192,176,205,62,124,88,125,125,91,251,168,166,47,154,24,30,79,198,135,27,
183,101,102,219,152,157,119,135,50,71,27,205,250,32,169,110,57,135,54,170,250,32,33,54,97,27,205,57,157,72,198,202,109,212,
120,90,209,157,209,241,232,16,134,23,79,165,227,67,109,52,247,116,13,186,99,169,161,241,248,88,58,57,62,245,64,70,98,147,242,125,
177,1,229,75,83,207,29,162,92,63,57,218,247,209,199,66,171,227,35,24,100,77,231,68,124,100,152,245,77,101,166,19,68,63,80,164,
63,150,130,203,78,61,91,45,50,16,75,167,225,96,169,201,46,63,96,10,25,225,54,154,145,21,26,74,38,210,177,68,186,177,139,233,
62,116,86,153,173,26,141,13,199,163,141,236,186,141,236,112,153,165,159,247,193,2,189,137,237,201,26,118,85,46,56,135,243,190,
210,109,84,251,193,66,3,233,104,122,2,163,174,126,63,177,236,6,114,186,210,73,50,58,58,212,40,149,147,171,185,248,116,13,54,
38,84,147,141,99,177,68,108,184,15,30,24,147,190,18,58,77,195,15,152,251,228,238,118,174,255,73,66,253,177,161,88,124,15,235,
41,202,138,36,83,141,157,19,137,225,17,44,67,177,147,217,19,101,38,68,75,156,220,77,209,241,161,216,200,230,137,248,112,27,5,
178,21,19,233,248,72,99,95,114,199,41,188,77,209,248,184,163,175,44,175,141,54,159,202,108,63,141,155,156,54,62,224,32,104,
234,27,74,142,54,142,39,71,226,141,187,16,213,26,79,10,109,53,39,71,246,54,106,62,77,139,83,34,106,27,205,255,7,155,56,215,100,
222,63,216,70,73,247,157,70,122,210,42,89,31,124,223,19,167,141,186,255,105,109,147,28,118,209,72,52,117,254,233,13,117,138,
150,211,79,58,51,225,77,209,244,78,14,19,31,40,205,155,117,56,58,178,39,126,126,35,66,107,18,27,24,135,98,227,170,132,62,16,187,
70,162,41,108,232,224,20,50,189,28,137,117,125,213,20,245,235,99,163,219,180,64,12,34,21,83,136,12,196,119,36,16,49,198,177,
75,202,166,168,142,236,28,79,238,69,211,105,125,124,118,54,198,147,141,142,131,187,141,10,21,123,36,154,216,209,168,199,81,228,
96,245,34,78,74,123,5,28,204,141,219,118,197,134,210,39,242,6,210,227,152,105,182,27,201,147,93,71,183,241,254,45,119,176,199,
99,219,27,207,138,69,207,239,143,109,143,141,199,18,72,18,42,62,168,150,55,191,172,150,187,177,99,124,60,186,159,195,82,166,
167,19,185,109,212,53,21,187,253,159,89,237,229,124,232,77,169,228,148,233,46,207,26,97,82,52,117,34,175,39,154,194,142,30,
203,88,213,201,59,85,16,103,214,41,130,224,157,104,130,94,156,164,81,121,214,23,56,184,210,38,254,147,24,109,212,114,18,167,253,
180,7,240,242,19,245,202,238,11,29,140,72,124,148,29,98,218,201,44,181,21,11,79,217,107,212,113,10,107,234,164,213,113,154,
132,82,251,113,240,140,134,82,177,113,153,69,6,78,221,245,228,115,46,26,213,58,143,252,134,174,142,190,190,206,142,174,117,231,
69,206,222,180,234,188,245,29,145,174,158,243,250,54,14,68,72,108,33,99,11,178,198,45,200,115,173,45,189,91,123,201,181,101,
45,242,200,181,96,35,123,220,130,180,210,218,194,121,165,189,69,114,193,145,31,44,221,167,42,81,182,249,115,173,34,200,69,183,
108,37,129,244,19,202,12,228,157,198,96,39,85,15,158,62,21,170,31,252,167,82,139,154,127,64,28,123,119,112,138,125,122,2,51,
179,81,115,163,67,67,177,84,106,245,72,116,71,138,188,72,55,39,162,35,50,231,118,103,174,10,102,116,120,152,159,134,199,33,71,
62,221,123,111,98,56,182,15,173,213,147,108,225,141,142,141,233,140,138,92,209,148,242,196,109,39,165,218,84,150,229,244,173,
146,123,79,173,237,230,205,189,221,20,216,118,74,122,234,208,144,113,164,226,73,78,118,218,41,135,220,121,250,206,145,179,45,
221,161,71,237,217,150,86,114,16,211,165,20,31,232,48,1,185,182,165,249,48,34,123,27,103,147,228,27,210,167,82,100,255,88,140,
92,24,5,210,9,202,31,58,33,25,39,123,104,36,22,29,103,146,76,197,200,141,132,50,1,27,83,174,46,72,133,30,78,51,163,241,68,74,
178,101,105,93,108,191,20,150,54,242,233,66,36,185,25,58,108,236,130,68,154,196,48,121,135,179,121,60,185,244,92,60,138,194,
70,153,210,48,229,101,74,74,65,238,112,214,1,82,153,186,140,201,188,234,81,38,59,57,195,241,113,12,17,97,31,236,120,42,51,116,
87,108,55,150,62,69,57,114,83,118,37,135,97,192,88,230,128,160,134,237,81,92,237,134,67,233,100,104,104,60,22,77,199,66,219,
38,70,244,157,82,233,14,109,31,79,142,134,50,110,226,217,30,79,68,71,226,23,196,168,10,165,225,201,133,90,157,28,119,220,190,148,
112,37,139,100,54,244,84,2,246,246,248,56,156,201,183,29,38,26,206,44,184,151,59,84,110,76,214,14,54,120,14,127,42,99,152,136,
36,228,197,71,70,69,46,151,71,164,107,167,168,140,31,148,231,158,114,45,159,57,89,119,106,12,155,198,149,99,99,35,241,33,121,
170,102,188,189,8,236,83,6,93,234,100,58,115,122,169,229,212,139,24,121,192,150,103,47,21,162,212,173,238,238,153,109,147,35,
89,210,23,242,179,69,181,214,222,236,115,138,220,40,75,231,155,131,66,207,196,40,135,115,108,100,28,190,202,82,83,90,23,162,112,
44,73,134,165,6,214,75,213,40,240,1,121,138,49,54,68,71,153,217,219,157,162,186,83,101,100,22,122,138,96,248,84,65,149,123,
158,34,57,3,146,92,125,242,48,49,185,233,186,170,59,235,204,152,142,30,50,107,144,139,204,43,44,31,242,50,15,19,156,59,145,95,63,
242,49,193,205,186,165,189,149,63,72,209,241,228,88,108,60,29,71,63,5,120,236,143,141,38,211,177,76,208,0,99,64,30,69,58,90,
201,46,101,128,200,219,41,111,33,250,222,66,238,157,209,212,6,118,9,15,10,59,229,46,178,118,38,225,187,57,252,169,124,83,196,201,
140,15,239,35,43,206,102,182,227,114,17,115,226,217,247,33,185,241,84,118,242,252,208,165,118,104,12,19,141,167,86,141,142,
165,247,115,65,218,153,171,39,95,164,120,226,58,37,32,15,167,55,61,220,175,111,151,243,69,138,121,62,2,144,11,31,156,97,120,71,
146,136,117,42,144,187,71,181,135,91,124,158,144,119,52,107,102,42,28,61,101,27,228,143,158,176,10,148,59,234,8,196,198,232,
40,153,163,169,29,248,72,79,144,149,224,181,176,249,19,81,33,17,219,203,123,0,70,73,176,145,204,228,182,93,228,74,110,223,158,
194,112,2,201,68,103,52,61,180,115,50,7,73,81,9,246,216,9,129,23,79,137,29,176,68,241,201,21,236,230,52,237,100,238,89,227,
48,137,212,162,108,136,61,43,251,87,106,200,159,76,76,190,51,145,26,10,157,28,213,58,47,169,239,194,112,68,244,156,159,60,225,106,
204,125,58,159,187,99,35,209,253,96,23,100,216,236,72,123,156,114,42,8,100,38,226,78,38,86,143,76,164,118,146,47,153,88,159,
158,200,176,49,50,30,143,242,194,254,84,42,78,165,204,25,137,243,86,150,227,234,74,142,142,33,2,67,22,45,101,66,33,35,116,230,
73,89,16,198,69,54,148,144,246,210,174,155,234,230,152,143,43,54,100,139,224,242,137,147,98,20,121,153,169,203,121,92,158,116,
176,18,126,60,225,170,121,86,60,189,19,91,169,52,83,49,121,161,212,53,129,76,141,131,151,207,60,199,203,190,28,126,86,59,209,
147,204,228,117,57,153,18,2,20,6,199,135,88,114,178,137,157,220,203,33,179,104,12,238,119,242,4,202,166,96,14,164,99,99,145,
189,73,42,57,161,110,50,152,144,53,198,233,163,37,223,105,230,140,201,116,139,247,133,103,76,103,94,170,36,3,75,126,166,164,35,
150,172,145,217,103,94,166,164,54,186,172,144,81,34,63,83,138,36,87,227,172,35,123,76,206,214,228,45,60,125,60,182,131,223,
175,140,159,248,146,134,92,227,210,115,200,171,168,10,13,170,172,242,173,25,227,56,178,99,169,244,164,111,111,26,143,39,225,27,
251,185,173,92,126,247,184,222,72,96,164,247,68,71,200,26,103,95,50,199,39,18,84,152,202,102,161,250,61,26,21,165,28,217,115,
134,233,206,188,116,246,164,134,118,198,134,113,236,147,43,21,67,218,48,76,86,138,125,171,140,63,213,219,222,157,209,225,80,239,
198,208,100,222,224,225,58,54,51,21,96,143,119,57,83,171,92,48,216,83,215,115,144,204,231,7,157,9,78,196,135,81,185,147,47,
5,216,43,152,168,149,226,68,194,78,201,135,28,73,184,33,229,169,98,58,57,38,31,93,41,117,188,90,41,112,208,115,134,159,3,239,201,
172,114,122,103,28,198,224,207,154,38,84,224,194,130,70,163,99,228,78,39,229,173,141,60,233,164,206,41,166,77,36,166,242,174,
25,39,177,29,62,84,58,145,120,159,181,180,97,251,9,156,14,146,108,220,78,203,197,205,194,157,111,188,65,109,251,140,43,47,106,
171,167,141,226,147,96,80,175,36,7,77,58,44,44,254,71,96,249,116,155,16,100,89,15,25,75,135,221,249,199,77,122,208,200,219,
106,19,125,74,136,251,88,254,10,97,92,39,30,52,220,249,231,247,153,116,84,88,245,71,108,90,182,175,207,69,13,135,47,128,216,126,
169,238,144,84,215,176,47,68,17,241,61,195,61,15,162,87,8,179,193,168,216,107,236,168,232,51,197,167,69,78,195,39,27,182,154,
198,195,70,238,103,182,154,230,35,70,254,186,173,203,30,239,221,104,27,182,73,151,8,169,228,48,61,40,172,119,196,65,241,101,227,
87,120,108,175,199,159,118,250,181,32,119,197,134,15,175,219,95,95,111,76,84,84,154,244,21,209,64,223,6,51,191,189,157,14,25,
60,129,167,248,137,222,147,159,111,11,235,175,226,98,227,22,241,125,12,185,254,22,250,152,97,170,103,212,61,203,18,79,108,93,
70,47,100,10,215,26,166,234,80,117,71,79,24,83,116,118,131,161,58,123,65,118,118,139,252,124,96,82,237,134,243,140,11,51,162,
119,202,202,123,229,231,39,77,131,222,65,125,125,123,61,221,96,26,223,16,215,243,24,174,51,77,46,61,141,30,233,122,71,249,211,
92,126,218,120,15,50,203,214,125,134,110,228,199,219,84,213,151,28,229,163,92,254,155,42,223,202,229,175,27,178,124,51,119,
32,75,71,178,165,127,55,45,250,178,56,42,30,134,206,173,60,187,175,155,24,215,178,118,44,206,215,140,21,125,91,7,151,111,56,119,
121,189,77,198,190,54,23,209,11,178,178,47,110,138,151,69,209,254,199,229,130,214,159,107,147,45,102,86,46,161,223,113,45,189,
46,63,255,34,37,15,238,11,150,211,71,45,246,178,10,227,144,213,102,188,115,225,188,250,39,250,140,252,189,198,158,138,125,251,
246,237,143,163,27,209,165,244,45,93,110,11,122,219,150,203,44,2,126,203,120,83,84,118,28,116,118,245,61,238,201,54,232,144,
75,9,77,247,155,116,187,104,130,204,13,70,237,81,174,164,215,220,220,239,33,211,248,255,162,43,104,210,75,66,8,183,77,166,64,225,
113,203,100,141,194,176,133,139,68,174,77,46,81,105,155,245,82,227,147,150,184,27,230,88,22,175,28,180,140,59,141,133,131,162,
216,111,138,219,141,186,125,198,254,111,179,196,42,151,129,177,254,93,172,162,191,186,197,29,188,0,34,80,96,17,43,252,101,200,
166,153,149,103,208,79,44,243,118,241,75,241,42,87,182,155,57,247,24,162,207,52,161,162,241,160,81,51,207,216,92,97,155,118,
206,66,151,233,202,217,101,185,239,70,187,134,117,166,235,168,40,108,128,91,252,65,204,106,216,101,26,95,52,102,212,99,120,180,
205,54,176,117,110,109,198,140,76,219,101,187,141,221,48,62,90,186,92,238,93,166,231,55,98,154,148,18,166,139,12,95,5,132,32,
98,123,42,233,58,11,142,57,184,108,80,76,47,192,216,69,211,119,108,177,180,189,146,159,140,55,68,29,76,106,27,13,108,88,236,208,
202,142,190,125,23,92,106,211,96,59,253,208,45,167,142,121,223,107,44,220,122,216,36,216,251,126,158,123,32,126,203,158,37,
125,115,108,177,9,91,248,136,92,151,138,101,187,226,139,140,125,21,7,155,91,227,13,149,244,109,139,151,250,17,249,121,191,91,220,
10,53,251,77,55,38,190,236,1,185,108,65,211,248,147,16,183,222,106,90,208,134,217,222,109,8,76,218,60,106,136,93,235,76,251,
14,99,126,92,120,109,187,193,101,215,178,137,49,87,203,182,109,151,49,84,97,187,23,186,132,203,112,89,60,101,227,194,54,84,184,
140,146,181,44,5,63,251,181,219,184,219,184,157,29,160,184,192,164,219,140,186,243,49,192,235,92,232,209,157,127,97,57,61,227,
18,207,242,90,174,51,61,24,3,186,189,93,136,160,233,254,134,176,43,205,156,87,196,138,95,237,15,62,110,218,28,138,214,153,214,
181,98,254,173,194,99,187,235,209,79,249,94,30,192,253,102,46,188,233,1,81,232,183,115,131,198,112,5,6,97,223,98,121,223,226,
21,219,213,208,190,98,165,237,93,164,6,202,86,183,115,150,240,24,93,30,87,142,43,215,72,183,217,185,44,79,7,221,106,12,112,68,
244,254,196,161,227,188,13,237,195,70,240,102,219,12,26,219,43,208,51,198,246,184,41,212,48,8,195,56,104,217,178,143,62,151,
217,208,222,41,151,222,94,215,36,13,99,209,151,212,236,150,29,178,72,187,14,124,185,112,189,41,228,172,172,7,140,21,203,130,188,
29,120,161,15,137,194,130,96,53,214,186,125,249,32,154,195,170,193,114,24,232,41,151,218,241,151,219,6,187,41,74,87,217,130,
173,72,119,217,24,134,123,158,26,134,49,109,167,145,168,88,22,55,242,230,25,123,218,110,17,126,191,236,164,225,186,134,25,244,
61,41,152,31,167,107,92,114,177,183,210,211,106,187,26,225,157,198,96,197,178,67,7,57,174,216,232,248,28,219,192,10,195,142,
60,57,88,160,29,7,194,58,203,122,107,114,236,23,118,216,38,188,24,134,196,250,194,183,97,181,74,83,112,124,124,201,48,239,20,247,
136,79,233,240,78,111,27,226,128,225,174,104,153,241,213,122,147,110,52,234,232,143,28,58,177,253,76,196,253,166,251,108,106,
71,100,186,219,3,223,175,167,217,236,138,159,247,136,155,224,171,8,97,135,132,105,248,230,25,123,43,206,95,182,110,31,60,231,
10,89,147,127,176,214,184,160,66,113,140,176,248,145,81,90,103,204,49,62,33,172,156,191,137,146,92,99,46,56,229,86,201,185,
37,118,201,64,137,71,61,218,37,162,36,10,198,188,146,28,41,90,147,227,130,108,233,100,179,233,198,60,150,19,165,243,39,121,37,74,
121,173,226,24,224,228,79,22,227,147,114,59,140,51,184,173,81,90,83,58,43,211,221,57,178,247,154,201,254,153,113,102,201,234,
12,195,93,114,22,24,203,129,38,72,121,51,76,150,234,41,217,140,207,238,12,211,131,161,15,148,152,89,217,172,70,67,170,232,201,
48,92,96,76,202,200,193,121,49,184,93,106,112,174,210,218,210,217,165,85,165,161,210,202,210,106,81,98,9,83,228,152,101,6,254,
8,163,229,192,1,235,185,217,11,196,129,58,33,142,2,207,3,135,194,112,123,224,24,240,252,28,33,110,60,67,8,254,55,202,228,218,
116,177,135,196,20,32,219,200,113,233,223,225,8,90,118,241,1,235,227,243,172,143,26,200,81,238,159,39,172,35,245,66,60,84,111,
136,159,130,190,1,124,188,65,136,123,129,39,128,3,141,8,240,238,92,217,174,7,237,30,110,236,21,47,54,10,235,137,38,33,94,2,14,
53,11,113,61,240,34,240,151,102,50,132,55,223,16,87,134,182,64,244,208,252,179,196,209,249,66,60,12,60,7,188,4,28,105,17,226,
46,224,49,224,121,224,21,224,221,22,178,132,237,199,100,5,55,141,162,233,149,11,182,137,135,22,96,4,11,133,120,114,17,180,3,135,
22,147,219,29,40,86,98,250,239,14,200,62,191,216,48,46,91,34,140,107,150,154,198,187,75,133,241,110,155,105,220,181,204,107,
220,184,124,167,245,238,10,83,60,221,9,75,117,153,226,249,110,204,174,219,16,151,173,194,72,87,99,8,107,240,12,188,180,22,186,
215,163,143,13,224,3,87,110,52,196,189,27,193,223,4,75,156,9,235,158,9,11,24,51,5,255,57,32,208,225,145,129,139,49,169,1,76,
38,194,191,206,11,122,133,247,99,226,208,1,235,181,8,215,30,218,44,114,110,4,46,219,146,253,255,149,156,191,233,201,252,223,129,
252,91,149,204,255,31,200,191,83,201,252,31,130,252,59,149,16,169,255,71,144,127,171,147,249,191,4,93,52,249,255,9,154,126,
245,59,26,249,123,170,144,250,127,164,54,129,225,10,41,25,254,247,244,194,175,126,251,206,255,6,222,8,169,126,249,255,31,52,181,
60,255,27,109,43,164,126,151,196,255,142,219,14,169,241,241,191,193,39,173,135,255,77,62,255,152,71,254,155,184,77,68,255,7,
100,114,50,46,48,81,0,0,0,0};

#define JNI_CLASS_MEMBERS(METHOD, STATICMETHOD, FIELD, STATICFIELD, CALLBACK) \
 STATICMETHOD (getAndroidMidiDeviceManager, "getAndroidMidiDeviceManager", "(Landroid/content/Context;)Lcom/roli/juce/JuceMidiSupport$MidiDeviceManager;") \
 STATICMETHOD (getAndroidBluetoothManager,  "getAndroidBluetoothManager",  "(Landroid/content/Context;)Lcom/roli/juce/JuceMidiSupport$BluetoothManager;")

DECLARE_JNI_CLASS_WITH_BYTECODE (JuceMidiSupport, "com/roli/juce/JuceMidiSupport", 23, javaMidiByteCode, sizeof (javaMidiByteCode))
#undef JNI_CLASS_MEMBERS

#define JNI_CLASS_MEMBERS(METHOD, STATICMETHOD, FIELD, STATICFIELD, CALLBACK) \
 METHOD (getJuceAndroidMidiInputDeviceNameAndIDs,  "getJuceAndroidMidiInputDeviceNameAndIDs",  "()[Ljava/lang/String;") \
 METHOD (getJuceAndroidMidiOutputDeviceNameAndIDs, "getJuceAndroidMidiOutputDeviceNameAndIDs", "()[Ljava/lang/String;") \
 METHOD (openMidiInputPortWithID,                  "openMidiInputPortWithID",                  "(IJ)Lcom/roli/juce/JuceMidiSupport$JuceMidiPort;") \
 METHOD (openMidiOutputPortWithID,                 "openMidiOutputPortWithID",                 "(I)Lcom/roli/juce/JuceMidiSupport$JuceMidiPort;")

DECLARE_JNI_CLASS_WITH_MIN_SDK (MidiDeviceManager, "com/roli/juce/JuceMidiSupport$MidiDeviceManager", 23)
#undef JNI_CLASS_MEMBERS

#define JNI_CLASS_MEMBERS(METHOD, STATICMETHOD, FIELD, STATICFIELD, CALLBACK) \
 METHOD (start,    "start",    "()V") \
 METHOD (stop,     "stop",     "()V") \
 METHOD (close,    "close",    "()V") \
 METHOD (sendMidi, "sendMidi", "([BII)V") \
 METHOD (getName,  "getName",  "()Ljava/lang/String;")

DECLARE_JNI_CLASS_WITH_MIN_SDK (JuceMidiPort, "com/roli/juce/JuceMidiSupport$JuceMidiPort", 23)
#undef JNI_CLASS_MEMBERS

//==============================================================================
class AndroidMidiInput
{
public:
    AndroidMidiInput (MidiInput* midiInput, int deviceID, juce::MidiInputCallback* midiInputCallback, jobject deviceManager)
        : juceMidiInput (midiInput), callback (midiInputCallback), midiConcatenator (2048),
          javaMidiDevice (LocalRef<jobject>(getEnv()->CallObjectMethod (deviceManager, MidiDeviceManager.openMidiInputPortWithID,
                                                                        (jint) deviceID, (jlong) this)))
    {
    }

    ~AndroidMidiInput()
    {
        if (jobject d = javaMidiDevice.get())
        {
            getEnv()->CallVoidMethod (d, JuceMidiPort.close);
            javaMidiDevice.clear();
        }
    }

    bool isOpen() const noexcept
    {
        return javaMidiDevice != nullptr;
    }

    void start()
    {
        if (jobject d = javaMidiDevice.get())
            getEnv()->CallVoidMethod (d, JuceMidiPort.start);
    }

    void stop()
    {
        if (jobject d = javaMidiDevice.get())
            getEnv()->CallVoidMethod (d, JuceMidiPort.stop);

        callback = nullptr;
    }

    String getName() const noexcept
    {
        if (jobject d = javaMidiDevice.get())
            return juceString (LocalRef<jstring> ((jstring) getEnv()->CallObjectMethod (d, JuceMidiPort.getName)));

        return {};
    }

    void handleMidi (jbyteArray byteArray, jlong offset, jint len, jlong timestamp)
    {
        auto* env = getEnv();

        jassert (byteArray != nullptr);
        auto* data = env->GetByteArrayElements (byteArray, nullptr);

        HeapBlock<uint8> buffer (static_cast<size_t> (len));
        std::memcpy (buffer.get(), data + offset, static_cast<size_t> (len));

        midiConcatenator.pushMidiData (buffer.get(),
                                       len, static_cast<double> (timestamp) * 1.0e-9,
                                       juceMidiInput, *callback);

        env->ReleaseByteArrayElements (byteArray, data, 0);
    }

    static void handleReceive (JNIEnv*, jobject, jlong host, jbyteArray byteArray,
                               jint offset, jint len, jlong timestamp)
    {
        auto* myself = reinterpret_cast<AndroidMidiInput*> (host);

        myself->handleMidi (byteArray, offset, len, timestamp);
    }

private:
    MidiInput* juceMidiInput;
    MidiInputCallback* callback;
    MidiDataConcatenator midiConcatenator;
    GlobalRef javaMidiDevice;
};

//==============================================================================
class AndroidMidiOutput
{
public:
    AndroidMidiOutput (const LocalRef<jobject>& midiDevice)
        : javaMidiDevice (midiDevice)
    {
    }

    ~AndroidMidiOutput()
    {
        if (jobject d = javaMidiDevice.get())
        {
            getEnv()->CallVoidMethod (d, JuceMidiPort.close);
            javaMidiDevice.clear();
        }
    }

    void send (jbyteArray byteArray, jint offset, jint len)
    {
        if (jobject d = javaMidiDevice.get())
            getEnv()->CallVoidMethod (d,
                                      JuceMidiPort.sendMidi,
                                      byteArray, offset, len);
    }

    String getName() const noexcept
    {
        if (jobject d = javaMidiDevice.get())
            return juceString (LocalRef<jstring> ((jstring) getEnv()->CallObjectMethod (d, JuceMidiPort.getName)));

        return {};
    }

private:
    GlobalRef javaMidiDevice;
};

//==============================================================================
#define JNI_CLASS_MEMBERS(METHOD, STATICMETHOD, FIELD, STATICFIELD, CALLBACK) \
 CALLBACK (AndroidMidiInput::handleReceive, "handleReceive", "(J[BIIJ)V" )

DECLARE_JNI_CLASS_WITH_MIN_SDK (JuceMidiInputPort, "com/roli/juce/JuceMidiSupport$JuceMidiInputPort", 23)
#undef JNI_CLASS_MEMBERS

//==============================================================================
class AndroidMidiDeviceManager
{
public:
    AndroidMidiDeviceManager()
        : deviceManager (LocalRef<jobject>(getEnv()->CallStaticObjectMethod (JuceMidiSupport,
                                                                             JuceMidiSupport.getAndroidMidiDeviceManager,
                                                                             getAppContext().get())))
    {
    }

    Array<MidiDeviceInfo> getDevices (bool input)
    {
        if (jobject dm = deviceManager.get())
        {
            jobjectArray jDeviceNameAndIDs
                = (jobjectArray) getEnv()->CallObjectMethod (dm, input ? MidiDeviceManager.getJuceAndroidMidiInputDeviceNameAndIDs
                                                                       : MidiDeviceManager.getJuceAndroidMidiOutputDeviceNameAndIDs);

            // Create a local reference as converting this to a JUCE string will call into JNI
            LocalRef<jobjectArray> localDeviceNameAndIDs (jDeviceNameAndIDs);

            auto deviceNameAndIDs = javaStringArrayToJuce (localDeviceNameAndIDs);
            deviceNameAndIDs.appendNumbersToDuplicates (false, false, CharPointer_UTF8 ("-"), CharPointer_UTF8 (""));

            Array<MidiDeviceInfo> devices;

            for (int i = 0; i < deviceNameAndIDs.size(); i += 2)
                devices.add ({ deviceNameAndIDs[i], deviceNameAndIDs[i + 1] });

            return devices;
        }

        return {};
    }

    AndroidMidiInput* openMidiInputPortWithID (int deviceID, MidiInput* juceMidiInput, juce::MidiInputCallback* callback)
    {
        if (auto dm = deviceManager.get())
        {
            std::unique_ptr<AndroidMidiInput> androidMidiInput (new AndroidMidiInput (juceMidiInput, deviceID, callback, dm));

            if (androidMidiInput->isOpen())
                return androidMidiInput.release();
        }

        return nullptr;
    }

    AndroidMidiOutput* openMidiOutputPortWithID (int deviceID)
    {
        if (auto dm = deviceManager.get())
            if (auto javaMidiPort = getEnv()->CallObjectMethod (dm, MidiDeviceManager.openMidiOutputPortWithID, (jint) deviceID))
                return new AndroidMidiOutput (LocalRef<jobject>(javaMidiPort));

        return nullptr;
    }

private:
    GlobalRef deviceManager;
};

//==============================================================================
Array<MidiDeviceInfo> MidiInput::getAvailableDevices()
{
    if (getAndroidSDKVersion() < 23)
        return {};

    AndroidMidiDeviceManager manager;
    return manager.getDevices (true);
}

MidiDeviceInfo MidiInput::getDefaultDevice()
{
    if (getAndroidSDKVersion() < 23)
        return {};

    return getAvailableDevices().getFirst();
}

std::unique_ptr<MidiInput> MidiInput::openDevice (const String& deviceIdentifier, MidiInputCallback* callback)
{
    if (getAndroidSDKVersion() < 23 || deviceIdentifier.isEmpty())
        return {};

    AndroidMidiDeviceManager manager;

    std::unique_ptr<MidiInput> midiInput (new MidiInput ({}, deviceIdentifier));

    if (auto* port = manager.openMidiInputPortWithID (deviceIdentifier.getIntValue(), midiInput.get(), callback))
    {
        midiInput->internal = port;
        midiInput->setName (port->getName());

        return midiInput;
    }

    return {};
}

StringArray MidiInput::getDevices()
{
    if (getAndroidSDKVersion() < 23)
        return {};

    StringArray deviceNames;

    for (auto& d : getAvailableDevices())
        deviceNames.add (d.name);

    return deviceNames;
}

int MidiInput::getDefaultDeviceIndex()
{
    return (getAndroidSDKVersion() < 23 ? -1 : 0);
}

std::unique_ptr<MidiInput> MidiInput::openDevice (int index, MidiInputCallback* callback)
{
    return openDevice (getAvailableDevices()[index].identifier, callback);
}

MidiInput::MidiInput (const String& deviceName, const String& deviceIdentifier)
    : deviceInfo (deviceName, deviceIdentifier)
{
}

MidiInput::~MidiInput()
{
    delete reinterpret_cast<AndroidMidiInput*> (internal);
}

void MidiInput::start()
{
    if (auto* mi = reinterpret_cast<AndroidMidiInput*> (internal))
        mi->start();
}

void MidiInput::stop()
{
    if (auto* mi = reinterpret_cast<AndroidMidiInput*> (internal))
        mi->stop();
}

//==============================================================================
Array<MidiDeviceInfo> MidiOutput::getAvailableDevices()
{
    if (getAndroidSDKVersion() < 23)
        return {};

    AndroidMidiDeviceManager manager;
    return manager.getDevices (false);
}

MidiDeviceInfo MidiOutput::getDefaultDevice()
{
    if (getAndroidSDKVersion() < 23)
        return {};

    return getAvailableDevices().getFirst();
}

std::unique_ptr<MidiOutput> MidiOutput::openDevice (const String& deviceIdentifier)
{
    if (getAndroidSDKVersion() < 23 || deviceIdentifier.isEmpty())
        return {};

    AndroidMidiDeviceManager manager;

    if (auto* port = manager.openMidiOutputPortWithID (deviceIdentifier.getIntValue()))
    {
        std::unique_ptr<MidiOutput> midiOutput (new MidiOutput ({}, deviceIdentifier));
        midiOutput->internal = port;
        midiOutput->setName (port->getName());

        return midiOutput;
    }

    return {};
}

StringArray MidiOutput::getDevices()
{
    if (getAndroidSDKVersion() < 23)
        return {};

    StringArray deviceNames;

    for (auto& d : getAvailableDevices())
        deviceNames.add (d.name);

    return deviceNames;
}

int MidiOutput::getDefaultDeviceIndex()
{
    return (getAndroidSDKVersion() < 23 ? -1 : 0);
}

std::unique_ptr<MidiOutput> MidiOutput::openDevice (int index)
{
    return openDevice (getAvailableDevices()[index].identifier);
}

MidiOutput::~MidiOutput()
{
    stopBackgroundThread();

    delete reinterpret_cast<AndroidMidiOutput*> (internal);
}

void MidiOutput::sendMessageNow (const MidiMessage& message)
{
    if (auto* androidMidi = reinterpret_cast<AndroidMidiOutput*>(internal))
    {
        auto* env = getEnv();
        auto messageSize = message.getRawDataSize();

        LocalRef<jbyteArray> messageContent (env->NewByteArray (messageSize));
        auto content = messageContent.get();

        auto* rawBytes = env->GetByteArrayElements (content, nullptr);
        std::memcpy (rawBytes, message.getRawData(), static_cast<size_t> (messageSize));
        env->ReleaseByteArrayElements (content, rawBytes, 0);

        androidMidi->send (content, (jint) 0, (jint) messageSize);
    }
}

} // namespace juce
