# _ProcessWindows
<span class="source-link">[[Source]](src/process/_process.md#L331)</span>
```pony
class ref _ProcessWindows is
  _Process ref
```

#### Implements

* [_Process](process-_Process.md) ref

---

## Constructors

### create
<span class="source-link">[[Source]](src/process/_process.md#L335)</span>


```pony
new ref create(
  path: String val,
  args: Array[String val] val,
  vars: Array[String val] val,
  wdir: (FilePath val | None val),
  stdin: _Pipe ref,
  stdout: _Pipe ref,
  stderr: _Pipe ref)
: _ProcessWindows ref^
```
#### Parameters

*   path: [String](builtin-String.md) val
*   args: [Array](builtin-Array.md)\[[String](builtin-String.md) val\] val
*   vars: [Array](builtin-Array.md)\[[String](builtin-String.md) val\] val
*   wdir: ([FilePath](files-FilePath.md) val | [None](builtin-None.md) val)
*   stdin: [_Pipe](process-_Pipe.md) ref
*   stdout: [_Pipe](process-_Pipe.md) ref
*   stderr: [_Pipe](process-_Pipe.md) ref

#### Returns

* [_ProcessWindows](process-_ProcessWindows.md) ref^

---

## Public fields

### let hProcess: [USize](builtin-USize.md) val
<span class="source-link">[[Source]](src/process/_process.md#L332)</span>



---

### let processError: ([ProcessError](process-ProcessError.md) val | [None](builtin-None.md) val)
<span class="source-link">[[Source]](src/process/_process.md#L333)</span>



---

## Public Functions

### kill
<span class="source-link">[[Source]](src/process/_process.md#L410)</span>


```pony
fun box kill()
: None val
```

#### Returns

* [None](builtin-None.md) val

---

### wait
<span class="source-link">[[Source]](src/process/_process.md#L415)</span>


```pony
fun ref wait()
: (Exited val | Signaled val | WaitpidError val | 
    _StillRunning val)
```

#### Returns

* ([Exited](process-Exited.md) val | [Signaled](process-Signaled.md) val | [WaitpidError](process-WaitpidError.md) val | 
    [_StillRunning](process-_StillRunning.md) val)

---

## Private Functions

### _make_cmdline
<span class="source-link">[[Source]](src/process/_process.md#L380)</span>


```pony
fun tag _make_cmdline(
  args: Array[String val] val)
: String val
```
#### Parameters

*   args: [Array](builtin-Array.md)\[[String](builtin-String.md) val\] val

#### Returns

* [String](builtin-String.md) val

---

### _make_environ
<span class="source-link">[[Source]](src/process/_process.md#L396)</span>


```pony
fun tag _make_environ(
  vars: Array[String val] val)
: Array[U8 val] ref
```
#### Parameters

*   vars: [Array](builtin-Array.md)\[[String](builtin-String.md) val\] val

#### Returns

* [Array](builtin-Array.md)\[[U8](builtin-U8.md) val\] ref

---

