/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jsampler.CC;
import org.jsampler.HF;
import org.jsampler.MidiInstrumentMap;
import org.jsampler.view.MidiMapTable;
import org.jsampler.view.std.JSAddMidiInstrumentMapDlg;
import org.jsampler.view.std.StdI18n;

public class JSManageMidiMapsPane
extends JPanel
implements ListSelectionListener {
    protected final MidiMapTable midiMapTable = new MidiMapTable();
    protected final Action actionAddMap = new AddMapAction();
    protected final Action actionEditMap = new EditMapAction();
    protected final Action actionRemoveMap = new RemoveMapAction();

    public JSManageMidiMapsPane() {
        this.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.midiMapTable);
        this.add(jScrollPane);
        this.installListeneres();
    }

    private void installListeneres() {
        this.midiMapTable.getSelectionModel().addListSelectionListener(this);
        this.midiMapTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() < 2) {
                    return;
                }
                if (JSManageMidiMapsPane.this.midiMapTable.getSelectedMidiInstrumentMap() == null) {
                    return;
                }
                JSManageMidiMapsPane.this.editMidiInstrumentMap(JSManageMidiMapsPane.this.midiMapTable.getSelectedMidiInstrumentMap());
            }
        });
        KeyStroke keyStroke = KeyStroke.getKeyStroke(127, 0);
        this.midiMapTable.getInputMap(0).put(keyStroke, "removeMidiMap");
        this.midiMapTable.getActionMap().put("removeMidiMap", this.actionRemoveMap);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        boolean bl = this.midiMapTable.getSelectedMidiInstrumentMap() != null;
        this.actionEditMap.setEnabled(bl);
        this.actionRemoveMap.setEnabled(bl);
    }

    public void addMidiInstrumentMap() {
        JSAddMidiInstrumentMapDlg jSAddMidiInstrumentMapDlg = new JSAddMidiInstrumentMapDlg();
        jSAddMidiInstrumentMapDlg.setVisible(true);
        if (jSAddMidiInstrumentMapDlg.isCancelled()) {
            return;
        }
        CC.getSamplerModel().addBackendMidiInstrumentMap(jSAddMidiInstrumentMapDlg.getMapName());
    }

    public void editMidiInstrumentMap(MidiInstrumentMap midiInstrumentMap) {
        int n = midiInstrumentMap.getMapId();
        JSAddMidiInstrumentMapDlg jSAddMidiInstrumentMapDlg = new JSAddMidiInstrumentMapDlg();
        jSAddMidiInstrumentMapDlg.setTitle(StdI18n.i18n.getLabel("JSManageMidiMapsPane.editMap"));
        jSAddMidiInstrumentMapDlg.setMapName(midiInstrumentMap.getName());
        jSAddMidiInstrumentMapDlg.setVisible(true);
        if (jSAddMidiInstrumentMapDlg.isCancelled()) {
            return;
        }
        midiInstrumentMap.setName(jSAddMidiInstrumentMapDlg.getMapName());
        CC.getSamplerModel().setBackendMidiInstrumentMapName(n, jSAddMidiInstrumentMapDlg.getMapName());
    }

    private class RemoveMapAction
    extends AbstractAction {
        RemoveMapAction() {
            super(StdI18n.i18n.getLabel("JSManageMidiMapsPane.removeMap"));
            String string = StdI18n.i18n.getLabel("JSManageMidiMapsPane.removeMap.tt");
            this.putValue("ShortDescription", string);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MidiInstrumentMap midiInstrumentMap = JSManageMidiMapsPane.this.midiMapTable.getSelectedMidiInstrumentMap();
            if (midiInstrumentMap.getAllMidiInstruments().length > 0) {
                String string = StdI18n.i18n.getMessage("JSManageMidiMapsPane.removeMap", midiInstrumentMap.getName());
                String string2 = StdI18n.i18n.getMessage("JSManageMidiMapsPane.removeMap?");
                if (!HF.showYesNoDialog(JSManageMidiMapsPane.this, string2, string)) {
                    return;
                }
            }
            CC.getSamplerModel().removeBackendMidiInstrumentMap(midiInstrumentMap.getMapId());
        }
    }

    private class EditMapAction
    extends AbstractAction {
        EditMapAction() {
            super(StdI18n.i18n.getLabel("JSManageMidiMapsPane.editMap"));
            String string = StdI18n.i18n.getLabel("JSManageMidiMapsPane.editMap.tt");
            this.putValue("ShortDescription", string);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JSManageMidiMapsPane.this.editMidiInstrumentMap(JSManageMidiMapsPane.this.midiMapTable.getSelectedMidiInstrumentMap());
        }
    }

    private class AddMapAction
    extends AbstractAction {
        AddMapAction() {
            super(StdI18n.i18n.getLabel("JSManageMidiMapsPane.addMap"));
            String string = StdI18n.i18n.getLabel("JSManageMidiMapsPane.addMap.tt");
            this.putValue("ShortDescription", string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JSManageMidiMapsPane.this.addMidiInstrumentMap();
        }
    }
}

