/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view;

import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jsampler.CC;
import org.jsampler.view.InstrumentsDbTreeModel;
import org.linuxsampler.lscp.DbDirectoryInfo;
import org.linuxsampler.lscp.DbInstrumentInfo;

public class DbClipboard {
    private Operation operation = Operation.NONE;
    private DbDirectoryInfo[] directories = new DbDirectoryInfo[0];
    private DbInstrumentInfo[] instruments = new DbInstrumentInfo[0];
    private final Vector<ChangeListener> listeners = new Vector();

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public DbDirectoryInfo[] getDirectories() {
        boolean bl = false;
        InstrumentsDbTreeModel instrumentsDbTreeModel = CC.getInstrumentsDbTreeModel();
        for (int i = 0; i < this.directories.length; ++i) {
            if (instrumentsDbTreeModel.getNodeByPath(this.directories[i].getDirectoryPath()) != null) continue;
            bl = true;
            this.directories[i] = null;
        }
        if (!bl) {
            return this.directories;
        }
        Vector<DbDirectoryInfo> vector = new Vector<DbDirectoryInfo>();
        for (DbDirectoryInfo dbDirectoryInfo : this.directories) {
            if (dbDirectoryInfo == null) continue;
            vector.add(dbDirectoryInfo);
        }
        this.instruments = vector.toArray(new DbInstrumentInfo[vector.size()]);
        return this.directories;
    }

    public void setDirectories(DbDirectoryInfo[] dbDirectoryInfoArray) {
        this.directories = dbDirectoryInfoArray;
        this.fireChangeEvent();
    }

    public DbInstrumentInfo[] getInstruments() {
        boolean bl = false;
        InstrumentsDbTreeModel instrumentsDbTreeModel = CC.getInstrumentsDbTreeModel();
        for (int i = 0; i < this.instruments.length; ++i) {
            DbInstrumentInfo[] dbInstrumentInfoArray = instrumentsDbTreeModel.getNodeByPath(this.instruments[i].getDirectoryPath());
            if (dbInstrumentInfoArray == null) {
                bl = true;
                this.instruments[i] = null;
                continue;
            }
            if (dbInstrumentInfoArray.getInstrument(this.instruments[i].getName()) != null) continue;
            bl = true;
            this.instruments[i] = null;
        }
        if (!bl) {
            return this.instruments;
        }
        Vector<DbInstrumentInfo> vector = new Vector<DbInstrumentInfo>();
        for (DbInstrumentInfo dbInstrumentInfo : this.instruments) {
            if (dbInstrumentInfo == null) continue;
            vector.add(dbInstrumentInfo);
        }
        this.instruments = vector.toArray(new DbInstrumentInfo[vector.size()]);
        return this.instruments;
    }

    public void setInstruments(DbInstrumentInfo[] dbInstrumentInfoArray) {
        this.instruments = dbInstrumentInfoArray;
        this.fireChangeEvent();
    }

    private void fireChangeEvent() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public static enum Operation {
        CUT,
        COPY,
        NONE;

    }
}

