/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import java.util.Arrays;

class RunnableQueue {
    private Runnable[] queue = new Runnable[32];
    private int start;
    private int count;

    RunnableQueue() {
    }

    private int modulo(int n) {
        if (n >= this.queue.length) {
            n -= this.queue.length;
        }
        return n;
    }

    synchronized void postRunnable(Runnable runnable) {
        if (this.count == this.queue.length) {
            Runnable[] runnableArray = new Runnable[this.queue.length * 3 / 2];
            System.arraycopy(this.queue, this.start, runnableArray, 0, this.queue.length - this.start);
            System.arraycopy(this.queue, 0, runnableArray, this.queue.length - this.start, this.start);
            this.queue = runnableArray;
            this.start = 0;
        }
        this.queue[this.modulo((int)(this.start + this.count))] = runnable;
        ++this.count;
        this.notifyAll();
    }

    synchronized Runnable getNextRunnable() throws InterruptedException {
        while (this.count == 0) {
            this.wait();
        }
        Runnable runnable = this.queue[this.start];
        this.queue[this.start] = null;
        this.start = this.modulo(this.start + 1);
        --this.count;
        return runnable;
    }

    synchronized void clear() {
        Arrays.fill(this.queue, null);
        this.count = 0;
    }
}

