/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.bcel.classfile;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tomcat.util.bcel.classfile.Annotations;
import org.apache.tomcat.util.bcel.classfile.ClassFormatException;
import org.apache.tomcat.util.bcel.classfile.ConstantPool;
import org.apache.tomcat.util.bcel.classfile.ConstantUtf8;
import org.apache.tomcat.util.bcel.classfile.JavaClass;
import org.apache.tomcat.util.bcel.classfile.Utility;

public final class ClassParser {
    private static final int MAGIC = -889275714;
    private final DataInput dataInputStream;
    private String class_name;
    private String superclassName;
    private int accessFlags;
    private String[] interfaceNames;
    private ConstantPool constantPool;
    private Annotations runtimeVisibleAnnotations;
    private static final int BUFSIZE = 8192;
    private static final String[] INTERFACES_EMPTY_ARRAY = new String[0];

    public ClassParser(InputStream inputStream) {
        this.dataInputStream = new DataInputStream(new BufferedInputStream(inputStream, 8192));
    }

    public JavaClass parse() throws IOException, ClassFormatException {
        this.readID();
        this.readVersion();
        this.readConstantPool();
        this.readClassInfo();
        this.readInterfaces();
        this.readFields();
        this.readMethods();
        this.readAttributes();
        return new JavaClass(this.class_name, this.superclassName, this.accessFlags, this.constantPool, this.interfaceNames, this.runtimeVisibleAnnotations);
    }

    private void readAttributes() throws IOException, ClassFormatException {
        int n = this.dataInputStream.readUnsignedShort();
        for (int i = 0; i < n; ++i) {
            int n2 = this.dataInputStream.readUnsignedShort();
            ConstantUtf8 constantUtf8 = (ConstantUtf8)this.constantPool.getConstant(n2, (byte)1);
            String string = constantUtf8.getBytes();
            int n3 = this.dataInputStream.readInt();
            if (string.equals("RuntimeVisibleAnnotations")) {
                if (this.runtimeVisibleAnnotations != null) {
                    throw new ClassFormatException("RuntimeVisibleAnnotations attribute is not allowed more than once in a class file");
                }
                this.runtimeVisibleAnnotations = new Annotations(this.dataInputStream, this.constantPool);
                continue;
            }
            Utility.skipFully(this.dataInputStream, n3);
        }
    }

    private void readClassInfo() throws IOException, ClassFormatException {
        this.accessFlags = this.dataInputStream.readUnsignedShort();
        if ((this.accessFlags & 0x200) != 0) {
            this.accessFlags |= 0x400;
        }
        if ((this.accessFlags & 0x400) != 0 && (this.accessFlags & 0x10) != 0) {
            throw new ClassFormatException("Class can't be both final and abstract");
        }
        int n = this.dataInputStream.readUnsignedShort();
        this.class_name = Utility.getClassName(this.constantPool, n);
        int n2 = this.dataInputStream.readUnsignedShort();
        this.superclassName = n2 > 0 ? Utility.getClassName(this.constantPool, n2) : "java.lang.Object";
    }

    private void readConstantPool() throws IOException, ClassFormatException {
        this.constantPool = new ConstantPool(this.dataInputStream);
    }

    private void readFields() throws IOException, ClassFormatException {
        int n = this.dataInputStream.readUnsignedShort();
        for (int i = 0; i < n; ++i) {
            Utility.swallowFieldOrMethod(this.dataInputStream);
        }
    }

    private void readID() throws IOException, ClassFormatException {
        if (this.dataInputStream.readInt() != -889275714) {
            throw new ClassFormatException("It is not a Java .class file");
        }
    }

    private void readInterfaces() throws IOException, ClassFormatException {
        int n = this.dataInputStream.readUnsignedShort();
        if (n > 0) {
            this.interfaceNames = new String[n];
            for (int i = 0; i < n; ++i) {
                int n2 = this.dataInputStream.readUnsignedShort();
                this.interfaceNames[i] = Utility.getClassName(this.constantPool, n2);
            }
        } else {
            this.interfaceNames = INTERFACES_EMPTY_ARRAY;
        }
    }

    private void readMethods() throws IOException, ClassFormatException {
        int n = this.dataInputStream.readUnsignedShort();
        for (int i = 0; i < n; ++i) {
            Utility.swallowFieldOrMethod(this.dataInputStream);
        }
    }

    private void readVersion() throws IOException, ClassFormatException {
        Utility.skipFully(this.dataInputStream, 4);
    }
}

