/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;

public class Tile {
    public static BufferedImage LOADING_IMAGE;
    public static BufferedImage ERROR_IMAGE;
    protected TileSource source;
    protected int xtile;
    protected int ytile;
    protected int zoom;
    protected BufferedImage image;
    protected String key;
    protected boolean loaded = false;
    protected boolean loading = false;
    protected boolean error = false;
    protected String error_message;
    protected Map<String, String> metadata;

    public Tile(TileSource source, int xtile, int ytile, int zoom) {
        this.source = source;
        this.xtile = xtile;
        this.ytile = ytile;
        this.zoom = zoom;
        this.image = LOADING_IMAGE;
        this.key = Tile.getTileKey(source, xtile, ytile, zoom);
    }

    public Tile(TileSource source, int xtile, int ytile, int zoom, BufferedImage image) {
        this(source, xtile, ytile, zoom);
        this.image = image;
    }

    public void loadPlaceholderFromCache(TileCache cache) {
        BufferedImage tmpImage = new BufferedImage(this.source.getTileSize(), this.source.getTileSize(), 1);
        Graphics2D g = (Graphics2D)tmpImage.getGraphics();
        for (int zoomDiff = 1; zoomDiff < 5; ++zoomDiff) {
            int zoom_low;
            int zoom_high = this.zoom + zoomDiff;
            if (zoomDiff < 3 && zoom_high <= 22) {
                int factor = 1 << zoomDiff;
                int xtile_high = this.xtile << zoomDiff;
                int ytile_high = this.ytile << zoomDiff;
                double scale = 1.0 / (double)factor;
                g.setTransform(AffineTransform.getScaleInstance(scale, scale));
                int paintedTileCount = 0;
                for (int x = 0; x < factor; ++x) {
                    for (int y = 0; y < factor; ++y) {
                        Tile tile = cache.getTile(this.source, xtile_high + x, ytile_high + y, zoom_high);
                        if (tile == null || !tile.isLoaded()) continue;
                        ++paintedTileCount;
                        tile.paint(g, x * this.source.getTileSize(), y * this.source.getTileSize());
                    }
                }
                if (paintedTileCount == factor * factor) {
                    this.image = tmpImage;
                    return;
                }
            }
            if ((zoom_low = this.zoom - zoomDiff) < 0) continue;
            int xtile_low = this.xtile >> zoomDiff;
            int ytile_low = this.ytile >> zoomDiff;
            int factor = 1 << zoomDiff;
            double scale = factor;
            AffineTransform at = new AffineTransform();
            int translate_x = this.xtile % factor * this.source.getTileSize();
            int translate_y = this.ytile % factor * this.source.getTileSize();
            at.setTransform(scale, 0.0, 0.0, scale, -translate_x, -translate_y);
            g.setTransform(at);
            Tile tile = cache.getTile(this.source, xtile_low, ytile_low, zoom_low);
            if (tile == null || !tile.isLoaded()) continue;
            tile.paint(g, 0, 0);
            this.image = tmpImage;
            return;
        }
    }

    public TileSource getSource() {
        return this.source;
    }

    public int getXtile() {
        return this.xtile;
    }

    public int getYtile() {
        return this.ytile;
    }

    public int getZoom() {
        return this.zoom;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    public void loadImage(InputStream input) throws IOException {
        this.image = ImageIO.read(input);
    }

    public String getKey() {
        return this.key;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public String getUrl() throws IOException {
        return this.source.getTileUrl(this.zoom, this.xtile, this.ytile);
    }

    public void paint(Graphics g, int x, int y) {
        if (this.image == null) {
            return;
        }
        g.drawImage(this.image, x, y, null);
    }

    public String toString() {
        return "Tile " + this.key;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.xtile;
        result = 31 * result + this.ytile;
        result = 31 * result + this.zoom;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tile other = (Tile)obj;
        if (this.xtile != other.xtile) {
            return false;
        }
        if (this.ytile != other.ytile) {
            return false;
        }
        return this.zoom == other.zoom;
    }

    public static String getTileKey(TileSource source, int xtile, int ytile, int zoom) {
        return zoom + "/" + xtile + "/" + ytile + "@" + source.getName();
    }

    public String getStatus() {
        if (this.error) {
            return "error";
        }
        if (this.loaded) {
            return "loaded";
        }
        if (this.loading) {
            return "loading";
        }
        return "new";
    }

    public boolean hasError() {
        return this.error;
    }

    public String getErrorMessage() {
        return this.error_message;
    }

    public void setError(String message) {
        this.error = true;
        this.setImage(ERROR_IMAGE);
        this.error_message = message;
    }

    public void putValue(String key, String value) {
        if (value == null || value.isEmpty()) {
            if (this.metadata != null) {
                this.metadata.remove(key);
            }
            return;
        }
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, value);
    }

    public String getValue(String key) {
        if (this.metadata == null) {
            return null;
        }
        return this.metadata.get(key);
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    static {
        try {
            LOADING_IMAGE = ImageIO.read(JMapViewer.class.getResourceAsStream("images/hourglass.png"));
            ERROR_IMAGE = ImageIO.read(JMapViewer.class.getResourceAsStream("images/error.png"));
        }
        catch (Exception e1) {
            LOADING_IMAGE = null;
            ERROR_IMAGE = null;
        }
    }
}

