/*
 * Decompiled with CFR 0.152.
 */
package accessories.plugins;

import freemind.extensions.ExportHook;
import freemind.main.Resources;
import freemind.main.Tools;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class ExportToOoWriter
extends ExportHook {
    private static Logger logger = null;

    public ExportToOoWriter() {
        if (logger == null) {
            logger = Resources.getInstance().getLogger(this.getClass().getName());
        }
    }

    @Override
    public void startupMapHook() {
        super.startupMapHook();
        File chosenFile = this.chooseFile(this.getResourceString("file_type"), null, null);
        if (chosenFile == null) {
            return;
        }
        this.getController().getFrame().setWaitingCursor(true);
        try {
            this.exportToOoWriter(chosenFile);
        }
        catch (IOException e) {
            Resources.getInstance().logException(e);
        }
        this.getController().getFrame().setWaitingCursor(false);
    }

    public boolean exportToOoWriter(File chosenFile) throws IOException {
        StringWriter writer = new StringWriter();
        this.getController().getMap().getFilteredXml(writer);
        String xslts = this.getResourceString("files");
        return this.exportToOoWriter(chosenFile, writer, xslts);
    }

    private boolean applyXsltFile(String xsltFileName, StringWriter writer, Result result) throws IOException {
        URL xsltUrl = this.getResource(xsltFileName);
        if (xsltUrl == null) {
            logger.severe("Can't find " + xsltFileName + " as resource.");
            throw new IllegalArgumentException("Can't find " + xsltFileName + " as resource.");
        }
        InputStream xsltStream = xsltUrl.openStream();
        StreamSource xsltSource = new StreamSource(xsltStream);
        try {
            StringReader reader = new StringReader(writer.getBuffer().toString());
            TransformerFactory transFact = TransformerFactory.newInstance();
            Transformer trans = transFact.newTransformer(xsltSource);
            trans.setParameter("date", DateFormat.getDateInstance(3).format(new Date()));
            trans.transform(new StreamSource(reader), result);
            return true;
        }
        catch (Exception e) {
            Resources.getInstance().logException(e);
            return false;
        }
    }

    public boolean exportToOoWriter(File file, StringWriter writer, String xslts) throws IOException {
        boolean resultValue = true;
        ZipOutputStream zipout = new ZipOutputStream(new FileOutputStream(file));
        StreamResult result = new StreamResult(zipout);
        StringTokenizer tokenizer = new StringTokenizer(xslts, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            String[] files = token.split("->");
            if (files.length != 2) continue;
            ZipEntry entry = new ZipEntry(files[1]);
            zipout.putNextEntry(entry);
            if (files[0].endsWith(".xsl")) {
                logger.info("Transforming with xslt " + files[0] + " to file " + files[1]);
                resultValue &= this.applyXsltFile(files[0], writer, result);
            } else {
                logger.info("Copying resource from " + files[0] + " to file " + files[1]);
                resultValue &= this.copyFromResource(files[0], zipout);
            }
            zipout.closeEntry();
        }
        zipout.close();
        return resultValue;
    }

    private boolean copyFromResource(String fileName, OutputStream out) {
        try {
            logger.finest("searching for " + fileName);
            URL resource = this.getResource(fileName);
            if (resource == null) {
                logger.severe("Cannot find resource: " + fileName);
                return false;
            }
            InputStream in = resource.openStream();
            Tools.copyStream(in, out, false);
            return true;
        }
        catch (Exception e) {
            logger.severe("File not found or could not be copied. Was earching for " + fileName + " and should go to " + out);
            Resources.getInstance().logException(e);
            return false;
        }
    }
}

