/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller;

import freemind.controller.Controller;
import freemind.controller.MindMapNodesSelection;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.modes.MindMapNode;
import freemind.view.mindmapview.MainView;
import java.awt.Cursor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;

public class NodeDragListener
implements DragGestureListener {
    private final Controller c;

    public NodeDragListener(Controller controller) {
        this.c = controller;
    }

    public Cursor getCursorByAction(int dragAction) {
        switch (dragAction) {
            case 1: {
                return DragSource.DefaultCopyDrop;
            }
            case 0x40000000: {
                return DragSource.DefaultLinkDrop;
            }
        }
        return DragSource.DefaultMoveDrop;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
        boolean otherOsLinkAction;
        if (!Resources.getInstance().getBoolProperty("draganddrop")) {
            return;
        }
        MindMapNode node = ((MainView)e.getComponent()).getNodeView().getModel();
        if (node.isRoot()) {
            return;
        }
        String dragAction = "MOVE";
        Cursor cursor = this.getCursorByAction(e.getDragAction());
        int modifiersEx = e.getTriggerEvent().getModifiersEx();
        boolean macLinkAction = Tools.isMacOsX() && (modifiersEx & 0x400) != 0 && e.getTriggerEvent().isMetaDown();
        boolean bl = otherOsLinkAction = (modifiersEx & 0x1000) != 0;
        if (macLinkAction || otherOsLinkAction) {
            cursor = DragSource.DefaultLinkDrop;
            dragAction = "LINK";
        }
        if ((modifiersEx & 0x800) != 0) {
            cursor = DragSource.DefaultCopyDrop;
            dragAction = "COPY";
        }
        Transferable t = this.c.getModeController().copy();
        ((MindMapNodesSelection)t).setDropAction(dragAction);
        e.startDrag(cursor, t, new DragSourceListener(){

            @Override
            public void dragDropEnd(DragSourceDropEvent dsde) {
            }

            @Override
            public void dragEnter(DragSourceDragEvent e) {
            }

            @Override
            public void dragExit(DragSourceEvent dse) {
            }

            @Override
            public void dragOver(DragSourceDragEvent dsde) {
            }

            @Override
            public void dropActionChanged(DragSourceDragEvent dsde) {
                dsde.getDragSourceContext().setCursor(NodeDragListener.this.getCursorByAction(dsde.getUserAction()));
            }
        });
    }
}

