/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools.groovydoc;

import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.ant.Groovydoc;
import org.codehaus.groovy.groovydoc.GroovyDoc;

public class SimpleGroovyDoc
implements GroovyDoc {
    private String name;
    private String commentText;
    private String rawCommentText;
    private String firstSentenceCommentText;
    private List links;
    private int definitionType;
    private final int CLASS = 0;
    private final int INTERFACE = 1;

    public SimpleGroovyDoc(String name, List links) {
        this.name = name;
        this.links = links;
        this.setRawCommentText("");
        this.definitionType = 0;
    }

    public SimpleGroovyDoc(String name) {
        this(name, new ArrayList());
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return "" + this.getClass() + "(" + this.name + ")";
    }

    public String commentText() {
        return this.commentText;
    }

    public String getRawCommentText() {
        return this.rawCommentText;
    }

    public String firstSentenceCommentText() {
        return this.firstSentenceCommentText;
    }

    public void setRawCommentText(String rawCommentText) {
        this.rawCommentText = rawCommentText;
        this.commentText = rawCommentText.replaceAll("(?m)^\\s*\\*", "");
        BreakIterator boundary = BreakIterator.getSentenceInstance(Locale.getDefault());
        boundary.setText(this.commentText);
        int start = boundary.first();
        int end = boundary.next();
        this.firstSentenceCommentText = start > -1 && end > -1 ? this.commentText.substring(start, end) : this.commentText;
        this.commentText = this.replaceAllTags(this.commentText, "(?m)@([a-z]*)\\s*(.*)$", "<DL><DT><B>$1:</B></DT><DD>", "</DD></DL>");
        this.firstSentenceCommentText = this.firstSentenceCommentText.replaceAll("(?m)@([a-z]*\\s*.*)$", "");
    }

    public String replaceAllTags(String self, String regex, String s1, String s2) {
        Matcher matcher = Pattern.compile(regex).matcher(self);
        if (matcher.find()) {
            matcher.reset();
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                if (matcher.group(1).equals("see")) {
                    matcher.appendReplacement(sb, s1 + this.getDocUrl(matcher.group(2)) + s2);
                    continue;
                }
                matcher.appendReplacement(sb, s1 + "$2" + s2);
            }
            matcher.appendTail(sb);
            return sb.toString();
        }
        return self;
    }

    public String getDocUrl(String type) {
        if (type == null || type.indexOf(46) == -1) {
            return type;
        }
        String[] target = type.split("#");
        String shortClassName = target[0].replaceAll(".*\\.", "");
        String packageName = type.substring(0, type.length() - shortClassName.length() - 2);
        shortClassName = shortClassName + (target.length > 1 ? "#" + target[1].split("\\(")[0] : "");
        for (int i = 0; i < this.links.size(); ++i) {
            Groovydoc.LinkArgument linkArgument = (Groovydoc.LinkArgument)this.links.get(i);
            StringTokenizer tokenizer = new StringTokenizer(linkArgument.getPackages(), ", ");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (!type.startsWith(token)) continue;
                String apiBaseUrl = linkArgument.getHref();
                if (!apiBaseUrl.endsWith("/")) {
                    apiBaseUrl = apiBaseUrl + "/";
                }
                String url = apiBaseUrl + target[0].replaceAll("\\.", "/") + ".html" + (target.length > 1 ? "#" + target[1] : "");
                return "<a href='" + url + "' title='" + shortClassName + "'>" + shortClassName + "</a>";
            }
        }
        return type;
    }

    public boolean isClass() {
        return this.definitionType == 0;
    }

    public boolean isInterface() {
        return this.definitionType == 1;
    }

    public void setAsInterfaceDefinition() {
        this.definitionType = 1;
    }

    public int compareTo(Object that) {
        if (that instanceof SimpleGroovyDoc) {
            return this.name.compareTo(((SimpleGroovyDoc)that).name);
        }
        throw new ClassCastException();
    }

    public boolean isAnnotationType() {
        return false;
    }

    public boolean isAnnotationTypeElement() {
        return false;
    }

    public boolean isConstructor() {
        return false;
    }

    public boolean isEnum() {
        return false;
    }

    public boolean isEnumConstant() {
        return false;
    }

    public boolean isError() {
        return false;
    }

    public boolean isException() {
        return false;
    }

    public boolean isField() {
        return false;
    }

    public boolean isIncluded() {
        return false;
    }

    public boolean isMethod() {
        return false;
    }

    public boolean isOrdinaryClass() {
        return false;
    }
}

