/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions.args;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.Named;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegisterArg
extends InsnArg
implements Named {
    public static final String THIS_ARG_NAME = "this";
    public static final String SUPER_ARG_NAME = "super";
    protected final int regNum;
    private SSAVar sVar;

    public RegisterArg(int rn, ArgType type) {
        this.type = type;
        this.regNum = rn;
    }

    public int getRegNum() {
        return this.regNum;
    }

    @Override
    public boolean isRegister() {
        return true;
    }

    public ArgType getInitType() {
        return this.type;
    }

    @Override
    public ArgType getType() {
        if (this.sVar != null) {
            return this.sVar.getTypeInfo().getType();
        }
        return ArgType.UNKNOWN;
    }

    @Override
    public void setType(ArgType newType) {
        if (this.sVar == null) {
            throw new JadxRuntimeException("Can't change type for register without SSA variable: " + this);
        }
        this.sVar.setType(newType);
    }

    public void forceSetInitType(ArgType type) {
        this.type = type;
    }

    @Nullable
    public ArgType getImmutableType() {
        if (this.sVar != null) {
            return this.sVar.getImmutableType();
        }
        if (this.contains(AFlag.IMMUTABLE_TYPE)) {
            return this.type;
        }
        return null;
    }

    @Override
    public boolean isTypeImmutable() {
        if (this.sVar != null) {
            return this.sVar.isTypeImmutable();
        }
        return this.contains(AFlag.IMMUTABLE_TYPE);
    }

    public SSAVar getSVar() {
        return this.sVar;
    }

    void setSVar(@NotNull SSAVar sVar) {
        this.sVar = sVar;
    }

    @Override
    public String getName() {
        if (this.isSuper()) {
            return SUPER_ARG_NAME;
        }
        if (this.isThis()) {
            return THIS_ARG_NAME;
        }
        if (this.sVar == null) {
            return null;
        }
        return this.sVar.getName();
    }

    private boolean isSuper() {
        return this.contains(AFlag.SUPER);
    }

    @Override
    public void setName(String name) {
        if (this.sVar != null && name != null) {
            this.sVar.setName(name);
        }
    }

    public void setNameIfUnknown(String name) {
        if (this.getName() == null) {
            this.setName(name);
        }
    }

    public boolean isNameEquals(InsnArg arg) {
        String n = this.getName();
        if (n == null || !(arg instanceof Named)) {
            return false;
        }
        return n.equals(((Named)((Object)arg)).getName());
    }

    @Override
    public RegisterArg duplicate() {
        return this.duplicate(this.getRegNum(), this.getInitType(), this.sVar);
    }

    public RegisterArg duplicate(ArgType initType) {
        return this.duplicate(this.getRegNum(), initType, this.sVar);
    }

    public RegisterArg duplicateWithNewSSAVar(MethodNode mth) {
        RegisterArg duplicate = this.duplicate(this.regNum, this.getInitType(), null);
        mth.makeNewSVar(duplicate);
        return duplicate;
    }

    public RegisterArg duplicate(int regNum, @Nullable SSAVar sVar) {
        return this.duplicate(regNum, this.getInitType(), sVar);
    }

    public RegisterArg duplicate(int regNum, ArgType initType, @Nullable SSAVar sVar) {
        RegisterArg dup = new RegisterArg(regNum, initType);
        if (sVar != null) {
            dup.setSVar(sVar);
        }
        return this.copyCommonParams(dup);
    }

    @Nullable
    public InsnNode getAssignInsn() {
        if (this.sVar == null) {
            return null;
        }
        return this.sVar.getAssign().getParentInsn();
    }

    public boolean equalRegisterAndType(RegisterArg arg) {
        return this.regNum == arg.regNum && this.type.equals(arg.type);
    }

    public boolean sameRegAndSVar(InsnArg arg) {
        if (this == arg) {
            return true;
        }
        if (!arg.isRegister()) {
            return false;
        }
        RegisterArg reg = (RegisterArg)arg;
        return this.regNum == reg.getRegNum() && Objects.equals(this.sVar, reg.getSVar());
    }

    public boolean sameReg(InsnArg arg) {
        if (!arg.isRegister()) {
            return false;
        }
        return this.regNum == ((RegisterArg)arg).getRegNum();
    }

    public boolean sameCodeVar(RegisterArg arg) {
        return this.getSVar().getCodeVar() == arg.getSVar().getCodeVar();
    }

    public int hashCode() {
        return this.regNum;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RegisterArg)) {
            return false;
        }
        RegisterArg other = (RegisterArg)obj;
        return this.regNum == other.regNum && Objects.equals(this.sVar, other.getSVar());
    }

    public String toString() {
        ArgType type;
        StringBuilder sb = new StringBuilder();
        sb.append("(r").append(this.regNum);
        if (this.sVar != null) {
            sb.append('v').append(this.sVar.getVersion());
        }
        if (this.getName() != null) {
            sb.append(" '").append(this.getName()).append('\'');
        }
        ArgType argType = type = this.sVar != null ? this.getType() : null;
        if (type != null) {
            sb.append(' ').append(type);
        }
        ArgType initType = this.getInitType();
        if (type == null || !type.equals(initType) && !type.isTypeKnown()) {
            sb.append(" I:").append(initType);
        }
        if (!this.isAttrStorageEmpty()) {
            sb.append(' ').append(this.getAttributesString());
        }
        sb.append(')');
        return sb.toString();
    }
}

