/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.nodes;

import jadx.api.plugins.input.data.ICodeReader;
import jadx.api.plugins.input.data.IDebugInfo;
import jadx.api.plugins.input.data.IMethodData;
import jadx.api.plugins.input.data.annotations.IAnnotation;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.annotations.AnnotationsList;
import jadx.core.dex.attributes.annotations.MethodParameters;
import jadx.core.dex.attributes.nodes.LoopInfo;
import jadx.core.dex.attributes.nodes.NotificationAttrNode;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.InsnDecoder;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.ICodeNode;
import jadx.core.dex.nodes.ILoadable;
import jadx.core.dex.nodes.IMethodDetails;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.nodes.utils.TypeUtils;
import jadx.core.dex.regions.Region;
import jadx.core.dex.trycatch.ExceptionHandler;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.DecodeException;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodNode
extends NotificationAttrNode
implements IMethodDetails,
ILoadable,
ICodeNode,
Comparable<MethodNode> {
    private static final Logger LOG = LoggerFactory.getLogger(MethodNode.class);
    private final MethodInfo mthInfo;
    private final ClassNode parentClass;
    private AccessInfo accFlags;
    private final ICodeReader codeReader;
    private final boolean methodIsVirtual;
    private final int insnsCount;
    private boolean noCode;
    private int regsCount;
    private boolean loaded;
    private ArgType retType;
    private List<ArgType> argTypes;
    private List<ArgType> typeParameters;
    private RegisterArg thisArg;
    private List<RegisterArg> argsList;
    private InsnNode[] instructions;
    private List<BlockNode> blocks;
    private BlockNode enterBlock;
    private List<BlockNode> exitBlocks;
    private List<SSAVar> sVars;
    private List<ExceptionHandler> exceptionHandlers;
    private List<LoopInfo> loops;
    private Region region;
    private List<MethodNode> useIn = Collections.emptyList();

    public static MethodNode build(ClassNode classNode, IMethodData methodData) {
        MethodNode methodNode = new MethodNode(classNode, methodData);
        AnnotationsList.attach(methodNode, methodData.getAnnotations());
        MethodParameters.attach(methodNode, methodData.getParamsAnnotations());
        return methodNode;
    }

    private MethodNode(ClassNode classNode, IMethodData mthData) {
        this.mthInfo = MethodInfo.fromRef(classNode.root(), mthData.getMethodRef());
        this.parentClass = classNode;
        this.accFlags = new AccessInfo(mthData.getAccessFlags(), AccessInfo.AFType.METHOD);
        this.methodIsVirtual = !mthData.isDirect();
        ICodeReader codeReader = mthData.getCodeReader();
        boolean bl = this.noCode = codeReader == null;
        if (this.noCode) {
            this.codeReader = null;
            this.insnsCount = 0;
        } else {
            this.codeReader = codeReader.copy();
            this.insnsCount = codeReader.getInsnsCount();
        }
        this.retType = this.mthInfo.getReturnType();
        this.argTypes = this.mthInfo.getArgumentsTypes();
        this.typeParameters = Collections.emptyList();
        this.unload();
    }

    @Override
    public void unload() {
        this.loaded = false;
        if (this.noCode) {
            return;
        }
        this.thisArg = null;
        this.argsList = null;
        this.sVars = Collections.emptyList();
        this.instructions = null;
        this.blocks = null;
        this.enterBlock = null;
        this.exitBlocks = null;
        this.region = null;
        this.exceptionHandlers = Collections.emptyList();
        this.loops = Collections.emptyList();
        this.unloadAttributes();
    }

    public void updateTypes(List<ArgType> argTypes, ArgType retType) {
        this.argTypes = argTypes;
        this.retType = retType;
    }

    public void updateTypeParameters(List<ArgType> typeParameters) {
        this.typeParameters = typeParameters;
    }

    @Override
    public void load() throws DecodeException {
        if (this.loaded) {
            return;
        }
        try {
            this.loaded = true;
            if (this.noCode) {
                this.regsCount = 0;
                this.initArguments(this.argTypes);
                return;
            }
            this.regsCount = this.codeReader.getRegistersCount();
            this.initArguments(this.argTypes);
            InsnDecoder decoder = new InsnDecoder(this);
            this.instructions = decoder.process(this.codeReader);
        }
        catch (Exception e) {
            if (!this.noCode) {
                this.unload();
                this.noCode = true;
                this.load();
                this.noCode = false;
            }
            throw new DecodeException(this, "Load method exception: " + e.getMessage(), (Throwable)e);
        }
    }

    public void checkInstructions() {
        ArrayList<RegisterArg> list = new ArrayList<RegisterArg>();
        for (InsnNode insnNode : this.instructions) {
            if (insnNode == null) continue;
            list.clear();
            RegisterArg resultArg = insnNode.getResult();
            if (resultArg != null) {
                list.add(resultArg);
            }
            insnNode.getRegisterArgs(list);
            for (RegisterArg arg : list) {
                if (arg.getRegNum() < this.regsCount) continue;
                throw new JadxRuntimeException("Incorrect register number in instruction: " + insnNode + ", expected to be less than " + this.regsCount);
            }
        }
    }

    public void reload() {
        this.unload();
        try {
            this.load();
        }
        catch (DecodeException e) {
            throw new JadxRuntimeException("Failed to reload method " + this.getClass().getName() + "." + this.getName());
        }
    }

    private void initArguments(List<ArgType> args) {
        int pos;
        if (this.noCode) {
            pos = 1;
        } else {
            pos = this.regsCount;
            for (ArgType arg : args) {
                pos -= arg.getRegCount();
            }
        }
        TypeUtils typeUtils = this.root().getTypeUtils();
        if (this.accFlags.isStatic()) {
            this.thisArg = null;
        } else {
            ArgType thisClsType = typeUtils.expandTypeVariables(this, this.parentClass.getType());
            RegisterArg arg = InsnArg.reg(pos - 1, thisClsType);
            arg.add(AFlag.THIS);
            arg.add(AFlag.IMMUTABLE_TYPE);
            this.thisArg = arg;
        }
        if (args.isEmpty()) {
            this.argsList = Collections.emptyList();
            return;
        }
        this.argsList = new ArrayList<RegisterArg>(args.size());
        for (ArgType argType : args) {
            ArgType expandedType = typeUtils.expandTypeVariables(this, argType);
            RegisterArg regArg = InsnArg.reg(pos, expandedType);
            regArg.add(AFlag.METHOD_ARGUMENT);
            regArg.add(AFlag.IMMUTABLE_TYPE);
            this.argsList.add(regArg);
            pos += argType.getRegCount();
        }
    }

    @Override
    @NotNull
    public List<ArgType> getArgTypes() {
        if (this.argTypes == null) {
            throw new JadxRuntimeException("Method generic types not initialized: " + this);
        }
        return this.argTypes;
    }

    public void updateArgTypes(List<ArgType> newArgTypes, String comment) {
        this.addDebugComment(comment + ", original types: " + this.getArgTypes());
        this.argTypes = Collections.unmodifiableList(newArgTypes);
        this.initArguments(newArgTypes);
    }

    public boolean containsGenericArgs() {
        return !Objects.equals(this.mthInfo.getArgumentsTypes(), this.getArgTypes());
    }

    @Override
    @NotNull
    public ArgType getReturnType() {
        return this.retType;
    }

    public void updateReturnType(ArgType type) {
        this.retType = type;
    }

    public boolean isVoidReturn() {
        return this.mthInfo.getReturnType().equals(ArgType.VOID);
    }

    public List<RegisterArg> getArgRegs() {
        if (this.argsList == null) {
            throw new JadxRuntimeException("Method arg registers not loaded: " + this + ", class status: " + (Object)((Object)this.parentClass.getTopParentClass().getState()));
        }
        return this.argsList;
    }

    public List<RegisterArg> getAllArgRegs() {
        List<RegisterArg> argRegs = this.getArgRegs();
        if (this.thisArg != null) {
            ArrayList<RegisterArg> list = new ArrayList<RegisterArg>(argRegs.size() + 1);
            list.add(this.thisArg);
            list.addAll(argRegs);
            return list;
        }
        return argRegs;
    }

    @Nullable
    public RegisterArg getThisArg() {
        return this.thisArg;
    }

    public void skipFirstArgument() {
        this.add(AFlag.SKIP_FIRST_ARG);
    }

    @Override
    public List<ArgType> getTypeParameters() {
        return this.typeParameters;
    }

    public String getName() {
        return this.mthInfo.getName();
    }

    public String getAlias() {
        return this.mthInfo.getAlias();
    }

    public ClassNode getParentClass() {
        return this.parentClass;
    }

    public boolean isNoCode() {
        return this.noCode;
    }

    public InsnNode[] getInstructions() {
        return this.instructions;
    }

    public void unloadInsnArr() {
        this.instructions = null;
    }

    public void initBasicBlocks() {
        this.blocks = new ArrayList<BlockNode>();
        this.exitBlocks = new ArrayList<BlockNode>(1);
    }

    public void finishBasicBlocks() {
        this.blocks = Utils.lockList(this.blocks);
        this.exitBlocks = Utils.lockList(this.exitBlocks);
        this.loops = Utils.lockList(this.loops);
        this.blocks.forEach(BlockNode::lock);
    }

    public List<BlockNode> getBasicBlocks() {
        return this.blocks;
    }

    public BlockNode getEnterBlock() {
        return this.enterBlock;
    }

    public void setEnterBlock(BlockNode enterBlock) {
        this.enterBlock = enterBlock;
    }

    public List<BlockNode> getExitBlocks() {
        return this.exitBlocks;
    }

    public void addExitBlock(BlockNode exitBlock) {
        this.exitBlocks.add(exitBlock);
    }

    public void registerLoop(LoopInfo loop) {
        if (this.loops.isEmpty()) {
            this.loops = new ArrayList<LoopInfo>(5);
        }
        loop.setId(this.loops.size());
        this.loops.add(loop);
    }

    @Nullable
    public LoopInfo getLoopForBlock(BlockNode block) {
        if (this.loops.isEmpty()) {
            return null;
        }
        for (LoopInfo loop : this.loops) {
            if (!loop.getLoopBlocks().contains(block)) continue;
            return loop;
        }
        return null;
    }

    public List<LoopInfo> getAllLoopsForBlock(BlockNode block) {
        if (this.loops.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<LoopInfo> list = new ArrayList<LoopInfo>(this.loops.size());
        for (LoopInfo loop : this.loops) {
            if (!loop.getLoopBlocks().contains(block)) continue;
            list.add(loop);
        }
        return list;
    }

    public int getLoopsCount() {
        return this.loops.size();
    }

    public Iterable<LoopInfo> getLoops() {
        return this.loops;
    }

    public ExceptionHandler addExceptionHandler(ExceptionHandler handler) {
        if (this.exceptionHandlers.isEmpty()) {
            this.exceptionHandlers = new ArrayList<ExceptionHandler>(2);
        } else {
            for (ExceptionHandler h : this.exceptionHandlers) {
                if (h.equals(handler)) {
                    return h;
                }
                if (h.getHandleOffset() != handler.getHandleOffset()) continue;
                if (h.getTryBlock() == handler.getTryBlock()) {
                    for (ClassInfo catchType : handler.getCatchTypes()) {
                        h.addCatchType(catchType);
                    }
                }
                return h;
            }
        }
        this.exceptionHandlers.add(handler);
        return handler;
    }

    public boolean clearExceptionHandlers() {
        return this.exceptionHandlers.removeIf(ExceptionHandler::isRemoved);
    }

    public Iterable<ExceptionHandler> getExceptionHandlers() {
        return this.exceptionHandlers;
    }

    public boolean isNoExceptionHandlers() {
        return this.exceptionHandlers.isEmpty();
    }

    public int getExceptionHandlersCount() {
        return this.exceptionHandlers.size();
    }

    @Override
    public List<ArgType> getThrows() {
        IAnnotation an = this.getAnnotation("Ldalvik/annotation/Throws;");
        if (an == null) {
            return Collections.emptyList();
        }
        List types = (List)an.getDefaultValue().getValue();
        return Utils.collectionMap(types, ev -> ArgType.object((String)ev.getValue()));
    }

    public boolean isArgsOverloaded() {
        MethodInfo thisMthInfo = this.mthInfo;
        for (MethodNode method : this.parentClass.getMethods()) {
            if (method == this || !method.getMethodInfo().isOverloadedBy(thisMthInfo)) continue;
            return true;
        }
        return this.root().getMethodUtils().isMethodArgsOverloaded(this.parentClass.getClassInfo().getType(), thisMthInfo);
    }

    public boolean isConstructor() {
        return this.accFlags.isConstructor() && this.mthInfo.isConstructor();
    }

    public boolean isDefaultConstructor() {
        if (this.isConstructor()) {
            int defaultArgCount = 0;
            if (this.parentClass.getClassInfo().isInner() && !this.parentClass.getAccessFlags().isStatic()) {
                ClassNode outerCls = this.parentClass.getParentClass();
                if (this.argsList != null && !this.argsList.isEmpty() && this.argsList.get(0).getInitType().equals(outerCls.getClassInfo().getType())) {
                    defaultArgCount = 1;
                }
            }
            return this.argsList == null || this.argsList.size() == defaultArgCount;
        }
        return false;
    }

    public boolean isVirtual() {
        return this.methodIsVirtual;
    }

    public int getRegsCount() {
        return this.regsCount;
    }

    public SSAVar makeNewSVar(@NotNull RegisterArg assignArg) {
        int regNum = assignArg.getRegNum();
        return this.makeNewSVar(regNum, this.getNextSVarVersion(regNum), assignArg);
    }

    public SSAVar makeNewSVar(int regNum, int version, @NotNull RegisterArg assignArg) {
        SSAVar var = new SSAVar(regNum, version, assignArg);
        if (this.sVars.isEmpty()) {
            this.sVars = new ArrayList<SSAVar>();
        }
        this.sVars.add(var);
        return var;
    }

    public int getNextSVarVersion(int regNum) {
        int v = -1;
        for (SSAVar sVar : this.sVars) {
            if (sVar.getRegNum() != regNum) continue;
            v = Math.max(v, sVar.getVersion());
        }
        return ++v;
    }

    public void removeSVar(SSAVar var) {
        this.sVars.remove(var);
    }

    public List<SSAVar> getSVars() {
        return this.sVars;
    }

    @Override
    public AccessInfo getAccessFlags() {
        return this.accFlags;
    }

    @Override
    public void setAccessFlags(AccessInfo newAccessFlags) {
        this.accFlags = newAccessFlags;
    }

    public Region getRegion() {
        return this.region;
    }

    public void setRegion(Region region) {
        this.region = region;
    }

    @Override
    public RootNode root() {
        return this.parentClass.root();
    }

    @Override
    public String typeName() {
        return "method";
    }

    @Override
    public String getInputFileName() {
        return this.parentClass.getInputFileName();
    }

    @Override
    public MethodInfo getMethodInfo() {
        return this.mthInfo;
    }

    public long getMethodCodeOffset() {
        return this.noCode ? 0L : (long)this.codeReader.getCodeOffset();
    }

    @Nullable
    public IDebugInfo getDebugInfo() {
        return this.noCode ? null : this.codeReader.getDebugInfo();
    }

    public long countInsns() {
        if (this.instructions != null) {
            return this.instructions.length;
        }
        if (this.blocks != null) {
            return this.blocks.stream().mapToLong(block -> block.getInstructions().size()).sum();
        }
        return -1L;
    }

    public int getInsnsCount() {
        return this.insnsCount;
    }

    @Override
    public boolean isVarArg() {
        return this.accFlags.isVarArgs();
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public ICodeReader getCodeReader() {
        return this.codeReader;
    }

    public List<MethodNode> getUseIn() {
        return this.useIn;
    }

    public void setUseIn(List<MethodNode> useIn) {
        this.useIn = useIn;
    }

    public int hashCode() {
        return this.mthInfo.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MethodNode other = (MethodNode)obj;
        return this.mthInfo.equals(other.mthInfo);
    }

    @Override
    public int compareTo(@NotNull MethodNode o) {
        return this.mthInfo.compareTo(o.mthInfo);
    }

    public String toString() {
        return this.parentClass + "." + this.mthInfo.getName() + '(' + Utils.listToString(this.argTypes) + "):" + this.retType;
    }
}

