/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.xmlgen.entry;

import jadx.core.dex.nodes.RootNode;
import jadx.core.xmlgen.ParserConstants;
import jadx.core.xmlgen.ResTableParser;
import jadx.core.xmlgen.entry.RawNamedValue;
import jadx.core.xmlgen.entry.RawValue;
import jadx.core.xmlgen.entry.ResourceEntry;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValuesParser
extends ParserConstants {
    private static final Logger LOG = LoggerFactory.getLogger(ValuesParser.class);
    private static Map<Integer, String> androidResMap;
    private final String[] strings;
    private final Map<Integer, String> resMap;

    public ValuesParser(RootNode root, String[] strings, Map<Integer, String> resMap) {
        this.strings = strings;
        this.resMap = resMap;
        if (androidResMap == null) {
            try {
                ValuesParser.decodeAndroid(root);
            }
            catch (Exception e) {
                LOG.error("Failed to decode Android Resource file", (Throwable)e);
            }
        }
    }

    private static void decodeAndroid(RootNode root) throws IOException {
        try (BufferedInputStream inputStream = new BufferedInputStream(ValuesParser.class.getResourceAsStream("/resources.arsc"));){
            ResTableParser androidParser = new ResTableParser(root);
            androidParser.decode(inputStream);
            androidResMap = androidParser.getResStorage().getResourcesNames();
        }
    }

    @Nullable
    public String getSimpleValueString(ResourceEntry ri) {
        RawValue simpleValue = ri.getSimpleValue();
        if (simpleValue == null) {
            return null;
        }
        return this.decodeValue(simpleValue);
    }

    @Nullable
    public String getValueString(ResourceEntry ri) {
        RawValue simpleValue = ri.getSimpleValue();
        if (simpleValue != null) {
            return this.decodeValue(simpleValue);
        }
        List<RawNamedValue> namedValues = ri.getNamedValues();
        ArrayList<String> strList = new ArrayList<String>(namedValues.size());
        for (RawNamedValue value : namedValues) {
            String nameStr = this.decodeNameRef(value.getNameRef());
            String valueStr = this.decodeValue(value.getRawValue());
            if (nameStr == null) {
                strList.add(valueStr);
                continue;
            }
            strList.add(nameStr + '=' + valueStr);
        }
        return ((Object)strList).toString();
    }

    @Nullable
    public String decodeValue(RawValue value) {
        int dataType = value.getDataType();
        int data = value.getData();
        return this.decodeValue(dataType, data);
    }

    @Nullable
    public String decodeValue(int dataType, int data) {
        switch (dataType) {
            case 0: {
                return null;
            }
            case 3: {
                return this.strings[data];
            }
            case 16: {
                return Integer.toString(data);
            }
            case 17: {
                return Integer.toHexString(data);
            }
            case 18: {
                return data == 0 ? "false" : "true";
            }
            case 4: {
                return ValuesParser.floatToString(Float.intBitsToFloat(data));
            }
            case 28: {
                return String.format("#%08x", data);
            }
            case 29: {
                return String.format("#%06x", data & 0xFFFFFF);
            }
            case 30: {
                return String.format("#%04x", data & 0xFFFF);
            }
            case 31: {
                return String.format("#%03x", data & 0xFFF);
            }
            case 1: 
            case 7: {
                String ri = this.resMap.get(data);
                if (ri == null) {
                    String androidRi = androidResMap.get(data);
                    if (androidRi != null) {
                        return "@android:" + androidRi;
                    }
                    if (data == 0) {
                        return "0";
                    }
                    return "?unknown_ref: " + Integer.toHexString(data);
                }
                return '@' + ri;
            }
            case 2: {
                String ri = this.resMap.get(data);
                if (ri == null) {
                    String androidRi = androidResMap.get(data);
                    if (androidRi != null) {
                        return "?android:" + androidRi;
                    }
                    return "?unknown_attr_ref: " + Integer.toHexString(data);
                }
                return '?' + ri;
            }
            case 5: {
                return this.decodeComplex(data, false);
            }
            case 6: {
                return this.decodeComplex(data, true);
            }
            case 8: {
                LOG.warn("Data type TYPE_DYNAMIC_ATTRIBUTE not yet supported: {}", (Object)data);
                return "  TYPE_DYNAMIC_ATTRIBUTE: " + data;
            }
        }
        LOG.warn("Unknown data type: 0x{} {}", (Object)Integer.toHexString(dataType), (Object)data);
        return "  ?0x" + Integer.toHexString(dataType) + ' ' + data;
    }

    public String decodeNameRef(int nameRef) {
        int ref = nameRef;
        if (ValuesParser.isResInternalId(nameRef) && (ref = nameRef & 0xFFFF) == 0) {
            return null;
        }
        String ri = this.resMap.get(ref);
        if (ri != null) {
            return ri.replace('/', '.');
        }
        String androidRi = androidResMap.get(ref);
        if (androidRi != null) {
            return "android:" + androidRi.replace('/', '.');
        }
        return "?0x" + Integer.toHexString(nameRef);
    }

    private String decodeComplex(int data, boolean isFraction) {
        String unit;
        double value = (double)(data & 0xFFFFFF00) * RADIX_MULTS[data >> 4 & 3];
        int unitType = data & 0xF;
        if (isFraction) {
            value *= 100.0;
            switch (unitType) {
                case 0: {
                    unit = "%";
                    break;
                }
                case 1: {
                    unit = "%p";
                    break;
                }
                default: {
                    unit = "?f" + Integer.toHexString(unitType);
                    break;
                }
            }
        } else {
            switch (unitType) {
                case 0: {
                    unit = "px";
                    break;
                }
                case 1: {
                    unit = "dp";
                    break;
                }
                case 2: {
                    unit = "sp";
                    break;
                }
                case 3: {
                    unit = "pt";
                    break;
                }
                case 4: {
                    unit = "in";
                    break;
                }
                case 5: {
                    unit = "mm";
                    break;
                }
                default: {
                    unit = "?d" + Integer.toHexString(unitType);
                }
            }
        }
        return ValuesParser.doubleToString(value) + unit;
    }

    private static String doubleToString(double value) {
        if (Double.compare(value, Math.floor(value)) == 0 && !Double.isInfinite(value)) {
            return Integer.toString((int)value);
        }
        NumberFormat f = NumberFormat.getInstance(Locale.ROOT);
        f.setMaximumFractionDigits(4);
        f.setMinimumIntegerDigits(1);
        return f.format(value);
    }

    private static String floatToString(float value) {
        return ValuesParser.doubleToString(value);
    }

    public static Map<Integer, String> getAndroidResMap() {
        return androidResMap;
    }
}

